/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.cloudn.base.ui.dialogs;

import com.clustercontrol.cloud.cloudn.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.cloudn.base.ui.dialogs.EditTagDialog;
import com.clustercontrol.cloud.resources.Tag;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wb.swt.SWTResourceManager;

public class EditTagsDialog
extends Dialog {
    private Table table;
    private Button btnAdd;
    private Button btnEdit;
    private Button btnRemove;
    private List<Tag> input = new ArrayList<Tag>();
    private List<Tag> output = new ArrayList<Tag>();
    private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
    private String strName = this.messages.getString("word.name");
    private String strValue = this.messages.getString("word.value");
    private String strAdd = this.messages.getString("word.add");
    private String strEdit = this.messages.getString("word.edit");
    private String strDelete = this.messages.getString("word.delete");
    private String strEditTagsDialog = this.messages.getString("caption.edit_tag_dialog");

    public EditTagsDialog(Shell parentShell, List<Tag> input) {
        super(parentShell);
        this.input = input;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setBackground(SWTResourceManager.getColor((int)22));
        GridLayout gl_container = new GridLayout(2, false);
        gl_container.verticalSpacing = 10;
        container.setLayout((Layout)gl_container);
        GridData gd_container = new GridData(1808);
        gd_container.widthHint = 614;
        container.setLayoutData((Object)gd_container);
        this.table = new Table(container, 67584);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditTagsDialog.this.btnEdit.setEnabled(true);
                EditTagsDialog.this.btnRemove.setEnabled(true);
            }
        });
        GridData gd_table = new GridData(4, 4, true, true, 1, 4);
        gd_table.widthHint = 378;
        this.table.setLayoutData((Object)gd_table);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableColumn tableColumn = new TableColumn(this.table, 0);
        tableColumn.setWidth(160);
        tableColumn.setText(this.strName);
        TableColumn tableColumn_1 = new TableColumn(this.table, 0);
        tableColumn_1.setWidth(260);
        tableColumn_1.setText(this.strValue);
        this.btnAdd = new Button(container, 0);
        this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditTagDialog dialog = new EditTagDialog(EditTagsDialog.this.getShell());
                if (dialog.open() == 0) {
                    TableItem item = new TableItem(EditTagsDialog.this.table, 0);
                    item.setText(dialog.getName());
                    item.setText(1, dialog.getValue());
                }
            }
        });
        this.btnAdd.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnAdd.setText(this.strAdd);
        this.btnEdit = new Button(container, 0);
        this.btnEdit.setEnabled(false);
        this.btnEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = EditTagsDialog.this.table.getSelection();
                if (items == null || items.length == 0) {
                    return;
                }
                TableItem item = items[0];
                EditTagDialog dialog = new EditTagDialog(EditTagsDialog.this.getShell(), item.getText(), item.getText(1));
                if (dialog.open() == 0) {
                    item.setText(dialog.getName());
                    item.setText(1, dialog.getValue());
                }
            }
        });
        this.btnEdit.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnEdit.setText(this.strEdit);
        this.btnRemove = new Button(container, 0);
        this.btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = EditTagsDialog.this.table.getSelection();
                if (items == null || items.length == 0) {
                    return;
                }
                TableItem item = items[0];
                item.dispose();
                EditTagsDialog.this.btnEdit.setEnabled(false);
                EditTagsDialog.this.btnRemove.setEnabled(false);
            }
        });
        this.btnRemove.setEnabled(false);
        this.btnRemove.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnRemove.setText(this.strDelete);
        new Label(container, 0);
        if (!this.input.isEmpty()) {
            for (Tag t : this.input) {
                TableItem item = new TableItem(this.table, 0);
                item.setText(t.name);
                item.setText(1, t.value);
            }
        }
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.strEditTagsDialog);
    }

    protected Point getInitialSize() {
        return new Point(629, 581);
    }

    public List<Tag> getOutput() {
        return this.output;
    }

    protected void okPressed() {
        for (TableItem item : this.table.getItems()) {
            this.output.add(new Tag(item.getText(), item.getText(1)));
        }
        this.setReturnCode(0);
        this.close();
    }
}

