/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.cloudn.base.ui.views.actions;

import java.util.Arrays;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;

import com.clustercontrol.cloud.cloudn.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.cloudn.base.resources.CloudResourceProvider;
import com.clustercontrol.cloud.cloudn.base.resources.CloudResourceProviderImpl;
import com.clustercontrol.cloud.cloudn.base.resources.DiskOffering;
import com.clustercontrol.cloud.cloudn.base.resources.Filter;
import com.clustercontrol.cloud.cloudn.base.resources.Snapshot;
import com.clustercontrol.cloud.cloudn.base.resources.Zone;
import com.clustercontrol.cloud.cloudn.base.ui.dialogs.CreateStorageDialog;
import com.clustercontrol.cloud.cloudn.base.ui.dialogs.CreateStorageDialog.DialogControlContainer;
import com.clustercontrol.cloud.presenter.CreateStorageRequest;
import com.clustercontrol.cloud.presenter.IAccountResource.IRegion;
import com.clustercontrol.cloud.presenter.ICloudComputeService;
import com.clustercontrol.cloud.ui.views.StoragesView;
import com.clustercontrol.cloud.ui.views.actions.AbstractViewAction;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.util.Messages;


public class CreateStorageAction extends AbstractViewAction {
	private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
	
	private String msgCreateStorageConfirm = messages.getString("message.confirm_some_action_to_something", new Object[]{"word.storage", "word.create"});
	private String msgCreateStorageResult = messages.getString("message.result_some_action_to_something", new Object[]{"word.storage", "word.create"});


	@Override
	public void invoke(IAction action) throws InvocationException {

		final StoragesView view = (StoragesView)viewPart;
		IRegion region = view.getActiveRegion();
		
		if (region == null) {
			assert view.getCurrentAccountResource().getRegions().length > 0;
			region = view.getCurrentAccountResource().getRegions()[0];
		}
		
		final String regionName = region.getRegion();
		
		final CloudResourceProvider provider = new CloudResourceProviderImpl(region.getAccountResource().getAccountResourceId());
		CreateStorageDialog dialog = new CreateStorageDialog(this.viewPart.getSite().getShell());
		
		dialog.setCloudInfoProvider(provider);
		
		dialog.setBehavior(new CreateStorageDialog.IDialogBehavior(){
			@Override
			public void setup(final DialogControlContainer container) {

				for(Zone zone: provider.getZones(regionName)){
					container.getCmbZone().add(zone.getName());
					container.getCmbZone().setData(zone.getName(), zone);
				}
				if(container.getCmbZone().getItemCount() > 0){
					container.getCmbZone().select(0);
				}

				container.getCmbZone().addSelectionListener(new SelectionAdapter(){
					@Override
					public void widgetSelected(SelectionEvent e) {
						setupSnapshotList(container);
					}
				});
				
				container.getBtnStorage().setSelection(true);
				container.getBtnSnapshot().setSelection(false);
				container.getCmbStorage().setEnabled(true);
				container.getCmbSnapshot().setEnabled(false);
				
				for(DiskOffering offering: provider.getDiskOfferings()){
					container.getCmbStorage().add(offering.getName());
					container.getCmbStorage().setData(offering.getName(), offering);
				}
				if(container.getCmbStorage().getItemCount() > 0){
					container.getCmbStorage().select(0);
				}

				setupSnapshotList(container);
				
				container.getBtnStorage().addSelectionListener(new SelectionAdapter(){
					public void widgetSelected(SelectionEvent e) {
						container.getCmbStorage().setEnabled(true);
						container.getCmbSnapshot().setEnabled(false);
					}
				});
				
				container.getBtnSnapshot().addSelectionListener(new SelectionAdapter(){
					public void widgetSelected(SelectionEvent e) {
						container.getCmbStorage().setEnabled(false);
						container.getCmbSnapshot().setEnabled(true);
					}
				});
			}
			
			private void setupSnapshotList(DialogControlContainer container){
				container.getCmbSnapshot().removeAll();
				
				Filter filter = new Filter();
				filter.setName("zone");
				filter.setValues(Arrays.asList(new String[]{container.getCmbZone().getText()}));
				
				for(Snapshot snapshot: provider.getSnapshots(regionName, Arrays.asList(new Filter[]{filter}))){
					container.getCmbSnapshot().add(snapshot.getName());
					container.getCmbSnapshot().setData(snapshot.getName(), snapshot);
				}
				
				if(container.getCmbSnapshot().getItemCount() > 0){
					container.getCmbSnapshot().select(0);
				}
			}
		});
		
		if (dialog.open() == Window.OK) {
			if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				msgCreateStorageConfirm)){

				CreateStorageDialog.DialogData output = dialog.getOutput();
				
				CreateStorageRequest request = new CreateStorageRequest();
				request.setZone(output.getZone());
				request.setFlavor(output.getStorage());
				request.setStorageName(output.getName());
				request.setSnapshotId(output.getSnapshot());
				// 以下のパラメータはダミー
				request.setStorageSize(0);
				request.setStorageDetail("");
				
				region.getCloudService(ICloudComputeService.class).getStorageManager().createCloudStorage(request);
				
				// 成功報告ダイアログを生成
				MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					msgCreateStorageResult);
			}
			else {
				return;
			}
		}
	}
	
	@Override
	public void selectionChanged(IAction action, ISelection selection) {
		action.setEnabled(true);
	}

}