/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.commons.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import com.clustercontrol.bean.EndStatusConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.presenter.IEndpointManager;
import com.clustercontrol.jobmanagement.bean.CommandStopTypeConstant;
import com.clustercontrol.jobmanagement.bean.ConditionTypeConstant;
import com.clustercontrol.jobmanagement.bean.JobConstant;
import com.clustercontrol.jobmanagement.bean.JobParamTypeConstant;
import com.clustercontrol.jobmanagement.bean.JudgmentObjectConstant;
import com.clustercontrol.jobmanagement.bean.ProcessingMethodConstant;
import com.clustercontrol.jobmanagement.bean.SystemParameterConstant;
import com.clustercontrol.notify.util.NotifyGroupIdGenerator;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.jobmanagement.JobCommandInfo;
import com.clustercontrol.ws.jobmanagement.JobEndStatusInfo;
import com.clustercontrol.ws.jobmanagement.JobEndpoint;
import com.clustercontrol.ws.jobmanagement.JobInfo;
import com.clustercontrol.ws.jobmanagement.JobNotificationsInfo;
import com.clustercontrol.ws.jobmanagement.JobObjectInfo;
import com.clustercontrol.ws.jobmanagement.JobParameterInfo;
import com.clustercontrol.ws.jobmanagement.JobTreeItem;
import com.clustercontrol.ws.jobmanagement.JobWaitRuleInfo;

public class TemplateJobUtil {
	private static IEndpointManager endpointManager = Activator.getEndpointManager();
	private static MessageManager messages = MessageManager.getInstance("messages");

	private TemplateJobUtil(){
	}
	
	private static JobTreeItem getRootJobunitForAccountResource(String jobunitId) throws Exception{
		JobEndpoint endpoint = endpointManager.getEndpoint(JobEndpoint.class);
		JobTreeItem jobTreeItem = endpoint.getJobTree(null, true);
		for(JobTreeItem item1 : jobTreeItem.getChildren()){
			for(JobTreeItem item2 : item1.getChildren()){
				// ジョブユニットIDがAWS配下のジョブIDを取得する
				if(jobunitId.equals(item2.getData().getId())){
					return item2;
				}
			}
		}
		return null;
	}
	
	private static JobTreeItem getTemplateJobRoot(String jobunitId) throws Exception{
		JobTreeItem accountItem = getRootJobunitForAccountResource(jobunitId);
		if(accountItem != null){
			return getTemplateJobRoot(accountItem);
		}
		return null;
	}

	private static JobTreeItem getTemplateJobRoot(JobTreeItem jobunit) throws Exception{
		if(jobunit != null){
			return findJobTreeItem(jobunit, "Template");
		}
		return null;
	}
	
	private static JobTreeItem findJobTreeItem(JobTreeItem srcItem, String targetJobId) {
		if(srcItem != null){
			for(JobTreeItem childItem : srcItem.getChildren()){
				if(targetJobId.equals(childItem.getData().getId())){
					return childItem;
				}
			}
		}
		return null;
	}
	
	public static void registerJob(String jobunitId, TemplateJobnet jobnet) throws Exception{

		JobTreeItem parentItem = TemplateJobUtil.createDefaultJobnetItem();
		JobInfo parentInfo = parentItem.getData();
//		parentInfo.setUpdate(true);
		parentInfo.setId(jobnet.getJobnetId());
		parentInfo.setJobunitId(jobunitId);
		parentInfo.setName(jobnet.getJobnetName());
		TemplateJobUtil.setNotifyGroupId(parentInfo.getNotifications(), parentInfo.getJobunitId(), parentInfo.getId());
		parentInfo.setPropertyFull(true);
		
		TemplateJobUtil.TemplateJobOSType osType = jobnet.getOsType();
		StringBuffer scripts = new StringBuffer();
		String scriptPrefix = null;
		if(osType.equals(TemplateJobUtil.TemplateJobOSType.windows)){
			scriptPrefix = CloudClientConstants.TEMPLATE_JOB_EXECUTE_SCRIPTS_FOR_WINDOWS;
		} else if(osType.equals(TemplateJobUtil.TemplateJobOSType.unix)){
			scriptPrefix = CloudClientConstants.TEMPLATE_JOB_EXECUTE_SCRIPTS_FOR_LINUX;
		}
		for(TemplateJobUtil.TemplateJob tmpJob: jobnet.getJobs()){
			if(tmpJob.getCommandType().equals(TemplateJobUtil.CommandType.script)){
				scripts.append(" " + tmpJob.getCommand());
				tmpJob.setCommand(scriptPrefix + tmpJob.getCommand());
			}
		}
		
		TemplateJobUtil.TemplateJob downloadJob = new TemplateJobUtil.TemplateJob();
		downloadJob.setJobId(jobnet.getJobnetId() + messages.getString("parameter.download_job_id_suffix"));
		downloadJob.setJobName(messages.getString("parameter.script_download_job_name"));
		downloadJob.setBehaviorInFailure(TemplateJobUtil.BehaviorInFailure.next);
		if(osType.equals(TemplateJobUtil.TemplateJobOSType.windows)){
			downloadJob.setCommand(CloudClientConstants.TEMPLATE_JOB_DOWNLOAD_SCRIPTS_FOR_WINDOWS + scripts);
			downloadJob.setUserSpecify(false);
//			downloadJob.setExecuteUser(messages.getString("parameter.windows_user"));
		} else if(osType.equals(TemplateJobUtil.TemplateJobOSType.unix)){
			downloadJob.setCommand(CloudClientConstants.TEMPLATE_JOB_DOWNLOAD_SCRIPTS_FOR_LINUX + scripts);
			downloadJob.setUserSpecify(true);
			downloadJob.setExecuteUser(messages.getString("parameter.linux_user"));
		}
		downloadJob.setSuccessRangeStartValue(0);
		downloadJob.setSuccessRangeEndValue(0);
		
		JobTreeItem downloadItem = TemplateJobUtil.createJobTreeItem(jobunitId, downloadJob);
		TemplateJobUtil.addChildren(parentItem, downloadItem);
		
		String precedingJobId = downloadJob.getJobId();
		Map<String, String> argMap = new HashMap<String, String>();
		
		for(TemplateJobUtil.TemplateJob tmpJob: jobnet.getJobs()){
			if(precedingJobId != null){
				tmpJob.setPrecedingJobId(precedingJobId);
			}
			JobTreeItem tmpItem = TemplateJobUtil.createJobTreeItem(jobunitId, tmpJob);
			
			TemplateJobUtil.addChildren(parentItem, tmpItem);
			
			precedingJobId = tmpJob.getJobId();
			
			if(tmpJob.getArgument() != null && !tmpJob.getArgument().isEmpty()){
				argMap.put(tmpJob.jobId, tmpJob.getArgument());
			}
		}

		List<JobParameterInfo> paramList = new ArrayList<JobParameterInfo>();
		
		for(Entry<String, String> entry: argMap.entrySet()){
			JobParameterInfo param = new JobParameterInfo();
			param.setParamId(jobunitId + "_" + entry.getKey());
			param.setType(JobParamTypeConstant.TYPE_USER);
			param.setDescription(messages.getString("parameter.job_parameter_description", new Object[]{entry.getKey()}));
			param.setValue(entry.getValue());
			paramList.add(param);
		}

		InternalRegisterJob(jobunitId, parentItem, paramList);
	}
//	
//	private static void InternalRegisterJob(String jobunitId, JobTreeItem item, List<JobParameterInfo> paramList) throws Exception{
//		JobEndpoint endpoint = endpointManager.getEndpoint(JobEndpoint.class);
//		
//		JobTreeItem root = endpoint.getJobTree(null, true);
//		JobTreeItem accountRoot = null;
//		for(JobTreeItem item1 : root.getChildren()){
//			for(JobTreeItem item2 : item1.getChildren()){
//				if(jobunitId.equals(item2.getData().getId())){
//					accountRoot = item2;
//					JobInfo info = endpoint.getJobFull(accountRoot.getData());
////					info.setEdit(true);
//					accountRoot.setData(info);
//				}
//			}
//		}
//		if(accountRoot == null){
//			accountRoot = createDefaultJobunitItem();
//			JobInfo accountRootInfo = accountRoot.getData();
//			accountRootInfo.setId(jobunitId);
//			accountRootInfo.setJobunitId(jobunitId);
//			accountRootInfo.setName(bundle_param.getString("parameter.aws_job_unit_name"));
//			setNotifyGroupId(accountRootInfo.getNotifications(), accountRootInfo.getJobunitId(), accountRootInfo.getId());
//			addChildren(root.getChildren().get(0), accountRoot);
//		}
//
//		accountRoot.getData().getParam().addAll(paramList);
//		
//		addChildren(accountRoot, item);
//		
//		// 循環参照を避けるため。
//		removeTreeParent(accountRoot);
//		accountRoot.setParent(null);
//		
//		endpoint.registerJobunit(accountRoot);
//	}

	private static void InternalRegisterJob(String jobunitId, JobTreeItem item, List<JobParameterInfo> paramList) throws Exception{
		JobEndpoint endpoint = endpointManager.getEndpoint(JobEndpoint.class);
		
		JobTreeItem accountRoot = getRootJobunitForAccountResource(jobunitId);
		
		if(accountRoot == null){
			throw new Exception("target jobunit id:" + jobunitId + " was not found.");
		}

		JobInfo info = endpoint.getJobFull(accountRoot.getData());
		accountRoot.setData(info);
		
		accountRoot.getData().getParam().addAll(paramList);
		
		JobTreeItem templateRoot = getTemplateJobRoot(accountRoot);

		if(templateRoot == null){
			throw new Exception("target jobunit id:" + jobunitId + " doesn't have \"Template\" jobnet.");
		}

		info = endpoint.getJobFull(templateRoot.getData());
		templateRoot.setData(info);
		
		addChildren(templateRoot, item);
		item.getData().setOwnerRoleId(templateRoot.getData().getOwnerRoleId());
		extendsOwnerRoleId(item);
		
		// 循環参照を避けるため。
		removeTreeParent(accountRoot);
		accountRoot.setParent(null);
		
		endpoint.registerJobunit(accountRoot);
	}

	private static JobInfo getJobFull(JobInfo jobInfo) throws Exception{
		JobEndpoint endpoint = endpointManager.getEndpoint(JobEndpoint.class);
		return endpoint.getJobFull(jobInfo);
	}

	private static void addChildren(JobTreeItem parent, JobTreeItem child){
		parent.getChildren().add(child);
		child.setParent(parent);

		return;
	}
	
	private static void removeTreeParent(JobTreeItem item) {
		List<JobTreeItem> children = item.getChildren();
		for (JobTreeItem child : children) {
			child.setParent(null);
			removeTreeParent(child);
		}
	}

	private static void extendsOwnerRoleId(JobTreeItem item){
		if(item != null && item.getData() != null && item.getData().getOwnerRoleId() != null && !item.getData().getOwnerRoleId().isEmpty() && item.getChildren() != null){
			for(JobTreeItem child: item.getChildren()){
				child.getData().setOwnerRoleId(item.getData().getOwnerRoleId());
				extendsOwnerRoleId(child);
			}
		}
	}
	
//	private static JobTreeItem createDefaultJobunitItem(){
//		JobTreeItem item = new JobTreeItem();
//		
//		JobInfo info = new JobInfo();
//		info.setWaitRule(getDefaultWaitRuleInfo());
//		info.setType(JobConstant.TYPE_JOBUNIT);
//
//		List<JobNotificationsInfo> notifications = info.getNotifications();
//		notifications.clear();
//		notifications.addAll(getDefaultNotifications());
//
//		List<JobEndStatusInfo> endStatusInfos = info.getEndStatus();
//		endStatusInfos.clear();
//		endStatusInfos.addAll(getJobEndStatusInfos());
//
//		// ジョブユニット登録時はシステム変数を自動で登録する。
//		List<JobParameterInfo> params = info.getParam();
//		JobParameterInfo paramInfo;
//		for (ArrayList<String> param : SystemParameterConstant.ALL) {
//			paramInfo = new JobParameterInfo();
//
//			//名前
//			paramInfo.setParamId(param.get(0));
//			//種別
//			paramInfo.setType(JobParamTypeConstant.TYPE_SYSTEM);
//			//値
//			paramInfo.setValue("(" + Messages.getString("auto") + ")");
//			//説明
//			paramInfo.setDescription(param.get(1));
//
//			params.add(paramInfo);
//		}
//
//		item.setData(info);
//		
//		return item;
//	}
	
	private static JobTreeItem createDefaultJobnetItem(){
		JobTreeItem item = new JobTreeItem();
		
		JobInfo info = new JobInfo();
		info.setWaitRule(getDefaultWaitRuleInfo());
		info.setType(JobConstant.TYPE_JOBNET);

		List<JobNotificationsInfo> notifications = info.getNotifications();
		notifications.clear();
		notifications.addAll(getDefaultNotifications());

		List<JobEndStatusInfo> endStatusInfos = info.getEndStatus();
		endStatusInfos.clear();
		endStatusInfos.addAll(getJobEndStatusInfos());
		
		item.setData(info);
		
		return item;
	}
	
	private static JobTreeItem createDefaultJobItem(){
		JobTreeItem item = new JobTreeItem();
		
		JobInfo info = new JobInfo();
		info.setWaitRule(getDefaultWaitRuleInfo());
		info.setType(JobConstant.TYPE_JOB);
		
		info.setCommand(getDefaultCommandInfo());
		
		List<JobNotificationsInfo> notifications = info.getNotifications();
		notifications.clear();
		notifications.addAll(getDefaultNotifications());

		List<JobEndStatusInfo> endStatusInfos = info.getEndStatus();
		endStatusInfos.clear();
		endStatusInfos.addAll(getJobEndStatusInfos());
		
		item.setData(info);
		
		return item;
	}
	
	private static JobWaitRuleInfo getDefaultWaitRuleInfo(){
		JobWaitRuleInfo jobWaitRuleInfo = new JobWaitRuleInfo();
		jobWaitRuleInfo.setSuspend(YesNoConstant.TYPE_NO);
		jobWaitRuleInfo.setSkip(YesNoConstant.TYPE_NO);
		jobWaitRuleInfo.setSkipEndValue(EndStatusConstant.INITIAL_VALUE_NORMAL);
		jobWaitRuleInfo.setCondition(ConditionTypeConstant.TYPE_AND);
		jobWaitRuleInfo.setEndCondition(YesNoConstant.TYPE_NO);
		jobWaitRuleInfo.setEndValue(EndStatusConstant.INITIAL_VALUE_NORMAL);
		jobWaitRuleInfo.setCalendar(YesNoConstant.TYPE_NO);
		jobWaitRuleInfo.setCalendarEndValue(EndStatusConstant.INITIAL_VALUE_NORMAL);
		jobWaitRuleInfo.setStartDelay(YesNoConstant.TYPE_NO);
		jobWaitRuleInfo.setStartDelaySession(YesNoConstant.TYPE_NO);
		jobWaitRuleInfo.setStartDelaySessionValue(1);
		jobWaitRuleInfo.setStartDelayTime(YesNoConstant.TYPE_NO);
		jobWaitRuleInfo.setStartDelayConditionType(ConditionTypeConstant.TYPE_AND);
		jobWaitRuleInfo.setStartDelayNotify(YesNoConstant.TYPE_NO);
		jobWaitRuleInfo.setStartDelayOperation(YesNoConstant.TYPE_NO);
		jobWaitRuleInfo.setStartDelayOperationEndValue(EndStatusConstant.INITIAL_VALUE_NORMAL);
		jobWaitRuleInfo.setEndDelay(YesNoConstant.TYPE_NO);
		jobWaitRuleInfo.setEndDelaySession(YesNoConstant.TYPE_NO);
		jobWaitRuleInfo.setEndDelaySessionValue(1);
		jobWaitRuleInfo.setEndDelayJob(YesNoConstant.TYPE_NO);
		jobWaitRuleInfo.setEndDelayJobValue(1);
		jobWaitRuleInfo.setEndDelayTime(YesNoConstant.TYPE_NO);
		jobWaitRuleInfo.setEndDelayConditionType(ConditionTypeConstant.TYPE_AND);
		jobWaitRuleInfo.setEndDelayNotify(YesNoConstant.TYPE_NO);
		jobWaitRuleInfo.setEndDelayOperation(YesNoConstant.TYPE_NO);
		jobWaitRuleInfo.setEndDelayOperationEndValue(EndStatusConstant.INITIAL_VALUE_NORMAL);
		jobWaitRuleInfo.setSkipEndStatus(0);
		jobWaitRuleInfo.setEndStatus(0);
		jobWaitRuleInfo.setStartDelayNotifyPriority(0);
		jobWaitRuleInfo.setStartDelayOperationType(0);
		jobWaitRuleInfo.setEndDelayNotifyPriority(0);
		jobWaitRuleInfo.setEndDelayOperationType(0);
		
		return jobWaitRuleInfo;
	}
	
	private static JobCommandInfo getDefaultCommandInfo(){
		JobCommandInfo jobCommandInfo = new JobCommandInfo();
		jobCommandInfo.setFacilityID(SystemParameterConstant.getParamText(SystemParameterConstant.FACILITY_ID));
		jobCommandInfo.setScope("");
		jobCommandInfo.setProcessingMethod(ProcessingMethodConstant.TYPE_ALL_NODE);
		jobCommandInfo.setStartCommand("");
		jobCommandInfo.setStopCommand("");
		jobCommandInfo.setUser("");
		jobCommandInfo.setErrorEndFlg(YesNoConstant.booleanToType(true));
		jobCommandInfo.setErrorEndValue(EndStatusConstant.INITIAL_VALUE_ABNORMAL);
		
		return jobCommandInfo;
	}
	
	private static List<JobNotificationsInfo> getDefaultNotifications(){

		List<JobNotificationsInfo> notifications = new ArrayList<JobNotificationsInfo>();
		
		JobNotificationsInfo infoNormal = null;
		JobNotificationsInfo infoWarning = null;
		JobNotificationsInfo infoAbnormal = null;
		JobNotificationsInfo infoStart = null;

		//メッセージ指定情報クラスのインスタンスを作成・取得
		infoStart = new JobNotificationsInfo();
		infoStart.setType(EndStatusConstant.TYPE_BEGINNING);
		infoStart.setPriority(PriorityConstant.TYPE_INFO);
		notifications.add(infoStart);
		infoNormal = new JobNotificationsInfo();
		infoNormal.setType(EndStatusConstant.TYPE_NORMAL);
		infoNormal.setPriority(PriorityConstant.TYPE_INFO);
		notifications.add(infoNormal);
		infoWarning = new JobNotificationsInfo();
		infoWarning.setType(EndStatusConstant.TYPE_WARNING);
		infoWarning.setPriority(PriorityConstant.TYPE_WARNING);
		notifications.add(infoWarning);
		infoAbnormal = new JobNotificationsInfo();
		infoAbnormal.setType(EndStatusConstant.TYPE_ABNORMAL);
		infoAbnormal.setPriority(PriorityConstant.TYPE_CRITICAL);
		notifications.add(infoAbnormal);
		
		return notifications;
	}

	private static List<JobEndStatusInfo> getJobEndStatusInfos(){

		List<JobEndStatusInfo> jobEndStatusInfos = new ArrayList<JobEndStatusInfo>();
		JobEndStatusInfo infoNormal = new JobEndStatusInfo();
		infoNormal.setType(EndStatusConstant.TYPE_NORMAL);
		infoNormal.setValue(EndStatusConstant.INITIAL_VALUE_NORMAL);
		infoNormal.setStartRangeValue(0);
		infoNormal.setEndRangeValue(0);
		jobEndStatusInfos.add(infoNormal);
		JobEndStatusInfo infoWarning = new JobEndStatusInfo();
		infoWarning.setType(EndStatusConstant.TYPE_WARNING);
		infoWarning.setValue(EndStatusConstant.INITIAL_VALUE_WARNING);
		infoWarning.setStartRangeValue(1);
		infoWarning.setEndRangeValue(1);
		jobEndStatusInfos.add(infoWarning);
		JobEndStatusInfo infoAbnormal = new JobEndStatusInfo();
		infoAbnormal.setType(EndStatusConstant.TYPE_ABNORMAL);
		infoAbnormal.setValue(EndStatusConstant.INITIAL_VALUE_ABNORMAL);
		jobEndStatusInfos.add(infoAbnormal);
		
		return jobEndStatusInfos;
	}

	private static void setNotifyGroupId(List<JobNotificationsInfo> notifications, String jobunitId, String jobId){
		for(JobNotificationsInfo info: notifications){
			info.setNotifyGroupId(NotifyGroupIdGenerator.createNotifyGroupIdJob(jobunitId, jobId,0));
		}
	}
	
	private static JobTreeItem createJobTreeItem(String jobunitId, TemplateJob templateJob){
		JobTreeItem item = createDefaultJobItem();
		JobInfo jobInfo = item.getData();
		jobInfo.setJobunitId(jobunitId);
		jobInfo.setId(templateJob.getJobId());
		jobInfo.setName(templateJob.getJobName());
//		JobPropertyUtil.setJobFull(item.getData()); // 不要？
//		item.getData().setUpdate(true);

		JobWaitRuleInfo jobWaitRuleInfo = jobInfo.getWaitRule();
		jobWaitRuleInfo.setEndCondition(YesNoConstant.booleanToType(templateJob.getBehaviorInFailure().isEndJudgementEnabled()));
		jobWaitRuleInfo.setEndValue(templateJob.getBehaviorInFailure().getEndValueInFailure());

		JobCommandInfo jobCommandInfo = jobInfo.getCommand();
		jobCommandInfo.setStartCommand(templateJob.getCommand());
		jobCommandInfo.setStopType(CommandStopTypeConstant.EXECUTE_COMMAND);
		jobCommandInfo.setStopCommand(messages.getString("parameter.stop_command"));
		if(templateJob.isUserSpecify()){
			jobCommandInfo.setSpecifyUser(YesNoConstant.TYPE_YES);
			jobCommandInfo.setUser(templateJob.getExecuteUser());
		} else {
			jobCommandInfo.setSpecifyUser(YesNoConstant.TYPE_NO);
		}
		jobCommandInfo.setErrorEndFlg(YesNoConstant.booleanToType(true)); //TODO
		jobCommandInfo.setErrorEndValue(EndStatusConstant.INITIAL_VALUE_ABNORMAL); //TODO
		jobCommandInfo.setMessageRetry(10);
		item.getData().setCommand(jobCommandInfo);
		
		List<JobEndStatusInfo> jobEndStatusInfos = new ArrayList<JobEndStatusInfo>();
		JobEndStatusInfo infoNormal = new JobEndStatusInfo();
		infoNormal.setType(EndStatusConstant.TYPE_NORMAL);
		infoNormal.setValue(EndStatusConstant.INITIAL_VALUE_NORMAL);
		infoNormal.setStartRangeValue(templateJob.getSuccessRangeStartValue());
		infoNormal.setEndRangeValue(templateJob.getSuccessRangeEndValue());
		jobEndStatusInfos.add(infoNormal);
		JobEndStatusInfo infoWarning = new JobEndStatusInfo();
		infoWarning.setType(EndStatusConstant.TYPE_WARNING);
		infoWarning.setValue(EndStatusConstant.INITIAL_VALUE_WARNING);
		infoWarning.setStartRangeValue(templateJob.getSuccessRangeStartValue());
		infoWarning.setEndRangeValue(templateJob.getSuccessRangeEndValue());
		jobEndStatusInfos.add(infoWarning);
		JobEndStatusInfo infoAbnormal = new JobEndStatusInfo();
		infoAbnormal.setType(EndStatusConstant.TYPE_ABNORMAL);
		infoAbnormal.setValue(EndStatusConstant.INITIAL_VALUE_ABNORMAL);
		jobEndStatusInfos.add(infoAbnormal);
		item.getData().getEndStatus().clear();
		item.getData().getEndStatus().addAll(jobEndStatusInfos);
		
		if(templateJob.getPrecedingJobId() != null && !templateJob.getPrecedingJobId().equals("")){
			List<JobObjectInfo> jobObjectInfos = new ArrayList<JobObjectInfo>();
			for(Integer endValueForJudgement: templateJob.behaviorInFailure.getEndValueForJudgement()){
				JobObjectInfo info = new JobObjectInfo();
				info.setJobId(templateJob.getPrecedingJobId());
				info.setType(JudgmentObjectConstant.TYPE_JOB_END_VALUE);
				info.setValue(endValueForJudgement);
				jobObjectInfos.add(info);
			}
			item.getData().getWaitRule().getObject().clear();
			item.getData().getWaitRule().getObject().addAll(jobObjectInfos);
			if(templateJob.behaviorInFailure.getEndValueForJudgement().length > 1){
				item.getData().getWaitRule().setCondition(ConditionTypeConstant.TYPE_OR);
			}
		}
		
		if(templateJob.getArgument() != null && !templateJob.getArgument().equals("")){
//			JobParameterInfo param = new JobParameterInfo();
//			param.setParamId(jobunitId + "_" + templateJob.getJobId());
//			param.setType(JobParamTypeConstant.TYPE_USER);
//			param.setDescription(bundle_param.getString("parameter.parameter.description", new Object[]{templateJob.getJobId()}));
//			param.setValue(templateJob.getArgument());
//			item.getData().getParam().add(param);
			
			item.getData().getCommand().setStartCommand(item.getData().getCommand().getStartCommand() + " #[" + jobunitId + "_" + templateJob.getJobId() + "]");
		}
		
		setNotifyGroupId(item.getData().getNotifications(), jobunitId, templateJob.getJobId());
		
		item.getData().setPropertyFull(true);
		
		return item;
	}
	
	public static class TemplateJobnet{
		private String jobnetId;
		private String jobnetName;
		private TemplateJobOSType osType;
		private List<TemplateJob> jobs;
		public String getJobnetId() {
			return jobnetId;
		}
		public void setJobnetId(String jobnetId) {
			this.jobnetId = jobnetId;
		}
		public String getJobnetName() {
			return jobnetName;
		}
		public void setJobnetName(String jobnetName) {
			this.jobnetName = jobnetName;
		}
		public TemplateJobOSType getOsType() {
			return osType;
		}
		public void setOsType(TemplateJobOSType osType) {
			this.osType = osType;
		}
		public List<TemplateJob> getJobs() {
			return jobs;
		}
		public void setJobs(List<TemplateJob> jobs) {
			this.jobs = jobs;
		}
	}
	
	public static class TemplateJob{
		private Integer orderNo;
		private String precedingJobId;
		private String jobId;
		private String jobName;
		private CommandType commandType;
		private String command;
		private String argument;
		private Boolean userSpecify;
		private String executeUser;
		private BehaviorInFailure behaviorInFailure;
		private Integer successRangeStartValue;
		private Integer successRangeEndValue;
		public void setOrderNo(Integer orderNo) {
			this.orderNo = orderNo;
		}
		public Integer getOrderNo() {
			return orderNo;
		}
		public String getJobId() {
			return jobId;
		}
		public void setJobId(String jobId) {
			this.jobId = jobId;
		}
		public String getJobName() {
			return jobName;
		}
		public void setJobName(String jobName) {
			this.jobName = jobName;
		}
		public CommandType getCommandType() {
			return commandType;
		}
		public void setCommandType(CommandType commandType) {
			this.commandType = commandType;
		}
		public String getCommand() {
			return command;
		}
		public void setCommand(String command) {
			this.command = command;
		}
		public String getArgument() {
			return argument;
		}
		public void setArgument(String argument) {
			this.argument = argument;
		}
		public String getExecuteUser() {
			return executeUser;
		}
		public void setExecuteUser(String executeUser) {
			this.executeUser = executeUser;
		}
		public BehaviorInFailure getBehaviorInFailure() {
			return behaviorInFailure;
		}
		public void setBehaviorInFailure(BehaviorInFailure behaviorInFailure) {
			this.behaviorInFailure = behaviorInFailure;
		}
		public Integer getSuccessRangeStartValue() {
			return successRangeStartValue;
		}
		public void setSuccessRangeStartValue(Integer successRangeStartValue) {
			this.successRangeStartValue = successRangeStartValue;
		}
		public Integer getSuccessRangeEndValue() {
			return successRangeEndValue;
		}
		public void setSuccessRangeEndValue(Integer successRangeEndValue) {
			this.successRangeEndValue = successRangeEndValue;
		}
		public void setPrecedingJobId(String precedingJobId) {
			this.precedingJobId = precedingJobId;
		}
		public String getPrecedingJobId() {
			return precedingJobId;
		}
		public Boolean isUserSpecify() {
			return userSpecify;
		}
		public void setUserSpecify(Boolean userSpecify) {
			this.userSpecify = userSpecify;
		}
	}

	public static enum TemplateJobOSType{
		unix,
		windows;
	}
	
	public static enum CommandType{
		command,
		script;
	}
	
	public static enum BehaviorInFailure {		
		next(new Integer[]{EndStatusConstant.INITIAL_VALUE_NORMAL, EndStatusConstant.INITIAL_VALUE_ABNORMAL}, true, EndStatusConstant.INITIAL_VALUE_ABNORMAL),
		stop(new Integer[]{EndStatusConstant.INITIAL_VALUE_NORMAL}, true, EndStatusConstant.INITIAL_VALUE_NORMAL),
		end(new Integer[]{EndStatusConstant.INITIAL_VALUE_NORMAL}, false, null);
		
		private MessageManager messages = MessageManager.getInstance("messages");
		
		private static class Parameter{
			private final Integer[] endValueForJudgement;
			private final Boolean endJudgementEnabled;
			private final Integer endValueInFailure;

			public Parameter(Integer[] endValueForJudgement, Boolean endJudgementEnabled, Integer endValueInFailure){
				this.endValueForJudgement = endValueForJudgement;
				this.endJudgementEnabled = endJudgementEnabled;
				this.endValueInFailure = endValueInFailure;
			}
			
			public Integer[] getEndValueForJudgement() {
				return endValueForJudgement;
			}
			public Boolean getEndJudgementEnabled() {
				return endJudgementEnabled;
			}
			public Integer getEndValueInFailure() {
				return endValueInFailure;
			}
		}
		
		private final Parameter parameter;
		
		BehaviorInFailure(Integer[] endValueForJudgement, Boolean endJudgementEnabled, Integer endValueInFailure){
			parameter = new Parameter(endValueForJudgement, endJudgementEnabled, endValueInFailure);
		}
		
		@Override
		public String toString(){
			switch(this){
			case next:
				return messages.getString("parameter.behavior_in_failure.next");
			case stop:
				return messages.getString("parameter.behavior_in_failure.stop");
			case end:
				return messages.getString("parameter.behavior_in_failure.end");
			default:
				throw new IllegalStateException();
			}
		}

		public BehaviorInFailure valueOf(Integer[] endValueForJudgement, Boolean endJudgementEnabled, Integer endValueInFailure){
			Parameter parameter = new Parameter(endValueForJudgement, endJudgementEnabled, endValueInFailure);
			if(next.parameter.hashCode() == parameter.hashCode()){
				return next;
			} else if(stop.parameter.hashCode() == parameter.hashCode()){
				return stop;
			} else if(end.parameter.hashCode() == parameter.hashCode()){
				return end;
			} else {
				throw new IllegalStateException();
			}
		}
		
		Integer[] getEndValueForJudgement(){
			return parameter.getEndValueForJudgement();
		}

		Boolean isEndJudgementEnabled(){
			return parameter.getEndJudgementEnabled();
		}
		
		Integer getEndValueInFailure(){
			return parameter.getEndValueInFailure();
		}
	}
	
	public static List<TemplateJobnet> getTemplateJobList(String jobunitId, Boolean listOnly) throws Exception{
		List<TemplateJobnet> templateJobs = new LinkedList<TemplateJobnet>();
		
		JobTreeItem accountRoot = getTemplateJobRoot(jobunitId);
		if(accountRoot != null){
			Map<String, JobTreeItem> itemMap = new HashMap<String, JobTreeItem>();
			TemplateJobnet templateJob;
			for(JobTreeItem jobnetItem: accountRoot.getChildren()){
				templateJob = new TemplateJobnet();
				templateJob.setJobnetId(jobnetItem.getData().getId());
				templateJob.setJobnetName(jobnetItem.getData().getName());
				itemMap.put(templateJob.getJobnetId(), jobnetItem);
				templateJobs.add(templateJob);
			}

			if(!listOnly){
				accountRoot.setData(getJobFull(accountRoot.getData()));
				Map<String, String> paramMap = new HashMap<String, String>();
//				for(JobParameterInfo paramInfo: accountRoot.getData().getParam()){
				for(JobParameterInfo paramInfo: getJobFull(getRootJobunitForAccountResource(jobunitId).getData()).getParam()){
					paramMap.put(paramInfo.getParamId(), paramInfo.getValue());
				}
				List<TemplateJob> jobs;
				TemplateJob job;
				for(TemplateJobnet jobnet: templateJobs){
					JobTreeItem item = itemMap.get(jobnet.getJobnetId());
					jobs = new LinkedList<TemplateJob>();
					for(JobTreeItem jobItem: item.getChildren()){
						JobInfo jobInfo = getJobFull(jobItem.getData());
						job = new TemplateJob();
						job.setJobId(jobInfo.getId());
						job.setJobName(jobInfo.getName());
						job.setCommand(jobInfo.getCommand().getStartCommand());
						job.setExecuteUser(jobInfo.getCommand().getUser());
						if(paramMap.containsKey(jobunitId + "_" + job.getJobId())){
							job.setArgument(paramMap.get(jobunitId + "_" + job.getJobId()));
						}
						jobs.add(job);
					}
					jobnet.setJobs(jobs);
				}
			}
		}
		
		return templateJobs;
	}
	
	public static List<String> getTemplateScripts(String roleId) throws Exception{
		List<String> scripts = new ArrayList<String>();
		CloudEndpoint endpoint = endpointManager.getEndpoint(CloudEndpoint.class);
		scripts.addAll(endpoint.getTemplateScripts(roleId));
		
		return scripts;
	}
}
