/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.azure.base.ui.dialogs;

import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.cloud.azure.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.azure.base.resources.AvailabilityZone;
import com.clustercontrol.cloud.azure.base.resources.CloudResourceProvider;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.azure.AzureCreateStorageRequest;
import com.clustercontrol.ws.azure.InstanceInfo;
import com.clustercontrol.ws.azure.VirtualHardDiskHostCaching;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class CreateStorageDialog
extends Dialog {
    private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
    private String strSeparator = this.messages.getString("caption.title_separator");
    private String strStorageSize = this.messages.getString("word.storage_size");
    private String strCreateStorageDialog = this.messages.getString("caption.create_storage_dialog");
    private String strCloudServiceName = this.messages.getString("word.cloud_service_name");
    private String strInstanceName = this.messages.getString("word.instance_name");
    private String strStorageAccountName = this.messages.getString("word.storage_account_name");
    private String strContainerName = this.messages.getString("word.container_name");
    private String strFileName = this.messages.getString("word.file_name");
    private String strHostCacheConfig = this.messages.getString("word.host_cache_config");
    private String strHostCacheNone = this.messages.getString("word.host_cache_none");
    private String strHostCacheReadOnly = this.messages.getString("word.host_cache_read_only");
    private String strHostCacheReadWrite = this.messages.getString("word.host_cache_read_write");
    private String strLun = this.messages.getString("word.lun");
    private Combo cmbCloudService;
    private Combo cmbInstance;
    private Combo cmbStorageAccount;
    private Combo cmbContainer;
    private Combo cmbLUN;
    private Text txtFileName;
    private Button btnHostCacheNone;
    private Button btnHostCacheReadOnly;
    private Button btnHostCacheReadWrite;
    private List<AvailabilityZone> cloudServices = new ArrayList<AvailabilityZone>();
    private List<InstanceInfo> instances = new ArrayList<InstanceInfo>();
    private String regionName = "";
    private Text txtVolumeName;
    private Text txtSize;
    private CloudResourceProvider provider;
    private DialogData output = new DialogData();
    private IDialogBehavior behavior;

    public CreateStorageDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setBackground(SWTResourceManager.getColor((int)22));
        GridLayout gl_container = new GridLayout(4, false);
        gl_container.horizontalSpacing = 15;
        container.setLayout((Layout)gl_container);
        GridData gd_container = new GridData(1808);
        gd_container.widthHint = 614;
        container.setLayoutData((Object)gd_container);
        Label lblCloudServiceName = new Label(container, 0);
        lblCloudServiceName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblCloudServiceName.setText(this.strCloudServiceName + this.strSeparator);
        this.cmbCloudService = new Combo(container, 8);
        for (AvailabilityZone az : this.cloudServices) {
            this.cmbCloudService.add(az.getZoneName());
        }
        this.cmbCloudService.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.cmbCloudService.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Combo bCombo = (Combo)e.widget;
                CreateStorageDialog.this.cmbInstance.removeAll();
                for (InstanceInfo instanceInfo : CreateStorageDialog.this.provider.getInstanceByCloudService(CreateStorageDialog.this.regionName, bCombo.getItem(bCombo.getSelectionIndex()))) {
                    if (instanceInfo.getDataDiskAttachableNum() - instanceInfo.getAttachedLun().size() <= 0) continue;
                    CreateStorageDialog.this.cmbInstance.add(instanceInfo.getInstanceName());
                    CreateStorageDialog.this.instances.add(instanceInfo);
                }
                CreateStorageDialog.this.cmbStorageAccount.removeAll();
                List<String> storageAccounts = CreateStorageDialog.this.provider.getStorageAccountByCloudService(CreateStorageDialog.this.regionName, bCombo.getItem(bCombo.getSelectionIndex()));
                for (String storageAccountName : storageAccounts) {
                    CreateStorageDialog.this.cmbStorageAccount.add(storageAccountName);
                }
            }
        });
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        Label lblInstanceName = new Label(container, 0);
        lblInstanceName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblInstanceName.setText(this.strInstanceName + this.strSeparator);
        this.cmbInstance = new Combo(container, 8);
        this.cmbInstance.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.cmbInstance.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Combo bCombo = (Combo)e.widget;
                CreateStorageDialog.this.cmbLUN.removeAll();
                for (InstanceInfo instanceInfo : CreateStorageDialog.this.instances) {
                    if (!instanceInfo.getInstanceName().equals(bCombo.getItem(bCombo.getSelectionIndex()))) continue;
                    for (int i = 0; i <= 15; ++i) {
                        if (instanceInfo.getAttachedLun().contains(i)) continue;
                        CreateStorageDialog.this.cmbLUN.add(Integer.toString(i));
                    }
                }
            }
        });
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        Label lblStorageAccountName = new Label(container, 0);
        lblStorageAccountName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblStorageAccountName.setText(this.strStorageAccountName + this.strSeparator);
        this.cmbStorageAccount = new Combo(container, 8);
        this.cmbStorageAccount.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.cmbStorageAccount.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Combo bCombo = (Combo)e.widget;
                CreateStorageDialog.this.cmbContainer.removeAll();
                List<String> containers = CreateStorageDialog.this.provider.getContainerByStorageAccount(CreateStorageDialog.this.regionName, bCombo.getItem(bCombo.getSelectionIndex()));
                for (String container : containers) {
                    CreateStorageDialog.this.cmbContainer.add(container);
                }
            }
        });
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        Label lblContainerName = new Label(container, 0);
        lblContainerName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblContainerName.setText(this.strContainerName + this.strSeparator);
        this.cmbContainer = new Combo(container, 8);
        this.cmbContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        Label lblLUN = new Label(container, 0);
        lblLUN.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblLUN.setText(this.strLun + this.strSeparator);
        this.cmbLUN = new Combo(container, 8);
        this.cmbLUN.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        Label lblFileName = new Label(container, 0);
        lblFileName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblFileName.setText(this.strFileName + this.strSeparator);
        this.txtFileName = new Text(container, 2048);
        this.txtFileName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        Label lblSize = new Label(container, 0);
        lblSize.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblSize.setText(this.strStorageSize + this.strSeparator);
        this.txtSize = new Text(container, 2048);
        this.txtSize.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        lblSize = new Label(container, 0);
        lblSize.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        lblSize.setText("GB (1-1023)");
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        Group grpHostCache = new Group(container, 0);
        GridLayout gl_hostCache = new GridLayout(3, false);
        grpHostCache.setLayout((Layout)gl_hostCache);
        GridData gd_hostCache = new GridData(4, 0x1000000, true, false, 4, 1);
        gd_hostCache.horizontalSpan = 4;
        grpHostCache.setLayoutData((Object)gd_hostCache);
        grpHostCache.setText(this.strHostCacheConfig);
        this.btnHostCacheNone = new Button((Composite)grpHostCache, 16);
        this.btnHostCacheNone.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnHostCacheNone.setSelection(true);
        this.btnHostCacheNone.setText(this.strHostCacheNone);
        this.btnHostCacheReadOnly = new Button((Composite)grpHostCache, 16);
        this.btnHostCacheReadOnly.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnHostCacheReadOnly.setText(this.strHostCacheReadOnly);
        this.btnHostCacheReadWrite = new Button((Composite)grpHostCache, 16);
        this.btnHostCacheReadWrite.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnHostCacheReadWrite.setText(this.strHostCacheReadWrite);
        this.behavior.setProvider(this.provider);
        this.behavior.setupVolumeName(this.txtVolumeName);
        this.txtSize.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                try {
                    String t = CreateStorageDialog.this.txtSize.getText().substring(0, e.start) + e.text + CreateStorageDialog.this.txtSize.getText().substring(e.start);
                    if (t.length() != 0) {
                        Integer.valueOf(t);
                    }
                }
                catch (Exception e1) {
                    e.doit = false;
                }
            }
        });
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(640, 500);
    }

    protected void okPressed() {
        if ("".equals(this.cmbCloudService.getItem(this.cmbCloudService.getSelectionIndex())) || "".equals(this.cmbInstance.getItem(this.cmbInstance.getSelectionIndex())) || "".equals(this.cmbStorageAccount.getItem(this.cmbStorageAccount.getSelectionIndex())) || "".equals(this.cmbContainer.getItem(this.cmbContainer.getSelectionIndex())) || "".equals(this.txtFileName.getText()) || "".equals(this.txtSize.getText())) {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)this.messages.getString("message.must_fully_input"));
            return;
        }
        this.output = new DialogData();
        String instanceName = this.cmbInstance.getItem(this.cmbInstance.getSelectionIndex());
        this.output.setInstanceName(instanceName);
        for (InstanceInfo instanceinfo : this.instances) {
            if (!instanceinfo.getInstanceName().equals(instanceName)) continue;
            this.output.setZone(instanceinfo.getDeploymentName());
        }
        this.output.setCloudServiceName(this.cmbCloudService.getItem(this.cmbCloudService.getSelectionIndex()));
        this.output.setStorageAccountName(this.cmbStorageAccount.getItem(this.cmbStorageAccount.getSelectionIndex()));
        if (this.btnHostCacheReadOnly.getSelection()) {
            this.output.setHostCacheConfig(VirtualHardDiskHostCaching.READ_ONLY);
        } else if (this.btnHostCacheReadWrite.getSelection()) {
            this.output.setHostCacheConfig(VirtualHardDiskHostCaching.READ_WRITE);
        } else {
            this.output.setHostCacheConfig(VirtualHardDiskHostCaching.NONE);
        }
        this.output.setContainerName(this.cmbContainer.getItem(this.cmbContainer.getSelectionIndex()));
        this.output.setStorageName(this.txtFileName.getText());
        this.output.setStorageSize(Integer.parseInt(this.txtSize.getText()));
        this.output.setFlavor(this.cmbLUN.getText());
        this.setReturnCode(0);
        this.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.strCreateStorageDialog);
    }

    public DialogData getOutput() {
        return this.output;
    }

    public void setCloudInfoProvider(CloudResourceProvider provider) {
        this.provider = provider;
    }

    public void setBehavior(IDialogBehavior behavior) {
        this.behavior = behavior;
    }

    public void setupCloudService(List<AvailabilityZone> cloudServices) {
        this.cloudServices = cloudServices;
    }

    public void setCurrentRegion(String regionName) {
        this.regionName = regionName;
    }

    public static class DialogBehavior
    implements IDialogBehavior {
        @Override
        public void setProvider(CloudResourceProvider provider) {
        }

        @Override
        public void setupVolumeName(Text txtVolumeName) {
        }

        @Override
        public void setupSize(Text txtSize, Combo txtUnit) {
        }

        @Override
        public void setupRegion(Combo cmbRegion) {
        }

        @Override
        public void setupAvailabilityZone(Combo cmbAvailabilityZone) {
        }

        @Override
        public void setupSnapshot(Combo cmbSnapshot) {
        }

        @Override
        public void setupVolumeType(Combo cmbVolumeType) {
        }

        @Override
        public void setupIops(Combo cmbIops) {
        }
    }

    public static interface IDialogBehavior {
        public void setProvider(CloudResourceProvider var1);

        public void setupVolumeName(Text var1);

        public void setupSize(Text var1, Combo var2);

        public void setupRegion(Combo var1);

        public void setupAvailabilityZone(Combo var1);

        public void setupSnapshot(Combo var1);

        public void setupVolumeType(Combo var1);

        public void setupIops(Combo var1);
    }

    public static class DialogData
    extends AzureCreateStorageRequest {
        private String region;
        private Integer iops;
        private VirtualHardDiskHostCaching hostCacheConfig;

        public String getRegion() {
            return this.region;
        }

        public void setRegion(String region) {
            this.region = region;
        }

        public Integer getIops() {
            return this.iops;
        }

        public void setIops(Integer iops) {
            this.iops = iops;
        }

        public VirtualHardDiskHostCaching getHostCacheConfig() {
            return this.hostCacheConfig;
        }

        public void setHostCacheConfig(VirtualHardDiskHostCaching hostCacheConfig) {
            this.hostCacheConfig = hostCacheConfig;
        }
    }

    public static class Decorator {
        private Combo control;
        private static ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (((Combo)e.getSource()).getText().equals("")) {
                    ((Combo)e.getSource()).setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
                } else {
                    ((Combo)e.getSource()).setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                }
            }
        };

        public Decorator(Combo control) {
            this.control = control;
            this.setEnabled(false);
        }

        public void setEnabled(boolean enable) {
            if (enable) {
                if (this.control.getText().equals("")) {
                    this.control.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
                } else {
                    this.control.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                }
                this.control.addModifyListener(modifyListener);
            } else {
                this.control.removeModifyListener(modifyListener);
                this.control.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
            }
        }
    }
}

