/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.azure.base.ui.dialogs;

import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.cloud.azure.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.azure.base.resources.CloudResourceProvider;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.azure.AzureRestoreStorageRequest;
import com.clustercontrol.ws.azure.SnapShotInfo;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class RestoreStorageDialog
extends Dialog {
    private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
    private String strSeparator = this.messages.getString("caption.title_separator");
    private String strStorageSize = this.messages.getString("word.storage_size");
    private String strCreateStorageDialog = this.messages.getString("caption.restore_snapshot");
    private String strStorageAccountName = this.messages.getString("word.storage_account_name");
    private String strContainerName = this.messages.getString("word.container_name");
    private String strFileName = this.messages.getString("word.disc_name");
    private Text txtStorageAccount;
    private Text txtContainer;
    private Text txtFileName;
    private SnapShotInfo snapShotInfo;
    private Text txtVolumeName;
    private Text txtSize;
    private CloudResourceProvider provider;
    private DialogData output = new DialogData();
    private IDialogBehavior behavior;

    public RestoreStorageDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setBackground(SWTResourceManager.getColor((int)22));
        GridLayout gl_container = new GridLayout(4, false);
        gl_container.horizontalSpacing = 15;
        container.setLayout((Layout)gl_container);
        GridData gd_container = new GridData(1808);
        gd_container.widthHint = 614;
        container.setLayoutData((Object)gd_container);
        Label lblStorageAccountName = new Label(container, 0);
        lblStorageAccountName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblStorageAccountName.setText(this.strStorageAccountName + this.strSeparator);
        this.txtStorageAccount = new Text(container, 2056);
        this.txtStorageAccount.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.txtStorageAccount.setText(this.snapShotInfo.getStorageAccountName());
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        Label lblContainerName = new Label(container, 0);
        lblContainerName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblContainerName.setText(this.strContainerName + this.strSeparator);
        this.txtContainer = new Text(container, 2056);
        this.txtContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.txtContainer.setText(this.snapShotInfo.getContainerName());
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        Label lblFileName = new Label(container, 0);
        lblFileName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblFileName.setText(this.strFileName + this.strSeparator);
        this.txtFileName = new Text(container, 2048);
        this.txtFileName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.txtFileName.setText(this.snapShotInfo.getVHDFileName());
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        Label lblSize = new Label(container, 0);
        lblSize.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblSize.setText(this.strStorageSize + this.strSeparator);
        this.txtSize = new Text(container, 2056);
        this.txtSize.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.txtSize.setText(Integer.toString(this.snapShotInfo.getFileSize()));
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        this.behavior.setProvider(this.provider);
        this.behavior.setupVolumeName(this.txtVolumeName);
        this.txtSize.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                try {
                    String t = RestoreStorageDialog.this.txtSize.getText().substring(0, e.start) + e.text + RestoreStorageDialog.this.txtSize.getText().substring(e.start);
                    if (t.length() != 0) {
                        Integer.valueOf(t);
                    }
                }
                catch (Exception e1) {
                    e.doit = false;
                }
            }
        });
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(640, 320);
    }

    protected void okPressed() {
        if ("".equals(this.txtStorageAccount.getText()) || "".equals(this.txtContainer.getText()) || "".equals(this.txtFileName.getText()) || "".equals(this.txtSize.getText())) {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)this.messages.getString("message.must_fully_input"));
            return;
        }
        this.output = new DialogData();
        this.output.setDiskName(this.txtFileName.getText());
        this.setReturnCode(0);
        this.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.strCreateStorageDialog);
    }

    public DialogData getOutput() {
        return this.output;
    }

    public void setCloudInfoProvider(CloudResourceProvider provider) {
        this.provider = provider;
    }

    public void setBehavior(IDialogBehavior behavior) {
        this.behavior = behavior;
    }

    public SnapShotInfo getSnapShotInfo() {
        return this.snapShotInfo;
    }

    public void setSnapShotInfo(SnapShotInfo snapShotInfo) {
        this.snapShotInfo = snapShotInfo;
    }

    public static class DialogBehavior
    implements IDialogBehavior {
        @Override
        public void setProvider(CloudResourceProvider provider) {
        }

        @Override
        public void setupVolumeName(Text txtVolumeName) {
        }

        @Override
        public void setupSize(Text txtSize, Combo txtUnit) {
        }

        @Override
        public void setupRegion(Combo cmbRegion) {
        }

        @Override
        public void setupAvailabilityZone(Combo cmbAvailabilityZone) {
        }

        @Override
        public void setupSnapshot(Combo cmbSnapshot) {
        }

        @Override
        public void setupVolumeType(Combo cmbVolumeType) {
        }

        @Override
        public void setupIops(Combo cmbIops) {
        }
    }

    public static interface IDialogBehavior {
        public void setProvider(CloudResourceProvider var1);

        public void setupVolumeName(Text var1);

        public void setupSize(Text var1, Combo var2);

        public void setupRegion(Combo var1);

        public void setupAvailabilityZone(Combo var1);

        public void setupSnapshot(Combo var1);

        public void setupVolumeType(Combo var1);

        public void setupIops(Combo var1);
    }

    public static class DialogData
    extends AzureRestoreStorageRequest {
        private String region;

        public String getRegion() {
            return this.region;
        }

        public void setRegion(String region) {
            this.region = region;
        }
    }

    public static class Decorator {
        private Combo control;
        private static ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (((Combo)e.getSource()).getText().equals("")) {
                    ((Combo)e.getSource()).setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
                } else {
                    ((Combo)e.getSource()).setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                }
            }
        };

        public Decorator(Combo control) {
            this.control = control;
            this.setEnabled(false);
        }

        public void setEnabled(boolean enable) {
            if (enable) {
                if (this.control.getText().equals("")) {
                    this.control.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
                } else {
                    this.control.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                }
                this.control.addModifyListener(modifyListener);
            } else {
                this.control.removeModifyListener(modifyListener);
                this.control.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
            }
        }
    }
}

