/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.azure.base.ui.views.actions;

import com.clustercontrol.action.FacilityTree;
import com.clustercontrol.cloud.azure.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.azure.base.resources.CloudResourceProviderImpl;
import com.clustercontrol.cloud.azure.base.ui.dialogs.CreateInstanceDialog;
import com.clustercontrol.cloud.presenter.ICloudTemplate;
import com.clustercontrol.cloud.presenter.ICloudTemplateManager;
import com.clustercontrol.cloud.ui.views.TemplatesView;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;
import java.util.HashMap;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;

public class CreateInstanceByTemplateAction
extends SingleSelectionActionEx {
    private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
    private String msgCreateInstanceConfirm = this.messages.getString("message.confirm_some_action_to_something", new Object[]{"word.instance", "word.create"});
    private String msgCreateInstanceResult = this.messages.getString("message.result_some_action_to_something", new Object[]{"word.instance", "word.create"});
    private ICloudTemplateManager templateManager;
    private ICloudTemplate template;

    protected void invoke(IAction action) throws InvocationException {
        CreateInstanceDialog dialog = new CreateInstanceDialog(this.viewPart.getSite().getShell());
        TemplatesView view = (TemplatesView)this.viewPart;
        this.template = (ICloudTemplate)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
        this.templateManager = this.template.getCloudTemplateManager();
        CreateInstanceDialog.Model input = new CreateInstanceDialog.Model();
        dialog.setInput(input);
        dialog.setCloudInfoProvider(new CloudResourceProviderImpl(view.getAccountResource().getAccountResourceId()));
        dialog.setBehavior(new CreateInstanceDialog.DialogBehavior(){
            private Combo region;

            @Override
            public void setupTemplate(Button useTemplate, Combo template, Button editArgument) {
                useTemplate.setSelection(true);
                HashMap<String, String> map = new HashMap<String, String>();
                for (ICloudTemplate tmpTemplate : CreateInstanceByTemplateAction.this.templateManager.getCloudTemplates()) {
                    if (!tmpTemplate.getRegion().equals(this.region.getData(this.region.getText()))) continue;
                    String tmpLabel = tmpTemplate.getTemplateName() + " ( " + tmpTemplate.getTemplateId() + " )";
                    template.add(tmpLabel);
                    template.setData(tmpLabel, (Object)tmpTemplate);
                    map.put(tmpTemplate.getTemplateId(), tmpLabel);
                }
                if (CreateInstanceByTemplateAction.this.template != null && map.containsKey(CreateInstanceByTemplateAction.this.template.getTemplateId())) {
                    template.select(template.indexOf((String)map.get(CreateInstanceByTemplateAction.this.template.getTemplateId())));
                }
                template.setEnabled(true);
                editArgument.setEnabled(true);
            }
        });
        if (dialog.open() == 0) {
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)this.msgCreateInstanceConfirm)) {
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)this.msgCreateInstanceResult);
                view.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        FacilityTree.refresh();
                    }
                });
            } else {
                return;
            }
        }
    }
}

