/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.ui.views.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.ui.dialogs.CreateCloudServiceDialog;
import com.clustercontrol.util.Messages;

public class EditCloudServiceAction extends SingleSelectionActionEx {
	public static final String ID = "com.clustercontrol.cloud.ui.views.actions.EditCloudServiceAction";

	private MessageManager messages = MessageManager.getInstance("messages");
	
	private String msgEditCloudServiceConfirm = messages.getString("message.confirm_some_action_to_something", new Object[]{"word.cloud_service", "word.modify"});
	private String msgEditCloudServiceResult = messages.getString("message.result_some_action_to_something", new Object[]{"word.cloud_service", "word.modify"});

	@Override
	protected void invoke(IAction action) throws InvocationException {
		
		CreateCloudServiceDialog dialog = new CreateCloudServiceDialog(this.viewPart.getSite().getShell());

//		IStructuredSelection selection = (IStructuredSelection) this.viewPart.getSite().getSelectionProvider().getSelection();
		
		dialog.setBehavior(new CreateCloudServiceDialog.DialogBehavior(){
			
			@Override
			public void setupServiceId(Text serviceId){
				serviceId.setEditable(false);
			}

			@Override
			public void setupServiceName(Text serviceName){
			}
			
			@Override
			public void setupEnvironmentInfo(Text environmentInfo) {
			}

			@Override
			public void setupMasterId(Text masterId) {
			}
			
		});
		
		if (dialog.open() == Window.OK) {
			if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				msgEditCloudServiceConfirm)) {
				
//				DialogOutput output = dialog.getOutput();
				
				// 成功報告ダイアログを生成
				MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					msgEditCloudServiceResult);
			}
			else {
				return;
			}
		}
	}
}