
package com.clustercontrol.ws.azure;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>platformKindのJavaクラス。
 * 
 * <p>次のスキーマ・フラグメントは、このクラス内に含まれる予期されるコンテンツを指定します。
 * <p>
 * <pre>
 * &lt;simpleType name="platformKind">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="windows"/>
 *     &lt;enumeration value="linux"/>
 *     &lt;enumeration value="other"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "platformKind")
@XmlEnum
public enum PlatformKind {

    @XmlEnumValue("windows")
    WINDOWS("windows"),
    @XmlEnumValue("linux")
    LINUX("linux"),
    @XmlEnumValue("other")
    OTHER("other");
    private final String value;

    PlatformKind(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static PlatformKind fromValue(String v) {
        for (PlatformKind c: PlatformKind.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
