/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.azure.base.resources;

public enum AvailableDevice {	
	SDF("/dev/sdf"),
	SDG("/dev/sdg"),
	SDH("/dev/sdh"),
	SDI("/dev/sdi"),
	SDJ("/dev/sdj"),
	SDK("/dev/sdk"),
	SDL("/dev/sdl"),
	SDM("/dev/sdm"),
	SDN("/dev/sdn"),
	SDO("/dev/sdo"),
	SDP("/dev/sdp"),
	;
	
	public static final String ROOT_DEVICE = "/dev/sda";
    
    private String value;

    private AvailableDevice(String value) {
        this.value = value;
    }

    @Override
	public String toString() {
        return this.value;
    }

    public static AvailableDevice fromValue(String value) {
        if (value == null || "".equals(value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");	        
        } else if ("/dev/sdf".equals(value)) {
            return AvailableDevice.SDF;	        
        } else if ("/dev/sdg".equals(value)) {
            return AvailableDevice.SDG;	        
        } else if ("/dev/sdh".equals(value)) {
            return AvailableDevice.SDH;	        
        } else if ("/dev/sdi".equals(value)) {
            return AvailableDevice.SDI;	        
        } else if ("/dev/sdj".equals(value)) {
            return AvailableDevice.SDJ;	        
        } else if ("/dev/sdk".equals(value)) {
            return AvailableDevice.SDK;	        
        } else if ("/dev/sdl".equals(value)) {
            return AvailableDevice.SDL;	        
        } else if ("/dev/sdm".equals(value)) {
            return AvailableDevice.SDM;	        
        } else if ("/dev/sdn".equals(value)) {
            return AvailableDevice.SDN;	        
        } else if ("/dev/sdo".equals(value)) {
            return AvailableDevice.SDO;	        
        } else if ("/dev/sdp".equals(value)) {
            return AvailableDevice.SDP;
        } else {
            throw new IllegalArgumentException("Cannot create enum from " + value + " value!");
        }
    }
}

