/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.azure.base.ui.dialogs;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.cloud.azure.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.azure.base.resources.EndPointInfo;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.azure.EndPoint;

public class CreateEndPointDialog extends Dialog {
	private Text txtname;
	private Button btnTcp;
	private Button btnUdp;
	private Button btnAuto;
	private Button btnMunual;
	private Text txtpublicPortManual;
	private Text txtprivatePort;

	private String osType;

	private MessageManagerExt messages = MessageManagerExt.getInstance("messages");

	private String strSeparator = messages.getString("caption.title_separator");
	private String msgMustSelectVmi = messages.getString("message.must_select_vmi");
	private String strCreateEndPointDialog = messages.getString("caption.create_end_point_dialog");
	private String strName = messages.getString("word.name");
	private String strProtcol = messages.getString("word.protocol");
	private String strPublicPort = messages.getString("word.public_port");
	private String strPrivatePort = messages.getString("word.private_port");
	private String strTcp = messages.getString("word.tcp");
	private String strUdp = messages.getString("word.udp");
	private String strPublicPortAuto = messages.getString("word.public_port_auto");
	private String strPublicPortManual = messages.getString("word.public_port_manual");

	List<EndPoint> endPoint= new ArrayList<>();

	private String endpointName="";
	private String protocol="";
	private String publicPort="";
	private String privatePort="";

	/**
	 * Create the dialog.				// リージョンを取得する。

	 * @param parentShell
	 */
	public CreateEndPointDialog(Shell parentShell) {
		super(parentShell);
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.NONE);
		container.setLayout(new GridLayout(2, false));
		container.setLayoutData(new GridData(GridData.FILL_BOTH));

		Label lblName = new Label(container, SWT.NONE);
		lblName.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1));
		lblName.setText(strName + strSeparator);

		txtname = new Text(container, SWT.BORDER);
		txtname.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		txtname.setText(this.endpointName);

		Group grpHostCache = new Group(container,SWT.NONE);
		GridLayout gl_hostCache = new GridLayout(1, false);
		grpHostCache.setLayout(gl_hostCache);
		GridData gd_hostCache = new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1);
		gd_hostCache.horizontalSpan=3;
		grpHostCache.setLayoutData(gd_hostCache);
		grpHostCache.setText(strProtcol);

		btnTcp = new Button(grpHostCache, SWT.RADIO);
		btnTcp.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		btnTcp.setText(strTcp);

		btnUdp = new Button(grpHostCache, SWT.RADIO);
		btnUdp.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		btnUdp.setText(strUdp);

		if(this.protocol.equals(strTcp)){
			btnTcp.setSelection(true);
		}
		else if(this.protocol.equals(strUdp)){
			btnUdp.setSelection(true);
		}
		else{
			btnTcp.setSelection(true);
		}

		Group grpHostCache2 = new Group(container,SWT.NONE);
		GridLayout gl_hostCache2 = new GridLayout(2, false);
		grpHostCache2.setLayout(gl_hostCache2);
		GridData gd_hostCache2 = new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1);
		gd_hostCache2.horizontalSpan=3;
		grpHostCache2.setLayoutData(gd_hostCache2);
		grpHostCache2.setText(strPublicPort);

		btnAuto = new Button(grpHostCache2, SWT.RADIO);
		btnAuto.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		btnAuto.setSelection(true);
		btnAuto.setText(strPublicPortAuto);
		btnAuto.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				txtpublicPortManual.setEnabled(false);
			}
		});

		new Label(grpHostCache2, SWT.NONE);

		btnMunual = new Button(grpHostCache2, SWT.RADIO);
		btnMunual.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		btnMunual.setText(strPublicPortManual);
		btnMunual.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				txtpublicPortManual.setEnabled(true);
			}
		});

		txtpublicPortManual = new Text(grpHostCache2, SWT.BORDER);
		//txtpublicPortManual.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		txtpublicPortManual.setLayoutData(new GridData(GridData.FILL_BOTH));
		txtpublicPortManual.setEnabled(false);

		if(!this.publicPort.equals(EndPointInfo.AUTO_GET_PORT)){
			btnAuto.setSelection(false);
			btnMunual.setSelection(true);
			txtpublicPortManual.setEnabled(true);
			txtpublicPortManual.setText(this.publicPort);
		}

		Label lblPrivate = new Label(container, SWT.NONE);
		lblPrivate.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1));
		lblPrivate.setText(strPrivatePort);

		new Label(container, SWT.NONE);

		Label lblPrivateNumber = new Label(container, SWT.NONE);
		lblPrivateNumber.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1));
		lblPrivateNumber.setText(strPublicPortManual + strSeparator);

		txtprivatePort = new Text(container, SWT.BORDER);
		txtprivatePort.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		txtprivatePort.setText(this.privatePort);

		return area;
	}

	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				true);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(440, 380);
	}

	@Override
	protected void okPressed() {
		if (txtname.getText().length() == 0) {
			MessageDialog.openError(null, Messages.getString("failed"), msgMustSelectVmi);
			return;
		}
		EndPoint ep = new EndPoint();
		ep.setName(txtname.getText());
		if(btnTcp.getSelection()){
			ep.setProtocol(btnTcp.getText());
		}
		else{
			ep.setProtocol(btnUdp.getText());
		}
		if(btnAuto.getSelection()){
			ep.setPublicPort(null);
		}
		else{
			ep.setPublicPort(Integer.parseInt(txtpublicPortManual.getText()));
		}
		ep.setPrivatePort(Integer.parseInt(txtprivatePort.getText()));
		endPoint.add(ep);
		setReturnCode(OK);
		close();
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(strCreateEndPointDialog);
	}

	public void setEndPoint(List<EndPoint> endPoint) {
		this.endPoint = endPoint;
	}

	public List<EndPoint> getEndPoint() {
		return endPoint;
	}

	public String getEndPointName() {
		return this.endpointName;
	}

	public void setEndPointName(String endpointName) {
		this.endpointName = endpointName;
	}

	public void setProtocol(String protocol) {
		this.protocol = protocol;
	}

	public String getProtocol() {
		return this.protocol;
	}

	public String getPublicPort() {
		return this.publicPort;
	}

	public void setPublicPort(String publicPort) {
		this.publicPort = publicPort;
	}

	public String getPrivatePort() {
		return this.privatePort;
	}

	public void setPrivatePort(String privatePort) {
		this.privatePort = privatePort;
	}

	public void setOStype(String osType){
		this.osType = osType;
	}

	public String getOStype(){
		return this.osType;
	}

}