/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.azure.base.ui.dialogs;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.cloud.azure.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.azure.base.resources.AvailabilityZone;
import com.clustercontrol.cloud.azure.base.resources.CloudResourceProvider;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.azure.AzureCreateStorageRequest;
import com.clustercontrol.ws.azure.InstanceInfo;
import com.clustercontrol.ws.azure.VirtualHardDiskHostCaching;

public class CreateStorageDialog extends Dialog {
	public static class Decorator {
		private Combo control;

		private static ModifyListener modifyListener = new ModifyListener(){
			@Override
			public void modifyText(ModifyEvent e) {
				if(((Combo)e.getSource()).getText().equals("")){
					((Combo)e.getSource()).setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
				} else {
					((Combo)e.getSource()).setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
				}
			}
		};

		public Decorator(Combo control) {
			this.control = control;
			setEnabled(false);
		}

		public void setEnabled(boolean enable) {
			if (enable) {
				if (control.getText().equals("")) {
					control.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
				}
				else {
					control.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
				}
				control.addModifyListener(modifyListener);
			}
			else {
				control.removeModifyListener(modifyListener);
				control.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
			}
		}
	}

	public static class DialogData extends AzureCreateStorageRequest {
		private String region;
		private Integer iops;
		private VirtualHardDiskHostCaching hostCacheConfig;
		public String getRegion() {
			return region;
		}
		public void setRegion(String region) {
			this.region = region;
		}
		public Integer getIops() {
			return iops;
		}
		public void setIops(Integer iops) {
			this.iops = iops;
		}
		public VirtualHardDiskHostCaching getHostCacheConfig() {
			return hostCacheConfig;
		}
		public void setHostCacheConfig(VirtualHardDiskHostCaching hostCacheConfig) {
			this.hostCacheConfig = hostCacheConfig;
		}
	}

	private MessageManagerExt messages = MessageManagerExt.getInstance("messages");

	private String strSeparator = messages.getString("caption.title_separator");
	private String strStorageSize = messages.getString("word.storage_size");
	private String strCreateStorageDialog = messages.getString("caption.create_storage_dialog");
	private String strCloudServiceName = messages.getString("word.cloud_service_name");
	private String strInstanceName = messages.getString("word.instance_name");
	private String strStorageAccountName = messages.getString("word.storage_account_name");
	private String strContainerName = messages.getString("word.container_name");
	private String strFileName = messages.getString("word.file_name");
	private String strHostCacheConfig = messages.getString("word.host_cache_config");
	private String strHostCacheNone = messages.getString("word.host_cache_none");
	private String strHostCacheReadOnly = messages.getString("word.host_cache_read_only");
	private String strHostCacheReadWrite = messages.getString("word.host_cache_read_write");
	private String strLun = messages.getString("word.lun");

	private Combo cmbCloudService;
	private Combo cmbInstance;
	private Combo cmbStorageAccount;
	private Combo cmbContainer;
	private Combo cmbLUN;
	private Text txtFileName;
	private Button btnHostCacheNone;
	private Button btnHostCacheReadOnly;
	private Button btnHostCacheReadWrite;

	private List<AvailabilityZone> cloudServices = new ArrayList<>();
	private List<InstanceInfo> instances = new ArrayList<InstanceInfo>();
	private String regionName = "";
	
	private Text txtVolumeName;
	private Text txtSize;

	private CloudResourceProvider provider;

	private DialogData output = new DialogData();

	private IDialogBehavior behavior;

	public interface IDialogBehavior{
		void setProvider(CloudResourceProvider provider);

		void setupVolumeName(Text txtVolumeName);
		void setupSize(Text txtSize, Combo cmbUnit);
		void setupRegion(Combo cmbRegion);
		void setupAvailabilityZone(Combo cmbAvailabilityZone);
		void setupSnapshot(Combo cmbSnapshot);
		void setupVolumeType(Combo cmbVolumeType);
		void setupIops(Combo cmbIops);
	}

	public static class DialogBehavior implements IDialogBehavior{

		@Override
		public void setProvider(CloudResourceProvider provider) {}

		@Override
		public void setupVolumeName(Text txtVolumeName) {}

		@Override
		public void setupSize(Text txtSize, Combo txtUnit) {}

		@Override
		public void setupRegion(final Combo cmbRegion) {}

		@Override
		public void setupAvailabilityZone(Combo cmbAvailabilityZone) {}

		@Override
		public void setupSnapshot(Combo cmbSnapshot) {}

		@Override
		public void setupVolumeType(Combo cmbVolumeType) {}

		@Override
		public void setupIops(Combo cmbIops) {}

	}

	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	public CreateStorageDialog(Shell parentShell) {
		super(parentShell);
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.NONE);
		container.setBackground(SWTResourceManager.getColor(SWT.COLOR_WIDGET_BACKGROUND));
		GridLayout gl_container = new GridLayout(4, false);
		gl_container.horizontalSpacing = 15;
		container.setLayout(gl_container);
		GridData gd_container = new GridData(GridData.FILL_BOTH);
		gd_container.widthHint = 614;
		container.setLayoutData(gd_container);

		Label lblCloudServiceName = new Label(container, SWT.NONE);
		lblCloudServiceName.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblCloudServiceName.setText(strCloudServiceName + strSeparator);

		cmbCloudService = new Combo(container, SWT.READ_ONLY);
		for(AvailabilityZone az : cloudServices){
			cmbCloudService.add(az.getZoneName());
		}
		cmbCloudService.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 3, 1));
		cmbCloudService.addSelectionListener(new SelectionListener(){
			public void widgetDefaultSelected(SelectionEvent e){
			}
			public void widgetSelected(SelectionEvent e){
			    Combo bCombo = (Combo)e.widget;
			    cmbInstance.removeAll();
			    
			    for(com.clustercontrol.ws.azure.InstanceInfo instanceInfo : provider.getInstanceByCloudService(regionName,bCombo.getItem(bCombo.getSelectionIndex()))){
			    	if(instanceInfo.getDataDiskAttachableNum()-instanceInfo.getAttachedLun().size()>0){
			    		cmbInstance.add(instanceInfo.getInstanceName());
			    		instances.add(instanceInfo);
			    	}
			    }

		    	cmbStorageAccount.removeAll();
			    List<String> storageAccounts = provider.getStorageAccountByCloudService(regionName,bCombo.getItem(bCombo.getSelectionIndex()));
			    for(String storageAccountName : storageAccounts){
			    	cmbStorageAccount.add(storageAccountName);
			    }
			}
		});

		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);

		Label lblInstanceName = new Label(container, SWT.NONE);
		lblInstanceName.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblInstanceName.setText(strInstanceName + strSeparator);

		cmbInstance = new Combo(container, SWT.READ_ONLY);
		cmbInstance.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 3, 1));
		cmbInstance.addSelectionListener(new SelectionListener(){
			public void widgetDefaultSelected(SelectionEvent e){
			}
			public void widgetSelected(SelectionEvent e){
			    Combo bCombo = (Combo)e.widget;
			    cmbLUN.removeAll();
			    for(InstanceInfo instanceInfo : instances){
			    	if(instanceInfo.getInstanceName().equals(bCombo.getItem(bCombo.getSelectionIndex()))){
			    		for(int i=0;i<=15;i++){
			    			if(!instanceInfo.getAttachedLun().contains(i)){
			    				cmbLUN.add(Integer.toString(i));
			    			}
			    		}
			    	}
			    }
			}
		});

		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);

		Label lblStorageAccountName = new Label(container, SWT.NONE);
		lblStorageAccountName.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblStorageAccountName.setText(strStorageAccountName + strSeparator);

		cmbStorageAccount = new Combo(container, SWT.READ_ONLY);
		cmbStorageAccount.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 3, 1));
		cmbStorageAccount.addSelectionListener(new SelectionListener(){
			public void widgetDefaultSelected(SelectionEvent e){
			}
			public void widgetSelected(SelectionEvent e){
				Combo bCombo = (Combo)e.widget;
				cmbContainer.removeAll();
				List<String> containers = provider.getContainerByStorageAccount(regionName, bCombo.getItem(bCombo.getSelectionIndex()));
				for(String container: containers){
					cmbContainer.add(container);
				}
			}
		});

		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);

		Label lblContainerName = new Label(container, SWT.NONE);
		lblContainerName.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblContainerName.setText(strContainerName + strSeparator);

		cmbContainer = new Combo(container, SWT.READ_ONLY);
		cmbContainer.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 3, 1));

		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		
		Label lblLUN = new Label(container, SWT.NONE);
		lblLUN.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblLUN.setText(strLun + strSeparator);
		
		cmbLUN = new Combo(container, SWT.READ_ONLY);
		cmbLUN.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 3, 1));

		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		
		Label lblFileName = new Label(container, SWT.NONE);
		lblFileName.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblFileName.setText(strFileName + strSeparator);

		txtFileName = new Text(container, SWT.BORDER);
		txtFileName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 3, 1));

		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);

		Label lblSize = new Label(container, SWT.NONE);
		lblSize.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblSize.setText(strStorageSize + strSeparator);

		txtSize = new Text(container, SWT.BORDER);
		txtSize.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));

		lblSize = new Label(container, SWT.NONE);
		lblSize.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		lblSize.setText("GB (1-1023)");

		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);

		Group grpHostCache = new Group(container,SWT.NONE);
		GridLayout gl_hostCache = new GridLayout(3, false);
		grpHostCache.setLayout(gl_hostCache);
		GridData gd_hostCache = new GridData(SWT.FILL, SWT.CENTER, true, false, 4, 1);
		gd_hostCache.horizontalSpan=4;
		grpHostCache.setLayoutData(gd_hostCache);
		grpHostCache.setText(strHostCacheConfig);

		btnHostCacheNone = new Button(grpHostCache, SWT.RADIO);
		btnHostCacheNone.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		btnHostCacheNone.setSelection(true);
		btnHostCacheNone.setText(strHostCacheNone);

		btnHostCacheReadOnly = new Button(grpHostCache, SWT.RADIO);
		btnHostCacheReadOnly.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		btnHostCacheReadOnly.setText(strHostCacheReadOnly);

		btnHostCacheReadWrite = new Button(grpHostCache, SWT.RADIO);
		btnHostCacheReadWrite.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		btnHostCacheReadWrite.setText(strHostCacheReadWrite);

		behavior.setProvider(provider);
		behavior.setupVolumeName(txtVolumeName);

		txtSize.addVerifyListener(new VerifyListener() {
			public void verifyText(VerifyEvent e) {
				try {
					String t = txtSize.getText().substring(0, e.start) + e.text + txtSize.getText().substring(e.start);
					if (t.length() != 0) {
						Integer.valueOf(t);
					}
				}
				catch(Exception e1) {
					e.doit = false;
				}
			}
		});

		return area;
	}

	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				false);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(640, 500);
	}

	@Override
	protected void okPressed() {
		if("".equals(cmbCloudService.getItem(cmbCloudService.getSelectionIndex())) ||
				"".equals(cmbInstance.getItem(cmbInstance.getSelectionIndex())) ||
				"".equals(cmbStorageAccount.getItem(cmbStorageAccount.getSelectionIndex())) ||
				"".equals(cmbContainer.getItem(cmbContainer.getSelectionIndex())) ||
				"".equals(txtFileName.getText()) ||
				"".equals(txtSize.getText())
			){
			MessageDialog.openError(null,
					Messages.getString("failed"),
					messages.getString("message.must_fully_input"));
			return;
		}

		output = new DialogData();
		String instanceName=cmbInstance.getItem(cmbInstance.getSelectionIndex());
		output.setInstanceName(instanceName);
		for(com.clustercontrol.ws.azure.InstanceInfo instanceinfo: instances){
			if(instanceinfo.getInstanceName().equals(instanceName)){
				output.setZone(instanceinfo.getDeploymentName());
			}
		}
		output.setCloudServiceName(cmbCloudService.getItem(cmbCloudService.getSelectionIndex()));
		output.setStorageAccountName(cmbStorageAccount.getItem(cmbStorageAccount.getSelectionIndex()));
		if(btnHostCacheReadOnly.getSelection()){
			output.setHostCacheConfig(VirtualHardDiskHostCaching.READ_ONLY);
		}else if(btnHostCacheReadWrite.getSelection()){
			output.setHostCacheConfig(VirtualHardDiskHostCaching.READ_WRITE);
		}else{
			output.setHostCacheConfig(VirtualHardDiskHostCaching.NONE);
		}
		output.setContainerName(cmbContainer.getItem(cmbContainer.getSelectionIndex()));
		output.setStorageName(txtFileName.getText());
		output.setStorageSize(Integer.parseInt(txtSize.getText()));
		output.setFlavor(cmbLUN.getText());

		setReturnCode(OK);
		close();
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(strCreateStorageDialog);
	}

	public CreateStorageDialog.DialogData getOutput() {
		return output;
	}

	public void setCloudInfoProvider(CloudResourceProvider provider) {
		this.provider = provider;
	}

	public void setBehavior(IDialogBehavior behavior) {
		this.behavior = behavior;
	}

	public void setupCloudService(List<AvailabilityZone> cloudServices){
		this.cloudServices = cloudServices;
	}

	public void setCurrentRegion(String regionName){
		this.regionName = regionName;
	}
}
