/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.azure.base.ui.dialogs;

import java.util.Arrays;

import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.cloud.azure.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.azure.base.resources.CloudResourceProvider;
import com.clustercontrol.cloud.azure.base.resources.Filter;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.azure.AzureImage;

public class SelectVMIDialog extends Dialog {
	private Text filter;
	private List vmi;
	private Button btnSearch;

	private String region;

	private CloudResourceProvider provider;
	private AzureImage output;


	private MessageManagerExt messages = MessageManagerExt.getInstance("messages");

	private String strSeparator = messages.getString("caption.title_separator");
	private String strFilter = messages.getString("word.filter");
	private String strSearchVmi = messages.getString("word.search_vmi");
	private String msgMustInputSearchText = messages.getString("message.must_input_search_text");
	private String strVmiList = messages.getString("word.vmi_list");
	private String msgMustSelectVmi = messages.getString("message.must_select_vmi");
	private String strSelectVmiDialog = messages.getString("caption.select_vmi_dialog");

	/**
	 * Create the dialog.				// リージョンを取得する。

	 * @param parentShell
	 */
	public SelectVMIDialog(Shell parentShell) {
		super(parentShell);
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.NONE);
		container.setLayout(new GridLayout(3, false));
		container.setLayoutData(new GridData(GridData.FILL_BOTH));

		Label lblTestfilter = new Label(container, SWT.NONE);
		lblTestfilter.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblTestfilter.setText(strFilter + strSeparator);

		filter = new Text(container, SWT.BORDER);
		filter.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));

		btnSearch = new Button(container, SWT.NONE);
		btnSearch.setText(strSearchVmi);
		btnSearch.addSelectionListener(new SelectionAdapter(){
			@Override
			public void widgetSelected(SelectionEvent e) {
				if(filter.getText() == ""){
					MessageDialog.openWarning(null, Messages.getString("failed"), msgMustInputSearchText);
					return;
				}
				vmi.removeAll();

				Filter f1 = new Filter();
				f1.setName("name");
				f1.setValues(Arrays.asList("*"+filter.getText()+"*"));
				Filter f2 = new Filter();
				f2.setName("image-type");
				f2.setValues(Arrays.asList("machine"));

				try{
					java.util.List<AzureImage> imgs = provider.getImages(region, filter.getText());

					for (AzureImage img: imgs) {
						String itemName = "("+img.getImageId()+") "+img.getName();
						vmi.add(itemName);
						vmi.setData(itemName, img);
					}
				} catch(Exception e1){

					Logger logger = Logger.getLogger(this.getClass());
					logger.error(e1.getMessage(), e1);


					// 失敗報告ダイアログを生成
					MessageDialog.openError(null, Messages.getString("failed"), e1.getMessage());
				}
			}
		});

		Label lblVmiList = new Label(container, SWT.NONE);
		lblVmiList.setLayoutData(new GridData(SWT.RIGHT, SWT.TOP, false, false, 1, 1));
		lblVmiList.setText(strVmiList + strSeparator);

		vmi = new List(container, SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL);
		GridData gd_vmi = new GridData(SWT.FILL, SWT.FILL, false, false, 2, 1);
		gd_vmi.heightHint = 303;
		gd_vmi.widthHint = 459;
		vmi.setLayoutData(gd_vmi);

		return area;
	}

	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				true);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(700, 480);
	}

	@Override
	protected void okPressed() {
		if (vmi.getSelection().length == 0) {
			MessageDialog.openError(null, Messages.getString("failed"), msgMustSelectVmi);
			return;
		}

		output = (AzureImage)vmi.getData(vmi.getSelection()[0]);

		setReturnCode(OK);
		close();
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(strSelectVmiDialog);
	}

	public AzureImage getOutput() {
		return output;
	}

	public void setRegion(String region) {
		this.region = region;
	}

	public void setCloudInfoProvider(CloudResourceProvider provider) {
		this.provider = provider;
	}
}