/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.azure.base.ui.views.actions;


import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.cloud.azure.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.azure.base.resources.CloudResourceProvider;
import com.clustercontrol.cloud.azure.base.resources.CloudResourceProviderImpl;
import com.clustercontrol.cloud.azure.base.ui.dialogs.CreateInstanceDialog;
import com.clustercontrol.cloud.presenter.CreateCloudInstanceRequest;
import com.clustercontrol.cloud.presenter.ICloudComputeService;
import com.clustercontrol.cloud.presenter.ICloudInstanceBackup;
import com.clustercontrol.cloud.presenter.IAccountResource.IRegion;
import com.clustercontrol.cloud.resources.Tag;
import com.clustercontrol.cloud.ui.views.InstanceBackupsView;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.azure.AzureCreateInstanceRequest;
import com.clustercontrol.ws.azure.AzureImage;
import com.clustercontrol.ws.azure.NodeDetail;

public class RestoreInstanceAction extends SingleSelectionActionEx {
	private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
	
	private String msgRestoreInstanceConfirm = messages.getString("message.confirm_some_action_to_something", new Object[]{"word.instance", "word.restore"});
	private String msgRestoreInstanceResult = messages.getString("message.result_some_action_to_something", new Object[]{"word.instance", "word.restore"});

	@Override
	protected void invoke(IAction action) throws InvocationException {
		CreateInstanceDialog dialog = new CreateInstanceDialog(this.viewPart.getSite().getShell());
		
		ICloudInstanceBackup backup = (ICloudInstanceBackup)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
		CloudResourceProvider provider = new CloudResourceProviderImpl(backup.getAccountResourceId());
		final InstanceBackupsView view = (InstanceBackupsView)viewPart;
		IRegion region = view.getActiveRegion();
		ICloudComputeService service = region.getCloudService(ICloudComputeService.class);
		
		if (region != null) {
			CreateInstanceDialog.Model m = new CreateInstanceDialog.Model();
			m.setFacilityId(backup.getBackupedData().getFacilityId());
			m.setFacilityName(backup.getBackupedData().getFacilityName());
			m.setNodeName(backup.getBackupedData().getNodeName());
			m.setReplaceNode(true);
			m.setDescription(backup.getDescription());
			
			AzureImage azureIMG= new AzureImage();
			azureIMG.setImageId(backup.getInstanceBackupId());
			azureIMG.setDescription(backup.getDescription());
			azureIMG.setOStype(backup.getPlatform());
			azureIMG.setName(backup.getInstanceBackupId());
			m.setAzureImage(azureIMG);
			m.setIsRestore(true);
			
			dialog.setInput(m);
		}
		
		dialog.setCurrentRegion(region.getRegion());
		dialog.setCloudInfoProvider(provider);
		dialog.setupCloudService(provider.getAvailabilityZones(region.getRegion()));
		dialog.setBehavior(new CreateInstanceDialog.DialogBehavior(){
			@Override
			public void setupFacilityId(Text facilityId) {
				facilityId.setText(input.getFacilityId());
			}

			@Override
			public void setupFacilityName(Text facilityName) {
				if(input.getFacilityName() != null){
					facilityName.setText(input.getFacilityName());
				}
			}

			@Override
			public void setupReplaceNode(Button btnReplaceNode) {
				btnReplaceNode.setSelection(true);
			}

			@Override
			public void setupDescription(Text description) {
				if(input.getDescription() != null){
					description.setText(input.getDescription());
				}
			}

			@Override
			public void setupNodeName(Text nodeName) {
				nodeName.setText(input.getNodeName());
			}

			@Override
			public void setupTemplate(Button useTemplate, Combo template, Button editArgument){
				useTemplate.setEnabled(false);
				template.setEnabled(false);
				editArgument.setEnabled(false);
			}
		});
		
		if(dialog.open() == Window.OK){
			if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				msgRestoreInstanceConfirm)){

				CreateInstanceDialog.Model m = dialog.getOutput();
				
				IRegion r = service.getRegion();
				
				AzureCreateInstanceRequest azureRequest = new AzureCreateInstanceRequest();
				CreateCloudInstanceRequest cloudRequest = new CreateCloudInstanceRequest();

				//ノードの基本情報セット
				NodeDetail nodeDetail = new NodeDetail();
				nodeDetail.setFacilityId(dialog.getOutput().getFacilityId());
				nodeDetail.setFacilityName(dialog.getOutput().getFacilityName());
				nodeDetail.setReplaceNode(dialog.getOutput().getReplaceNode());
				nodeDetail.setDescription(dialog.getOutput().getDescription());
				nodeDetail.setNodeName(dialog.getOutput().getNodeName());
				azureRequest.setNodeDetail(nodeDetail);

				azureRequest.setCloudServiceName(dialog.getOutput().getCloudServiceName());
				azureRequest.setStorageAccountName(dialog.getOutput().getStorageAccountName());
				azureRequest.setContainerName(dialog.getOutput().getContainerName());
				azureRequest.setSize(dialog.getOutput().getSize());
				azureRequest.setAccountName(dialog.getOutput().getNewUserName());
				if(dialog.getOutput().getPassword().equals(dialog.getOutput().getRePassword())){
					azureRequest.setPassWord(dialog.getOutput().getPassword());
				}
				azureRequest.setImage(dialog.getOutput().getAzureImage());
				azureRequest.setImageId(dialog.getOutput().getAzureImage().getName());
				azureRequest.getEndPoint().addAll(dialog.getOutput().getEndPoint());
				azureRequest.setAvailabilitySet(dialog.getOutput().getIsAvailabilitySet());
				azureRequest.setAvailabilitySetName(dialog.getOutput().getAvailabilitySetNmae());
				
				cloudRequest.setFacilityId(dialog.getOutput().getFacilityId());
				cloudRequest.setFacilityName(dialog.getOutput().getFacilityName());
				cloudRequest.setDescription(dialog.getOutput().getDescription());
				cloudRequest.setImageId(dialog.getOutput().getAzureImage().getImageId());
				cloudRequest.setNodeName(dialog.getOutput().getNodeName());
				cloudRequest.setReplaceNode(dialog.getOutput().getReplaceNode());
				cloudRequest.setZone(dialog.getOutput().getCloudServiceName());
				
				List<Tag> tags = new ArrayList<>();
				
				Tag Tag_platform = new Tag();
				Tag_platform.name="PlatForm";
				Tag_platform.value=dialog.getOutput().getAzureImage().getOStype();
				tags.add(Tag_platform);
				
				Tag Tag_NodeName = new Tag();
				Tag_NodeName.name="NodeName";
				Tag_NodeName.value=dialog.getOutput().getNodeName();
				tags.add(Tag_NodeName);
				
				cloudRequest.setTags(tags);
				
				r.getAccountResource().getRegion(m.getRegionName()).getCloudService(ICloudComputeService.class).getInstanceManager().createCloudInstance(cloudRequest);
				provider.createInstance(region.getRegion(), azureRequest);
				
				// 成功報告ダイアログを生成
				MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					msgRestoreInstanceResult);
				
				viewPart.getSite().getShell().getDisplay().asyncExec(new Runnable() {
					@Override
					public void run() {
						//InstanceMonitorService.getInstanceMonitorService().startMonitor(instance, ICloudInstance.StateType.running, ICloudInstance.StateType.terminated, ICloudInstance.StateType.stopped);
						com.clustercontrol.action.FacilityTree.refresh();
					}
				});
			}
			else {
				return;
			}
		}
	}
	
	@Override
	public void selectionChanged(IAction action, ISelection selection) {
		super.selectionChanged(action, selection);
		ICloudInstanceBackup backup = (ICloudInstanceBackup)((IStructuredSelection)selection).getFirstElement();
		if(backup == null || backup.getRestoreStatus() == null || backup.getRestoreStatus().equals(ICloudInstanceBackup.RestoreStatus.unavailable.name())){
			action.setEnabled(false);
		}
	}
}