/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.management.compute;

import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.OperationStatus;
import com.microsoft.windowsazure.core.OperationStatusResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestFilter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceResponseFilter;
import com.microsoft.windowsazure.core.utils.BOMInputStream;
import com.microsoft.windowsazure.core.utils.Base64;
import com.microsoft.windowsazure.core.utils.XmlUtility;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.compute.ComputeManagementClient;
import com.microsoft.windowsazure.management.compute.ComputeManagementClientImpl;
import com.microsoft.windowsazure.management.compute.HostedServiceOperations;
import com.microsoft.windowsazure.management.compute.models.AccessControlListRule;
import com.microsoft.windowsazure.management.compute.models.ConfigurationSet;
import com.microsoft.windowsazure.management.compute.models.DataVirtualHardDisk;
import com.microsoft.windowsazure.management.compute.models.DeploymentSlot;
import com.microsoft.windowsazure.management.compute.models.DeploymentStatus;
import com.microsoft.windowsazure.management.compute.models.DeploymentUpgradeType;
import com.microsoft.windowsazure.management.compute.models.DnsServer;
import com.microsoft.windowsazure.management.compute.models.DnsSettings;
import com.microsoft.windowsazure.management.compute.models.DomainJoinCredentials;
import com.microsoft.windowsazure.management.compute.models.DomainJoinProvisioning;
import com.microsoft.windowsazure.management.compute.models.DomainJoinSettings;
import com.microsoft.windowsazure.management.compute.models.EndpointAcl;
import com.microsoft.windowsazure.management.compute.models.GuestAgentFormattedMessage;
import com.microsoft.windowsazure.management.compute.models.GuestAgentMessage;
import com.microsoft.windowsazure.management.compute.models.GuestAgentStatus;
import com.microsoft.windowsazure.management.compute.models.HostedServiceAddExtensionParameters;
import com.microsoft.windowsazure.management.compute.models.HostedServiceCheckNameAvailabilityResponse;
import com.microsoft.windowsazure.management.compute.models.HostedServiceCreateParameters;
import com.microsoft.windowsazure.management.compute.models.HostedServiceGetDetailedResponse;
import com.microsoft.windowsazure.management.compute.models.HostedServiceGetExtensionResponse;
import com.microsoft.windowsazure.management.compute.models.HostedServiceGetResponse;
import com.microsoft.windowsazure.management.compute.models.HostedServiceListAvailableExtensionsResponse;
import com.microsoft.windowsazure.management.compute.models.HostedServiceListExtensionsResponse;
import com.microsoft.windowsazure.management.compute.models.HostedServiceListResponse;
import com.microsoft.windowsazure.management.compute.models.HostedServiceProperties;
import com.microsoft.windowsazure.management.compute.models.HostedServiceStatus;
import com.microsoft.windowsazure.management.compute.models.HostedServiceUpdateParameters;
import com.microsoft.windowsazure.management.compute.models.InputEndpoint;
import com.microsoft.windowsazure.management.compute.models.InstanceEndpoint;
import com.microsoft.windowsazure.management.compute.models.LoadBalancerProbe;
import com.microsoft.windowsazure.management.compute.models.LoadBalancerProbeTransportProtocol;
import com.microsoft.windowsazure.management.compute.models.OSVirtualHardDisk;
import com.microsoft.windowsazure.management.compute.models.PersistentVMDowntime;
import com.microsoft.windowsazure.management.compute.models.ResourceExtensionConfigurationStatus;
import com.microsoft.windowsazure.management.compute.models.ResourceExtensionParameterValue;
import com.microsoft.windowsazure.management.compute.models.ResourceExtensionReference;
import com.microsoft.windowsazure.management.compute.models.ResourceExtensionStatus;
import com.microsoft.windowsazure.management.compute.models.ResourceExtensionSubStatus;
import com.microsoft.windowsazure.management.compute.models.Role;
import com.microsoft.windowsazure.management.compute.models.RoleInstance;
import com.microsoft.windowsazure.management.compute.models.RoleInstancePowerState;
import com.microsoft.windowsazure.management.compute.models.SshSettingKeyPair;
import com.microsoft.windowsazure.management.compute.models.SshSettingPublicKey;
import com.microsoft.windowsazure.management.compute.models.SshSettings;
import com.microsoft.windowsazure.management.compute.models.StoredCertificateSettings;
import com.microsoft.windowsazure.management.compute.models.UpgradeDomainState;
import com.microsoft.windowsazure.management.compute.models.UpgradeStatus;
import com.microsoft.windowsazure.management.compute.models.VirtualHardDiskHostCaching;
import com.microsoft.windowsazure.management.compute.models.VirtualIPAddress;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineWindowsRemoteManagementListenerType;
import com.microsoft.windowsazure.management.compute.models.WindowsRemoteManagementListener;
import com.microsoft.windowsazure.management.compute.models.WindowsRemoteManagementSettings;
import com.microsoft.windowsazure.tracing.ClientRequestTrackingHandler;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class HostedServiceOperationsImpl
implements ServiceOperations<ComputeManagementClientImpl>,
HostedServiceOperations {
    private ComputeManagementClientImpl client;

    HostedServiceOperationsImpl(ComputeManagementClientImpl client) {
        this.client = client;
    }

    public ComputeManagementClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<OperationStatusResponse> addExtensionAsync(final String serviceName, final HostedServiceAddExtensionParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return HostedServiceOperationsImpl.this.addExtension(serviceName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse addExtension(String serviceName, HostedServiceAddExtensionParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"addExtensionAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getHostedServicesOperations().beginAddingExtensionAsync(serviceName, parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            while (!(result.getStatus() != OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationResponse> beginAddingExtensionAsync(final String serviceName, final HostedServiceAddExtensionParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return HostedServiceOperationsImpl.this.beginAddingExtension(serviceName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginAddingExtension(String serviceName, HostedServiceAddExtensionParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getId() == null) {
            throw new NullPointerException("parameters.Id");
        }
        if (parameters.getType() == null) {
            throw new NullPointerException("parameters.Type");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginAddingExtensionAsync", tracingParameters);
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        String url = "/" + this.getClient().getCredentials().getSubscriptionId().trim() + "/services/hostedservices/" + serviceName.trim() + "/extensions";
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-04-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element extensionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Extension");
        requestDoc.appendChild(extensionElement);
        if (parameters.getProviderNamespace() != null) {
            Element providerNameSpaceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ProviderNameSpace");
            providerNameSpaceElement.appendChild(requestDoc.createTextNode(parameters.getProviderNamespace()));
            extensionElement.appendChild(providerNameSpaceElement);
        }
        Element typeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Type");
        typeElement.appendChild(requestDoc.createTextNode(parameters.getType()));
        extensionElement.appendChild(typeElement);
        Element idElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Id");
        idElement.appendChild(requestDoc.createTextNode(parameters.getId()));
        extensionElement.appendChild(idElement);
        if (parameters.getThumbprint() != null) {
            Element thumbprintElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Thumbprint");
            thumbprintElement.appendChild(requestDoc.createTextNode(parameters.getThumbprint()));
            extensionElement.appendChild(thumbprintElement);
        }
        if (parameters.getThumbprintAlgorithm() != null) {
            Element thumbprintAlgorithmElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ThumbprintAlgorithm");
            thumbprintAlgorithmElement.appendChild(requestDoc.createTextNode(parameters.getThumbprintAlgorithm()));
            extensionElement.appendChild(thumbprintAlgorithmElement);
        }
        if (parameters.getPublicConfiguration() != null) {
            Element publicConfigurationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PublicConfiguration");
            publicConfigurationElement.appendChild(requestDoc.createTextNode(Base64.encode((byte[])parameters.getPublicConfiguration().getBytes())));
            extensionElement.appendChild(publicConfigurationElement);
        }
        if (parameters.getPrivateConfiguration() != null) {
            Element privateConfigurationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PrivateConfiguration");
            privateConfigurationElement.appendChild(requestDoc.createTextNode(Base64.encode((byte[])parameters.getPrivateConfiguration().getBytes())));
            extensionElement.appendChild(privateConfigurationElement);
        }
        if (parameters.getVersion() != null) {
            Element versionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Version");
            versionElement.appendChild(requestDoc.createTextNode(parameters.getVersion()));
            extensionElement.appendChild(versionElement);
        }
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> beginDeletingAllAsync(final String serviceName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return HostedServiceOperationsImpl.this.beginDeletingAll(serviceName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginDeletingAll(String serviceName) throws IOException, ServiceException {
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("serviceName", serviceName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginDeletingAllAsync", tracingParameters);
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        String url = "/" + this.getClient().getCredentials().getSubscriptionId().trim() + "/services/hostedservices/" + serviceName.trim() + "?" + "comp=media";
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        httpRequest.setHeader("x-ms-version", "2014-04-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> beginDeletingExtensionAsync(final String serviceName, final String extensionId) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return HostedServiceOperationsImpl.this.beginDeletingExtension(serviceName, extensionId);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginDeletingExtension(String serviceName, String extensionId) throws IOException, ServiceException {
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (extensionId == null) {
            throw new NullPointerException("extensionId");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("extensionId", extensionId);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginDeletingExtensionAsync", tracingParameters);
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        String url = "/" + this.getClient().getCredentials().getSubscriptionId().trim() + "/services/hostedservices/" + serviceName.trim() + "/extensions/" + extensionId.trim();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        httpRequest.setHeader("x-ms-version", "2014-04-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<HostedServiceCheckNameAvailabilityResponse> checkNameAvailabilityAsync(final String serviceName) {
        return this.getClient().getExecutorService().submit(new Callable<HostedServiceCheckNameAvailabilityResponse>(){

            @Override
            public HostedServiceCheckNameAvailabilityResponse call() throws Exception {
                return HostedServiceOperationsImpl.this.checkNameAvailability(serviceName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HostedServiceCheckNameAvailabilityResponse checkNameAvailability(String serviceName) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("serviceName", serviceName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"checkNameAvailabilityAsync", tracingParameters);
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        String url = "/" + this.getClient().getCredentials().getSubscriptionId().trim() + "/services/hostedservices/operations/isavailable/" + serviceName.trim();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2014-04-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            HostedServiceCheckNameAvailabilityResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new HostedServiceCheckNameAvailabilityResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element availabilityResponseElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"AvailabilityResponse");
            if (availabilityResponseElement != null) {
                Element reasonElement;
                Element resultElement = XmlUtility.getElementByTagNameNS((Node)availabilityResponseElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Result");
                if (resultElement != null) {
                    boolean resultInstance = DatatypeConverter.parseBoolean((String)resultElement.getTextContent().toLowerCase());
                    result.setIsAvailable(resultInstance);
                }
                if ((reasonElement = XmlUtility.getElementByTagNameNS((Node)availabilityResponseElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Reason")) != null) {
                    String reasonInstance = reasonElement.getTextContent();
                    result.setReason(reasonInstance);
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            HostedServiceCheckNameAvailabilityResponse hostedServiceCheckNameAvailabilityResponse = result;
            return hostedServiceCheckNameAvailabilityResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> createAsync(final HostedServiceCreateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return HostedServiceOperationsImpl.this.create(parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse create(HostedServiceCreateParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException, ParserConfigurationException, SAXException, TransformerException, URISyntaxException {
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getDescription() != null && parameters.getDescription().length() > 1024) {
            throw new IllegalArgumentException("parameters.Description");
        }
        if (parameters.getLabel() == null) {
            throw new NullPointerException("parameters.Label");
        }
        if (parameters.getServiceName() == null) {
            throw new NullPointerException("parameters.ServiceName");
        }
        int locationCount = (parameters.getAffinityGroup() != null ? 1 : 0) + (parameters.getLocation() != null ? 1 : 0);
        if (locationCount != 1) {
            throw new IllegalArgumentException("Only one of parameters.AffinityGroup, parameters.Location may be provided.");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, HostedServiceCreateParameters> tracingParameters = new HashMap<String, HostedServiceCreateParameters>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"createAsync", tracingParameters);
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        String url = "/" + this.getClient().getCredentials().getSubscriptionId().trim() + "/services/hostedservices";
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-04-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element createHostedServiceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "CreateHostedService");
        requestDoc.appendChild(createHostedServiceElement);
        Element serviceNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ServiceName");
        serviceNameElement.appendChild(requestDoc.createTextNode(parameters.getServiceName()));
        createHostedServiceElement.appendChild(serviceNameElement);
        Element labelElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Label");
        labelElement.appendChild(requestDoc.createTextNode(Base64.encode((byte[])parameters.getLabel().getBytes())));
        createHostedServiceElement.appendChild(labelElement);
        if (parameters.getDescription() != null) {
            Element descriptionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Description");
            descriptionElement.appendChild(requestDoc.createTextNode(parameters.getDescription()));
            createHostedServiceElement.appendChild(descriptionElement);
        }
        if (parameters.getLocation() != null) {
            Element locationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Location");
            locationElement.appendChild(requestDoc.createTextNode(parameters.getLocation()));
            createHostedServiceElement.appendChild(locationElement);
        }
        if (parameters.getAffinityGroup() != null) {
            Element affinityGroupElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "AffinityGroup");
            affinityGroupElement.appendChild(requestDoc.createTextNode(parameters.getAffinityGroup()));
            createHostedServiceElement.appendChild(affinityGroupElement);
        }
        if (parameters.getExtendedProperties() != null) {
            Element extendedPropertiesDictionaryElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ExtendedProperties");
            for (Map.Entry<String, String> entry : parameters.getExtendedProperties().entrySet()) {
                String extendedPropertiesKey = entry.getKey();
                String extendedPropertiesValue = entry.getValue();
                Element extendedPropertiesElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ExtendedProperty");
                extendedPropertiesDictionaryElement.appendChild(extendedPropertiesElement);
                Element extendedPropertiesKeyElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
                extendedPropertiesKeyElement.appendChild(requestDoc.createTextNode(extendedPropertiesKey));
                extendedPropertiesElement.appendChild(extendedPropertiesKeyElement);
                Element extendedPropertiesValueElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Value");
                extendedPropertiesValueElement.appendChild(requestDoc.createTextNode(extendedPropertiesValue));
                extendedPropertiesElement.appendChild(extendedPropertiesValueElement);
            }
            createHostedServiceElement.appendChild(extendedPropertiesDictionaryElement);
        }
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 201) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> deleteAsync(final String serviceName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return HostedServiceOperationsImpl.this.delete(serviceName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse delete(String serviceName) throws IOException, ServiceException, InterruptedException, ExecutionException {
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("serviceName", serviceName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"deleteAsync", tracingParameters);
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        String url = "/" + this.getClient().getCredentials().getSubscriptionId().trim() + "/services/hostedservices/" + serviceName.trim();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        httpRequest.setHeader("x-ms-version", "2014-04-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> deleteAllAsync(final String serviceName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return HostedServiceOperationsImpl.this.deleteAll(serviceName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse deleteAll(String serviceName) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("serviceName", serviceName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"deleteAllAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getHostedServicesOperations().beginDeletingAllAsync(serviceName).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            while (!(result.getStatus() != OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> deleteExtensionAsync(final String serviceName, final String extensionId) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return HostedServiceOperationsImpl.this.deleteExtension(serviceName, extensionId);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse deleteExtension(String serviceName, String extensionId) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("extensionId", extensionId);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"deleteExtensionAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getHostedServicesOperations().beginDeletingExtensionAsync(serviceName, extensionId).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            while (!(result.getStatus() != OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<HostedServiceGetResponse> getAsync(final String serviceName) {
        return this.getClient().getExecutorService().submit(new Callable<HostedServiceGetResponse>(){

            @Override
            public HostedServiceGetResponse call() throws Exception {
                return HostedServiceOperationsImpl.this.get(serviceName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HostedServiceGetResponse get(String serviceName) throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException {
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("serviceName", serviceName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getAsync", tracingParameters);
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        String url = "/" + this.getClient().getCredentials().getSubscriptionId().trim() + "/services/hostedservices/" + serviceName.trim();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2014-04-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            HostedServiceGetResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new HostedServiceGetResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element hostedServiceElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"HostedService");
            if (hostedServiceElement != null) {
                Element hostedServicePropertiesElement;
                Element serviceNameElement;
                Element urlElement = XmlUtility.getElementByTagNameNS((Node)hostedServiceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Url");
                if (urlElement != null) {
                    URI urlInstance = new URI(urlElement.getTextContent());
                    result.setUri(urlInstance);
                }
                if ((serviceNameElement = XmlUtility.getElementByTagNameNS((Node)hostedServiceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceName")) != null) {
                    String serviceNameInstance = serviceNameElement.getTextContent();
                    result.setServiceName(serviceNameInstance);
                }
                if ((hostedServicePropertiesElement = XmlUtility.getElementByTagNameNS((Node)hostedServiceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"HostedServiceProperties")) != null) {
                    Element extendedPropertiesSequenceElement;
                    Element dateLastModifiedElement;
                    Element dateCreatedElement;
                    Element statusElement;
                    Element labelElement;
                    Element locationElement;
                    Element affinityGroupElement;
                    HostedServiceProperties hostedServicePropertiesInstance = new HostedServiceProperties();
                    result.setProperties(hostedServicePropertiesInstance);
                    Element descriptionElement = XmlUtility.getElementByTagNameNS((Node)hostedServicePropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Description");
                    if (descriptionElement != null) {
                        String descriptionInstance = descriptionElement.getTextContent();
                        hostedServicePropertiesInstance.setDescription(descriptionInstance);
                    }
                    if ((affinityGroupElement = XmlUtility.getElementByTagNameNS((Node)hostedServicePropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AffinityGroup")) != null) {
                        String affinityGroupInstance = affinityGroupElement.getTextContent();
                        hostedServicePropertiesInstance.setAffinityGroup(affinityGroupInstance);
                    }
                    if ((locationElement = XmlUtility.getElementByTagNameNS((Node)hostedServicePropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Location")) != null) {
                        String locationInstance = locationElement.getTextContent();
                        hostedServicePropertiesInstance.setLocation(locationInstance);
                    }
                    if ((labelElement = XmlUtility.getElementByTagNameNS((Node)hostedServicePropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Label")) != null) {
                        String labelInstance = labelElement.getTextContent() != null ? new String(Base64.decode((String)labelElement.getTextContent())) : null;
                        hostedServicePropertiesInstance.setLabel(labelInstance);
                    }
                    if ((statusElement = XmlUtility.getElementByTagNameNS((Node)hostedServicePropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Status")) != null) {
                        HostedServiceStatus statusInstance = HostedServiceStatus.valueOf(statusElement.getTextContent());
                        hostedServicePropertiesInstance.setStatus(statusInstance);
                    }
                    if ((dateCreatedElement = XmlUtility.getElementByTagNameNS((Node)hostedServicePropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DateCreated")) != null) {
                        Calendar dateCreatedInstance = DatatypeConverter.parseDateTime((String)dateCreatedElement.getTextContent());
                        hostedServicePropertiesInstance.setDateCreated(dateCreatedInstance);
                    }
                    if ((dateLastModifiedElement = XmlUtility.getElementByTagNameNS((Node)hostedServicePropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DateLastModified")) != null) {
                        Calendar dateLastModifiedInstance = DatatypeConverter.parseDateTime((String)dateLastModifiedElement.getTextContent());
                        hostedServicePropertiesInstance.setDateLastModified(dateLastModifiedInstance);
                    }
                    if ((extendedPropertiesSequenceElement = XmlUtility.getElementByTagNameNS((Node)hostedServicePropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ExtendedProperties")) != null) {
                        for (int i1 = 0; i1 < XmlUtility.getElementsByTagNameNS((Node)extendedPropertiesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ExtendedProperty").size(); ++i1) {
                            Element extendedPropertiesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)extendedPropertiesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ExtendedProperty").get(i1);
                            String extendedPropertiesKey = XmlUtility.getElementByTagNameNS((Node)extendedPropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name").getTextContent();
                            String extendedPropertiesValue = XmlUtility.getElementByTagNameNS((Node)extendedPropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Value").getTextContent();
                            hostedServicePropertiesInstance.getExtendedProperties().put(extendedPropertiesKey, extendedPropertiesValue);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            HostedServiceGetResponse hostedServiceGetResponse = result;
            return hostedServiceGetResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<HostedServiceGetDetailedResponse> getDetailedAsync(final String serviceName) {
        return this.getClient().getExecutorService().submit(new Callable<HostedServiceGetDetailedResponse>(){

            @Override
            public HostedServiceGetDetailedResponse call() throws Exception {
                return HostedServiceOperationsImpl.this.getDetailed(serviceName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HostedServiceGetDetailedResponse getDetailed(String serviceName) throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException {
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("serviceName", serviceName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getDetailedAsync", tracingParameters);
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        String url = "/" + this.getClient().getCredentials().getSubscriptionId().trim() + "/services/hostedservices/" + serviceName.trim() + "?" + "embed-detail=true";
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2014-04-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            HostedServiceGetDetailedResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new HostedServiceGetDetailedResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element hostedServiceElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"HostedService");
            if (hostedServiceElement != null) {
                Element hostedServicePropertiesElement;
                Element serviceNameElement;
                Element urlElement2;
                Element deploymentsSequenceElement = XmlUtility.getElementByTagNameNS((Node)hostedServiceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Deployments");
                if (deploymentsSequenceElement != null) {
                    for (int i1 = 0; i1 < XmlUtility.getElementsByTagNameNS((Node)deploymentsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Deployment").size(); ++i1) {
                        Element dnsElement;
                        Element virtualIPsSequenceElement;
                        Element persistentVMDowntimeElement;
                        Element extendedPropertiesSequenceElement;
                        Element virtualNetworkNameElement;
                        Element lastModifiedTimeElement;
                        Element createdTimeElement;
                        Element rollbackAllowedElement;
                        Element lockedElement;
                        Element sdkVersionElement;
                        Element roleListSequenceElement;
                        Element upgradeDomainCountElement;
                        Element upgradeStatusElement;
                        Element roleInstanceListSequenceElement;
                        Element configurationElement;
                        Element urlElement;
                        Element labelElement;
                        Element statusElement;
                        Element privateIDElement;
                        Element deploymentSlotElement;
                        Element deploymentsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)deploymentsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Deployment").get(i1);
                        HostedServiceGetDetailedResponse.Deployment deploymentInstance = new HostedServiceGetDetailedResponse.Deployment();
                        result.getDeployments().add(deploymentInstance);
                        Element nameElement = XmlUtility.getElementByTagNameNS((Node)deploymentsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                        if (nameElement != null) {
                            String nameInstance = nameElement.getTextContent();
                            deploymentInstance.setName(nameInstance);
                        }
                        if ((deploymentSlotElement = XmlUtility.getElementByTagNameNS((Node)deploymentsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DeploymentSlot")) != null) {
                            DeploymentSlot deploymentSlotInstance = DeploymentSlot.valueOf(deploymentSlotElement.getTextContent());
                            deploymentInstance.setDeploymentSlot(deploymentSlotInstance);
                        }
                        if ((privateIDElement = XmlUtility.getElementByTagNameNS((Node)deploymentsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PrivateID")) != null) {
                            String privateIDInstance = privateIDElement.getTextContent();
                            deploymentInstance.setPrivateId(privateIDInstance);
                        }
                        if ((statusElement = XmlUtility.getElementByTagNameNS((Node)deploymentsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Status")) != null) {
                            DeploymentStatus statusInstance = DeploymentStatus.valueOf(statusElement.getTextContent());
                            deploymentInstance.setStatus(statusInstance);
                        }
                        if ((labelElement = XmlUtility.getElementByTagNameNS((Node)deploymentsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Label")) != null) {
                            String labelInstance = labelElement.getTextContent() != null ? new String(Base64.decode((String)labelElement.getTextContent())) : null;
                            deploymentInstance.setLabel(labelInstance);
                        }
                        if ((urlElement = XmlUtility.getElementByTagNameNS((Node)deploymentsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Url")) != null) {
                            URI urlInstance = new URI(urlElement.getTextContent());
                            deploymentInstance.setUri(urlInstance);
                        }
                        if ((configurationElement = XmlUtility.getElementByTagNameNS((Node)deploymentsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Configuration")) != null) {
                            String configurationInstance = configurationElement.getTextContent() != null ? new String(Base64.decode((String)configurationElement.getTextContent())) : null;
                            deploymentInstance.setConfiguration(configurationInstance);
                        }
                        if ((roleInstanceListSequenceElement = XmlUtility.getElementByTagNameNS((Node)deploymentsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RoleInstanceList")) != null) {
                            for (int i2 = 0; i2 < XmlUtility.getElementsByTagNameNS((Node)roleInstanceListSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RoleInstance").size(); ++i2) {
                                Element remoteAccessCertificateThumbprintElement;
                                Element hostNameElement;
                                Element powerStateElement;
                                Element resourceExtensionStatusListSequenceElement;
                                Element guestAgentStatusElement;
                                Element instanceEndpointsSequenceElement;
                                Element ipAddressElement;
                                Element instanceErrorCodeElement;
                                Element instanceStateDetailsElement;
                                Element instanceSizeElement;
                                Element instanceFaultDomainElement;
                                Element instanceUpgradeDomainElement;
                                Element instanceStatusElement;
                                Element instanceNameElement;
                                Element roleInstanceListElement = (Element)XmlUtility.getElementsByTagNameNS((Node)roleInstanceListSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RoleInstance").get(i2);
                                RoleInstance roleInstanceInstance = new RoleInstance();
                                deploymentInstance.getRoleInstances().add(roleInstanceInstance);
                                Element roleNameElement = XmlUtility.getElementByTagNameNS((Node)roleInstanceListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RoleName");
                                if (roleNameElement != null) {
                                    String roleNameInstance = roleNameElement.getTextContent();
                                    roleInstanceInstance.setRoleName(roleNameInstance);
                                }
                                if ((instanceNameElement = XmlUtility.getElementByTagNameNS((Node)roleInstanceListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"InstanceName")) != null) {
                                    String instanceNameInstance = instanceNameElement.getTextContent();
                                    roleInstanceInstance.setInstanceName(instanceNameInstance);
                                }
                                if ((instanceStatusElement = XmlUtility.getElementByTagNameNS((Node)roleInstanceListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"InstanceStatus")) != null) {
                                    String instanceStatusInstance = instanceStatusElement.getTextContent();
                                    roleInstanceInstance.setInstanceStatus(instanceStatusInstance);
                                }
                                if ((instanceUpgradeDomainElement = XmlUtility.getElementByTagNameNS((Node)roleInstanceListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"InstanceUpgradeDomain")) != null && !(instanceUpgradeDomainElement.getTextContent() == null || instanceUpgradeDomainElement.getTextContent().isEmpty())) {
                                    int instanceUpgradeDomainInstance = DatatypeConverter.parseInt((String)instanceUpgradeDomainElement.getTextContent());
                                    roleInstanceInstance.setInstanceUpgradeDomain(instanceUpgradeDomainInstance);
                                }
                                if ((instanceFaultDomainElement = XmlUtility.getElementByTagNameNS((Node)roleInstanceListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"InstanceFaultDomain")) != null && !(instanceFaultDomainElement.getTextContent() == null || instanceFaultDomainElement.getTextContent().isEmpty())) {
                                    int instanceFaultDomainInstance = DatatypeConverter.parseInt((String)instanceFaultDomainElement.getTextContent());
                                    roleInstanceInstance.setInstanceFaultDomain(instanceFaultDomainInstance);
                                }
                                if ((instanceSizeElement = XmlUtility.getElementByTagNameNS((Node)roleInstanceListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"InstanceSize")) != null) {
                                    String instanceSizeInstance = instanceSizeElement.getTextContent();
                                    roleInstanceInstance.setInstanceSize(instanceSizeInstance);
                                }
                                if ((instanceStateDetailsElement = XmlUtility.getElementByTagNameNS((Node)roleInstanceListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"InstanceStateDetails")) != null) {
                                    String instanceStateDetailsInstance = instanceStateDetailsElement.getTextContent();
                                    roleInstanceInstance.setInstanceStateDetails(instanceStateDetailsInstance);
                                }
                                if ((instanceErrorCodeElement = XmlUtility.getElementByTagNameNS((Node)roleInstanceListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"InstanceErrorCode")) != null) {
                                    String instanceErrorCodeInstance = instanceErrorCodeElement.getTextContent();
                                    roleInstanceInstance.setInstanceErrorCode(instanceErrorCodeInstance);
                                }
                                if ((ipAddressElement = XmlUtility.getElementByTagNameNS((Node)roleInstanceListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IpAddress")) != null) {
                                    InetAddress ipAddressInstance = InetAddress.getByName(ipAddressElement.getTextContent());
                                    roleInstanceInstance.setIPAddress(ipAddressInstance);
                                }
                                if ((instanceEndpointsSequenceElement = XmlUtility.getElementByTagNameNS((Node)roleInstanceListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"InstanceEndpoints")) != null) {
                                    for (int i3 = 0; i3 < XmlUtility.getElementsByTagNameNS((Node)instanceEndpointsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"InstanceEndpoint").size(); ++i3) {
                                        Element vipElement;
                                        Element protocolElement;
                                        Element publicPortElement;
                                        Element nameElement2;
                                        Element instanceEndpointsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)instanceEndpointsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"InstanceEndpoint").get(i3);
                                        InstanceEndpoint instanceEndpointInstance = new InstanceEndpoint();
                                        roleInstanceInstance.getInstanceEndpoints().add(instanceEndpointInstance);
                                        Element localPortElement = XmlUtility.getElementByTagNameNS((Node)instanceEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LocalPort");
                                        if (localPortElement != null && !(localPortElement.getTextContent() == null || localPortElement.getTextContent().isEmpty())) {
                                            int localPortInstance = DatatypeConverter.parseInt((String)localPortElement.getTextContent());
                                            instanceEndpointInstance.setLocalPort(localPortInstance);
                                        }
                                        if ((nameElement2 = XmlUtility.getElementByTagNameNS((Node)instanceEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name")) != null) {
                                            String nameInstance2 = nameElement2.getTextContent();
                                            instanceEndpointInstance.setName(nameInstance2);
                                        }
                                        if ((publicPortElement = XmlUtility.getElementByTagNameNS((Node)instanceEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublicPort")) != null) {
                                            int publicPortInstance = DatatypeConverter.parseInt((String)publicPortElement.getTextContent());
                                            instanceEndpointInstance.setPort(publicPortInstance);
                                        }
                                        if ((protocolElement = XmlUtility.getElementByTagNameNS((Node)instanceEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Protocol")) != null) {
                                            String protocolInstance = protocolElement.getTextContent();
                                            instanceEndpointInstance.setProtocol(protocolInstance);
                                        }
                                        if ((vipElement = XmlUtility.getElementByTagNameNS((Node)instanceEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Vip")) == null) continue;
                                        InetAddress vipInstance = InetAddress.getByName(vipElement.getTextContent());
                                        instanceEndpointInstance.setVirtualIPAddress(vipInstance);
                                    }
                                }
                                if ((guestAgentStatusElement = XmlUtility.getElementByTagNameNS((Node)roleInstanceListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"GuestAgentStatus")) != null) {
                                    Element formattedMessageElement;
                                    Element messageElement;
                                    Element codeElement;
                                    Element statusElement2;
                                    Element guestAgentVersionElement;
                                    Element timestampElement;
                                    GuestAgentStatus guestAgentStatusInstance = new GuestAgentStatus();
                                    roleInstanceInstance.setGuestAgentStatus(guestAgentStatusInstance);
                                    Element protocolVersionElement = XmlUtility.getElementByTagNameNS((Node)guestAgentStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ProtocolVersion");
                                    if (protocolVersionElement != null) {
                                        String protocolVersionInstance = protocolVersionElement.getTextContent();
                                        guestAgentStatusInstance.setProtocolVersion(protocolVersionInstance);
                                    }
                                    if ((timestampElement = XmlUtility.getElementByTagNameNS((Node)guestAgentStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Timestamp")) != null && !(timestampElement.getTextContent() == null || timestampElement.getTextContent().isEmpty())) {
                                        Calendar timestampInstance = DatatypeConverter.parseDateTime((String)timestampElement.getTextContent());
                                        guestAgentStatusInstance.setTimestamp(timestampInstance);
                                    }
                                    if ((guestAgentVersionElement = XmlUtility.getElementByTagNameNS((Node)guestAgentStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"GuestAgentVersion")) != null) {
                                        String guestAgentVersionInstance = guestAgentVersionElement.getTextContent();
                                        guestAgentStatusInstance.setGuestAgentVersion(guestAgentVersionInstance);
                                    }
                                    if ((statusElement2 = XmlUtility.getElementByTagNameNS((Node)guestAgentStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Status")) != null) {
                                        String statusInstance2 = statusElement2.getTextContent();
                                        guestAgentStatusInstance.setStatus(statusInstance2);
                                    }
                                    if ((codeElement = XmlUtility.getElementByTagNameNS((Node)guestAgentStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Code")) != null && !(codeElement.getTextContent() == null || codeElement.getTextContent().isEmpty())) {
                                        int codeInstance = DatatypeConverter.parseInt((String)codeElement.getTextContent());
                                        guestAgentStatusInstance.setCode(codeInstance);
                                    }
                                    if ((messageElement = XmlUtility.getElementByTagNameNS((Node)guestAgentStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Message")) != null) {
                                        Element paramListSequenceElement;
                                        GuestAgentMessage messageInstance = new GuestAgentMessage();
                                        guestAgentStatusInstance.setMessage(messageInstance);
                                        Element messageResourceIdElement = XmlUtility.getElementByTagNameNS((Node)messageElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"MessageResourceId");
                                        if (messageResourceIdElement != null) {
                                            String messageResourceIdInstance = messageResourceIdElement.getTextContent();
                                            messageInstance.setMessageResourceId(messageResourceIdInstance);
                                        }
                                        if ((paramListSequenceElement = XmlUtility.getElementByTagNameNS((Node)messageElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ParamList")) != null) {
                                            for (int i4 = 0; i4 < XmlUtility.getElementsByTagNameNS((Node)paramListSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Param").size(); ++i4) {
                                                Element paramListElement = (Element)XmlUtility.getElementsByTagNameNS((Node)paramListSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Param").get(i4);
                                                messageInstance.getParamList().add(paramListElement.getTextContent());
                                            }
                                        }
                                    }
                                    if ((formattedMessageElement = XmlUtility.getElementByTagNameNS((Node)guestAgentStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"FormattedMessage")) != null) {
                                        Element messageElement2;
                                        GuestAgentFormattedMessage formattedMessageInstance = new GuestAgentFormattedMessage();
                                        guestAgentStatusInstance.setFormattedMessage(formattedMessageInstance);
                                        Element languageElement = XmlUtility.getElementByTagNameNS((Node)formattedMessageElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Language");
                                        if (languageElement != null) {
                                            String languageInstance = languageElement.getTextContent();
                                            formattedMessageInstance.setLanguage(languageInstance);
                                        }
                                        if ((messageElement2 = XmlUtility.getElementByTagNameNS((Node)formattedMessageElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Message")) != null) {
                                            String messageInstance2 = messageElement2.getTextContent();
                                            formattedMessageInstance.setMessage(messageInstance2);
                                        }
                                    }
                                }
                                if ((resourceExtensionStatusListSequenceElement = XmlUtility.getElementByTagNameNS((Node)roleInstanceListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ResourceExtensionStatusList")) != null) {
                                    for (int i5 = 0; i5 < XmlUtility.getElementsByTagNameNS((Node)resourceExtensionStatusListSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ResourceExtensionStatus").size(); ++i5) {
                                        Element subStatusListSequenceElement;
                                        Element formattedMessageElement3;
                                        Element messageElement5;
                                        Element codeElement3;
                                        Element statusElement4;
                                        Element operationElement;
                                        Element nameElement3;
                                        Element configurationAppliedTimeElement;
                                        Element extensionSettingStatusElement;
                                        Element formattedMessageElement2;
                                        Element messageElement3;
                                        Element codeElement2;
                                        Element statusElement3;
                                        Element versionElement;
                                        Element resourceExtensionStatusListElement = (Element)XmlUtility.getElementsByTagNameNS((Node)resourceExtensionStatusListSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ResourceExtensionStatus").get(i5);
                                        ResourceExtensionStatus resourceExtensionStatusInstance = new ResourceExtensionStatus();
                                        roleInstanceInstance.getResourceExtensionStatusList().add(resourceExtensionStatusInstance);
                                        Element handlerNameElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionStatusListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"HandlerName");
                                        if (handlerNameElement != null) {
                                            String handlerNameInstance = handlerNameElement.getTextContent();
                                            resourceExtensionStatusInstance.setHandlerName(handlerNameInstance);
                                        }
                                        if ((versionElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionStatusListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Version")) != null) {
                                            String versionInstance = versionElement.getTextContent();
                                            resourceExtensionStatusInstance.setVersion(versionInstance);
                                        }
                                        if ((statusElement3 = XmlUtility.getElementByTagNameNS((Node)resourceExtensionStatusListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Status")) != null) {
                                            String statusInstance3 = statusElement3.getTextContent();
                                            resourceExtensionStatusInstance.setStatus(statusInstance3);
                                        }
                                        if ((codeElement2 = XmlUtility.getElementByTagNameNS((Node)resourceExtensionStatusListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Code")) != null && !(codeElement2.getTextContent() == null || codeElement2.getTextContent().isEmpty())) {
                                            int codeInstance2 = DatatypeConverter.parseInt((String)codeElement2.getTextContent());
                                            resourceExtensionStatusInstance.setCode(codeInstance2);
                                        }
                                        if ((messageElement3 = XmlUtility.getElementByTagNameNS((Node)resourceExtensionStatusListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Message")) != null) {
                                            Element paramListSequenceElement2;
                                            GuestAgentMessage messageInstance3 = new GuestAgentMessage();
                                            resourceExtensionStatusInstance.setMessage(messageInstance3);
                                            Element messageResourceIdElement2 = XmlUtility.getElementByTagNameNS((Node)messageElement3, (String)"http://schemas.microsoft.com/windowsazure", (String)"MessageResourceId");
                                            if (messageResourceIdElement2 != null) {
                                                String messageResourceIdInstance2 = messageResourceIdElement2.getTextContent();
                                                messageInstance3.setMessageResourceId(messageResourceIdInstance2);
                                            }
                                            if ((paramListSequenceElement2 = XmlUtility.getElementByTagNameNS((Node)messageElement3, (String)"http://schemas.microsoft.com/windowsazure", (String)"ParamList")) != null) {
                                                for (int i6 = 0; i6 < XmlUtility.getElementsByTagNameNS((Node)paramListSequenceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Param").size(); ++i6) {
                                                    Element paramListElement2 = (Element)XmlUtility.getElementsByTagNameNS((Node)paramListSequenceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Param").get(i6);
                                                    messageInstance3.getParamList().add(paramListElement2.getTextContent());
                                                }
                                            }
                                        }
                                        if ((formattedMessageElement2 = XmlUtility.getElementByTagNameNS((Node)resourceExtensionStatusListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"FormattedMessage")) != null) {
                                            Element messageElement4;
                                            GuestAgentFormattedMessage formattedMessageInstance2 = new GuestAgentFormattedMessage();
                                            resourceExtensionStatusInstance.setFormattedMessage(formattedMessageInstance2);
                                            Element languageElement2 = XmlUtility.getElementByTagNameNS((Node)formattedMessageElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Language");
                                            if (languageElement2 != null) {
                                                String languageInstance2 = languageElement2.getTextContent();
                                                formattedMessageInstance2.setLanguage(languageInstance2);
                                            }
                                            if ((messageElement4 = XmlUtility.getElementByTagNameNS((Node)formattedMessageElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Message")) != null) {
                                                String messageInstance4 = messageElement4.getTextContent();
                                                formattedMessageInstance2.setMessage(messageInstance4);
                                            }
                                        }
                                        if ((extensionSettingStatusElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionStatusListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ExtensionSettingStatus")) == null) continue;
                                        ResourceExtensionConfigurationStatus extensionSettingStatusInstance = new ResourceExtensionConfigurationStatus();
                                        resourceExtensionStatusInstance.setExtensionSettingStatus(extensionSettingStatusInstance);
                                        Element timestampElement2 = XmlUtility.getElementByTagNameNS((Node)extensionSettingStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Timestamp");
                                        if (timestampElement2 != null && !(timestampElement2.getTextContent() == null || timestampElement2.getTextContent().isEmpty())) {
                                            Calendar timestampInstance2 = DatatypeConverter.parseDateTime((String)timestampElement2.getTextContent());
                                            extensionSettingStatusInstance.setTimestamp(timestampInstance2);
                                        }
                                        if ((configurationAppliedTimeElement = XmlUtility.getElementByTagNameNS((Node)extensionSettingStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ConfigurationAppliedTime")) != null && !(configurationAppliedTimeElement.getTextContent() == null || configurationAppliedTimeElement.getTextContent().isEmpty())) {
                                            Calendar configurationAppliedTimeInstance = DatatypeConverter.parseDateTime((String)configurationAppliedTimeElement.getTextContent());
                                            extensionSettingStatusInstance.setConfigurationAppliedTime(configurationAppliedTimeInstance);
                                        }
                                        if ((nameElement3 = XmlUtility.getElementByTagNameNS((Node)extensionSettingStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name")) != null) {
                                            String nameInstance3 = nameElement3.getTextContent();
                                            extensionSettingStatusInstance.setName(nameInstance3);
                                        }
                                        if ((operationElement = XmlUtility.getElementByTagNameNS((Node)extensionSettingStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Operation")) != null) {
                                            String operationInstance = operationElement.getTextContent();
                                            extensionSettingStatusInstance.setOperation(operationInstance);
                                        }
                                        if ((statusElement4 = XmlUtility.getElementByTagNameNS((Node)extensionSettingStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Status")) != null) {
                                            String statusInstance4 = statusElement4.getTextContent();
                                            extensionSettingStatusInstance.setStatus(statusInstance4);
                                        }
                                        if ((codeElement3 = XmlUtility.getElementByTagNameNS((Node)extensionSettingStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Code")) != null && !(codeElement3.getTextContent() == null || codeElement3.getTextContent().isEmpty())) {
                                            int codeInstance3 = DatatypeConverter.parseInt((String)codeElement3.getTextContent());
                                            extensionSettingStatusInstance.setCode(codeInstance3);
                                        }
                                        if ((messageElement5 = XmlUtility.getElementByTagNameNS((Node)extensionSettingStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Message")) != null) {
                                            Element paramListSequenceElement3;
                                            GuestAgentMessage messageInstance5 = new GuestAgentMessage();
                                            extensionSettingStatusInstance.setMessage(messageInstance5);
                                            Element messageResourceIdElement3 = XmlUtility.getElementByTagNameNS((Node)messageElement5, (String)"http://schemas.microsoft.com/windowsazure", (String)"MessageResourceId");
                                            if (messageResourceIdElement3 != null) {
                                                String messageResourceIdInstance3 = messageResourceIdElement3.getTextContent();
                                                messageInstance5.setMessageResourceId(messageResourceIdInstance3);
                                            }
                                            if ((paramListSequenceElement3 = XmlUtility.getElementByTagNameNS((Node)messageElement5, (String)"http://schemas.microsoft.com/windowsazure", (String)"ParamList")) != null) {
                                                for (int i7 = 0; i7 < XmlUtility.getElementsByTagNameNS((Node)paramListSequenceElement3, (String)"http://schemas.microsoft.com/windowsazure", (String)"Param").size(); ++i7) {
                                                    Element paramListElement3 = (Element)XmlUtility.getElementsByTagNameNS((Node)paramListSequenceElement3, (String)"http://schemas.microsoft.com/windowsazure", (String)"Param").get(i7);
                                                    messageInstance5.getParamList().add(paramListElement3.getTextContent());
                                                }
                                            }
                                        }
                                        if ((formattedMessageElement3 = XmlUtility.getElementByTagNameNS((Node)extensionSettingStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"FormattedMessage")) != null) {
                                            Element messageElement6;
                                            GuestAgentFormattedMessage formattedMessageInstance3 = new GuestAgentFormattedMessage();
                                            extensionSettingStatusInstance.setFormattedMessage(formattedMessageInstance3);
                                            Element languageElement3 = XmlUtility.getElementByTagNameNS((Node)formattedMessageElement3, (String)"http://schemas.microsoft.com/windowsazure", (String)"Language");
                                            if (languageElement3 != null) {
                                                String languageInstance3 = languageElement3.getTextContent();
                                                formattedMessageInstance3.setLanguage(languageInstance3);
                                            }
                                            if ((messageElement6 = XmlUtility.getElementByTagNameNS((Node)formattedMessageElement3, (String)"http://schemas.microsoft.com/windowsazure", (String)"Message")) != null) {
                                                String messageInstance6 = messageElement6.getTextContent();
                                                formattedMessageInstance3.setMessage(messageInstance6);
                                            }
                                        }
                                        if ((subStatusListSequenceElement = XmlUtility.getElementByTagNameNS((Node)extensionSettingStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SubStatusList")) == null) continue;
                                        for (int i8 = 0; i8 < XmlUtility.getElementsByTagNameNS((Node)subStatusListSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SubStatus").size(); ++i8) {
                                            Element messageElement8;
                                            Element formattedMessageElement4;
                                            Element messageElement7;
                                            Element codeElement4;
                                            Element statusElement5;
                                            Element subStatusListElement = (Element)XmlUtility.getElementsByTagNameNS((Node)subStatusListSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SubStatus").get(i8);
                                            ResourceExtensionSubStatus subStatusInstance = new ResourceExtensionSubStatus();
                                            extensionSettingStatusInstance.getSubStatusList().add(subStatusInstance);
                                            Element nameElement4 = XmlUtility.getElementByTagNameNS((Node)subStatusListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                                            if (nameElement4 != null) {
                                                String nameInstance4 = nameElement4.getTextContent();
                                                subStatusInstance.setName(nameInstance4);
                                            }
                                            if ((statusElement5 = XmlUtility.getElementByTagNameNS((Node)subStatusListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Status")) != null) {
                                                String statusInstance5 = statusElement5.getTextContent();
                                                subStatusInstance.setStatus(statusInstance5);
                                            }
                                            if ((codeElement4 = XmlUtility.getElementByTagNameNS((Node)subStatusListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Code")) != null && !(codeElement4.getTextContent() == null || codeElement4.getTextContent().isEmpty())) {
                                                int codeInstance4 = DatatypeConverter.parseInt((String)codeElement4.getTextContent());
                                                subStatusInstance.setCode(codeInstance4);
                                            }
                                            if ((messageElement7 = XmlUtility.getElementByTagNameNS((Node)subStatusListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Message")) != null) {
                                                Element paramListSequenceElement4;
                                                GuestAgentMessage messageInstance7 = new GuestAgentMessage();
                                                subStatusInstance.setMessage(messageInstance7);
                                                Element messageResourceIdElement4 = XmlUtility.getElementByTagNameNS((Node)messageElement7, (String)"http://schemas.microsoft.com/windowsazure", (String)"MessageResourceId");
                                                if (messageResourceIdElement4 != null) {
                                                    String messageResourceIdInstance4 = messageResourceIdElement4.getTextContent();
                                                    messageInstance7.setMessageResourceId(messageResourceIdInstance4);
                                                }
                                                if ((paramListSequenceElement4 = XmlUtility.getElementByTagNameNS((Node)messageElement7, (String)"http://schemas.microsoft.com/windowsazure", (String)"ParamList")) != null) {
                                                    for (int i9 = 0; i9 < XmlUtility.getElementsByTagNameNS((Node)paramListSequenceElement4, (String)"http://schemas.microsoft.com/windowsazure", (String)"Param").size(); ++i9) {
                                                        Element paramListElement4 = (Element)XmlUtility.getElementsByTagNameNS((Node)paramListSequenceElement4, (String)"http://schemas.microsoft.com/windowsazure", (String)"Param").get(i9);
                                                        messageInstance7.getParamList().add(paramListElement4.getTextContent());
                                                    }
                                                }
                                            }
                                            if ((formattedMessageElement4 = XmlUtility.getElementByTagNameNS((Node)subStatusListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"FormattedMessage")) == null) continue;
                                            GuestAgentFormattedMessage formattedMessageInstance4 = new GuestAgentFormattedMessage();
                                            subStatusInstance.setFormattedMessage(formattedMessageInstance4);
                                            Element languageElement4 = XmlUtility.getElementByTagNameNS((Node)formattedMessageElement4, (String)"http://schemas.microsoft.com/windowsazure", (String)"Language");
                                            if (languageElement4 != null) {
                                                String languageInstance4 = languageElement4.getTextContent();
                                                formattedMessageInstance4.setLanguage(languageInstance4);
                                            }
                                            if ((messageElement8 = XmlUtility.getElementByTagNameNS((Node)formattedMessageElement4, (String)"http://schemas.microsoft.com/windowsazure", (String)"Message")) == null) continue;
                                            String messageInstance8 = messageElement8.getTextContent();
                                            formattedMessageInstance4.setMessage(messageInstance8);
                                        }
                                    }
                                }
                                if ((powerStateElement = XmlUtility.getElementByTagNameNS((Node)roleInstanceListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PowerState")) != null) {
                                    RoleInstancePowerState powerStateInstance = RoleInstancePowerState.valueOf(powerStateElement.getTextContent());
                                    roleInstanceInstance.setPowerState(powerStateInstance);
                                }
                                if ((hostNameElement = XmlUtility.getElementByTagNameNS((Node)roleInstanceListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"HostName")) != null) {
                                    String hostNameInstance = hostNameElement.getTextContent();
                                    roleInstanceInstance.setHostName(hostNameInstance);
                                }
                                if ((remoteAccessCertificateThumbprintElement = XmlUtility.getElementByTagNameNS((Node)roleInstanceListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RemoteAccessCertificateThumbprint")) == null) continue;
                                String remoteAccessCertificateThumbprintInstance = remoteAccessCertificateThumbprintElement.getTextContent();
                                roleInstanceInstance.setRemoteAccessCertificateThumbprint(remoteAccessCertificateThumbprintInstance);
                            }
                        }
                        if ((upgradeStatusElement = XmlUtility.getElementByTagNameNS((Node)deploymentsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"UpgradeStatus")) != null) {
                            Element currentUpgradeDomainElement;
                            Element currentUpgradeDomainStateElement;
                            UpgradeStatus upgradeStatusInstance = new UpgradeStatus();
                            deploymentInstance.setUpgradeStatus(upgradeStatusInstance);
                            Element upgradeTypeElement = XmlUtility.getElementByTagNameNS((Node)upgradeStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"UpgradeType");
                            if (upgradeTypeElement != null) {
                                DeploymentUpgradeType upgradeTypeInstance = DeploymentUpgradeType.valueOf(upgradeTypeElement.getTextContent());
                                upgradeStatusInstance.setUpgradeType(upgradeTypeInstance);
                            }
                            if ((currentUpgradeDomainStateElement = XmlUtility.getElementByTagNameNS((Node)upgradeStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"CurrentUpgradeDomainState")) != null) {
                                UpgradeDomainState currentUpgradeDomainStateInstance = UpgradeDomainState.valueOf(currentUpgradeDomainStateElement.getTextContent());
                                upgradeStatusInstance.setCurrentUpgradeDomainState(currentUpgradeDomainStateInstance);
                            }
                            if ((currentUpgradeDomainElement = XmlUtility.getElementByTagNameNS((Node)upgradeStatusElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"CurrentUpgradeDomain")) != null) {
                                int currentUpgradeDomainInstance = DatatypeConverter.parseInt((String)currentUpgradeDomainElement.getTextContent());
                                upgradeStatusInstance.setCurrentUpgradeDomain(currentUpgradeDomainInstance);
                            }
                        }
                        if ((upgradeDomainCountElement = XmlUtility.getElementByTagNameNS((Node)deploymentsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"UpgradeDomainCount")) != null) {
                            int upgradeDomainCountInstance = DatatypeConverter.parseInt((String)upgradeDomainCountElement.getTextContent());
                            deploymentInstance.setUpgradeDomainCount(upgradeDomainCountInstance);
                        }
                        if ((roleListSequenceElement = XmlUtility.getElementByTagNameNS((Node)deploymentsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RoleList")) != null) {
                            for (int i10 = 0; i10 < XmlUtility.getElementsByTagNameNS((Node)roleListSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Role").size(); ++i10) {
                                Element defaultWinRmCertificateThumbprintElement;
                                Element provisionGuestAgentElement;
                                Element roleSizeElement;
                                Element oSVirtualHardDiskElement;
                                Element labelElement2;
                                Element dataVirtualHardDisksSequenceElement;
                                Element availabilitySetNameElement;
                                Element vMImageNameElement;
                                Element resourceExtensionReferencesSequenceElement;
                                Element configurationSetsSequenceElement;
                                Element roleTypeElement;
                                Element osVersionElement;
                                Element roleListElement = (Element)XmlUtility.getElementsByTagNameNS((Node)roleListSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Role").get(i10);
                                Role roleInstance = new Role();
                                deploymentInstance.getRoles().add(roleInstance);
                                Element roleNameElement2 = XmlUtility.getElementByTagNameNS((Node)roleListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RoleName");
                                if (roleNameElement2 != null) {
                                    String roleNameInstance2 = roleNameElement2.getTextContent();
                                    roleInstance.setRoleName(roleNameInstance2);
                                }
                                if ((osVersionElement = XmlUtility.getElementByTagNameNS((Node)roleListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"OsVersion")) != null) {
                                    String osVersionInstance = osVersionElement.getTextContent();
                                    roleInstance.setOSVersion(osVersionInstance);
                                }
                                if ((roleTypeElement = XmlUtility.getElementByTagNameNS((Node)roleListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RoleType")) != null) {
                                    String roleTypeInstance = roleTypeElement.getTextContent();
                                    roleInstance.setRoleType(roleTypeInstance);
                                }
                                if ((configurationSetsSequenceElement = XmlUtility.getElementByTagNameNS((Node)roleListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ConfigurationSets")) != null) {
                                    for (int i11 = 0; i11 < XmlUtility.getElementsByTagNameNS((Node)configurationSetsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ConfigurationSet").size(); ++i11) {
                                        Element customDataElement;
                                        Element sSHElement;
                                        Element disableSshPasswordAuthenticationElement;
                                        Element userPasswordElement;
                                        Element userNameElement;
                                        Element hostNameElement2;
                                        Element adminUsernameElement;
                                        Element winRMElement;
                                        Element storedCertificateSettingsSequenceElement;
                                        Element domainJoinElement;
                                        Element timeZoneElement;
                                        Element enableAutomaticUpdatesElement;
                                        Element resetPasswordOnFirstLogonElement;
                                        Element adminPasswordElement;
                                        Element computerNameElement;
                                        Element staticVirtualNetworkIPAddressElement;
                                        Element subnetNamesSequenceElement;
                                        Element inputEndpointsSequenceElement;
                                        Element configurationSetsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)configurationSetsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ConfigurationSet").get(i11);
                                        ConfigurationSet configurationSetInstance = new ConfigurationSet();
                                        roleInstance.getConfigurationSets().add(configurationSetInstance);
                                        Element configurationSetTypeElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ConfigurationSetType");
                                        if (configurationSetTypeElement != null) {
                                            String configurationSetTypeInstance = configurationSetTypeElement.getTextContent();
                                            configurationSetInstance.setConfigurationSetType(configurationSetTypeInstance);
                                        }
                                        if ((inputEndpointsSequenceElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"InputEndpoints")) != null) {
                                            for (int i12 = 0; i12 < XmlUtility.getElementsByTagNameNS((Node)inputEndpointsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"InputEndpoint").size(); ++i12) {
                                                Element endpointAclElement;
                                                Element enableDirectServerReturnElement;
                                                Element vipElement2;
                                                Element protocolElement3;
                                                Element loadBalancerProbeElement;
                                                Element portElement;
                                                Element nameElement5;
                                                Element localPortElement2;
                                                Element inputEndpointsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)inputEndpointsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"InputEndpoint").get(i12);
                                                InputEndpoint inputEndpointInstance = new InputEndpoint();
                                                configurationSetInstance.getInputEndpoints().add(inputEndpointInstance);
                                                Element loadBalancedEndpointSetNameElement = XmlUtility.getElementByTagNameNS((Node)inputEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LoadBalancedEndpointSetName");
                                                if (loadBalancedEndpointSetNameElement != null) {
                                                    String loadBalancedEndpointSetNameInstance = loadBalancedEndpointSetNameElement.getTextContent();
                                                    inputEndpointInstance.setLoadBalancedEndpointSetName(loadBalancedEndpointSetNameInstance);
                                                }
                                                if ((localPortElement2 = XmlUtility.getElementByTagNameNS((Node)inputEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LocalPort")) != null && !(localPortElement2.getTextContent() == null || localPortElement2.getTextContent().isEmpty())) {
                                                    int localPortInstance2 = DatatypeConverter.parseInt((String)localPortElement2.getTextContent());
                                                    inputEndpointInstance.setLocalPort(localPortInstance2);
                                                }
                                                if ((nameElement5 = XmlUtility.getElementByTagNameNS((Node)inputEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name")) != null) {
                                                    String nameInstance5 = nameElement5.getTextContent();
                                                    inputEndpointInstance.setName(nameInstance5);
                                                }
                                                if ((portElement = XmlUtility.getElementByTagNameNS((Node)inputEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Port")) != null && !(portElement.getTextContent() == null || portElement.getTextContent().isEmpty())) {
                                                    int portInstance = DatatypeConverter.parseInt((String)portElement.getTextContent());
                                                    inputEndpointInstance.setPort(portInstance);
                                                }
                                                if ((loadBalancerProbeElement = XmlUtility.getElementByTagNameNS((Node)inputEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LoadBalancerProbe")) != null) {
                                                    Element timeoutInSecondsElement;
                                                    Element intervalInSecondsElement;
                                                    Element protocolElement2;
                                                    Element portElement2;
                                                    LoadBalancerProbe loadBalancerProbeInstance = new LoadBalancerProbe();
                                                    inputEndpointInstance.setLoadBalancerProbe(loadBalancerProbeInstance);
                                                    Element pathElement = XmlUtility.getElementByTagNameNS((Node)loadBalancerProbeElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Path");
                                                    if (pathElement != null) {
                                                        String pathInstance = pathElement.getTextContent();
                                                        loadBalancerProbeInstance.setPath(pathInstance);
                                                    }
                                                    if ((portElement2 = XmlUtility.getElementByTagNameNS((Node)loadBalancerProbeElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Port")) != null) {
                                                        int portInstance2 = DatatypeConverter.parseInt((String)portElement2.getTextContent());
                                                        loadBalancerProbeInstance.setPort(portInstance2);
                                                    }
                                                    if ((protocolElement2 = XmlUtility.getElementByTagNameNS((Node)loadBalancerProbeElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Protocol")) != null) {
                                                        LoadBalancerProbeTransportProtocol protocolInstance2 = ComputeManagementClientImpl.parseLoadBalancerProbeTransportProtocol(protocolElement2.getTextContent());
                                                        loadBalancerProbeInstance.setProtocol(protocolInstance2);
                                                    }
                                                    if ((intervalInSecondsElement = XmlUtility.getElementByTagNameNS((Node)loadBalancerProbeElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IntervalInSeconds")) != null && !(intervalInSecondsElement.getTextContent() == null || intervalInSecondsElement.getTextContent().isEmpty())) {
                                                        int intervalInSecondsInstance = DatatypeConverter.parseInt((String)intervalInSecondsElement.getTextContent());
                                                        loadBalancerProbeInstance.setIntervalInSeconds(intervalInSecondsInstance);
                                                    }
                                                    if ((timeoutInSecondsElement = XmlUtility.getElementByTagNameNS((Node)loadBalancerProbeElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"TimeoutInSeconds")) != null && !(timeoutInSecondsElement.getTextContent() == null || timeoutInSecondsElement.getTextContent().isEmpty())) {
                                                        int timeoutInSecondsInstance = DatatypeConverter.parseInt((String)timeoutInSecondsElement.getTextContent());
                                                        loadBalancerProbeInstance.setTimeoutInSeconds(timeoutInSecondsInstance);
                                                    }
                                                }
                                                if ((protocolElement3 = XmlUtility.getElementByTagNameNS((Node)inputEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Protocol")) != null) {
                                                    String protocolInstance3 = protocolElement3.getTextContent();
                                                    inputEndpointInstance.setProtocol(protocolInstance3);
                                                }
                                                if ((vipElement2 = XmlUtility.getElementByTagNameNS((Node)inputEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Vip")) != null) {
                                                    InetAddress vipInstance2 = InetAddress.getByName(vipElement2.getTextContent());
                                                    inputEndpointInstance.setVirtualIPAddress(vipInstance2);
                                                }
                                                if ((enableDirectServerReturnElement = XmlUtility.getElementByTagNameNS((Node)inputEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"EnableDirectServerReturn")) != null && !(enableDirectServerReturnElement.getTextContent() == null || enableDirectServerReturnElement.getTextContent().isEmpty())) {
                                                    boolean enableDirectServerReturnInstance = DatatypeConverter.parseBoolean((String)enableDirectServerReturnElement.getTextContent().toLowerCase());
                                                    inputEndpointInstance.setEnableDirectServerReturn(enableDirectServerReturnInstance);
                                                }
                                                if ((endpointAclElement = XmlUtility.getElementByTagNameNS((Node)inputEndpointsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"EndpointAcl")) == null) continue;
                                                EndpointAcl endpointAclInstance = new EndpointAcl();
                                                inputEndpointInstance.setEndpointAcl(endpointAclInstance);
                                                Element rulesSequenceElement = XmlUtility.getElementByTagNameNS((Node)endpointAclElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Rules");
                                                if (rulesSequenceElement == null) continue;
                                                for (int i13 = 0; i13 < XmlUtility.getElementsByTagNameNS((Node)rulesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Rule").size(); ++i13) {
                                                    Element descriptionElement;
                                                    Element remoteSubnetElement;
                                                    Element actionElement;
                                                    Element rulesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)rulesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Rule").get(i13);
                                                    AccessControlListRule ruleInstance = new AccessControlListRule();
                                                    endpointAclInstance.getRules().add(ruleInstance);
                                                    Element orderElement = XmlUtility.getElementByTagNameNS((Node)rulesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Order");
                                                    if (orderElement != null && !(orderElement.getTextContent() == null || orderElement.getTextContent().isEmpty())) {
                                                        int orderInstance = DatatypeConverter.parseInt((String)orderElement.getTextContent());
                                                        ruleInstance.setOrder(orderInstance);
                                                    }
                                                    if ((actionElement = XmlUtility.getElementByTagNameNS((Node)rulesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Action")) != null) {
                                                        String actionInstance = actionElement.getTextContent();
                                                        ruleInstance.setAction(actionInstance);
                                                    }
                                                    if ((remoteSubnetElement = XmlUtility.getElementByTagNameNS((Node)rulesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RemoteSubnet")) != null) {
                                                        String remoteSubnetInstance = remoteSubnetElement.getTextContent();
                                                        ruleInstance.setRemoteSubnet(remoteSubnetInstance);
                                                    }
                                                    if ((descriptionElement = XmlUtility.getElementByTagNameNS((Node)rulesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Description")) == null) continue;
                                                    String descriptionInstance = descriptionElement.getTextContent();
                                                    ruleInstance.setDescription(descriptionInstance);
                                                }
                                            }
                                        }
                                        if ((subnetNamesSequenceElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SubnetNames")) != null) {
                                            for (int i14 = 0; i14 < XmlUtility.getElementsByTagNameNS((Node)subnetNamesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SubnetName").size(); ++i14) {
                                                Element subnetNamesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)subnetNamesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SubnetName").get(i14);
                                                configurationSetInstance.getSubnetNames().add(subnetNamesElement.getTextContent());
                                            }
                                        }
                                        if ((staticVirtualNetworkIPAddressElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StaticVirtualNetworkIPAddress")) != null) {
                                            String staticVirtualNetworkIPAddressInstance = staticVirtualNetworkIPAddressElement.getTextContent();
                                            configurationSetInstance.setStaticVirtualNetworkIPAddress(staticVirtualNetworkIPAddressInstance);
                                        }
                                        if ((computerNameElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ComputerName")) != null) {
                                            String computerNameInstance = computerNameElement.getTextContent();
                                            configurationSetInstance.setComputerName(computerNameInstance);
                                        }
                                        if ((adminPasswordElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AdminPassword")) != null) {
                                            String adminPasswordInstance = adminPasswordElement.getTextContent();
                                            configurationSetInstance.setAdminPassword(adminPasswordInstance);
                                        }
                                        if ((resetPasswordOnFirstLogonElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ResetPasswordOnFirstLogon")) != null && !(resetPasswordOnFirstLogonElement.getTextContent() == null || resetPasswordOnFirstLogonElement.getTextContent().isEmpty())) {
                                            boolean resetPasswordOnFirstLogonInstance = DatatypeConverter.parseBoolean((String)resetPasswordOnFirstLogonElement.getTextContent().toLowerCase());
                                            configurationSetInstance.setResetPasswordOnFirstLogon(resetPasswordOnFirstLogonInstance);
                                        }
                                        if ((enableAutomaticUpdatesElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"EnableAutomaticUpdates")) != null && !(enableAutomaticUpdatesElement.getTextContent() == null || enableAutomaticUpdatesElement.getTextContent().isEmpty())) {
                                            boolean enableAutomaticUpdatesInstance = DatatypeConverter.parseBoolean((String)enableAutomaticUpdatesElement.getTextContent().toLowerCase());
                                            configurationSetInstance.setEnableAutomaticUpdates(enableAutomaticUpdatesInstance);
                                        }
                                        if ((timeZoneElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"TimeZone")) != null) {
                                            String timeZoneInstance = timeZoneElement.getTextContent();
                                            configurationSetInstance.setTimeZone(timeZoneInstance);
                                        }
                                        if ((domainJoinElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DomainJoin")) != null) {
                                            Element provisioningElement;
                                            Element machineObjectOUElement;
                                            Element joinDomainElement;
                                            DomainJoinSettings domainJoinInstance = new DomainJoinSettings();
                                            configurationSetInstance.setDomainJoin(domainJoinInstance);
                                            Element credentialsElement = XmlUtility.getElementByTagNameNS((Node)domainJoinElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Credentials");
                                            if (credentialsElement != null) {
                                                Element passwordElement;
                                                Element usernameElement;
                                                DomainJoinCredentials credentialsInstance = new DomainJoinCredentials();
                                                domainJoinInstance.setCredentials(credentialsInstance);
                                                Element domainElement = XmlUtility.getElementByTagNameNS((Node)credentialsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Domain");
                                                if (domainElement != null) {
                                                    String domainInstance = domainElement.getTextContent();
                                                    credentialsInstance.setDomain(domainInstance);
                                                }
                                                if ((usernameElement = XmlUtility.getElementByTagNameNS((Node)credentialsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Username")) != null) {
                                                    String usernameInstance = usernameElement.getTextContent();
                                                    credentialsInstance.setUserName(usernameInstance);
                                                }
                                                if ((passwordElement = XmlUtility.getElementByTagNameNS((Node)credentialsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Password")) != null) {
                                                    String passwordInstance = passwordElement.getTextContent();
                                                    credentialsInstance.setPassword(passwordInstance);
                                                }
                                            }
                                            if ((joinDomainElement = XmlUtility.getElementByTagNameNS((Node)domainJoinElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"JoinDomain")) != null) {
                                                String joinDomainInstance = joinDomainElement.getTextContent();
                                                domainJoinInstance.setDomainToJoin(joinDomainInstance);
                                            }
                                            if ((machineObjectOUElement = XmlUtility.getElementByTagNameNS((Node)domainJoinElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"MachineObjectOU")) != null) {
                                                String machineObjectOUInstance = machineObjectOUElement.getTextContent();
                                                domainJoinInstance.setLdapMachineObjectOU(machineObjectOUInstance);
                                            }
                                            if ((provisioningElement = XmlUtility.getElementByTagNameNS((Node)domainJoinElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Provisioning")) != null) {
                                                DomainJoinProvisioning provisioningInstance = new DomainJoinProvisioning();
                                                domainJoinInstance.setProvisioning(provisioningInstance);
                                                Element accountDataElement = XmlUtility.getElementByTagNameNS((Node)provisioningElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AccountData");
                                                if (accountDataElement != null) {
                                                    String accountDataInstance = accountDataElement.getTextContent();
                                                    provisioningInstance.setAccountData(accountDataInstance);
                                                }
                                            }
                                        }
                                        if ((storedCertificateSettingsSequenceElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StoredCertificateSettings")) != null) {
                                            for (int i15 = 0; i15 < XmlUtility.getElementsByTagNameNS((Node)storedCertificateSettingsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"CertificateSetting").size(); ++i15) {
                                                Element thumbprintElement;
                                                Element storeNameElement;
                                                Element storedCertificateSettingsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)storedCertificateSettingsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"CertificateSetting").get(i15);
                                                StoredCertificateSettings certificateSettingInstance = new StoredCertificateSettings();
                                                configurationSetInstance.getStoredCertificateSettings().add(certificateSettingInstance);
                                                Element storeLocationElement = XmlUtility.getElementByTagNameNS((Node)storedCertificateSettingsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StoreLocation");
                                                if (storeLocationElement != null) {
                                                    // empty if block
                                                }
                                                if ((storeNameElement = XmlUtility.getElementByTagNameNS((Node)storedCertificateSettingsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StoreName")) != null) {
                                                    String storeNameInstance = storeNameElement.getTextContent();
                                                    certificateSettingInstance.setStoreName(storeNameInstance);
                                                }
                                                if ((thumbprintElement = XmlUtility.getElementByTagNameNS((Node)storedCertificateSettingsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Thumbprint")) == null) continue;
                                                String thumbprintInstance = thumbprintElement.getTextContent();
                                                certificateSettingInstance.setThumbprint(thumbprintInstance);
                                            }
                                        }
                                        if ((winRMElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"WinRM")) != null) {
                                            WindowsRemoteManagementSettings winRMInstance = new WindowsRemoteManagementSettings();
                                            configurationSetInstance.setWindowsRemoteManagement(winRMInstance);
                                            Element listenersSequenceElement = XmlUtility.getElementByTagNameNS((Node)winRMElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Listeners");
                                            if (listenersSequenceElement != null) {
                                                for (int i16 = 0; i16 < XmlUtility.getElementsByTagNameNS((Node)listenersSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Listener").size(); ++i16) {
                                                    Element certificateThumbprintElement;
                                                    Element listenersElement = (Element)XmlUtility.getElementsByTagNameNS((Node)listenersSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Listener").get(i16);
                                                    WindowsRemoteManagementListener listenerInstance = new WindowsRemoteManagementListener();
                                                    winRMInstance.getListeners().add(listenerInstance);
                                                    Element protocolElement4 = XmlUtility.getElementByTagNameNS((Node)listenersElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Protocol");
                                                    if (protocolElement4 != null) {
                                                        VirtualMachineWindowsRemoteManagementListenerType protocolInstance4 = VirtualMachineWindowsRemoteManagementListenerType.valueOf(protocolElement4.getTextContent());
                                                        listenerInstance.setListenerType(protocolInstance4);
                                                    }
                                                    if ((certificateThumbprintElement = XmlUtility.getElementByTagNameNS((Node)listenersElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"CertificateThumbprint")) == null) continue;
                                                    String certificateThumbprintInstance = certificateThumbprintElement.getTextContent();
                                                    listenerInstance.setCertificateThumbprint(certificateThumbprintInstance);
                                                }
                                            }
                                        }
                                        if ((adminUsernameElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AdminUsername")) != null) {
                                            String adminUsernameInstance = adminUsernameElement.getTextContent();
                                            configurationSetInstance.setAdminUserName(adminUsernameInstance);
                                        }
                                        if ((hostNameElement2 = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"HostName")) != null) {
                                            String hostNameInstance2 = hostNameElement2.getTextContent();
                                            configurationSetInstance.setHostName(hostNameInstance2);
                                        }
                                        if ((userNameElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"UserName")) != null) {
                                            String userNameInstance = userNameElement.getTextContent();
                                            configurationSetInstance.setUserName(userNameInstance);
                                        }
                                        if ((userPasswordElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"UserPassword")) != null) {
                                            String userPasswordInstance = userPasswordElement.getTextContent();
                                            configurationSetInstance.setUserPassword(userPasswordInstance);
                                        }
                                        if ((disableSshPasswordAuthenticationElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DisableSshPasswordAuthentication")) != null && !(disableSshPasswordAuthenticationElement.getTextContent() == null || disableSshPasswordAuthenticationElement.getTextContent().isEmpty())) {
                                            boolean disableSshPasswordAuthenticationInstance = DatatypeConverter.parseBoolean((String)disableSshPasswordAuthenticationElement.getTextContent().toLowerCase());
                                            configurationSetInstance.setDisableSshPasswordAuthentication(disableSshPasswordAuthenticationInstance);
                                        }
                                        if ((sSHElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SSH")) != null) {
                                            Element keyPairsSequenceElement;
                                            SshSettings sSHInstance = new SshSettings();
                                            configurationSetInstance.setSshSettings(sSHInstance);
                                            Element publicKeysSequenceElement = XmlUtility.getElementByTagNameNS((Node)sSHElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublicKeys");
                                            if (publicKeysSequenceElement != null) {
                                                for (int i17 = 0; i17 < XmlUtility.getElementsByTagNameNS((Node)publicKeysSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublicKey").size(); ++i17) {
                                                    Element pathElement2;
                                                    Element publicKeysElement = (Element)XmlUtility.getElementsByTagNameNS((Node)publicKeysSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublicKey").get(i17);
                                                    SshSettingPublicKey publicKeyInstance = new SshSettingPublicKey();
                                                    sSHInstance.getPublicKeys().add(publicKeyInstance);
                                                    Element fingerprintElement = XmlUtility.getElementByTagNameNS((Node)publicKeysElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Fingerprint");
                                                    if (fingerprintElement != null) {
                                                        String fingerprintInstance = fingerprintElement.getTextContent();
                                                        publicKeyInstance.setFingerprint(fingerprintInstance);
                                                    }
                                                    if ((pathElement2 = XmlUtility.getElementByTagNameNS((Node)publicKeysElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Path")) == null) continue;
                                                    String pathInstance2 = pathElement2.getTextContent();
                                                    publicKeyInstance.setPath(pathInstance2);
                                                }
                                            }
                                            if ((keyPairsSequenceElement = XmlUtility.getElementByTagNameNS((Node)sSHElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"KeyPairs")) != null) {
                                                for (int i18 = 0; i18 < XmlUtility.getElementsByTagNameNS((Node)keyPairsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"KeyPair").size(); ++i18) {
                                                    Element pathElement3;
                                                    Element keyPairsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)keyPairsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"KeyPair").get(i18);
                                                    SshSettingKeyPair keyPairInstance = new SshSettingKeyPair();
                                                    sSHInstance.getKeyPairs().add(keyPairInstance);
                                                    Element fingerprintElement2 = XmlUtility.getElementByTagNameNS((Node)keyPairsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Fingerprint");
                                                    if (fingerprintElement2 != null) {
                                                        String fingerprintInstance2 = fingerprintElement2.getTextContent();
                                                        keyPairInstance.setFingerprint(fingerprintInstance2);
                                                    }
                                                    if ((pathElement3 = XmlUtility.getElementByTagNameNS((Node)keyPairsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Path")) == null) continue;
                                                    String pathInstance3 = pathElement3.getTextContent();
                                                    keyPairInstance.setPath(pathInstance3);
                                                }
                                            }
                                        }
                                        if ((customDataElement = XmlUtility.getElementByTagNameNS((Node)configurationSetsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"CustomData")) == null) continue;
                                        String customDataInstance = customDataElement.getTextContent();
                                        configurationSetInstance.setCustomData(customDataInstance);
                                    }
                                }
                                if ((resourceExtensionReferencesSequenceElement = XmlUtility.getElementByTagNameNS((Node)roleListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ResourceExtensionReferences")) != null) {
                                    for (int i19 = 0; i19 < XmlUtility.getElementsByTagNameNS((Node)resourceExtensionReferencesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ResourceExtensionReference").size(); ++i19) {
                                        Element stateElement;
                                        Element resourceExtensionParameterValuesSequenceElement;
                                        Element versionElement2;
                                        Element nameElement6;
                                        Element publisherElement;
                                        Element resourceExtensionReferencesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)resourceExtensionReferencesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ResourceExtensionReference").get(i19);
                                        ResourceExtensionReference resourceExtensionReferenceInstance = new ResourceExtensionReference();
                                        roleInstance.getResourceExtensionReferences().add(resourceExtensionReferenceInstance);
                                        Element referenceNameElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionReferencesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ReferenceName");
                                        if (referenceNameElement != null) {
                                            String referenceNameInstance = referenceNameElement.getTextContent();
                                            resourceExtensionReferenceInstance.setReferenceName(referenceNameInstance);
                                        }
                                        if ((publisherElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionReferencesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Publisher")) != null) {
                                            String publisherInstance = publisherElement.getTextContent();
                                            resourceExtensionReferenceInstance.setPublisher(publisherInstance);
                                        }
                                        if ((nameElement6 = XmlUtility.getElementByTagNameNS((Node)resourceExtensionReferencesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name")) != null) {
                                            String nameInstance6 = nameElement6.getTextContent();
                                            resourceExtensionReferenceInstance.setName(nameInstance6);
                                        }
                                        if ((versionElement2 = XmlUtility.getElementByTagNameNS((Node)resourceExtensionReferencesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Version")) != null) {
                                            String versionInstance2 = versionElement2.getTextContent();
                                            resourceExtensionReferenceInstance.setVersion(versionInstance2);
                                        }
                                        if ((resourceExtensionParameterValuesSequenceElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionReferencesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ResourceExtensionParameterValues")) != null) {
                                            for (int i20 = 0; i20 < XmlUtility.getElementsByTagNameNS((Node)resourceExtensionParameterValuesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ResourceExtensionParameterValue").size(); ++i20) {
                                                Element typeElement;
                                                Element valueElement;
                                                Element resourceExtensionParameterValuesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)resourceExtensionParameterValuesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ResourceExtensionParameterValue").get(i20);
                                                ResourceExtensionParameterValue resourceExtensionParameterValueInstance = new ResourceExtensionParameterValue();
                                                resourceExtensionReferenceInstance.getResourceExtensionParameterValues().add(resourceExtensionParameterValueInstance);
                                                Element keyElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionParameterValuesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Key");
                                                if (keyElement != null) {
                                                    String keyInstance = keyElement.getTextContent();
                                                    resourceExtensionParameterValueInstance.setKey(keyInstance);
                                                }
                                                if ((valueElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionParameterValuesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Value")) != null) {
                                                    String valueInstance = valueElement.getTextContent() != null ? new String(Base64.decode((String)valueElement.getTextContent())) : null;
                                                    resourceExtensionParameterValueInstance.setValue(valueInstance);
                                                }
                                                if ((typeElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionParameterValuesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Type")) == null) continue;
                                                String typeInstance = typeElement.getTextContent();
                                                resourceExtensionParameterValueInstance.setType(typeInstance);
                                            }
                                        }
                                        if ((stateElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionReferencesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"State")) == null) continue;
                                        String stateInstance = stateElement.getTextContent();
                                        resourceExtensionReferenceInstance.setState(stateInstance);
                                    }
                                }
                                if ((vMImageNameElement = XmlUtility.getElementByTagNameNS((Node)roleListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"VMImageName")) != null) {
                                    String vMImageNameInstance = vMImageNameElement.getTextContent();
                                    roleInstance.setVMImageName(vMImageNameInstance);
                                }
                                if ((availabilitySetNameElement = XmlUtility.getElementByTagNameNS((Node)roleListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AvailabilitySetName")) != null) {
                                    String availabilitySetNameInstance = availabilitySetNameElement.getTextContent();
                                    roleInstance.setAvailabilitySetName(availabilitySetNameInstance);
                                }
                                if ((dataVirtualHardDisksSequenceElement = XmlUtility.getElementByTagNameNS((Node)roleListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DataVirtualHardDisks")) != null) {
                                    for (int i21 = 0; i21 < XmlUtility.getElementsByTagNameNS((Node)dataVirtualHardDisksSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DataVirtualHardDisk").size(); ++i21) {
                                        Element sourceMediaLinkElement;
                                        Element mediaLinkElement;
                                        Element logicalDiskSizeInGBElement;
                                        Element lunElement;
                                        Element diskNameElement;
                                        Element diskLabelElement;
                                        Element dataVirtualHardDisksElement = (Element)XmlUtility.getElementsByTagNameNS((Node)dataVirtualHardDisksSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DataVirtualHardDisk").get(i21);
                                        DataVirtualHardDisk dataVirtualHardDiskInstance = new DataVirtualHardDisk();
                                        roleInstance.getDataVirtualHardDisks().add(dataVirtualHardDiskInstance);
                                        Element hostCachingElement = XmlUtility.getElementByTagNameNS((Node)dataVirtualHardDisksElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"HostCaching");
                                        if (hostCachingElement != null && !(hostCachingElement.getTextContent() == null || hostCachingElement.getTextContent().isEmpty())) {
                                            VirtualHardDiskHostCaching hostCachingInstance = VirtualHardDiskHostCaching.valueOf(hostCachingElement.getTextContent());
                                            dataVirtualHardDiskInstance.setHostCaching(hostCachingInstance);
                                        }
                                        if ((diskLabelElement = XmlUtility.getElementByTagNameNS((Node)dataVirtualHardDisksElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DiskLabel")) != null) {
                                            String diskLabelInstance = diskLabelElement.getTextContent();
                                            dataVirtualHardDiskInstance.setLabel(diskLabelInstance);
                                        }
                                        if ((diskNameElement = XmlUtility.getElementByTagNameNS((Node)dataVirtualHardDisksElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DiskName")) != null) {
                                            String diskNameInstance = diskNameElement.getTextContent();
                                            dataVirtualHardDiskInstance.setName(diskNameInstance);
                                        }
                                        if ((lunElement = XmlUtility.getElementByTagNameNS((Node)dataVirtualHardDisksElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Lun")) != null && !(lunElement.getTextContent() == null || lunElement.getTextContent().isEmpty())) {
                                            int lunInstance = DatatypeConverter.parseInt((String)lunElement.getTextContent());
                                            dataVirtualHardDiskInstance.setLogicalUnitNumber(lunInstance);
                                        }
                                        if ((logicalDiskSizeInGBElement = XmlUtility.getElementByTagNameNS((Node)dataVirtualHardDisksElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LogicalDiskSizeInGB")) != null && !(logicalDiskSizeInGBElement.getTextContent() == null || logicalDiskSizeInGBElement.getTextContent().isEmpty())) {
                                            int logicalDiskSizeInGBInstance = DatatypeConverter.parseInt((String)logicalDiskSizeInGBElement.getTextContent());
                                            dataVirtualHardDiskInstance.setLogicalDiskSizeInGB(logicalDiskSizeInGBInstance);
                                        }
                                        if ((mediaLinkElement = XmlUtility.getElementByTagNameNS((Node)dataVirtualHardDisksElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"MediaLink")) != null) {
                                            URI mediaLinkInstance = new URI(mediaLinkElement.getTextContent());
                                            dataVirtualHardDiskInstance.setMediaLink(mediaLinkInstance);
                                        }
                                        if ((sourceMediaLinkElement = XmlUtility.getElementByTagNameNS((Node)dataVirtualHardDisksElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SourceMediaLink")) == null) continue;
                                        URI sourceMediaLinkInstance = new URI(sourceMediaLinkElement.getTextContent());
                                        dataVirtualHardDiskInstance.setSourceMediaLink(sourceMediaLinkInstance);
                                    }
                                }
                                if ((labelElement2 = XmlUtility.getElementByTagNameNS((Node)roleListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Label")) != null) {
                                    String labelInstance2 = labelElement2.getTextContent();
                                    roleInstance.setLabel(labelInstance2);
                                }
                                if ((oSVirtualHardDiskElement = XmlUtility.getElementByTagNameNS((Node)roleListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"OSVirtualHardDisk")) != null) {
                                    Element osElement;
                                    Element sourceImageNameElement;
                                    Element mediaLinkElement2;
                                    Element diskNameElement2;
                                    Element diskLabelElement2;
                                    OSVirtualHardDisk oSVirtualHardDiskInstance = new OSVirtualHardDisk();
                                    roleInstance.setOSVirtualHardDisk(oSVirtualHardDiskInstance);
                                    Element hostCachingElement2 = XmlUtility.getElementByTagNameNS((Node)oSVirtualHardDiskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"HostCaching");
                                    if (hostCachingElement2 != null && !(hostCachingElement2.getTextContent() == null || hostCachingElement2.getTextContent().isEmpty())) {
                                        VirtualHardDiskHostCaching hostCachingInstance2 = VirtualHardDiskHostCaching.valueOf(hostCachingElement2.getTextContent());
                                        oSVirtualHardDiskInstance.setHostCaching(hostCachingInstance2);
                                    }
                                    if ((diskLabelElement2 = XmlUtility.getElementByTagNameNS((Node)oSVirtualHardDiskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DiskLabel")) != null) {
                                        String diskLabelInstance2 = diskLabelElement2.getTextContent();
                                        oSVirtualHardDiskInstance.setLabel(diskLabelInstance2);
                                    }
                                    if ((diskNameElement2 = XmlUtility.getElementByTagNameNS((Node)oSVirtualHardDiskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DiskName")) != null) {
                                        String diskNameInstance2 = diskNameElement2.getTextContent();
                                        oSVirtualHardDiskInstance.setName(diskNameInstance2);
                                    }
                                    if ((mediaLinkElement2 = XmlUtility.getElementByTagNameNS((Node)oSVirtualHardDiskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"MediaLink")) != null) {
                                        URI mediaLinkInstance2 = new URI(mediaLinkElement2.getTextContent());
                                        oSVirtualHardDiskInstance.setMediaLink(mediaLinkInstance2);
                                    }
                                    if ((sourceImageNameElement = XmlUtility.getElementByTagNameNS((Node)oSVirtualHardDiskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SourceImageName")) != null) {
                                        String sourceImageNameInstance = sourceImageNameElement.getTextContent();
                                        oSVirtualHardDiskInstance.setSourceImageName(sourceImageNameInstance);
                                    }
                                    if ((osElement = XmlUtility.getElementByTagNameNS((Node)oSVirtualHardDiskElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"OS")) != null) {
                                        String osInstance = osElement.getTextContent();
                                        oSVirtualHardDiskInstance.setOperatingSystem(osInstance);
                                    }
                                }
                                if ((roleSizeElement = XmlUtility.getElementByTagNameNS((Node)roleListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RoleSize")) != null) {
                                    String roleSizeInstance = roleSizeElement.getTextContent();
                                    roleInstance.setRoleSize(roleSizeInstance);
                                }
                                if ((provisionGuestAgentElement = XmlUtility.getElementByTagNameNS((Node)roleListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ProvisionGuestAgent")) != null && !(provisionGuestAgentElement.getTextContent() == null || provisionGuestAgentElement.getTextContent().isEmpty())) {
                                    boolean provisionGuestAgentInstance = DatatypeConverter.parseBoolean((String)provisionGuestAgentElement.getTextContent().toLowerCase());
                                    roleInstance.setProvisionGuestAgent(provisionGuestAgentInstance);
                                }
                                if ((defaultWinRmCertificateThumbprintElement = XmlUtility.getElementByTagNameNS((Node)roleListElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DefaultWinRmCertificateThumbprint")) == null) continue;
                                String defaultWinRmCertificateThumbprintInstance = defaultWinRmCertificateThumbprintElement.getTextContent();
                                roleInstance.setDefaultWinRmCertificateThumbprint(defaultWinRmCertificateThumbprintInstance);
                            }
                        }
                        if ((sdkVersionElement = XmlUtility.getElementByTagNameNS((Node)deploymentsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SdkVersion")) != null) {
                            String sdkVersionInstance = sdkVersionElement.getTextContent();
                            deploymentInstance.setSdkVersion(sdkVersionInstance);
                        }
                        if ((lockedElement = XmlUtility.getElementByTagNameNS((Node)deploymentsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Locked")) != null) {
                            boolean lockedInstance = DatatypeConverter.parseBoolean((String)lockedElement.getTextContent().toLowerCase());
                            deploymentInstance.setLocked(lockedInstance);
                        }
                        if ((rollbackAllowedElement = XmlUtility.getElementByTagNameNS((Node)deploymentsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RollbackAllowed")) != null) {
                            boolean rollbackAllowedInstance = DatatypeConverter.parseBoolean((String)rollbackAllowedElement.getTextContent().toLowerCase());
                            deploymentInstance.setRollbackAllowed(rollbackAllowedInstance);
                        }
                        if ((createdTimeElement = XmlUtility.getElementByTagNameNS((Node)deploymentsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"CreatedTime")) != null) {
                            Calendar createdTimeInstance = DatatypeConverter.parseDateTime((String)createdTimeElement.getTextContent());
                            deploymentInstance.setCreatedTime(createdTimeInstance);
                        }
                        if ((lastModifiedTimeElement = XmlUtility.getElementByTagNameNS((Node)deploymentsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LastModifiedTime")) != null) {
                            String lastModifiedTimeInstance = lastModifiedTimeElement.getTextContent();
                            deploymentInstance.setLastModifiedTime(lastModifiedTimeInstance);
                        }
                        if ((virtualNetworkNameElement = XmlUtility.getElementByTagNameNS((Node)deploymentsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"VirtualNetworkName")) != null) {
                            String virtualNetworkNameInstance = virtualNetworkNameElement.getTextContent();
                            deploymentInstance.setVirtualNetworkName(virtualNetworkNameInstance);
                        }
                        if ((extendedPropertiesSequenceElement = XmlUtility.getElementByTagNameNS((Node)deploymentsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ExtendedProperties")) != null) {
                            for (int i22 = 0; i22 < XmlUtility.getElementsByTagNameNS((Node)extendedPropertiesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ExtendedProperty").size(); ++i22) {
                                Element extendedPropertiesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)extendedPropertiesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ExtendedProperty").get(i22);
                                String extendedPropertiesKey = XmlUtility.getElementByTagNameNS((Node)extendedPropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name").getTextContent();
                                String extendedPropertiesValue = XmlUtility.getElementByTagNameNS((Node)extendedPropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Value").getTextContent();
                                deploymentInstance.getExtendedProperties().put(extendedPropertiesKey, extendedPropertiesValue);
                            }
                        }
                        if ((persistentVMDowntimeElement = XmlUtility.getElementByTagNameNS((Node)deploymentsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PersistentVMDowntime")) != null) {
                            Element statusElement6;
                            Element endTimeElement;
                            PersistentVMDowntime persistentVMDowntimeInstance = new PersistentVMDowntime();
                            deploymentInstance.setPersistentVMDowntime(persistentVMDowntimeInstance);
                            Element startTimeElement = XmlUtility.getElementByTagNameNS((Node)persistentVMDowntimeElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StartTime");
                            if (startTimeElement != null) {
                                Calendar startTimeInstance = DatatypeConverter.parseDateTime((String)startTimeElement.getTextContent());
                                persistentVMDowntimeInstance.setStartTime(startTimeInstance);
                            }
                            if ((endTimeElement = XmlUtility.getElementByTagNameNS((Node)persistentVMDowntimeElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"EndTime")) != null) {
                                Calendar endTimeInstance = DatatypeConverter.parseDateTime((String)endTimeElement.getTextContent());
                                persistentVMDowntimeInstance.setEndTime(endTimeInstance);
                            }
                            if ((statusElement6 = XmlUtility.getElementByTagNameNS((Node)persistentVMDowntimeElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Status")) != null) {
                                String statusInstance6 = statusElement6.getTextContent();
                                persistentVMDowntimeInstance.setStatus(statusInstance6);
                            }
                        }
                        if ((virtualIPsSequenceElement = XmlUtility.getElementByTagNameNS((Node)deploymentsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"VirtualIPs")) != null) {
                            for (int i23 = 0; i23 < XmlUtility.getElementsByTagNameNS((Node)virtualIPsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"VirtualIP").size(); ++i23) {
                                Element isDnsProgrammedElement;
                                Element nameElement7;
                                Element virtualIPsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)virtualIPsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"VirtualIP").get(i23);
                                VirtualIPAddress virtualIPInstance = new VirtualIPAddress();
                                deploymentInstance.getVirtualIPAddresses().add(virtualIPInstance);
                                Element addressElement = XmlUtility.getElementByTagNameNS((Node)virtualIPsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Address");
                                if (addressElement != null) {
                                    InetAddress addressInstance = InetAddress.getByName(addressElement.getTextContent());
                                    virtualIPInstance.setAddress(addressInstance);
                                }
                                if ((nameElement7 = XmlUtility.getElementByTagNameNS((Node)virtualIPsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name")) != null) {
                                    String nameInstance7 = nameElement7.getTextContent();
                                    virtualIPInstance.setName(nameInstance7);
                                }
                                if ((isDnsProgrammedElement = XmlUtility.getElementByTagNameNS((Node)virtualIPsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsDnsProgrammed")) == null || isDnsProgrammedElement.getTextContent() == null || isDnsProgrammedElement.getTextContent().isEmpty()) continue;
                                boolean isDnsProgrammedInstance = DatatypeConverter.parseBoolean((String)isDnsProgrammedElement.getTextContent().toLowerCase());
                                virtualIPInstance.setIsDnsProgrammed(isDnsProgrammedInstance);
                            }
                        }
                        if ((dnsElement = XmlUtility.getElementByTagNameNS((Node)deploymentsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Dns")) == null) continue;
                        DnsSettings dnsInstance = new DnsSettings();
                        deploymentInstance.setDnsSettings(dnsInstance);
                        Element dnsServersSequenceElement = XmlUtility.getElementByTagNameNS((Node)dnsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DnsServers");
                        if (dnsServersSequenceElement == null) continue;
                        for (int i24 = 0; i24 < XmlUtility.getElementsByTagNameNS((Node)dnsServersSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DnsServer").size(); ++i24) {
                            Element addressElement2;
                            Element dnsServersElement = (Element)XmlUtility.getElementsByTagNameNS((Node)dnsServersSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DnsServer").get(i24);
                            DnsServer dnsServerInstance = new DnsServer();
                            dnsInstance.getDnsServers().add(dnsServerInstance);
                            Element nameElement8 = XmlUtility.getElementByTagNameNS((Node)dnsServersElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                            if (nameElement8 != null) {
                                String nameInstance8 = nameElement8.getTextContent();
                                dnsServerInstance.setName(nameInstance8);
                            }
                            if ((addressElement2 = XmlUtility.getElementByTagNameNS((Node)dnsServersElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Address")) == null) continue;
                            InetAddress addressInstance2 = InetAddress.getByName(addressElement2.getTextContent());
                            dnsServerInstance.setAddress(addressInstance2);
                        }
                    }
                }
                if ((urlElement2 = XmlUtility.getElementByTagNameNS((Node)hostedServiceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Url")) != null) {
                    URI urlInstance2 = new URI(urlElement2.getTextContent());
                    result.setUri(urlInstance2);
                }
                if ((serviceNameElement = XmlUtility.getElementByTagNameNS((Node)hostedServiceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceName")) != null) {
                    String serviceNameInstance = serviceNameElement.getTextContent();
                    result.setServiceName(serviceNameInstance);
                }
                if ((hostedServicePropertiesElement = XmlUtility.getElementByTagNameNS((Node)hostedServiceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"HostedServiceProperties")) != null) {
                    Element extendedPropertiesSequenceElement2;
                    Element dateLastModifiedElement;
                    Element dateCreatedElement;
                    Element statusElement7;
                    Element labelElement3;
                    Element locationElement;
                    Element affinityGroupElement;
                    HostedServiceProperties hostedServicePropertiesInstance = new HostedServiceProperties();
                    result.setProperties(hostedServicePropertiesInstance);
                    Element descriptionElement2 = XmlUtility.getElementByTagNameNS((Node)hostedServicePropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Description");
                    if (descriptionElement2 != null) {
                        String descriptionInstance2 = descriptionElement2.getTextContent();
                        hostedServicePropertiesInstance.setDescription(descriptionInstance2);
                    }
                    if ((affinityGroupElement = XmlUtility.getElementByTagNameNS((Node)hostedServicePropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AffinityGroup")) != null) {
                        String affinityGroupInstance = affinityGroupElement.getTextContent();
                        hostedServicePropertiesInstance.setAffinityGroup(affinityGroupInstance);
                    }
                    if ((locationElement = XmlUtility.getElementByTagNameNS((Node)hostedServicePropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Location")) != null) {
                        String locationInstance = locationElement.getTextContent();
                        hostedServicePropertiesInstance.setLocation(locationInstance);
                    }
                    if ((labelElement3 = XmlUtility.getElementByTagNameNS((Node)hostedServicePropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Label")) != null) {
                        String labelInstance3 = labelElement3.getTextContent() != null ? new String(Base64.decode((String)labelElement3.getTextContent())) : null;
                        hostedServicePropertiesInstance.setLabel(labelInstance3);
                    }
                    if ((statusElement7 = XmlUtility.getElementByTagNameNS((Node)hostedServicePropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Status")) != null) {
                        HostedServiceStatus statusInstance7 = HostedServiceStatus.valueOf(statusElement7.getTextContent());
                        hostedServicePropertiesInstance.setStatus(statusInstance7);
                    }
                    if ((dateCreatedElement = XmlUtility.getElementByTagNameNS((Node)hostedServicePropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DateCreated")) != null) {
                        Calendar dateCreatedInstance = DatatypeConverter.parseDateTime((String)dateCreatedElement.getTextContent());
                        hostedServicePropertiesInstance.setDateCreated(dateCreatedInstance);
                    }
                    if ((dateLastModifiedElement = XmlUtility.getElementByTagNameNS((Node)hostedServicePropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DateLastModified")) != null) {
                        Calendar dateLastModifiedInstance = DatatypeConverter.parseDateTime((String)dateLastModifiedElement.getTextContent());
                        hostedServicePropertiesInstance.setDateLastModified(dateLastModifiedInstance);
                    }
                    if ((extendedPropertiesSequenceElement2 = XmlUtility.getElementByTagNameNS((Node)hostedServicePropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ExtendedProperties")) != null) {
                        for (int i25 = 0; i25 < XmlUtility.getElementsByTagNameNS((Node)extendedPropertiesSequenceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"ExtendedProperty").size(); ++i25) {
                            Element extendedPropertiesElement2 = (Element)XmlUtility.getElementsByTagNameNS((Node)extendedPropertiesSequenceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"ExtendedProperty").get(i25);
                            String extendedPropertiesKey2 = XmlUtility.getElementByTagNameNS((Node)extendedPropertiesElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name").getTextContent();
                            String extendedPropertiesValue2 = XmlUtility.getElementByTagNameNS((Node)extendedPropertiesElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Value").getTextContent();
                            hostedServicePropertiesInstance.getExtendedProperties().put(extendedPropertiesKey2, extendedPropertiesValue2);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            HostedServiceGetDetailedResponse hostedServiceGetDetailedResponse = result;
            return hostedServiceGetDetailedResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<HostedServiceGetExtensionResponse> getExtensionAsync(final String serviceName, final String extensionId) {
        return this.getClient().getExecutorService().submit(new Callable<HostedServiceGetExtensionResponse>(){

            @Override
            public HostedServiceGetExtensionResponse call() throws Exception {
                return HostedServiceOperationsImpl.this.getExtension(serviceName, extensionId);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HostedServiceGetExtensionResponse getExtension(String serviceName, String extensionId) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (extensionId == null) {
            throw new NullPointerException("extensionId");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("extensionId", extensionId);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getExtensionAsync", tracingParameters);
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        String url = "/" + this.getClient().getCredentials().getSubscriptionId().trim() + "/services/hostedservices/" + serviceName.trim() + "/extensions/" + extensionId.trim();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2014-04-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            HostedServiceGetExtensionResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new HostedServiceGetExtensionResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element extensionElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"Extension");
            if (extensionElement != null) {
                Element publicConfigurationElement;
                Element thumbprintAlgorithmElement;
                Element thumbprintElement;
                Element versionElement;
                Element idElement;
                Element typeElement;
                Element providerNameSpaceElement = XmlUtility.getElementByTagNameNS((Node)extensionElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ProviderNameSpace");
                if (providerNameSpaceElement != null) {
                    String providerNameSpaceInstance = providerNameSpaceElement.getTextContent();
                    result.setProviderNamespace(providerNameSpaceInstance);
                }
                if ((typeElement = XmlUtility.getElementByTagNameNS((Node)extensionElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Type")) != null) {
                    String typeInstance = typeElement.getTextContent();
                    result.setType(typeInstance);
                }
                if ((idElement = XmlUtility.getElementByTagNameNS((Node)extensionElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Id")) != null) {
                    String idInstance = idElement.getTextContent();
                    result.setId(idInstance);
                }
                if ((versionElement = XmlUtility.getElementByTagNameNS((Node)extensionElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Version")) != null) {
                    String versionInstance = versionElement.getTextContent();
                    result.setVersion(versionInstance);
                }
                if ((thumbprintElement = XmlUtility.getElementByTagNameNS((Node)extensionElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Thumbprint")) != null) {
                    String thumbprintInstance = thumbprintElement.getTextContent();
                    result.setThumbprint(thumbprintInstance);
                }
                if ((thumbprintAlgorithmElement = XmlUtility.getElementByTagNameNS((Node)extensionElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ThumbprintAlgorithm")) != null) {
                    String thumbprintAlgorithmInstance = thumbprintAlgorithmElement.getTextContent();
                    result.setThumbprintAlgorithm(thumbprintAlgorithmInstance);
                }
                if ((publicConfigurationElement = XmlUtility.getElementByTagNameNS((Node)extensionElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublicConfiguration")) != null) {
                    String publicConfigurationInstance = publicConfigurationElement.getTextContent() != null ? new String(Base64.decode((String)publicConfigurationElement.getTextContent())) : null;
                    result.setPublicConfiguration(publicConfigurationInstance);
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            HostedServiceGetExtensionResponse hostedServiceGetExtensionResponse = result;
            return hostedServiceGetExtensionResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<HostedServiceListResponse> listAsync() {
        return this.getClient().getExecutorService().submit(new Callable<HostedServiceListResponse>(){

            @Override
            public HostedServiceListResponse call() throws Exception {
                return HostedServiceOperationsImpl.this.list();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HostedServiceListResponse list() throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException {
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap tracingParameters = new HashMap();
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        String url = "/" + this.getClient().getCredentials().getSubscriptionId().trim() + "/services/hostedservices";
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2014-04-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            HostedServiceListResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new HostedServiceListResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element hostedServicesSequenceElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"HostedServices");
            if (hostedServicesSequenceElement != null) {
                for (int i1 = 0; i1 < XmlUtility.getElementsByTagNameNS((Node)hostedServicesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"HostedService").size(); ++i1) {
                    Element extendedPropertiesSequenceElement;
                    Element dateLastModifiedElement;
                    Element dateCreatedElement;
                    Element statusElement;
                    Element labelElement;
                    Element locationElement;
                    Element affinityGroupElement;
                    Element hostedServicePropertiesElement;
                    Element serviceNameElement;
                    Element hostedServicesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)hostedServicesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"HostedService").get(i1);
                    HostedServiceListResponse.HostedService hostedServiceInstance = new HostedServiceListResponse.HostedService();
                    result.getHostedServices().add(hostedServiceInstance);
                    Element urlElement = XmlUtility.getElementByTagNameNS((Node)hostedServicesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Url");
                    if (urlElement != null) {
                        URI urlInstance = new URI(urlElement.getTextContent());
                        hostedServiceInstance.setUri(urlInstance);
                    }
                    if ((serviceNameElement = XmlUtility.getElementByTagNameNS((Node)hostedServicesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceName")) != null) {
                        String serviceNameInstance = serviceNameElement.getTextContent();
                        hostedServiceInstance.setServiceName(serviceNameInstance);
                    }
                    if ((hostedServicePropertiesElement = XmlUtility.getElementByTagNameNS((Node)hostedServicesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"HostedServiceProperties")) == null) continue;
                    HostedServiceProperties hostedServicePropertiesInstance = new HostedServiceProperties();
                    hostedServiceInstance.setProperties(hostedServicePropertiesInstance);
                    Element descriptionElement = XmlUtility.getElementByTagNameNS((Node)hostedServicePropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Description");
                    if (descriptionElement != null) {
                        String descriptionInstance = descriptionElement.getTextContent();
                        hostedServicePropertiesInstance.setDescription(descriptionInstance);
                    }
                    if ((affinityGroupElement = XmlUtility.getElementByTagNameNS((Node)hostedServicePropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AffinityGroup")) != null) {
                        String affinityGroupInstance = affinityGroupElement.getTextContent();
                        hostedServicePropertiesInstance.setAffinityGroup(affinityGroupInstance);
                    }
                    if ((locationElement = XmlUtility.getElementByTagNameNS((Node)hostedServicePropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Location")) != null) {
                        String locationInstance = locationElement.getTextContent();
                        hostedServicePropertiesInstance.setLocation(locationInstance);
                    }
                    if ((labelElement = XmlUtility.getElementByTagNameNS((Node)hostedServicePropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Label")) != null) {
                        String labelInstance = labelElement.getTextContent() != null ? new String(Base64.decode((String)labelElement.getTextContent())) : null;
                        hostedServicePropertiesInstance.setLabel(labelInstance);
                    }
                    if ((statusElement = XmlUtility.getElementByTagNameNS((Node)hostedServicePropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Status")) != null) {
                        HostedServiceStatus statusInstance = HostedServiceStatus.valueOf(statusElement.getTextContent());
                        hostedServicePropertiesInstance.setStatus(statusInstance);
                    }
                    if ((dateCreatedElement = XmlUtility.getElementByTagNameNS((Node)hostedServicePropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DateCreated")) != null) {
                        Calendar dateCreatedInstance = DatatypeConverter.parseDateTime((String)dateCreatedElement.getTextContent());
                        hostedServicePropertiesInstance.setDateCreated(dateCreatedInstance);
                    }
                    if ((dateLastModifiedElement = XmlUtility.getElementByTagNameNS((Node)hostedServicePropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DateLastModified")) != null) {
                        Calendar dateLastModifiedInstance = DatatypeConverter.parseDateTime((String)dateLastModifiedElement.getTextContent());
                        hostedServicePropertiesInstance.setDateLastModified(dateLastModifiedInstance);
                    }
                    if ((extendedPropertiesSequenceElement = XmlUtility.getElementByTagNameNS((Node)hostedServicePropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ExtendedProperties")) == null) continue;
                    for (int i2 = 0; i2 < XmlUtility.getElementsByTagNameNS((Node)extendedPropertiesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ExtendedProperty").size(); ++i2) {
                        Element extendedPropertiesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)extendedPropertiesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ExtendedProperty").get(i2);
                        String extendedPropertiesKey = XmlUtility.getElementByTagNameNS((Node)extendedPropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name").getTextContent();
                        String extendedPropertiesValue = XmlUtility.getElementByTagNameNS((Node)extendedPropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Value").getTextContent();
                        hostedServicePropertiesInstance.getExtendedProperties().put(extendedPropertiesKey, extendedPropertiesValue);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            HostedServiceListResponse hostedServiceListResponse = result;
            return hostedServiceListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<HostedServiceListAvailableExtensionsResponse> listAvailableExtensionsAsync() {
        return this.getClient().getExecutorService().submit(new Callable<HostedServiceListAvailableExtensionsResponse>(){

            @Override
            public HostedServiceListAvailableExtensionsResponse call() throws Exception {
                return HostedServiceOperationsImpl.this.listAvailableExtensions();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HostedServiceListAvailableExtensionsResponse listAvailableExtensions() throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException {
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap tracingParameters = new HashMap();
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAvailableExtensionsAsync", tracingParameters);
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        String url = "/" + this.getClient().getCredentials().getSubscriptionId().trim() + "/services/extensions";
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2014-04-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            HostedServiceListAvailableExtensionsResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new HostedServiceListAvailableExtensionsResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element extensionImagesSequenceElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"ExtensionImages");
            if (extensionImagesSequenceElement != null) {
                for (int i1 = 0; i1 < XmlUtility.getElementsByTagNameNS((Node)extensionImagesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ExtensionImage").size(); ++i1) {
                    Element isJsonExtensionElement;
                    Element homepageUriElement;
                    Element privacyUriElement;
                    Element eulaElement;
                    Element replicationCompletedElement;
                    Element sampleConfigElement;
                    Element blockRoleUponFailureElement;
                    Element privateConfigurationSchemaElement;
                    Element publicConfigurationSchemaElement;
                    Element hostingResourcesElement;
                    Element thumbprintAlgorithmElement;
                    Element descriptionElement;
                    Element versionElement;
                    Element labelElement;
                    Element typeElement;
                    Element extensionImagesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)extensionImagesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ExtensionImage").get(i1);
                    HostedServiceListAvailableExtensionsResponse.ExtensionImage extensionImageInstance = new HostedServiceListAvailableExtensionsResponse.ExtensionImage();
                    result.getExtensionImages().add(extensionImageInstance);
                    Element providerNameSpaceElement = XmlUtility.getElementByTagNameNS((Node)extensionImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ProviderNameSpace");
                    if (providerNameSpaceElement != null) {
                        String providerNameSpaceInstance = providerNameSpaceElement.getTextContent();
                        extensionImageInstance.setProviderNamespace(providerNameSpaceInstance);
                    }
                    if ((typeElement = XmlUtility.getElementByTagNameNS((Node)extensionImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Type")) != null) {
                        String typeInstance = typeElement.getTextContent();
                        extensionImageInstance.setType(typeInstance);
                    }
                    if ((labelElement = XmlUtility.getElementByTagNameNS((Node)extensionImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Label")) != null) {
                        String labelInstance = labelElement.getTextContent();
                        extensionImageInstance.setLabel(labelInstance);
                    }
                    if ((versionElement = XmlUtility.getElementByTagNameNS((Node)extensionImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Version")) != null) {
                        String versionInstance = versionElement.getTextContent();
                        extensionImageInstance.setVersion(versionInstance);
                    }
                    if ((descriptionElement = XmlUtility.getElementByTagNameNS((Node)extensionImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Description")) != null) {
                        String descriptionInstance = descriptionElement.getTextContent();
                        extensionImageInstance.setDescription(descriptionInstance);
                    }
                    if ((thumbprintAlgorithmElement = XmlUtility.getElementByTagNameNS((Node)extensionImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ThumbprintAlgorithm")) != null) {
                        String thumbprintAlgorithmInstance = thumbprintAlgorithmElement.getTextContent();
                        extensionImageInstance.setThumbprintAlgorithm(thumbprintAlgorithmInstance);
                    }
                    if ((hostingResourcesElement = XmlUtility.getElementByTagNameNS((Node)extensionImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"HostingResources")) != null) {
                        String hostingResourcesInstance = hostingResourcesElement.getTextContent();
                        extensionImageInstance.setHostingResources(hostingResourcesInstance);
                    }
                    if ((publicConfigurationSchemaElement = XmlUtility.getElementByTagNameNS((Node)extensionImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublicConfigurationSchema")) != null) {
                        String publicConfigurationSchemaInstance = publicConfigurationSchemaElement.getTextContent() != null ? new String(Base64.decode((String)publicConfigurationSchemaElement.getTextContent())) : null;
                        extensionImageInstance.setPublicConfigurationSchema(publicConfigurationSchemaInstance);
                    }
                    if ((privateConfigurationSchemaElement = XmlUtility.getElementByTagNameNS((Node)extensionImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PrivateConfigurationSchema")) != null) {
                        String privateConfigurationSchemaInstance = privateConfigurationSchemaElement.getTextContent() != null ? new String(Base64.decode((String)privateConfigurationSchemaElement.getTextContent())) : null;
                        extensionImageInstance.setPrivateConfigurationSchema(privateConfigurationSchemaInstance);
                    }
                    if ((blockRoleUponFailureElement = XmlUtility.getElementByTagNameNS((Node)extensionImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"BlockRoleUponFailure")) != null && !(blockRoleUponFailureElement.getTextContent() == null || blockRoleUponFailureElement.getTextContent().isEmpty())) {
                        boolean blockRoleUponFailureInstance = DatatypeConverter.parseBoolean((String)blockRoleUponFailureElement.getTextContent().toLowerCase());
                        extensionImageInstance.setBlockRoleUponFailure(blockRoleUponFailureInstance);
                    }
                    if ((sampleConfigElement = XmlUtility.getElementByTagNameNS((Node)extensionImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SampleConfig")) != null) {
                        String sampleConfigInstance = sampleConfigElement.getTextContent() != null ? new String(Base64.decode((String)sampleConfigElement.getTextContent())) : null;
                        extensionImageInstance.setSampleConfig(sampleConfigInstance);
                    }
                    if ((replicationCompletedElement = XmlUtility.getElementByTagNameNS((Node)extensionImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ReplicationCompleted")) != null && !(replicationCompletedElement.getTextContent() == null || replicationCompletedElement.getTextContent().isEmpty())) {
                        boolean replicationCompletedInstance = DatatypeConverter.parseBoolean((String)replicationCompletedElement.getTextContent().toLowerCase());
                        extensionImageInstance.setReplicationCompleted(replicationCompletedInstance);
                    }
                    if ((eulaElement = XmlUtility.getElementByTagNameNS((Node)extensionImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Eula")) != null) {
                        URI eulaInstance = new URI(eulaElement.getTextContent());
                        extensionImageInstance.setEula(eulaInstance);
                    }
                    if ((privacyUriElement = XmlUtility.getElementByTagNameNS((Node)extensionImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PrivacyUri")) != null) {
                        URI privacyUriInstance = new URI(privacyUriElement.getTextContent());
                        extensionImageInstance.setPrivacyUri(privacyUriInstance);
                    }
                    if ((homepageUriElement = XmlUtility.getElementByTagNameNS((Node)extensionImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"HomepageUri")) != null) {
                        URI homepageUriInstance = new URI(homepageUriElement.getTextContent());
                        extensionImageInstance.setHomepageUri(homepageUriInstance);
                    }
                    if ((isJsonExtensionElement = XmlUtility.getElementByTagNameNS((Node)extensionImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsJsonExtension")) == null || isJsonExtensionElement.getTextContent() == null || isJsonExtensionElement.getTextContent().isEmpty()) continue;
                    boolean isJsonExtensionInstance = DatatypeConverter.parseBoolean((String)isJsonExtensionElement.getTextContent().toLowerCase());
                    extensionImageInstance.setIsJsonExtension(isJsonExtensionInstance);
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            HostedServiceListAvailableExtensionsResponse hostedServiceListAvailableExtensionsResponse = result;
            return hostedServiceListAvailableExtensionsResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<HostedServiceListExtensionsResponse> listExtensionsAsync(final String serviceName) {
        return this.getClient().getExecutorService().submit(new Callable<HostedServiceListExtensionsResponse>(){

            @Override
            public HostedServiceListExtensionsResponse call() throws Exception {
                return HostedServiceOperationsImpl.this.listExtensions(serviceName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HostedServiceListExtensionsResponse listExtensions(String serviceName) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("serviceName", serviceName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listExtensionsAsync", tracingParameters);
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        String url = "/" + this.getClient().getCredentials().getSubscriptionId().trim() + "/services/hostedservices/" + serviceName.trim() + "/extensions";
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2014-04-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            HostedServiceListExtensionsResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new HostedServiceListExtensionsResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element extensionsSequenceElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"Extensions");
            if (extensionsSequenceElement != null) {
                for (int i1 = 0; i1 < XmlUtility.getElementsByTagNameNS((Node)extensionsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Extension").size(); ++i1) {
                    Element publicConfigurationElement;
                    Element thumbprintAlgorithmElement;
                    Element thumbprintElement;
                    Element versionElement;
                    Element idElement;
                    Element typeElement;
                    Element extensionsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)extensionsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Extension").get(i1);
                    HostedServiceListExtensionsResponse.Extension extensionInstance = new HostedServiceListExtensionsResponse.Extension();
                    result.getExtensions().add(extensionInstance);
                    Element providerNameSpaceElement = XmlUtility.getElementByTagNameNS((Node)extensionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ProviderNameSpace");
                    if (providerNameSpaceElement != null) {
                        String providerNameSpaceInstance = providerNameSpaceElement.getTextContent();
                        extensionInstance.setProviderNamespace(providerNameSpaceInstance);
                    }
                    if ((typeElement = XmlUtility.getElementByTagNameNS((Node)extensionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Type")) != null) {
                        String typeInstance = typeElement.getTextContent();
                        extensionInstance.setType(typeInstance);
                    }
                    if ((idElement = XmlUtility.getElementByTagNameNS((Node)extensionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Id")) != null) {
                        String idInstance = idElement.getTextContent();
                        extensionInstance.setId(idInstance);
                    }
                    if ((versionElement = XmlUtility.getElementByTagNameNS((Node)extensionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Version")) != null) {
                        String versionInstance = versionElement.getTextContent();
                        extensionInstance.setVersion(versionInstance);
                    }
                    if ((thumbprintElement = XmlUtility.getElementByTagNameNS((Node)extensionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Thumbprint")) != null) {
                        String thumbprintInstance = thumbprintElement.getTextContent();
                        extensionInstance.setThumbprint(thumbprintInstance);
                    }
                    if ((thumbprintAlgorithmElement = XmlUtility.getElementByTagNameNS((Node)extensionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ThumbprintAlgorithm")) != null) {
                        String thumbprintAlgorithmInstance = thumbprintAlgorithmElement.getTextContent();
                        extensionInstance.setThumbprintAlgorithm(thumbprintAlgorithmInstance);
                    }
                    if ((publicConfigurationElement = XmlUtility.getElementByTagNameNS((Node)extensionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublicConfiguration")) == null) continue;
                    String publicConfigurationInstance = publicConfigurationElement.getTextContent() != null ? new String(Base64.decode((String)publicConfigurationElement.getTextContent())) : null;
                    extensionInstance.setPublicConfiguration(publicConfigurationInstance);
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            HostedServiceListExtensionsResponse hostedServiceListExtensionsResponse = result;
            return hostedServiceListExtensionsResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<HostedServiceListAvailableExtensionsResponse> listExtensionVersionsAsync(final String providerNamespace, final String extensionType) {
        return this.getClient().getExecutorService().submit(new Callable<HostedServiceListAvailableExtensionsResponse>(){

            @Override
            public HostedServiceListAvailableExtensionsResponse call() throws Exception {
                return HostedServiceOperationsImpl.this.listExtensionVersions(providerNamespace, extensionType);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HostedServiceListAvailableExtensionsResponse listExtensionVersions(String providerNamespace, String extensionType) throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException {
        if (providerNamespace == null) {
            throw new NullPointerException("providerNamespace");
        }
        if (extensionType == null) {
            throw new NullPointerException("extensionType");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("providerNamespace", providerNamespace);
            tracingParameters.put("extensionType", extensionType);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listExtensionVersionsAsync", tracingParameters);
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        String url = "/" + this.getClient().getCredentials().getSubscriptionId().trim() + "/services/extensions/" + providerNamespace.trim() + "/" + extensionType.trim();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2014-04-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            HostedServiceListAvailableExtensionsResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new HostedServiceListAvailableExtensionsResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element extensionImagesSequenceElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"ExtensionImages");
            if (extensionImagesSequenceElement != null) {
                for (int i1 = 0; i1 < XmlUtility.getElementsByTagNameNS((Node)extensionImagesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ExtensionImage").size(); ++i1) {
                    Element isJsonExtensionElement;
                    Element homepageUriElement;
                    Element privacyUriElement;
                    Element eulaElement;
                    Element replicationCompletedElement;
                    Element sampleConfigElement;
                    Element blockRoleUponFailureElement;
                    Element privateConfigurationSchemaElement;
                    Element publicConfigurationSchemaElement;
                    Element hostingResourcesElement;
                    Element thumbprintAlgorithmElement;
                    Element descriptionElement;
                    Element versionElement;
                    Element labelElement;
                    Element typeElement;
                    Element extensionImagesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)extensionImagesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ExtensionImage").get(i1);
                    HostedServiceListAvailableExtensionsResponse.ExtensionImage extensionImageInstance = new HostedServiceListAvailableExtensionsResponse.ExtensionImage();
                    result.getExtensionImages().add(extensionImageInstance);
                    Element providerNameSpaceElement = XmlUtility.getElementByTagNameNS((Node)extensionImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ProviderNameSpace");
                    if (providerNameSpaceElement != null) {
                        String providerNameSpaceInstance = providerNameSpaceElement.getTextContent();
                        extensionImageInstance.setProviderNamespace(providerNameSpaceInstance);
                    }
                    if ((typeElement = XmlUtility.getElementByTagNameNS((Node)extensionImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Type")) != null) {
                        String typeInstance = typeElement.getTextContent();
                        extensionImageInstance.setType(typeInstance);
                    }
                    if ((labelElement = XmlUtility.getElementByTagNameNS((Node)extensionImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Label")) != null) {
                        String labelInstance = labelElement.getTextContent();
                        extensionImageInstance.setLabel(labelInstance);
                    }
                    if ((versionElement = XmlUtility.getElementByTagNameNS((Node)extensionImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Version")) != null) {
                        String versionInstance = versionElement.getTextContent();
                        extensionImageInstance.setVersion(versionInstance);
                    }
                    if ((descriptionElement = XmlUtility.getElementByTagNameNS((Node)extensionImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Description")) != null) {
                        String descriptionInstance = descriptionElement.getTextContent();
                        extensionImageInstance.setDescription(descriptionInstance);
                    }
                    if ((thumbprintAlgorithmElement = XmlUtility.getElementByTagNameNS((Node)extensionImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ThumbprintAlgorithm")) != null) {
                        String thumbprintAlgorithmInstance = thumbprintAlgorithmElement.getTextContent();
                        extensionImageInstance.setThumbprintAlgorithm(thumbprintAlgorithmInstance);
                    }
                    if ((hostingResourcesElement = XmlUtility.getElementByTagNameNS((Node)extensionImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"HostingResources")) != null) {
                        String hostingResourcesInstance = hostingResourcesElement.getTextContent();
                        extensionImageInstance.setHostingResources(hostingResourcesInstance);
                    }
                    if ((publicConfigurationSchemaElement = XmlUtility.getElementByTagNameNS((Node)extensionImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublicConfigurationSchema")) != null) {
                        String publicConfigurationSchemaInstance = publicConfigurationSchemaElement.getTextContent() != null ? new String(Base64.decode((String)publicConfigurationSchemaElement.getTextContent())) : null;
                        extensionImageInstance.setPublicConfigurationSchema(publicConfigurationSchemaInstance);
                    }
                    if ((privateConfigurationSchemaElement = XmlUtility.getElementByTagNameNS((Node)extensionImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PrivateConfigurationSchema")) != null) {
                        String privateConfigurationSchemaInstance = privateConfigurationSchemaElement.getTextContent() != null ? new String(Base64.decode((String)privateConfigurationSchemaElement.getTextContent())) : null;
                        extensionImageInstance.setPrivateConfigurationSchema(privateConfigurationSchemaInstance);
                    }
                    if ((blockRoleUponFailureElement = XmlUtility.getElementByTagNameNS((Node)extensionImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"BlockRoleUponFailure")) != null && !(blockRoleUponFailureElement.getTextContent() == null || blockRoleUponFailureElement.getTextContent().isEmpty())) {
                        boolean blockRoleUponFailureInstance = DatatypeConverter.parseBoolean((String)blockRoleUponFailureElement.getTextContent().toLowerCase());
                        extensionImageInstance.setBlockRoleUponFailure(blockRoleUponFailureInstance);
                    }
                    if ((sampleConfigElement = XmlUtility.getElementByTagNameNS((Node)extensionImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SampleConfig")) != null) {
                        String sampleConfigInstance = sampleConfigElement.getTextContent() != null ? new String(Base64.decode((String)sampleConfigElement.getTextContent())) : null;
                        extensionImageInstance.setSampleConfig(sampleConfigInstance);
                    }
                    if ((replicationCompletedElement = XmlUtility.getElementByTagNameNS((Node)extensionImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ReplicationCompleted")) != null && !(replicationCompletedElement.getTextContent() == null || replicationCompletedElement.getTextContent().isEmpty())) {
                        boolean replicationCompletedInstance = DatatypeConverter.parseBoolean((String)replicationCompletedElement.getTextContent().toLowerCase());
                        extensionImageInstance.setReplicationCompleted(replicationCompletedInstance);
                    }
                    if ((eulaElement = XmlUtility.getElementByTagNameNS((Node)extensionImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Eula")) != null) {
                        URI eulaInstance = new URI(eulaElement.getTextContent());
                        extensionImageInstance.setEula(eulaInstance);
                    }
                    if ((privacyUriElement = XmlUtility.getElementByTagNameNS((Node)extensionImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PrivacyUri")) != null) {
                        URI privacyUriInstance = new URI(privacyUriElement.getTextContent());
                        extensionImageInstance.setPrivacyUri(privacyUriInstance);
                    }
                    if ((homepageUriElement = XmlUtility.getElementByTagNameNS((Node)extensionImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"HomepageUri")) != null) {
                        URI homepageUriInstance = new URI(homepageUriElement.getTextContent());
                        extensionImageInstance.setHomepageUri(homepageUriInstance);
                    }
                    if ((isJsonExtensionElement = XmlUtility.getElementByTagNameNS((Node)extensionImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsJsonExtension")) == null || isJsonExtensionElement.getTextContent() == null || isJsonExtensionElement.getTextContent().isEmpty()) continue;
                    boolean isJsonExtensionInstance = DatatypeConverter.parseBoolean((String)isJsonExtensionElement.getTextContent().toLowerCase());
                    extensionImageInstance.setIsJsonExtension(isJsonExtensionInstance);
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            HostedServiceListAvailableExtensionsResponse hostedServiceListAvailableExtensionsResponse = result;
            return hostedServiceListAvailableExtensionsResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> updateAsync(final String serviceName, final HostedServiceUpdateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return HostedServiceOperationsImpl.this.update(serviceName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse update(String serviceName, HostedServiceUpdateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException, InterruptedException, ExecutionException, URISyntaxException {
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getDescription() != null && parameters.getDescription().length() > 1024) {
            throw new IllegalArgumentException("parameters.Description");
        }
        int labelCount = (parameters.getDescription() != null ? 1 : 0) + (parameters.getLabel() != null ? 1 : 0);
        if (labelCount < 1) {
            throw new IllegalArgumentException("Expected at least one of parameters.Description, parameters.Label to be provided.");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"updateAsync", tracingParameters);
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        String url = "/" + this.getClient().getCredentials().getSubscriptionId().trim() + "/services/hostedservices/" + serviceName.trim();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        HttpPut httpRequest = new HttpPut(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-04-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element updateHostedServiceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "UpdateHostedService");
        requestDoc.appendChild(updateHostedServiceElement);
        if (parameters.getLabel() != null) {
            Element labelElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Label");
            labelElement.appendChild(requestDoc.createTextNode(Base64.encode((byte[])parameters.getLabel().getBytes())));
            updateHostedServiceElement.appendChild(labelElement);
        }
        if (parameters.getDescription() != null) {
            Element descriptionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Description");
            descriptionElement.appendChild(requestDoc.createTextNode(parameters.getDescription()));
            updateHostedServiceElement.appendChild(descriptionElement);
        }
        if (parameters.getExtendedProperties() != null) {
            Element extendedPropertiesDictionaryElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ExtendedProperties");
            for (Map.Entry<String, String> entry : parameters.getExtendedProperties().entrySet()) {
                String extendedPropertiesKey = entry.getKey();
                String extendedPropertiesValue = entry.getValue();
                Element extendedPropertiesElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ExtendedProperty");
                extendedPropertiesDictionaryElement.appendChild(extendedPropertiesElement);
                Element extendedPropertiesKeyElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
                extendedPropertiesKeyElement.appendChild(requestDoc.createTextNode(extendedPropertiesKey));
                extendedPropertiesElement.appendChild(extendedPropertiesKeyElement);
                Element extendedPropertiesValueElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Value");
                extendedPropertiesValueElement.appendChild(requestDoc.createTextNode(extendedPropertiesValue));
                extendedPropertiesElement.appendChild(extendedPropertiesValueElement);
            }
            updateHostedServiceElement.appendChild(extendedPropertiesDictionaryElement);
        }
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

