/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.management.compute;

import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.utils.BOMInputStream;
import com.microsoft.windowsazure.core.utils.Base64;
import com.microsoft.windowsazure.core.utils.XmlUtility;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.compute.ComputeManagementClientImpl;
import com.microsoft.windowsazure.management.compute.OperatingSystemOperations;
import com.microsoft.windowsazure.management.compute.models.OperatingSystemListFamiliesResponse;
import com.microsoft.windowsazure.management.compute.models.OperatingSystemListResponse;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class OperatingSystemOperationsImpl
implements ServiceOperations<ComputeManagementClientImpl>,
OperatingSystemOperations {
    private ComputeManagementClientImpl client;

    OperatingSystemOperationsImpl(ComputeManagementClientImpl client) {
        this.client = client;
    }

    public ComputeManagementClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<OperatingSystemListResponse> listAsync() {
        return this.getClient().getExecutorService().submit(new Callable<OperatingSystemListResponse>(){

            @Override
            public OperatingSystemListResponse call() throws Exception {
                return OperatingSystemOperationsImpl.this.list();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperatingSystemListResponse list() throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException {
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap tracingParameters = new HashMap();
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        String url = "/" + this.getClient().getCredentials().getSubscriptionId().trim() + "/operatingsystems";
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2014-04-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperatingSystemListResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new OperatingSystemListResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element operatingSystemsSequenceElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"OperatingSystems");
            if (operatingSystemsSequenceElement != null) {
                for (int i1 = 0; i1 < XmlUtility.getElementsByTagNameNS((Node)operatingSystemsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"OperatingSystem").size(); ++i1) {
                    Element familyLabelElement;
                    Element familyElement;
                    Element isActiveElement;
                    Element isDefaultElement;
                    Element labelElement;
                    Element operatingSystemsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)operatingSystemsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"OperatingSystem").get(i1);
                    OperatingSystemListResponse.OperatingSystem operatingSystemInstance = new OperatingSystemListResponse.OperatingSystem();
                    result.getOperatingSystems().add(operatingSystemInstance);
                    Element versionElement = XmlUtility.getElementByTagNameNS((Node)operatingSystemsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Version");
                    if (versionElement != null) {
                        String versionInstance = versionElement.getTextContent();
                        operatingSystemInstance.setVersion(versionInstance);
                    }
                    if ((labelElement = XmlUtility.getElementByTagNameNS((Node)operatingSystemsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Label")) != null) {
                        String labelInstance = labelElement.getTextContent() != null ? new String(Base64.decode((String)labelElement.getTextContent())) : null;
                        operatingSystemInstance.setLabel(labelInstance);
                    }
                    if ((isDefaultElement = XmlUtility.getElementByTagNameNS((Node)operatingSystemsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsDefault")) != null) {
                        boolean isDefaultInstance = DatatypeConverter.parseBoolean((String)isDefaultElement.getTextContent().toLowerCase());
                        operatingSystemInstance.setIsDefault(isDefaultInstance);
                    }
                    if ((isActiveElement = XmlUtility.getElementByTagNameNS((Node)operatingSystemsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsActive")) != null) {
                        boolean isActiveInstance = DatatypeConverter.parseBoolean((String)isActiveElement.getTextContent().toLowerCase());
                        operatingSystemInstance.setIsActive(isActiveInstance);
                    }
                    if ((familyElement = XmlUtility.getElementByTagNameNS((Node)operatingSystemsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Family")) != null) {
                        int familyInstance = DatatypeConverter.parseInt((String)familyElement.getTextContent());
                        operatingSystemInstance.setFamily(familyInstance);
                    }
                    if ((familyLabelElement = XmlUtility.getElementByTagNameNS((Node)operatingSystemsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"FamilyLabel")) == null) continue;
                    String familyLabelInstance = familyLabelElement.getTextContent() != null ? new String(Base64.decode((String)familyLabelElement.getTextContent())) : null;
                    operatingSystemInstance.setFamilyLabel(familyLabelInstance);
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperatingSystemListResponse operatingSystemListResponse = result;
            return operatingSystemListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperatingSystemListFamiliesResponse> listFamiliesAsync() {
        return this.getClient().getExecutorService().submit(new Callable<OperatingSystemListFamiliesResponse>(){

            @Override
            public OperatingSystemListFamiliesResponse call() throws Exception {
                return OperatingSystemOperationsImpl.this.listFamilies();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperatingSystemListFamiliesResponse listFamilies() throws IOException, ServiceException, ParserConfigurationException, SAXException {
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap tracingParameters = new HashMap();
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listFamiliesAsync", tracingParameters);
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        String url = "/" + this.getClient().getCredentials().getSubscriptionId().trim() + "/operatingsystemfamilies";
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2014-04-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperatingSystemListFamiliesResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new OperatingSystemListFamiliesResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element operatingSystemFamiliesSequenceElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"OperatingSystemFamilies");
            if (operatingSystemFamiliesSequenceElement != null) {
                for (int i1 = 0; i1 < XmlUtility.getElementsByTagNameNS((Node)operatingSystemFamiliesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"OperatingSystemFamily").size(); ++i1) {
                    Element operatingSystemsSequenceElement;
                    Element labelElement;
                    Element operatingSystemFamiliesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)operatingSystemFamiliesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"OperatingSystemFamily").get(i1);
                    OperatingSystemListFamiliesResponse.OperatingSystemFamily operatingSystemFamilyInstance = new OperatingSystemListFamiliesResponse.OperatingSystemFamily();
                    result.getOperatingSystemFamilies().add(operatingSystemFamilyInstance);
                    Element nameElement = XmlUtility.getElementByTagNameNS((Node)operatingSystemFamiliesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                    if (nameElement != null) {
                        int nameInstance = DatatypeConverter.parseInt((String)nameElement.getTextContent());
                        operatingSystemFamilyInstance.setName(nameInstance);
                    }
                    if ((labelElement = XmlUtility.getElementByTagNameNS((Node)operatingSystemFamiliesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Label")) != null) {
                        String labelInstance = labelElement.getTextContent() != null ? new String(Base64.decode((String)labelElement.getTextContent())) : null;
                        operatingSystemFamilyInstance.setLabel(labelInstance);
                    }
                    if ((operatingSystemsSequenceElement = XmlUtility.getElementByTagNameNS((Node)operatingSystemFamiliesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"OperatingSystems")) == null) continue;
                    for (int i2 = 0; i2 < XmlUtility.getElementsByTagNameNS((Node)operatingSystemsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"OperatingSystem").size(); ++i2) {
                        Element isActiveElement;
                        Element isDefaultElement;
                        Element labelElement2;
                        Element operatingSystemsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)operatingSystemsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"OperatingSystem").get(i2);
                        OperatingSystemListFamiliesResponse.OperatingSystem operatingSystemInstance = new OperatingSystemListFamiliesResponse.OperatingSystem();
                        operatingSystemFamilyInstance.getOperatingSystems().add(operatingSystemInstance);
                        Element versionElement = XmlUtility.getElementByTagNameNS((Node)operatingSystemsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Version");
                        if (versionElement != null) {
                            String versionInstance = versionElement.getTextContent();
                            operatingSystemInstance.setVersion(versionInstance);
                        }
                        if ((labelElement2 = XmlUtility.getElementByTagNameNS((Node)operatingSystemsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Label")) != null) {
                            String labelInstance2 = labelElement2.getTextContent() != null ? new String(Base64.decode((String)labelElement2.getTextContent())) : null;
                            operatingSystemInstance.setLabel(labelInstance2);
                        }
                        if ((isDefaultElement = XmlUtility.getElementByTagNameNS((Node)operatingSystemsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsDefault")) != null) {
                            boolean isDefaultInstance = DatatypeConverter.parseBoolean((String)isDefaultElement.getTextContent().toLowerCase());
                            operatingSystemInstance.setIsDefault(isDefaultInstance);
                        }
                        if ((isActiveElement = XmlUtility.getElementByTagNameNS((Node)operatingSystemsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsActive")) == null) continue;
                        boolean isActiveInstance = DatatypeConverter.parseBoolean((String)isActiveElement.getTextContent().toLowerCase());
                        operatingSystemInstance.setIsActive(isActiveInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperatingSystemListFamiliesResponse operatingSystemListFamiliesResponse = result;
            return operatingSystemListFamiliesResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

