/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.management.compute;

import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.BOMInputStream;
import com.microsoft.windowsazure.core.utils.XmlUtility;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.compute.ComputeManagementClientImpl;
import com.microsoft.windowsazure.management.compute.VirtualMachineOSImageOperations;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineOSImageCreateParameters;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineOSImageCreateResponse;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineOSImageGetResponse;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineOSImageListResponse;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineOSImageUpdateParameters;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineOSImageUpdateResponse;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class VirtualMachineOSImageOperationsImpl
implements ServiceOperations<ComputeManagementClientImpl>,
VirtualMachineOSImageOperations {
    private ComputeManagementClientImpl client;

    VirtualMachineOSImageOperationsImpl(ComputeManagementClientImpl client) {
        this.client = client;
    }

    public ComputeManagementClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<VirtualMachineOSImageCreateResponse> createAsync(final VirtualMachineOSImageCreateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineOSImageCreateResponse>(){

            @Override
            public VirtualMachineOSImageCreateResponse call() throws Exception {
                return VirtualMachineOSImageOperationsImpl.this.create(parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualMachineOSImageCreateResponse create(VirtualMachineOSImageCreateParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException, ParserConfigurationException, SAXException, TransformerException, URISyntaxException {
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getLabel() == null) {
            throw new NullPointerException("parameters.Label");
        }
        if (parameters.getMediaLinkUri() == null) {
            throw new NullPointerException("parameters.MediaLinkUri");
        }
        if (parameters.getName() == null) {
            throw new NullPointerException("parameters.Name");
        }
        if (parameters.getOperatingSystemType() == null) {
            throw new NullPointerException("parameters.OperatingSystemType");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, VirtualMachineOSImageCreateParameters> tracingParameters = new HashMap<String, VirtualMachineOSImageCreateParameters>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"createAsync", tracingParameters);
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        String url = "/" + this.getClient().getCredentials().getSubscriptionId().trim() + "/services/images";
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-04-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element oSImageElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "OSImage");
        requestDoc.appendChild(oSImageElement);
        Element labelElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Label");
        labelElement.appendChild(requestDoc.createTextNode(parameters.getLabel()));
        oSImageElement.appendChild(labelElement);
        Element mediaLinkElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "MediaLink");
        mediaLinkElement.appendChild(requestDoc.createTextNode(parameters.getMediaLinkUri().toString()));
        oSImageElement.appendChild(mediaLinkElement);
        Element nameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
        nameElement.appendChild(requestDoc.createTextNode(parameters.getName()));
        oSImageElement.appendChild(nameElement);
        Element osElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "OS");
        osElement.appendChild(requestDoc.createTextNode(parameters.getOperatingSystemType()));
        oSImageElement.appendChild(osElement);
        if (parameters.getEula() != null) {
            Element eulaElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Eula");
            eulaElement.appendChild(requestDoc.createTextNode(parameters.getEula()));
            oSImageElement.appendChild(eulaElement);
        }
        if (parameters.getDescription() != null) {
            Element descriptionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Description");
            descriptionElement.appendChild(requestDoc.createTextNode(parameters.getDescription()));
            oSImageElement.appendChild(descriptionElement);
        }
        if (parameters.getImageFamily() != null) {
            Element imageFamilyElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ImageFamily");
            imageFamilyElement.appendChild(requestDoc.createTextNode(parameters.getImageFamily()));
            oSImageElement.appendChild(imageFamilyElement);
        }
        if (parameters.getPublishedDate() != null) {
            Element publishedDateElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PublishedDate");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            publishedDateElement.appendChild(requestDoc.createTextNode(simpleDateFormat.format(parameters.getPublishedDate().getTime())));
            oSImageElement.appendChild(publishedDateElement);
        }
        Element isPremiumElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IsPremium");
        isPremiumElement.appendChild(requestDoc.createTextNode(Boolean.toString(parameters.isPremium()).toLowerCase()));
        oSImageElement.appendChild(isPremiumElement);
        Element showInGuiElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ShowInGui");
        showInGuiElement.appendChild(requestDoc.createTextNode(Boolean.toString(parameters.isShowInGui()).toLowerCase()));
        oSImageElement.appendChild(showInGuiElement);
        if (parameters.getPrivacyUri() != null) {
            Element privacyUriElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PrivacyUri");
            privacyUriElement.appendChild(requestDoc.createTextNode(parameters.getPrivacyUri().toString()));
            oSImageElement.appendChild(privacyUriElement);
        }
        if (parameters.getIconUri() != null) {
            Element iconUriElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IconUri");
            iconUriElement.appendChild(requestDoc.createTextNode(parameters.getIconUri().toString()));
            oSImageElement.appendChild(iconUriElement);
        }
        if (parameters.getRecommendedVMSize() != null) {
            Element recommendedVMSizeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RecommendedVMSize");
            recommendedVMSizeElement.appendChild(requestDoc.createTextNode(parameters.getRecommendedVMSize()));
            oSImageElement.appendChild(recommendedVMSizeElement);
        }
        if (parameters.getSmallIconUri() != null) {
            Element smallIconUriElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "SmallIconUri");
            smallIconUriElement.appendChild(requestDoc.createTextNode(parameters.getSmallIconUri().toString()));
            oSImageElement.appendChild(smallIconUriElement);
        }
        if (parameters.getLanguage() != null) {
            Element languageElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Language");
            languageElement.appendChild(requestDoc.createTextNode(parameters.getLanguage()));
            oSImageElement.appendChild(languageElement);
        }
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            VirtualMachineOSImageCreateResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new VirtualMachineOSImageCreateResponse();
            DocumentBuilderFactory documentBuilderFactory2 = DocumentBuilderFactory.newInstance();
            documentBuilderFactory2.setNamespaceAware(true);
            DocumentBuilder documentBuilder2 = documentBuilderFactory2.newDocumentBuilder();
            Document responseDoc = documentBuilder2.parse((InputStream)new BOMInputStream(responseContent));
            Element oSImageElement2 = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"OSImage");
            if (oSImageElement2 != null) {
                Element languageElement2;
                Element smallIconUriElement2;
                Element recommendedVMSizeElement2;
                Element iconUriElement2;
                Element privacyUriElement2;
                Element showInGuiElement2;
                Element isPremiumElement2;
                Element publisherNameElement;
                Element publishedDateElement2;
                Element imageFamilyElement2;
                Element descriptionElement2;
                Element eulaElement2;
                Element osElement2;
                Element nameElement2;
                Element mediaLinkElement2;
                Element logicalSizeInGBElement;
                Element labelElement2;
                Element categoryElement;
                Element locationElement = XmlUtility.getElementByTagNameNS((Node)oSImageElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Location");
                if (locationElement != null) {
                    String locationInstance = locationElement.getTextContent();
                    result.setLocation(locationInstance);
                }
                if ((categoryElement = XmlUtility.getElementByTagNameNS((Node)oSImageElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Category")) != null) {
                    String categoryInstance = categoryElement.getTextContent();
                    result.setCategory(categoryInstance);
                }
                if ((labelElement2 = XmlUtility.getElementByTagNameNS((Node)oSImageElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Label")) != null) {
                    String labelInstance = labelElement2.getTextContent();
                    result.setLabel(labelInstance);
                }
                if ((logicalSizeInGBElement = XmlUtility.getElementByTagNameNS((Node)oSImageElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"LogicalSizeInGB")) != null) {
                    double logicalSizeInGBInstance = DatatypeConverter.parseDouble((String)logicalSizeInGBElement.getTextContent());
                    result.setLogicalSizeInGB(logicalSizeInGBInstance);
                }
                if ((mediaLinkElement2 = XmlUtility.getElementByTagNameNS((Node)oSImageElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"MediaLink")) != null) {
                    URI mediaLinkInstance = new URI(mediaLinkElement2.getTextContent());
                    result.setMediaLinkUri(mediaLinkInstance);
                }
                if ((nameElement2 = XmlUtility.getElementByTagNameNS((Node)oSImageElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name")) != null) {
                    String nameInstance = nameElement2.getTextContent();
                    result.setName(nameInstance);
                }
                if ((osElement2 = XmlUtility.getElementByTagNameNS((Node)oSImageElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"OS")) != null) {
                    String osInstance = osElement2.getTextContent();
                    result.setOperatingSystemType(osInstance);
                }
                if ((eulaElement2 = XmlUtility.getElementByTagNameNS((Node)oSImageElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Eula")) != null) {
                    String eulaInstance = eulaElement2.getTextContent();
                    result.setEula(eulaInstance);
                }
                if ((descriptionElement2 = XmlUtility.getElementByTagNameNS((Node)oSImageElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Description")) != null) {
                    String descriptionInstance = descriptionElement2.getTextContent();
                    result.setDescription(descriptionInstance);
                }
                if ((imageFamilyElement2 = XmlUtility.getElementByTagNameNS((Node)oSImageElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"ImageFamily")) != null) {
                    String imageFamilyInstance = imageFamilyElement2.getTextContent();
                    result.setImageFamily(imageFamilyInstance);
                }
                if ((publishedDateElement2 = XmlUtility.getElementByTagNameNS((Node)oSImageElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublishedDate")) != null && !(publishedDateElement2.getTextContent() == null || publishedDateElement2.getTextContent().isEmpty())) {
                    Calendar publishedDateInstance = DatatypeConverter.parseDateTime((String)publishedDateElement2.getTextContent());
                    result.setPublishedDate(publishedDateInstance);
                }
                if ((publisherNameElement = XmlUtility.getElementByTagNameNS((Node)oSImageElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublisherName")) != null) {
                    String publisherNameInstance = publisherNameElement.getTextContent();
                    result.setPublisherName(publisherNameInstance);
                }
                if ((isPremiumElement2 = XmlUtility.getElementByTagNameNS((Node)oSImageElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsPremium")) != null && !(isPremiumElement2.getTextContent() == null || isPremiumElement2.getTextContent().isEmpty())) {
                    boolean isPremiumInstance = DatatypeConverter.parseBoolean((String)isPremiumElement2.getTextContent().toLowerCase());
                    result.setIsPremium(isPremiumInstance);
                }
                if ((showInGuiElement2 = XmlUtility.getElementByTagNameNS((Node)oSImageElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"ShowInGui")) != null && !(showInGuiElement2.getTextContent() == null || showInGuiElement2.getTextContent().isEmpty())) {
                    boolean showInGuiInstance = DatatypeConverter.parseBoolean((String)showInGuiElement2.getTextContent().toLowerCase());
                    result.setShowInGui(showInGuiInstance);
                }
                if ((privacyUriElement2 = XmlUtility.getElementByTagNameNS((Node)oSImageElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"PrivacyUri")) != null) {
                    URI privacyUriInstance = new URI(privacyUriElement2.getTextContent());
                    result.setPrivacyUri(privacyUriInstance);
                }
                if ((iconUriElement2 = XmlUtility.getElementByTagNameNS((Node)oSImageElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"IconUri")) != null) {
                    URI iconUriInstance = new URI(iconUriElement2.getTextContent());
                    result.setIconUri(iconUriInstance);
                }
                if ((recommendedVMSizeElement2 = XmlUtility.getElementByTagNameNS((Node)oSImageElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"RecommendedVMSize")) != null) {
                    String recommendedVMSizeInstance = recommendedVMSizeElement2.getTextContent();
                    result.setRecommendedVMSize(recommendedVMSizeInstance);
                }
                if ((smallIconUriElement2 = XmlUtility.getElementByTagNameNS((Node)oSImageElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"SmallIconUri")) != null) {
                    URI smallIconUriInstance = new URI(smallIconUriElement2.getTextContent());
                    result.setSmallIconUri(smallIconUriInstance);
                }
                if ((languageElement2 = XmlUtility.getElementByTagNameNS((Node)oSImageElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Language")) != null) {
                    String languageInstance = languageElement2.getTextContent();
                    result.setLanguage(languageInstance);
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            VirtualMachineOSImageCreateResponse virtualMachineOSImageCreateResponse = result;
            return virtualMachineOSImageCreateResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> deleteAsync(final String imageName, final boolean deleteFromStorage) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return VirtualMachineOSImageOperationsImpl.this.delete(imageName, deleteFromStorage);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse delete(String imageName, boolean deleteFromStorage) throws IOException, ServiceException, InterruptedException, ExecutionException {
        if (imageName == null) {
            throw new NullPointerException("imageName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("imageName", imageName);
            tracingParameters.put("deleteFromStorage", deleteFromStorage);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"deleteAsync", tracingParameters);
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        String url = "/" + this.getClient().getCredentials().getSubscriptionId().trim() + "/services/images/" + imageName.trim() + "?";
        if (deleteFromStorage) {
            url = url + "comp=" + "media";
        }
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        httpRequest.setHeader("x-ms-version", "2014-04-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<VirtualMachineOSImageGetResponse> getAsync(final String imageName) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineOSImageGetResponse>(){

            @Override
            public VirtualMachineOSImageGetResponse call() throws Exception {
                return VirtualMachineOSImageOperationsImpl.this.get(imageName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualMachineOSImageGetResponse get(String imageName) throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException {
        if (imageName == null) {
            throw new NullPointerException("imageName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("imageName", imageName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getAsync", tracingParameters);
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        String url = "/" + this.getClient().getCredentials().getSubscriptionId().trim() + "/services/images/" + imageName.trim();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2014-04-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            VirtualMachineOSImageGetResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new VirtualMachineOSImageGetResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element oSImageElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"OSImage");
            if (oSImageElement != null) {
                Element languageElement;
                Element smallIconUriElement;
                Element publisherNameElement;
                Element recommendedVMSizeElement;
                Element privacyUriElement;
                Element iconUriElement;
                Element isPremiumElement;
                Element publishedDateElement;
                Element showInGuiElement;
                Element imageFamilyElement;
                Element descriptionElement;
                Element eulaElement;
                Element osElement;
                Element nameElement;
                Element mediaLinkElement;
                Element logicalSizeInGBElement;
                Element locationElement;
                Element labelElement;
                Element categoryElement;
                Element affinityGroupElement = XmlUtility.getElementByTagNameNS((Node)oSImageElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AffinityGroup");
                if (affinityGroupElement != null) {
                    String affinityGroupInstance = affinityGroupElement.getTextContent();
                    result.setAffinityGroup(affinityGroupInstance);
                }
                if ((categoryElement = XmlUtility.getElementByTagNameNS((Node)oSImageElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Category")) != null) {
                    String categoryInstance = categoryElement.getTextContent();
                    result.setCategory(categoryInstance);
                }
                if ((labelElement = XmlUtility.getElementByTagNameNS((Node)oSImageElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Label")) != null) {
                    String labelInstance = labelElement.getTextContent();
                    result.setLabel(labelInstance);
                }
                if ((locationElement = XmlUtility.getElementByTagNameNS((Node)oSImageElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Location")) != null) {
                    String locationInstance = locationElement.getTextContent();
                    result.setLocation(locationInstance);
                }
                if ((logicalSizeInGBElement = XmlUtility.getElementByTagNameNS((Node)oSImageElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LogicalSizeInGB")) != null) {
                    double logicalSizeInGBInstance = DatatypeConverter.parseDouble((String)logicalSizeInGBElement.getTextContent());
                    result.setLogicalSizeInGB(logicalSizeInGBInstance);
                }
                if ((mediaLinkElement = XmlUtility.getElementByTagNameNS((Node)oSImageElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"MediaLink")) != null) {
                    URI mediaLinkInstance = new URI(mediaLinkElement.getTextContent());
                    result.setMediaLinkUri(mediaLinkInstance);
                }
                if ((nameElement = XmlUtility.getElementByTagNameNS((Node)oSImageElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name")) != null) {
                    String nameInstance = nameElement.getTextContent();
                    result.setName(nameInstance);
                }
                if ((osElement = XmlUtility.getElementByTagNameNS((Node)oSImageElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"OS")) != null) {
                    String osInstance = osElement.getTextContent();
                    result.setOperatingSystemType(osInstance);
                }
                if ((eulaElement = XmlUtility.getElementByTagNameNS((Node)oSImageElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Eula")) != null) {
                    String eulaInstance = eulaElement.getTextContent();
                    result.setEula(eulaInstance);
                }
                if ((descriptionElement = XmlUtility.getElementByTagNameNS((Node)oSImageElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Description")) != null) {
                    String descriptionInstance = descriptionElement.getTextContent();
                    result.setDescription(descriptionInstance);
                }
                if ((imageFamilyElement = XmlUtility.getElementByTagNameNS((Node)oSImageElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ImageFamily")) != null) {
                    String imageFamilyInstance = imageFamilyElement.getTextContent();
                    result.setImageFamily(imageFamilyInstance);
                }
                if ((showInGuiElement = XmlUtility.getElementByTagNameNS((Node)oSImageElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ShowInGui")) != null && !(showInGuiElement.getTextContent() == null || showInGuiElement.getTextContent().isEmpty())) {
                    boolean showInGuiInstance = DatatypeConverter.parseBoolean((String)showInGuiElement.getTextContent().toLowerCase());
                    result.setShowInGui(showInGuiInstance);
                }
                if ((publishedDateElement = XmlUtility.getElementByTagNameNS((Node)oSImageElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublishedDate")) != null) {
                    Calendar publishedDateInstance = DatatypeConverter.parseDateTime((String)publishedDateElement.getTextContent());
                    result.setPublishedDate(publishedDateInstance);
                }
                if ((isPremiumElement = XmlUtility.getElementByTagNameNS((Node)oSImageElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsPremium")) != null && !(isPremiumElement.getTextContent() == null || isPremiumElement.getTextContent().isEmpty())) {
                    boolean isPremiumInstance = DatatypeConverter.parseBoolean((String)isPremiumElement.getTextContent().toLowerCase());
                    result.setIsPremium(isPremiumInstance);
                }
                if ((iconUriElement = XmlUtility.getElementByTagNameNS((Node)oSImageElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IconUri")) != null) {
                    URI iconUriInstance = new URI(iconUriElement.getTextContent());
                    result.setIconUri(iconUriInstance);
                }
                if ((privacyUriElement = XmlUtility.getElementByTagNameNS((Node)oSImageElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PrivacyUri")) != null) {
                    URI privacyUriInstance = new URI(privacyUriElement.getTextContent());
                    result.setPrivacyUri(privacyUriInstance);
                }
                if ((recommendedVMSizeElement = XmlUtility.getElementByTagNameNS((Node)oSImageElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RecommendedVMSize")) != null) {
                    String recommendedVMSizeInstance = recommendedVMSizeElement.getTextContent();
                    result.setRecommendedVMSize(recommendedVMSizeInstance);
                }
                if ((publisherNameElement = XmlUtility.getElementByTagNameNS((Node)oSImageElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublisherName")) != null) {
                    String publisherNameInstance = publisherNameElement.getTextContent();
                    result.setPublisherName(publisherNameInstance);
                }
                if ((smallIconUriElement = XmlUtility.getElementByTagNameNS((Node)oSImageElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SmallIconUri")) != null) {
                    URI smallIconUriInstance = new URI(smallIconUriElement.getTextContent());
                    result.setSmallIconUri(smallIconUriInstance);
                }
                if ((languageElement = XmlUtility.getElementByTagNameNS((Node)oSImageElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Language")) != null) {
                    String languageInstance = languageElement.getTextContent();
                    result.setLanguage(languageInstance);
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            VirtualMachineOSImageGetResponse virtualMachineOSImageGetResponse = result;
            return virtualMachineOSImageGetResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<VirtualMachineOSImageListResponse> listAsync() {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineOSImageListResponse>(){

            @Override
            public VirtualMachineOSImageListResponse call() throws Exception {
                return VirtualMachineOSImageOperationsImpl.this.list();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualMachineOSImageListResponse list() throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException {
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap tracingParameters = new HashMap();
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        String url = "/" + this.getClient().getCredentials().getSubscriptionId().trim() + "/services/images";
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2014-04-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            VirtualMachineOSImageListResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new VirtualMachineOSImageListResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element imagesSequenceElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"Images");
            if (imagesSequenceElement != null) {
                for (int i1 = 0; i1 < XmlUtility.getElementsByTagNameNS((Node)imagesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"OSImage").size(); ++i1) {
                    Element languageElement;
                    Element smallIconUriElement;
                    Element pricingDetailLinkElement;
                    Element publisherNameElement;
                    Element recommendedVMSizeElement;
                    Element privacyUriElement;
                    Element isPremiumElement;
                    Element publishedDateElement;
                    Element imageFamilyElement;
                    Element descriptionElement;
                    Element eulaElement;
                    Element osElement;
                    Element nameElement;
                    Element mediaLinkElement;
                    Element logicalSizeInGBElement;
                    Element locationElement;
                    Element labelElement;
                    Element categoryElement;
                    Element imagesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)imagesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"OSImage").get(i1);
                    VirtualMachineOSImageListResponse.VirtualMachineOSImage oSImageInstance = new VirtualMachineOSImageListResponse.VirtualMachineOSImage();
                    result.getImages().add(oSImageInstance);
                    Element affinityGroupElement = XmlUtility.getElementByTagNameNS((Node)imagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AffinityGroup");
                    if (affinityGroupElement != null) {
                        String affinityGroupInstance = affinityGroupElement.getTextContent();
                        oSImageInstance.setAffinityGroup(affinityGroupInstance);
                    }
                    if ((categoryElement = XmlUtility.getElementByTagNameNS((Node)imagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Category")) != null) {
                        String categoryInstance = categoryElement.getTextContent();
                        oSImageInstance.setCategory(categoryInstance);
                    }
                    if ((labelElement = XmlUtility.getElementByTagNameNS((Node)imagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Label")) != null) {
                        String labelInstance = labelElement.getTextContent();
                        oSImageInstance.setLabel(labelInstance);
                    }
                    if ((locationElement = XmlUtility.getElementByTagNameNS((Node)imagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Location")) != null) {
                        String locationInstance = locationElement.getTextContent();
                        oSImageInstance.setLocation(locationInstance);
                    }
                    if ((logicalSizeInGBElement = XmlUtility.getElementByTagNameNS((Node)imagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LogicalSizeInGB")) != null) {
                        double logicalSizeInGBInstance = DatatypeConverter.parseDouble((String)logicalSizeInGBElement.getTextContent());
                        oSImageInstance.setLogicalSizeInGB(logicalSizeInGBInstance);
                    }
                    if ((mediaLinkElement = XmlUtility.getElementByTagNameNS((Node)imagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"MediaLink")) != null) {
                        URI mediaLinkInstance = new URI(mediaLinkElement.getTextContent());
                        oSImageInstance.setMediaLinkUri(mediaLinkInstance);
                    }
                    if ((nameElement = XmlUtility.getElementByTagNameNS((Node)imagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name")) != null) {
                        String nameInstance = nameElement.getTextContent();
                        oSImageInstance.setName(nameInstance);
                    }
                    if ((osElement = XmlUtility.getElementByTagNameNS((Node)imagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"OS")) != null) {
                        String osInstance = osElement.getTextContent();
                        oSImageInstance.setOperatingSystemType(osInstance);
                    }
                    if ((eulaElement = XmlUtility.getElementByTagNameNS((Node)imagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Eula")) != null) {
                        String eulaInstance = eulaElement.getTextContent();
                        oSImageInstance.setEula(eulaInstance);
                    }
                    if ((descriptionElement = XmlUtility.getElementByTagNameNS((Node)imagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Description")) != null) {
                        String descriptionInstance = descriptionElement.getTextContent();
                        oSImageInstance.setDescription(descriptionInstance);
                    }
                    if ((imageFamilyElement = XmlUtility.getElementByTagNameNS((Node)imagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ImageFamily")) != null) {
                        String imageFamilyInstance = imageFamilyElement.getTextContent();
                        oSImageInstance.setImageFamily(imageFamilyInstance);
                    }
                    if ((publishedDateElement = XmlUtility.getElementByTagNameNS((Node)imagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublishedDate")) != null) {
                        Calendar publishedDateInstance = DatatypeConverter.parseDateTime((String)publishedDateElement.getTextContent());
                        oSImageInstance.setPublishedDate(publishedDateInstance);
                    }
                    if ((isPremiumElement = XmlUtility.getElementByTagNameNS((Node)imagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsPremium")) != null && !(isPremiumElement.getTextContent() == null || isPremiumElement.getTextContent().isEmpty())) {
                        boolean isPremiumInstance = DatatypeConverter.parseBoolean((String)isPremiumElement.getTextContent().toLowerCase());
                        oSImageInstance.setIsPremium(isPremiumInstance);
                    }
                    if ((privacyUriElement = XmlUtility.getElementByTagNameNS((Node)imagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PrivacyUri")) != null) {
                        URI privacyUriInstance = new URI(privacyUriElement.getTextContent());
                        oSImageInstance.setPrivacyUri(privacyUriInstance);
                    }
                    if ((recommendedVMSizeElement = XmlUtility.getElementByTagNameNS((Node)imagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RecommendedVMSize")) != null) {
                        String recommendedVMSizeInstance = recommendedVMSizeElement.getTextContent();
                        oSImageInstance.setRecommendedVMSize(recommendedVMSizeInstance);
                    }
                    if ((publisherNameElement = XmlUtility.getElementByTagNameNS((Node)imagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublisherName")) != null) {
                        String publisherNameInstance = publisherNameElement.getTextContent();
                        oSImageInstance.setPublisherName(publisherNameInstance);
                    }
                    if ((pricingDetailLinkElement = XmlUtility.getElementByTagNameNS((Node)imagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PricingDetailLink")) != null) {
                        URI pricingDetailLinkInstance = new URI(pricingDetailLinkElement.getTextContent());
                        oSImageInstance.setPricingDetailUri(pricingDetailLinkInstance);
                    }
                    if ((smallIconUriElement = XmlUtility.getElementByTagNameNS((Node)imagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SmallIconUri")) != null) {
                        URI smallIconUriInstance = new URI(smallIconUriElement.getTextContent());
                        oSImageInstance.setSmallIconUri(smallIconUriInstance);
                    }
                    if ((languageElement = XmlUtility.getElementByTagNameNS((Node)imagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Language")) == null) continue;
                    String languageInstance = languageElement.getTextContent();
                    oSImageInstance.setLanguage(languageInstance);
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            VirtualMachineOSImageListResponse virtualMachineOSImageListResponse = result;
            return virtualMachineOSImageListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<VirtualMachineOSImageUpdateResponse> updateAsync(final String imageName, final VirtualMachineOSImageUpdateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineOSImageUpdateResponse>(){

            @Override
            public VirtualMachineOSImageUpdateResponse call() throws Exception {
                return VirtualMachineOSImageOperationsImpl.this.update(imageName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualMachineOSImageUpdateResponse update(String imageName, VirtualMachineOSImageUpdateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException, InterruptedException, ExecutionException, URISyntaxException {
        if (imageName == null) {
            throw new NullPointerException("imageName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getLabel() == null) {
            throw new NullPointerException("parameters.Label");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("imageName", imageName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"updateAsync", tracingParameters);
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        String url = "/" + this.getClient().getCredentials().getSubscriptionId().trim() + "/services/images/" + imageName.trim();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        HttpPut httpRequest = new HttpPut(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-04-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element oSImageElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "OSImage");
        requestDoc.appendChild(oSImageElement);
        Element labelElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Label");
        labelElement.appendChild(requestDoc.createTextNode(parameters.getLabel()));
        oSImageElement.appendChild(labelElement);
        if (parameters.getEula() != null) {
            Element eulaElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Eula");
            eulaElement.appendChild(requestDoc.createTextNode(parameters.getEula()));
            oSImageElement.appendChild(eulaElement);
        }
        if (parameters.getDescription() != null) {
            Element descriptionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Description");
            descriptionElement.appendChild(requestDoc.createTextNode(parameters.getDescription()));
            oSImageElement.appendChild(descriptionElement);
        }
        if (parameters.getImageFamily() != null) {
            Element imageFamilyElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ImageFamily");
            imageFamilyElement.appendChild(requestDoc.createTextNode(parameters.getImageFamily()));
            oSImageElement.appendChild(imageFamilyElement);
        }
        if (parameters.getPublishedDate() != null) {
            Element publishedDateElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PublishedDate");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            publishedDateElement.appendChild(requestDoc.createTextNode(simpleDateFormat.format(parameters.getPublishedDate().getTime())));
            oSImageElement.appendChild(publishedDateElement);
        }
        Element isPremiumElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IsPremium");
        isPremiumElement.appendChild(requestDoc.createTextNode(Boolean.toString(parameters.isPremium()).toLowerCase()));
        oSImageElement.appendChild(isPremiumElement);
        if (parameters.getPrivacyUri() != null) {
            Element privacyUriElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PrivacyUri");
            privacyUriElement.appendChild(requestDoc.createTextNode(parameters.getPrivacyUri().toString()));
            oSImageElement.appendChild(privacyUriElement);
        }
        if (parameters.getIconUri() != null) {
            Element iconUriElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IconUri");
            iconUriElement.appendChild(requestDoc.createTextNode(parameters.getIconUri().toString()));
            oSImageElement.appendChild(iconUriElement);
        }
        if (parameters.getRecommendedVMSize() != null) {
            Element recommendedVMSizeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RecommendedVMSize");
            recommendedVMSizeElement.appendChild(requestDoc.createTextNode(parameters.getRecommendedVMSize()));
            oSImageElement.appendChild(recommendedVMSizeElement);
        }
        if (parameters.getSmallIconUri() != null) {
            Element smallIconUriElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "SmallIconUri");
            smallIconUriElement.appendChild(requestDoc.createTextNode(parameters.getSmallIconUri().toString()));
            oSImageElement.appendChild(smallIconUriElement);
        }
        if (parameters.getLanguage() != null) {
            Element languageElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Language");
            languageElement.appendChild(requestDoc.createTextNode(parameters.getLanguage()));
            oSImageElement.appendChild(languageElement);
        }
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            VirtualMachineOSImageUpdateResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new VirtualMachineOSImageUpdateResponse();
            DocumentBuilderFactory documentBuilderFactory2 = DocumentBuilderFactory.newInstance();
            documentBuilderFactory2.setNamespaceAware(true);
            DocumentBuilder documentBuilder2 = documentBuilderFactory2.newDocumentBuilder();
            Document responseDoc = documentBuilder2.parse((InputStream)new BOMInputStream(responseContent));
            Element oSImageElement2 = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"OSImage");
            if (oSImageElement2 != null) {
                Element languageElement2;
                Element smallIconUriElement2;
                Element recommendedVMSizeElement2;
                Element iconUriElement2;
                Element privacyUriElement2;
                Element showInGuiElement;
                Element isPremiumElement2;
                Element publisherNameElement;
                Element publishedDateElement2;
                Element imageFamilyElement2;
                Element descriptionElement2;
                Element eulaElement2;
                Element osElement;
                Element nameElement;
                Element mediaLinkElement;
                Element logicalSizeInGBElement;
                Element labelElement2;
                Element categoryElement;
                Element locationElement = XmlUtility.getElementByTagNameNS((Node)oSImageElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Location");
                if (locationElement != null) {
                    String locationInstance = locationElement.getTextContent();
                    result.setLocation(locationInstance);
                }
                if ((categoryElement = XmlUtility.getElementByTagNameNS((Node)oSImageElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Category")) != null) {
                    String categoryInstance = categoryElement.getTextContent();
                    result.setCategory(categoryInstance);
                }
                if ((labelElement2 = XmlUtility.getElementByTagNameNS((Node)oSImageElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Label")) != null) {
                    String labelInstance = labelElement2.getTextContent();
                    result.setLabel(labelInstance);
                }
                if ((logicalSizeInGBElement = XmlUtility.getElementByTagNameNS((Node)oSImageElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"LogicalSizeInGB")) != null) {
                    double logicalSizeInGBInstance = DatatypeConverter.parseDouble((String)logicalSizeInGBElement.getTextContent());
                    result.setLogicalSizeInGB(logicalSizeInGBInstance);
                }
                if ((mediaLinkElement = XmlUtility.getElementByTagNameNS((Node)oSImageElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"MediaLink")) != null) {
                    URI mediaLinkInstance = new URI(mediaLinkElement.getTextContent());
                    result.setMediaLinkUri(mediaLinkInstance);
                }
                if ((nameElement = XmlUtility.getElementByTagNameNS((Node)oSImageElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name")) != null) {
                    String nameInstance = nameElement.getTextContent();
                    result.setName(nameInstance);
                }
                if ((osElement = XmlUtility.getElementByTagNameNS((Node)oSImageElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"OS")) != null) {
                    String osInstance = osElement.getTextContent();
                    result.setOperatingSystemType(osInstance);
                }
                if ((eulaElement2 = XmlUtility.getElementByTagNameNS((Node)oSImageElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Eula")) != null) {
                    String eulaInstance = eulaElement2.getTextContent();
                    result.setEula(eulaInstance);
                }
                if ((descriptionElement2 = XmlUtility.getElementByTagNameNS((Node)oSImageElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Description")) != null) {
                    String descriptionInstance = descriptionElement2.getTextContent();
                    result.setDescription(descriptionInstance);
                }
                if ((imageFamilyElement2 = XmlUtility.getElementByTagNameNS((Node)oSImageElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"ImageFamily")) != null) {
                    String imageFamilyInstance = imageFamilyElement2.getTextContent();
                    result.setImageFamily(imageFamilyInstance);
                }
                if ((publishedDateElement2 = XmlUtility.getElementByTagNameNS((Node)oSImageElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublishedDate")) != null && !(publishedDateElement2.getTextContent() == null || publishedDateElement2.getTextContent().isEmpty())) {
                    Calendar publishedDateInstance = DatatypeConverter.parseDateTime((String)publishedDateElement2.getTextContent());
                    result.setPublishedDate(publishedDateInstance);
                }
                if ((publisherNameElement = XmlUtility.getElementByTagNameNS((Node)oSImageElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublisherName")) != null) {
                    String publisherNameInstance = publisherNameElement.getTextContent();
                    result.setPublisherName(publisherNameInstance);
                }
                if ((isPremiumElement2 = XmlUtility.getElementByTagNameNS((Node)oSImageElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsPremium")) != null && !(isPremiumElement2.getTextContent() == null || isPremiumElement2.getTextContent().isEmpty())) {
                    boolean isPremiumInstance = DatatypeConverter.parseBoolean((String)isPremiumElement2.getTextContent().toLowerCase());
                    result.setIsPremium(isPremiumInstance);
                }
                if ((showInGuiElement = XmlUtility.getElementByTagNameNS((Node)oSImageElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"ShowInGui")) != null && !(showInGuiElement.getTextContent() == null || showInGuiElement.getTextContent().isEmpty())) {
                    boolean showInGuiInstance = DatatypeConverter.parseBoolean((String)showInGuiElement.getTextContent().toLowerCase());
                    result.setShowInGui(showInGuiInstance);
                }
                if ((privacyUriElement2 = XmlUtility.getElementByTagNameNS((Node)oSImageElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"PrivacyUri")) != null) {
                    URI privacyUriInstance = new URI(privacyUriElement2.getTextContent());
                    result.setPrivacyUri(privacyUriInstance);
                }
                if ((iconUriElement2 = XmlUtility.getElementByTagNameNS((Node)oSImageElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"IconUri")) != null) {
                    URI iconUriInstance = new URI(iconUriElement2.getTextContent());
                    result.setIconUri(iconUriInstance);
                }
                if ((recommendedVMSizeElement2 = XmlUtility.getElementByTagNameNS((Node)oSImageElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"RecommendedVMSize")) != null) {
                    String recommendedVMSizeInstance = recommendedVMSizeElement2.getTextContent();
                    result.setRecommendedVMSize(recommendedVMSizeInstance);
                }
                if ((smallIconUriElement2 = XmlUtility.getElementByTagNameNS((Node)oSImageElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"SmallIconUri")) != null) {
                    URI smallIconUriInstance = new URI(smallIconUriElement2.getTextContent());
                    result.setSmallIconUri(smallIconUriInstance);
                }
                if ((languageElement2 = XmlUtility.getElementByTagNameNS((Node)oSImageElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Language")) != null) {
                    String languageInstance = languageElement2.getTextContent();
                    result.setLanguage(languageInstance);
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            VirtualMachineOSImageUpdateResponse virtualMachineOSImageUpdateResponse = result;
            return virtualMachineOSImageUpdateResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

