/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.media.implementation;

import com.microsoft.windowsazure.core.RFC1123DateConverter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestFilter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceResponseFilter;
import com.microsoft.windowsazure.core.pipeline.jersey.ClientFilterAdapter;
import com.microsoft.windowsazure.core.pipeline.jersey.ClientFilterRequestAdapter;
import com.microsoft.windowsazure.core.pipeline.jersey.ClientFilterResponseAdapter;
import com.microsoft.windowsazure.core.pipeline.jersey.ServiceFilter;
import com.microsoft.windowsazure.services.blob.BlobContract;
import com.microsoft.windowsazure.services.blob.implementation.BlobOperationRestProxy;
import com.microsoft.windowsazure.services.media.implementation.SASTokenFilter;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.util.Arrays;

class MediaBlobRestProxy
extends BlobOperationRestProxy {
    private final SASTokenFilter tokenFilter;

    public MediaBlobRestProxy(Client channel, String accountName, String url, SASTokenFilter tokenFilter) {
        super(channel, accountName, url);
        this.tokenFilter = tokenFilter;
        channel.addFilter((ClientFilter)tokenFilter);
    }

    public MediaBlobRestProxy(Client channel, ClientFilter[] filters, String accountName, String url, SASTokenFilter tokenFilter, RFC1123DateConverter dateMapper) {
        super(channel, filters, accountName, url, dateMapper);
        this.tokenFilter = tokenFilter;
    }

    public BlobContract withFilter(ServiceFilter filter) {
        ClientFilter[] currentFilters = this.getFilters();
        ClientFilter[] newFilters = Arrays.copyOf(currentFilters, currentFilters.length + 1);
        newFilters[currentFilters.length] = new ClientFilterAdapter(filter);
        return new MediaBlobRestProxy(this.getChannel(), newFilters, this.getAccountName(), this.getUrl(), this.tokenFilter, this.getDateMapper());
    }

    @Override
    public BlobContract withRequestFilterFirst(ServiceRequestFilter serviceRequestFilter) {
        ClientFilter[] currentFilters = this.getFilters();
        ClientFilter[] newFilters = new ClientFilter[currentFilters.length + 1];
        System.arraycopy(currentFilters, 0, newFilters, 1, currentFilters.length);
        newFilters[0] = new ClientFilterRequestAdapter(serviceRequestFilter);
        return new MediaBlobRestProxy(this.getChannel(), newFilters, this.getAccountName(), this.getUrl(), this.tokenFilter, this.getDateMapper());
    }

    @Override
    public BlobContract withRequestFilterLast(ServiceRequestFilter serviceRequestFilter) {
        ClientFilter[] currentFilters = this.getFilters();
        ClientFilter[] newFilters = Arrays.copyOf(currentFilters, currentFilters.length + 1);
        newFilters[currentFilters.length] = new ClientFilterRequestAdapter(serviceRequestFilter);
        return new MediaBlobRestProxy(this.getChannel(), newFilters, this.getAccountName(), this.getUrl(), this.tokenFilter, this.getDateMapper());
    }

    @Override
    public BlobContract withResponseFilterFirst(ServiceResponseFilter serviceResponseFilter) {
        ClientFilter[] currentFilters = this.getFilters();
        ClientFilter[] newFilters = new ClientFilter[currentFilters.length + 1];
        System.arraycopy(currentFilters, 0, newFilters, 1, currentFilters.length);
        newFilters[0] = new ClientFilterResponseAdapter(serviceResponseFilter);
        return new MediaBlobRestProxy(this.getChannel(), newFilters, this.getAccountName(), this.getUrl(), this.tokenFilter, this.getDateMapper());
    }

    @Override
    public BlobContract withResponseFilterLast(ServiceResponseFilter serviceResponseFilter) {
        ClientFilter[] currentFilters = this.getFilters();
        ClientFilter[] newFilters = Arrays.copyOf(currentFilters, currentFilters.length + 1);
        newFilters[currentFilters.length] = new ClientFilterResponseAdapter(serviceResponseFilter);
        return new MediaBlobRestProxy(this.getChannel(), newFilters, this.getAccountName(), this.getUrl(), this.tokenFilter, this.getDateMapper());
    }
}

