/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.media.implementation;

import com.microsoft.windowsazure.core.UserAgentFilter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestFilter;
import com.microsoft.windowsazure.core.pipeline.jersey.ClientFilterRequestAdapter;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.exception.ServiceExceptionFactory;
import com.microsoft.windowsazure.services.media.implementation.OAuthContract;
import com.microsoft.windowsazure.services.media.implementation.OAuthTokenResponse;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.representation.Form;
import java.io.IOException;
import java.net.URI;
import javax.inject.Inject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;

public class OAuthRestProxy
implements OAuthContract {
    private Client channel;
    private final String grantType = "client_credentials";
    private static Log log = LogFactory.getLog(OAuthContract.class);

    @Inject
    public OAuthRestProxy(Client channel, UserAgentFilter userAgentFilter) {
        this.channel = channel;
        channel.addFilter((ClientFilter)new ClientFilterRequestAdapter((ServiceRequestFilter)userAgentFilter));
    }

    @Override
    public OAuthTokenResponse getAccessToken(URI oAuthUri, String clientId, String clientSecret, String scope) throws ServiceException {
        ClientResponse clientResponse;
        OAuthTokenResponse response = null;
        Form requestForm = new Form();
        requestForm.add("grant_type", "client_credentials");
        requestForm.add("client_id", clientId);
        requestForm.add("client_secret", clientSecret);
        requestForm.add("scope", scope);
        try {
            clientResponse = (ClientResponse)((WebResource.Builder)this.channel.resource(oAuthUri).accept(new String[]{"application/x-www-form-urlencoded"}).type("application/x-www-form-urlencoded")).post(ClientResponse.class, (Object)requestForm);
        }
        catch (UniformInterfaceException e) {
            log.warn((Object)"OAuth server returned error acquiring access_token", (Throwable)e);
            throw ServiceExceptionFactory.process((String)"OAuth", (ServiceException)new ServiceException("OAuth server returned error acquiring access_token", (Throwable)e));
        }
        String responseJson = (String)clientResponse.getEntity(String.class);
        try {
            ObjectMapper mapper = new ObjectMapper();
            TypeReference<OAuthTokenResponse> typeReference = new TypeReference<OAuthTokenResponse>(){};
            response = (OAuthTokenResponse)mapper.readValue(responseJson, (TypeReference)typeReference);
        }
        catch (JsonParseException e) {
            log.warn((Object)"The response from OAuth server cannot be parsed correctly", (Throwable)e);
            throw ServiceExceptionFactory.process((String)"OAuth", (ServiceException)new ServiceException("The response from OAuth server cannot be parsed correctly", (Throwable)e));
        }
        catch (JsonMappingException e) {
            log.warn((Object)"The response from OAuth server cannot be mapped to OAuthResponse object", (Throwable)e);
            throw ServiceExceptionFactory.process((String)"OAuth", (ServiceException)new ServiceException("The response from OAuth server cannot be mapped to OAuthResponse object", (Throwable)e));
        }
        catch (IOException e) {
            log.warn((Object)"Cannot map the response from OAuth server correctly.", (Throwable)e);
            throw ServiceExceptionFactory.process((String)"OAuth", (ServiceException)new ServiceException("Cannot map the response from OAuth server correctly.", (Throwable)e));
        }
        return response;
    }
}

