/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.media.implementation;

import com.microsoft.windowsazure.services.media.implementation.atom.ContentType;
import com.microsoft.windowsazure.services.media.implementation.atom.EntryType;
import com.microsoft.windowsazure.services.media.implementation.atom.FeedType;
import com.microsoft.windowsazure.services.media.implementation.content.AccessPolicyType;
import com.microsoft.windowsazure.services.media.implementation.content.AssetFileType;
import com.microsoft.windowsazure.services.media.implementation.content.AssetType;
import com.microsoft.windowsazure.services.media.implementation.content.ChannelType;
import com.microsoft.windowsazure.services.media.implementation.content.ContentKeyRestType;
import com.microsoft.windowsazure.services.media.implementation.content.JobNotificationSubscriptionType;
import com.microsoft.windowsazure.services.media.implementation.content.JobType;
import com.microsoft.windowsazure.services.media.implementation.content.LocatorRestType;
import com.microsoft.windowsazure.services.media.implementation.content.NotificationEndPointType;
import com.microsoft.windowsazure.services.media.implementation.content.OperationType;
import com.microsoft.windowsazure.services.media.implementation.content.OriginType;
import com.microsoft.windowsazure.services.media.implementation.content.ProgramType;
import com.microsoft.windowsazure.services.media.implementation.content.TaskType;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ODataAtomMarshaller {
    private final Marshaller marshaller;
    private final DocumentBuilder documentBuilder;

    public ODataAtomMarshaller() throws JAXBException, ParserConfigurationException {
        JAXBContext context = JAXBContext.newInstance((Class[])ODataAtomMarshaller.getMarshalledClasses(), null);
        this.marshaller = context.createMarshaller();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        this.documentBuilder = dbf.newDocumentBuilder();
    }

    public Document marshalEntry(Object content) throws JAXBException {
        JAXBElement<EntryType> entryElement = this.createEntry(content);
        Document doc = this.documentBuilder.newDocument();
        doc.setXmlStandalone(true);
        this.marshaller.marshal(entryElement, (Node)doc);
        return doc;
    }

    public void marshalEntry(Object content, OutputStream stream) throws JAXBException {
        this.marshaller.marshal(this.createEntry(content), stream);
    }

    public void marshalEntryType(EntryType entryType, OutputStream stream) throws JAXBException {
        this.marshaller.marshal((Object)new JAXBElement(new QName("http://www.w3.org/2005/Atom", "entry"), EntryType.class, (Object)entryType), stream);
    }

    private JAXBElement<EntryType> createEntry(Object content) {
        ContentType atomContent = new ContentType();
        EntryType atomEntry = new EntryType();
        atomContent.setType("application/xml");
        atomContent.getContent().add(new JAXBElement(new QName("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "properties"), content.getClass(), content));
        atomEntry.getEntryChildren().add(new JAXBElement(new QName("http://www.w3.org/2005/Atom", "content"), ContentType.class, (Object)atomContent));
        JAXBElement entryElement = new JAXBElement(new QName("http://www.w3.org/2005/Atom", "entry"), EntryType.class, (Object)atomEntry);
        return entryElement;
    }

    private static Class<?>[] getMarshalledClasses() {
        ArrayList<Class<TaskType>> classes = new ArrayList<Class<TaskType>>();
        classes.add(AccessPolicyType.class);
        classes.add(AssetType.class);
        classes.add(AssetFileType.class);
        classes.add(ChannelType.class);
        classes.add(ContentKeyRestType.class);
        classes.add(EntryType.class);
        classes.add(FeedType.class);
        classes.add(JobNotificationSubscriptionType.class);
        classes.add(JobType.class);
        classes.add(LocatorRestType.class);
        classes.add(NotificationEndPointType.class);
        classes.add(OperationType.class);
        classes.add(OriginType.class);
        classes.add(ProgramType.class);
        classes.add(TaskType.class);
        return classes.toArray(new Class[0]);
    }
}

