/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.media.models;

import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.services.media.entityoperations.DefaultActionOperation;
import com.microsoft.windowsazure.services.media.entityoperations.DefaultDeleteOperation;
import com.microsoft.windowsazure.services.media.entityoperations.DefaultGetOperation;
import com.microsoft.windowsazure.services.media.entityoperations.DefaultListOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityActionOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityBatchOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityCreateOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityDeleteOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityGetOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityOperationSingleResultBase;
import com.microsoft.windowsazure.services.media.implementation.MediaBatchOperations;
import com.microsoft.windowsazure.services.media.implementation.content.JobNotificationSubscriptionType;
import com.microsoft.windowsazure.services.media.implementation.content.JobType;
import com.microsoft.windowsazure.services.media.models.JobInfo;
import com.microsoft.windowsazure.services.media.models.JobNotificationSubscription;
import com.microsoft.windowsazure.services.media.models.ListResult;
import com.microsoft.windowsazure.services.media.models.Task;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMultipart;
import javax.ws.rs.core.MediaType;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;

public final class Job {
    private static final String ENTITY_SET = "Jobs";

    private Job() {
    }

    public static Creator create() {
        return new Creator();
    }

    public static EntityGetOperation<JobInfo> get(String jobId) {
        return new DefaultGetOperation<JobInfo>(ENTITY_SET, jobId, JobInfo.class);
    }

    public static DefaultListOperation<JobInfo> list() {
        return new DefaultListOperation<JobInfo>(ENTITY_SET, new GenericType<ListResult<JobInfo>>(){});
    }

    public static EntityDeleteOperation delete(String jobId) {
        return new DefaultDeleteOperation(ENTITY_SET, jobId);
    }

    public static EntityActionOperation cancel(String jobId) {
        return new DefaultActionOperation("CancelJob").addQueryParameter("jobId", String.format("'%s'", jobId));
    }

    public static class CreateBatchOperation
    extends EntityBatchOperation {
        private final URI serviceUri;
        private JobInfo jobInfo;

        public CreateBatchOperation(URI serviceUri) {
            this.serviceUri = serviceUri;
            this.setVerb("POST");
        }

        public static CreateBatchOperation create(URI serviceUri, Creator creator) {
            CreateBatchOperation createBatchOperation = new CreateBatchOperation(serviceUri);
            JobType jobType = new JobType();
            jobType.setName(creator.getName());
            jobType.setPriority(creator.getPriority());
            for (JobNotificationSubscription jobNotificationSubscription : creator.getJobNotificationSubscription()) {
                JobNotificationSubscriptionType jobNotificationSubscriptionType = new JobNotificationSubscriptionType();
                jobNotificationSubscriptionType.setNotificationEndPointId(jobNotificationSubscription.getNotificationEndPointId());
                jobNotificationSubscriptionType.setTargetJobState(jobNotificationSubscription.getTargetJobState().getCode());
                jobType.addJobNotificationSubscriptionType(jobNotificationSubscriptionType);
            }
            for (String inputMediaAsset : creator.getInputMediaAssets()) {
                createBatchOperation.addLink("InputMediaAssets", String.format("%s/Assets('%s')", createBatchOperation.getServiceUri().toString(), inputMediaAsset.toString()), "application/atom+xml;type=feed", "http://schemas.microsoft.com/ado/2007/08/dataservices/related/InputMediaAssets");
            }
            createBatchOperation.addContentObject(jobType);
            return createBatchOperation;
        }

        public URI getServiceUri() {
            return this.serviceUri;
        }

        public CreateBatchOperation setJobInfo(JobInfo jobInfo) {
            this.jobInfo = jobInfo;
            return this;
        }

        public JobInfo getJobInfo() {
            return this.jobInfo;
        }
    }

    public static class Creator
    extends EntityOperationSingleResultBase<JobInfo>
    implements EntityCreateOperation<JobInfo> {
        private String name;
        private Integer priority;
        private final List<String> inputMediaAssets;
        private MediaType contentType;
        private final List<Task.CreateBatchOperation> taskCreateBatchOperations;
        private Boolean fresh = true;
        private MimeMultipart mimeMultipart;
        private MediaBatchOperations mediaBatchOperations;
        private final List<JobNotificationSubscription> jobNotificationSubscriptions = new ArrayList<JobNotificationSubscription>();

        private void buildMimeMultipart(URI serviceUri) {
            this.mediaBatchOperations = null;
            CreateBatchOperation createJobBatchOperation = CreateBatchOperation.create(serviceUri, this);
            try {
                this.mediaBatchOperations = new MediaBatchOperations(serviceUri);
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException(e);
            }
            this.mediaBatchOperations.addOperation(createJobBatchOperation);
            for (Task.CreateBatchOperation taskCreateBatchOperation : this.taskCreateBatchOperations) {
                this.mediaBatchOperations.addOperation(taskCreateBatchOperation);
            }
            try {
                this.mimeMultipart = this.mediaBatchOperations.getMimeMultipart();
            }
            catch (MessagingException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
            this.contentType = this.mediaBatchOperations.getContentType();
            this.fresh = false;
        }

        public Creator() {
            super(Job.ENTITY_SET, JobInfo.class);
            this.inputMediaAssets = new ArrayList<String>();
            this.taskCreateBatchOperations = new ArrayList<Task.CreateBatchOperation>();
        }

        @Override
        public Object getRequestContents() throws ServiceException {
            if (this.fresh.booleanValue()) {
                this.buildMimeMultipart(this.getProxyData().getServiceUri());
            }
            return this.mimeMultipart;
        }

        @Override
        public Class getResponseClass() {
            return ClientResponse.class;
        }

        @Override
        public Object processResponse(Object clientResponse) throws ServiceException {
            try {
                this.mediaBatchOperations.parseBatchResult((ClientResponse)clientResponse);
            }
            catch (IOException e) {
                throw new ServiceException((Throwable)e);
            }
            JobInfo jobInfo = null;
            for (EntityBatchOperation entityBatchOperation : this.mediaBatchOperations.getOperations()) {
                if (!(entityBatchOperation instanceof CreateBatchOperation)) continue;
                jobInfo = ((CreateBatchOperation)entityBatchOperation).getJobInfo();
                break;
            }
            return jobInfo;
        }

        public Creator addTaskCreator(Task.CreateBatchOperation taskCreateBatchOperation) {
            this.taskCreateBatchOperations.add(taskCreateBatchOperation);
            this.fresh = true;
            return this;
        }

        public Creator setName(String name) {
            this.name = name;
            this.fresh = true;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Creator setPriority(Integer priority) {
            this.priority = priority;
            this.fresh = true;
            return this;
        }

        public Integer getPriority() {
            return this.priority;
        }

        public List<String> getInputMediaAssets() {
            return this.inputMediaAssets;
        }

        public List<Task.CreateBatchOperation> getTaskCreators() {
            return this.taskCreateBatchOperations;
        }

        public Creator addInputMediaAsset(String assetId) {
            this.inputMediaAssets.add(assetId);
            this.fresh = true;
            return this;
        }

        @Override
        public MediaType getContentType() {
            if (this.fresh.booleanValue()) {
                this.buildMimeMultipart(this.getProxyData().getServiceUri());
            }
            return this.contentType;
        }

        @Override
        public String getUri() {
            return "$batch";
        }

        public Creator addJobNotificationSubscription(JobNotificationSubscription jobNotificationSubscription) {
            this.jobNotificationSubscriptions.add(jobNotificationSubscription);
            this.fresh = true;
            return this;
        }

        public List<JobNotificationSubscription> getJobNotificationSubscription() {
            return this.jobNotificationSubscriptions;
        }
    }
}

