/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.azure;

import com.clustercontrol.cloud.CloudManagerBaseService;
import com.clustercontrol.cloud.CloudPlugin;
import com.clustercontrol.cloud.ICloudOption;
import com.clustercontrol.cloud.IResourceManagement;
import com.clustercontrol.cloud.IUserManagement;
import com.clustercontrol.cloud.InternalManagerError;
import com.clustercontrol.cloud.PluginFault;
import com.clustercontrol.cloud.azure.AzureOptionPropertyConstants;
import com.clustercontrol.cloud.azure.factory.AzureAsyncThread;
import com.clustercontrol.cloud.azure.factory.AzureOption;
import com.clustercontrol.cloud.azure.factory.AzureResourceManagement;
import com.clustercontrol.cloud.azure.factory.AzureUserManagement;
import com.clustercontrol.cloud.azure.util.AzureUtil;
import com.clustercontrol.cloud.registry.AbstractObjectChangedListener;
import com.clustercontrol.cloud.registry.IObjectChangedListener;
import com.clustercontrol.cloud.registry.IObjectChangedService;
import com.clustercontrol.cloud.registry.ObjectRegistryService;
import com.clustercontrol.cloud.util.proxy.IProxyStore;
import com.clustercontrol.repository.bean.NodeInfo;
import com.clustercontrol.repository.bean.NodeVariableInfo;
import com.clustercontrol.ws.azure.AzureOptionEndpointImpl;
import com.clustercontrol.ws.cloud.IWebServiceBase;
import com.microsoft.windowsazure.Configuration;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class AzureManagerBaseService
extends CloudPlugin {
    public static final String id = "com.clustercontrol.cloud.azure.AzureManagerBaseService";
    private static AzureManagerBaseService singleton;
    AzureAsyncThread azureAsyncThread = null;

    public AzureManagerBaseService() {
        singleton = this;
    }

    public Set<String> getDependency() {
        HashSet<String> set = new HashSet<String>();
        set.add(CloudManagerBaseService.class.getName());
        return set;
    }

    public void create() {
        Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
        logger.info((Object)("creating " + ((Object)((Object)this)).getClass().getSimpleName() + "..."));
        for (AzureOptionPropertyConstants value : AzureOptionPropertyConstants.values()) {
            logger.info((Object)(value.id + " = " + value.value() + " (" + value.defaultValue() + ")"));
        }
        logger.info((Object)("successful in creating " + ((Object)((Object)this)).getClass().getSimpleName() + "..."));
    }

    public void activate() {
        Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
        logger.info((Object)("starting " + ((Object)((Object)this)).getClass().getSimpleName() + "..."));
        logger.info((Object)("successful in starting " + ((Object)((Object)this)).getClass().getSimpleName() + "..."));
    }

    public void deactivate() {
        Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
        logger.info((Object)("stopping " + ((Object)((Object)this)).getClass().getSimpleName() + "..."));
        logger.info((Object)("successful in stopping " + ((Object)((Object)this)).getClass().getSimpleName() + "..."));
    }

    public void destroy() {
        Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
        if (this.azureAsyncThread != null) {
            this.azureAsyncThread.terminate();
        }
        logger.info((Object)("destroying " + ((Object)((Object)this)).getClass().getSimpleName() + "..."));
        logger.info((Object)("successful in destroying " + ((Object)((Object)this)).getClass().getSimpleName() + "..."));
    }

    public static AzureManagerBaseService getSingleton() {
        return singleton;
    }

    public String getPluginId() {
        return id;
    }

    public void initialize() {
        Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
        logger.info((Object)("initializing " + ((Object)((Object)this)).getClass().getSimpleName() + "..."));
        AzureUtil.setBuilder(Configuration.getInstance());
        if (this.azureAsyncThread == null) {
            this.azureAsyncThread = new AzureAsyncThread();
        }
        ObjectRegistryService.registry().put(ICloudOption.class, (Object)"Azure", AzureOption.class);
        ObjectRegistryService.registry().put(IUserManagement.class, (Object)"Azure", AzureUserManagement.class);
        ObjectRegistryService.registry().put(IResourceManagement.class, (Object)"Azure", AzureResourceManagement.class);
        CloudManagerBaseService.getSingleton().publish("/HinemosWS/AzureOptionEndpoint", (IWebServiceBase)new AzureOptionEndpointImpl());
        String proxyHost = AzureOptionPropertyConstants.azure_client_config_proxyHost.value();
        int proxyPort = Integer.valueOf(AzureOptionPropertyConstants.azure_client_config_proxyPort.value());
        if (proxyHost != null && !proxyHost.isEmpty() && proxyPort > 0) {
            String proxyUsername = AzureOptionPropertyConstants.azure_client_config_proxyUsername.value();
            String proxyPassword = AzureOptionPropertyConstants.azure_client_config_proxyPassword.value();
            IProxyStore proxyStore = (IProxyStore)ObjectRegistryService.registry().get(IProxyStore.class);
            ArrayList<String> destinations = new ArrayList<String>();
            try {
                destinations.add(new URI(AzureOptionPropertyConstants.azure_base_uri.value()).getHost());
            }
            catch (URISyntaxException e) {
                throw new InternalManagerError((Throwable)e);
            }
            proxyStore.add(proxyHost, proxyPort, proxyUsername, proxyPassword, destinations.toArray(new String[destinations.size()]));
        }
        IObjectChangedService service = (IObjectChangedService)ObjectRegistryService.registry().get(IObjectChangedService.class);
        service.addObjectChangedListener("Node_Instance_Modify", NodeInfo.class, (IObjectChangedListener)new AbstractObjectChangedListener<NodeInfo>(){

            public void preModified(String type, NodeInfo object) throws PluginFault {
                if (!"Azure".equals(object.getCloudService())) {
                    return;
                }
                NodeVariableInfo instaceId = null;
                ArrayList variables = object.getNodeVariableInfo();
                for (NodeVariableInfo variable : variables) {
                    if (!variable.getNodeVariableName().equals("CLOUD_AZURE_InstanceId")) continue;
                    variable.setNodeVariableValue(object.getCloudResourceId());
                    instaceId = variable;
                    break;
                }
                if (instaceId == null) {
                    ArrayList<NodeVariableInfo> newVariables = new ArrayList<NodeVariableInfo>(variables);
                    newVariables.add(new NodeVariableInfo("CLOUD_AZURE_InstanceId", object.getCloudResourceId()));
                    object.setNodeVariableInfo(new ArrayList(newVariables));
                }
            }
        });
        service.addObjectChangedListener("Node_Instance_Add", NodeInfo.class, (IObjectChangedListener)new AbstractObjectChangedListener<NodeInfo>(){

            public void preAdded(String type, NodeInfo object) throws PluginFault {
                if (!"Azure".equals(object.getCloudService())) {
                    return;
                }
                object.getNodeVariableInfo().add(new NodeVariableInfo("CLOUD_AZURE_InstanceId", object.getCloudResourceId()));
            }
        });
        service.addObjectChangedListener("Node_Instance_Clear", NodeInfo.class, (IObjectChangedListener)new AbstractObjectChangedListener<NodeInfo>(){

            public void preModified(String type, NodeInfo object) throws PluginFault {
                if (!"Azure".equals(object.getCloudService())) {
                    return;
                }
                for (NodeVariableInfo var : object.getNodeVariableInfo()) {
                    if (!"CLOUD_AZURE_InstanceId".equals(var.getNodeVariableName())) continue;
                    object.getNodeVariableInfo().remove(var);
                    break;
                }
            }
        });
        if (this.azureAsyncThread != null) {
            this.azureAsyncThread.start();
        }
        logger.info((Object)("successful in initializing " + ((Object)((Object)this)).getClass().getSimpleName() + "..."));
    }
}

