/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.azure.bean;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.azure.AzureOptionPropertyConstants;
import com.clustercontrol.cloud.azure.factory.AzureAsyncExecution;
import com.clustercontrol.cloud.azure.factory.AzureAsyncOperations;
import com.clustercontrol.cloud.azure.factory.AzureStopInstance;
import com.clustercontrol.cloud.azure.util.AzureUtil;
import com.microsoft.windowsazure.Configuration;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.compute.ComputeManagementClient;
import com.microsoft.windowsazure.management.compute.ComputeManagementService;
import com.microsoft.windowsazure.management.compute.DeploymentOperations;
import com.microsoft.windowsazure.management.compute.HostedServiceOperations;
import com.microsoft.windowsazure.management.compute.models.DeploymentGetResponse;
import com.microsoft.windowsazure.management.compute.models.DeploymentSlot;
import com.microsoft.windowsazure.management.compute.models.HostedServiceListResponse;
import com.microsoft.windowsazure.management.compute.models.RoleInstance;
import org.apache.log4j.Logger;

public class AzurePendingStopInstance
extends AzureAsyncOperations {
    private Logger logger = Logger.getLogger(this.getClass());
    private Configuration config = null;
    private String instanceId = null;
    private String subscriptionId = null;

    public AzurePendingStopInstance(Configuration config, String instanceId, String subscriptionId) {
        this.config = config;
        this.instanceId = instanceId;
        this.subscriptionId = subscriptionId;
    }

    /*
     * Loose catch block
     */
    @Override
    public void execute() throws CloudManagerFault {
        try {
            this.logger.info((Object)("Start AzurePendingStopInstance:" + this.instanceId));
            ComputeManagementClient computeManagementClient = ComputeManagementService.create((Configuration)this.config);
            DeploymentOperations deploymentOperations = computeManagementClient.getDeploymentsOperations();
            HostedServiceOperations hostedServicesOperations = computeManagementClient.getHostedServicesOperations();
            HostedServiceListResponse hostedServiceListResponse = hostedServicesOperations.list();
            for (HostedServiceListResponse.HostedService hostService : hostedServiceListResponse.getHostedServices()) {
                for (DeploymentSlot slot : AzureUtil.getDeploymentSlots()) {
                    DeploymentGetResponse deploymentGetResponse = null;
                    try {
                        deploymentGetResponse = deploymentOperations.getBySlot(hostService.getServiceName(), slot);
                    }
                    catch (ServiceException e) {
                        if (e.getErrorCode().equals("ResourceNotFound")) continue;
                        throw new CloudManagerFault(e.getMessage(), (Throwable)e);
                    }
                    for (RoleInstance roleInstance : deploymentGetResponse.getRoleInstances()) {
                        if (roleInstance.getRoleName().equals(this.instanceId)) {
                            AzureStopInstance azureStopInstance = new AzureStopInstance(this.config, hostService.getServiceName(), deploymentGetResponse.getName());
                            azureStopInstance.setKey("stopInstance@" + this.subscriptionId + "@" + hostService.getServiceName() + "@" + deploymentGetResponse.getName());
                            azureStopInstance.addParams(roleInstance.getInstanceName());
                            if (AzureOptionPropertyConstants.azure_api_mode.value().equalsIgnoreCase("async")) {
                                AzureAsyncExecution.getSingleton().merge(azureStopInstance);
                            } else {
                                azureStopInstance.execute();
                            }
                            return;
                        }
                    }
                }
            }
            {
                this.logger.error((Object)("Resouce Not Found!" + this.instanceId));
                throw new CloudManagerFault("ResourceNotFound");
            }
            catch (Exception e) {
                this.putLog("AzurePendingStopInstance", "AzurePendingStopInstance was failed", e.getMessage());
                throw new CloudManagerFault(e.getMessage(), (Throwable)e);
            }
        }
        finally {
            this.logger.info((Object)("Finish AzurePendingStopInstance:" + this.instanceId));
        }
    }
}

