/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.azure.factory;

import com.clustercontrol.cloud.azure.factory.AzureAsyncOperations;
import com.microsoft.windowsazure.core.OperationStatus;
import com.microsoft.windowsazure.core.OperationStatusResponse;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.compute.ComputeManagementClient;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class AzureAsyncOperationStatus
extends AzureAsyncOperations {
    private Logger logger = Logger.getLogger(this.getClass());
    private ComputeManagementClient computeManagementClient = null;
    private String requestId = null;
    private String message = null;

    public AzureAsyncOperationStatus(ComputeManagementClient computeManagementClient, String requestId, String message) {
        this.computeManagementClient = computeManagementClient;
        this.requestId = requestId;
        this.message = message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        this.logger.debug((Object)("AzureAsyncOperationStatus:execute() start " + this.message));
        OperationStatusResponse operationStatusResponse = null;
        try {
            while (true) {
                this.logger.debug((Object)("computeManagementClient.getOperationStatus(" + this.requestId + ") " + this.message));
                operationStatusResponse = this.computeManagementClient.getOperationStatus(this.requestId);
                if (operationStatusResponse.getStatus() != OperationStatus.InProgress) break;
                this.logger.debug((Object)("AzureAsyncOperationStatus:execute() operationStatusResponse:InProgress " + this.message));
                Thread.sleep(1000L);
            }
            if (operationStatusResponse.getStatus() == OperationStatus.Succeeded) {
                this.logger.info((Object)("AzureAsyncOperationStatus:execute() operationStatusResponse:Succeeded " + this.message));
            } else if (operationStatusResponse.getStatus() == OperationStatus.Failed) {
                this.logger.error((Object)("AzureAsyncOperationStatus:execute() operationStatusResponse:Failed " + this.message));
            } else {
                this.logger.error((Object)("AzureAsyncOperationStatus:execute() operationStatusResponse:?????(unknown) " + this.message));
            }
        }
        catch (InterruptedException e) {
            this.logger.error((Object)("AzureAsyncOperationStatus:execute() InterruptedException:" + e.getMessage() + " " + this.message));
        }
        catch (IOException e) {
            this.logger.error((Object)("AzureAsyncOperationStatus:execute() IOException:" + e.getMessage() + " " + this.message));
        }
        catch (ServiceException e) {
            this.logger.error((Object)("AzureAsyncOperationStatus:execute() ServiceException:" + e.getMessage() + " " + this.message));
        }
        catch (ParserConfigurationException e) {
            this.logger.error((Object)("AzureAsyncOperationStatus:execute() ParserConfigurationException:" + e.getMessage() + " " + this.message));
        }
        catch (SAXException e) {
            this.logger.error((Object)("AzureAsyncOperationStatus:execute() SAXException:" + e.getMessage() + " " + this.message));
        }
        finally {
            this.logger.debug((Object)("AzureAsyncOperationStatus:execute() end " + this.message));
        }
    }
}

