/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.azure.factory;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.azure.bean.AzureCreateStorageRequest;
import com.clustercontrol.cloud.azure.factory.AzureAsyncOperations;
import com.clustercontrol.cloud.azure.util.AzureUtil;
import com.microsoft.windowsazure.Configuration;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.OperationStatus;
import com.microsoft.windowsazure.core.OperationStatusResponse;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceResponseFilter;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.compute.ComputeManagementClient;
import com.microsoft.windowsazure.management.compute.ComputeManagementService;
import com.microsoft.windowsazure.management.compute.DeploymentOperations;
import com.microsoft.windowsazure.management.compute.HostedServiceOperations;
import com.microsoft.windowsazure.management.compute.VirtualMachineDiskOperations;
import com.microsoft.windowsazure.management.compute.models.DataVirtualHardDisk;
import com.microsoft.windowsazure.management.compute.models.DeploymentGetResponse;
import com.microsoft.windowsazure.management.compute.models.DeploymentSlot;
import com.microsoft.windowsazure.management.compute.models.HostedServiceListResponse;
import com.microsoft.windowsazure.management.compute.models.Role;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineDataDiskCreateParameters;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineDiskListResponse;
import com.microsoft.windowsazure.management.storage.StorageAccountOperations;
import com.microsoft.windowsazure.management.storage.StorageManagementClient;
import com.microsoft.windowsazure.management.storage.StorageManagementService;
import com.microsoft.windowsazure.management.storage.models.StorageAccount;
import com.microsoft.windowsazure.management.storage.models.StorageAccountListResponse;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class AzureAttachStorage
extends AzureAsyncOperations {
    private Logger logger = Logger.getLogger(this.getClass());
    private Configuration config = null;
    private String storageId = null;
    private AzureCreateStorageRequest azureCreateStorageRequest = null;

    public AzureAttachStorage(Configuration config, String storageId, AzureCreateStorageRequest azureCreateStorageRequest) {
        this.config = config;
        this.storageId = storageId;
        this.azureCreateStorageRequest = azureCreateStorageRequest;
    }

    @Override
    public void execute() throws CloudManagerFault {
        block21: {
            String deploymentName = "";
            String cloudServiceName = "";
            VirtualMachineDiskListResponse.VirtualMachineDisk addDisk = new VirtualMachineDiskListResponse.VirtualMachineDisk();
            AzureUtil.AzureServiceResponseFilter reponseFilter = new AzureUtil.AzureServiceResponseFilter();
            try {
                OperationStatusResponse operationStatusResponse;
                this.logger.info((Object)("AzureAttachStorage start: " + this.storageId));
                ComputeManagementClient computeManagementClient = ComputeManagementService.create((Configuration)this.config);
                StorageManagementClient storageManagementClient = StorageManagementService.create((Configuration)this.config);
                DeploymentOperations deploymentOperations = computeManagementClient.getDeploymentsOperations();
                HostedServiceOperations hostedServicesOperations = computeManagementClient.getHostedServicesOperations();
                ArrayList<DataVirtualHardDisk> dataVirtualHardDisks = new ArrayList<DataVirtualHardDisk>();
                HostedServiceListResponse hostedServiceListResponse = hostedServicesOperations.list();
                for (HostedServiceListResponse.HostedService hostService : hostedServiceListResponse.getHostedServices()) {
                    if (!this.azureCreateStorageRequest.getCloudServiceName().equals(hostService.getServiceName())) continue;
                    for (DeploymentSlot slot : AzureUtil.getDeploymentSlots()) {
                        DeploymentGetResponse deploymentGetResponse = null;
                        try {
                            deploymentGetResponse = deploymentOperations.getBySlot(hostService.getServiceName(), slot);
                        }
                        catch (ServiceException e) {
                            if (e.getErrorCode().equals("ResourceNotFound")) continue;
                            this.logger.error((Object)("AzureAttachStorage: " + this.storageId + " (" + e.getErrorCode() + ") " + e.getMessage()));
                            throw new CloudManagerFault(e.getMessage(), (Throwable)e);
                        }
                        deploymentGetResponse.getRoles();
                        for (Role role : deploymentGetResponse.getRoles()) {
                            if (!role.getRoleName().equals(this.azureCreateStorageRequest.getInstanceName())) continue;
                            deploymentName = deploymentGetResponse.getName();
                            cloudServiceName = hostService.getServiceName();
                            for (DataVirtualHardDisk dvhd : role.getDataVirtualHardDisks()) {
                                dataVirtualHardDisks.add(dvhd);
                            }
                        }
                    }
                }
                StorageAccountOperations storageAccountOperations = storageManagementClient.getStorageAccountsOperations();
                StorageAccountListResponse storageServiceListResponse = storageAccountOperations.list();
                VirtualMachineDiskListResponse vmds = computeManagementClient.getVirtualMachineDisksOperations().listDisks();
                for (VirtualMachineDiskListResponse.VirtualMachineDisk vmd : vmds.getDisks()) {
                    for (StorageAccount sa : storageServiceListResponse.getStorageAccounts()) {
                        String match = sa.getUri().toString().substring(sa.getUri().toString().lastIndexOf("/") + 1);
                        if (vmd.getMediaLinkUri().toString().indexOf("http://" + match + ".") != 0 && vmd.getMediaLinkUri().toString().indexOf("https://" + match + ".") != 0 || !vmd.getName().equals(this.storageId)) continue;
                        addDisk = vmd;
                    }
                }
                VirtualMachineDataDiskCreateParameters parameters = new VirtualMachineDataDiskCreateParameters();
                parameters.setHostCaching(this.azureCreateStorageRequest.getVirtualHardDiskHostCaching());
                parameters.setName(addDisk.getName());
                parameters.setMediaLinkUri(addDisk.getMediaLinkUri());
                parameters.setLogicalUnitNumber(this.azureCreateStorageRequest.getLUN());
                VirtualMachineDiskOperations virtualMachineDiskOperations = ((ComputeManagementClient)computeManagementClient.withResponseFilterLast((ServiceResponseFilter)reponseFilter)).getVirtualMachineDisksOperations();
                OperationResponse operationResponse = virtualMachineDiskOperations.createDataDisk(cloudServiceName, deploymentName, this.azureCreateStorageRequest.getInstanceName(), parameters);
                this.logger.info((Object)("RequestId:" + operationResponse.getRequestId()));
                while ((operationStatusResponse = computeManagementClient.getOperationStatus(operationResponse.getRequestId())).getStatus().equals((Object)OperationStatus.InProgress)) {
                }
                this.logger.info((Object)("attaching " + this.getClass().getSimpleName() + "..."));
                if (operationStatusResponse.getStatus().equals((Object)OperationStatus.Succeeded)) {
                    this.logger.info((Object)("successful in attaching " + this.getClass().getSimpleName() + "..."));
                    break block21;
                }
                this.logger.error((Object)("failed in attaching " + operationStatusResponse.getError()));
                this.putLog("AttacheStorage", "AttacheStorage was failed", operationStatusResponse.getError().getMessage());
                throw new CloudManagerFault(operationStatusResponse.getError().getMessage(), (Throwable)new Exception(operationStatusResponse.getError().getCode()));
            }
            catch (ServiceException e) {
                if (reponseFilter != null && reponseFilter.getCalled() > 0) {
                    switch (reponseFilter.getStatus()) {
                        case 200: 
                        case 201: 
                        case 202: {
                            reponseFilter.close();
                            return;
                        }
                    }
                }
                this.putLog("AttacheStorage", "AttacheStorage was failed", e.getMessage());
                throw new CloudManagerFault(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                this.putLog("AttacheStorage", "AttacheStorage was failed", e.getMessage());
                throw new CloudManagerFault(e.getMessage(), (Throwable)e);
            }
            finally {
                reponseFilter.close();
                this.logger.info((Object)("AzureAttachStorage end: " + this.storageId));
            }
        }
    }
}

