/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.azure.factory;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.azure.factory.AzureAsyncOperations;
import com.clustercontrol.cloud.azure.util.AzureUtil;
import com.microsoft.windowsazure.Configuration;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.OperationStatus;
import com.microsoft.windowsazure.core.OperationStatusResponse;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.compute.ComputeManagementClient;
import com.microsoft.windowsazure.management.compute.ComputeManagementService;
import com.microsoft.windowsazure.management.compute.DeploymentOperations;
import com.microsoft.windowsazure.management.compute.HostedServiceOperations;
import com.microsoft.windowsazure.management.compute.VirtualMachineOperations;
import com.microsoft.windowsazure.management.compute.models.DeploymentGetResponse;
import com.microsoft.windowsazure.management.compute.models.DeploymentSlot;
import com.microsoft.windowsazure.management.compute.models.HostedServiceListResponse;
import com.microsoft.windowsazure.management.compute.models.Role;
import org.apache.log4j.Logger;

public class AzureDeleteInstance
extends AzureAsyncOperations {
    private Logger logger = Logger.getLogger(this.getClass());
    private String instanceId = null;
    private Configuration config = null;

    public AzureDeleteInstance(Configuration config, String instanceId) {
        this.config = config;
        this.instanceId = instanceId;
    }

    /*
     * Loose catch block
     */
    @Override
    public void execute() throws CloudManagerFault {
        OperationResponse operationResponse = new OperationResponse();
        try {
            this.logger.info((Object)("AzureDeleteInstance start: " + this.instanceId));
            ComputeManagementClient computeManagementClient = ComputeManagementService.create((Configuration)this.config);
            VirtualMachineOperations virtualMachineOperations = computeManagementClient.getVirtualMachinesOperations();
            DeploymentOperations deploymentOperations = computeManagementClient.getDeploymentsOperations();
            HostedServiceOperations hostedServicesOperations = computeManagementClient.getHostedServicesOperations();
            HostedServiceListResponse hostedServiceListResponse = hostedServicesOperations.list();
            for (HostedServiceListResponse.HostedService hostService : hostedServiceListResponse.getHostedServices()) {
                for (DeploymentSlot slot : AzureUtil.getDeploymentSlots()) {
                    DeploymentGetResponse deploymentGetResponse = null;
                    try {
                        deploymentGetResponse = deploymentOperations.getBySlot(hostService.getServiceName(), slot);
                    }
                    catch (ServiceException e) {
                        if (e.getErrorCode().equals("ResourceNotFound")) continue;
                        this.logger.error((Object)("AzureDeleteInstance: " + this.instanceId + " (" + e.getErrorCode() + ") " + e.getMessage()));
                        throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
                    }
                    for (Role role : deploymentGetResponse.getRoles()) {
                        if (role.getRoleName().equals(this.instanceId)) {
                            OperationStatusResponse operationStatusResponse;
                            this.logger.info((Object)("VirtualMachineOperations.beginDeleting(" + hostService.getServiceName() + "," + deploymentGetResponse.getName() + "," + this.instanceId + ")"));
                            operationResponse = virtualMachineOperations.beginDeleting(hostService.getServiceName(), deploymentGetResponse.getName(), this.instanceId, true);
                            this.logger.info((Object)("RequestId:" + operationResponse.getRequestId()));
                            while ((operationStatusResponse = computeManagementClient.getOperationStatus(operationResponse.getRequestId())).getStatus().equals((Object)OperationStatus.InProgress)) {
                            }
                            this.logger.info((Object)("beginDeleting " + this.getClass().getSimpleName() + "..."));
                            if (operationStatusResponse.getStatus().equals((Object)OperationStatus.Succeeded)) {
                                this.logger.info((Object)("successful in beginDeleting " + this.getClass().getSimpleName() + "..."));
                            } else {
                                this.logger.error((Object)("failed in beginDeleting " + operationStatusResponse.getError()));
                                this.putLog("DeleteInstance", "DeleteInstance was failed", operationStatusResponse.getError().getMessage());
                                throw new CloudManagerFault(operationStatusResponse.getError().getMessage(), (Throwable)new Exception(operationStatusResponse.getError().getCode()));
                            }
                            return;
                        }
                    }
                }
            }
            {
                throw new CloudManagerFault("ResourceNotFound");
            }
            catch (ServiceException e) {
                this.logger.error((Object)("AzureDeleteInstance: " + this.instanceId + "(" + e.getErrorCode() + ") " + e.getMessage()));
                this.putLog("DeleteInstance", "DeleteInstance was failed", e.getStackTrace().toString());
                throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
            }
            catch (Exception e) {
                this.logger.error((Object)("AzureDeleteInstance: " + this.instanceId + " " + e.getMessage()));
                this.putLog("DeleteInstance", "DeleteInstance was failed", e.getStackTrace().toString());
                throw new CloudManagerFault(e.getMessage(), (Throwable)e);
            }
        }
        finally {
            this.logger.info((Object)("AzureDeleteInstance end: " + this.instanceId));
        }
    }
}

