/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.azure.factory;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.azure.factory.AzureAsyncOperations;
import com.clustercontrol.cloud.azure.util.AzureUtil;
import com.microsoft.windowsazure.Configuration;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.OperationStatus;
import com.microsoft.windowsazure.core.OperationStatusResponse;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.AffinityGroupOperations;
import com.microsoft.windowsazure.management.ManagementClient;
import com.microsoft.windowsazure.management.ManagementService;
import com.microsoft.windowsazure.management.compute.ComputeManagementClient;
import com.microsoft.windowsazure.management.compute.ComputeManagementService;
import com.microsoft.windowsazure.management.compute.DeploymentOperations;
import com.microsoft.windowsazure.management.compute.VirtualMachineDiskOperations;
import com.microsoft.windowsazure.management.compute.models.DataVirtualHardDisk;
import com.microsoft.windowsazure.management.compute.models.DeploymentGetResponse;
import com.microsoft.windowsazure.management.compute.models.DeploymentSlot;
import com.microsoft.windowsazure.management.compute.models.HostedServiceListResponse;
import com.microsoft.windowsazure.management.compute.models.Role;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineDiskListResponse;
import com.microsoft.windowsazure.management.models.AffinityGroupListResponse;
import org.apache.log4j.Logger;

public class AzureDeleteStorage
extends AzureAsyncOperations {
    private Logger logger = Logger.getLogger(this.getClass());
    private String storageId = null;
    private String regionId = null;
    private Configuration config = null;

    public AzureDeleteStorage(Configuration config, String storageId, String regionId) {
        this.config = config;
        this.storageId = storageId;
        this.regionId = regionId;
    }

    @Override
    public void execute() throws CloudManagerFault {
        block19: {
            OperationResponse operationResponse = new OperationResponse();
            try {
                OperationStatusResponse operationStatusResponse;
                this.logger.info((Object)("deleteStorage start: " + this.storageId));
                ManagementClient managementClient = ManagementService.create((Configuration)this.config);
                ComputeManagementClient computeManagementClient = ComputeManagementService.create((Configuration)this.config);
                AffinityGroupOperations affinityGroupOperations = managementClient.getAffinityGroupsOperations();
                AffinityGroupListResponse affinityGroupListResponse = affinityGroupOperations.list();
                VirtualMachineDiskListResponse vmds = computeManagementClient.getVirtualMachineDisksOperations().listDisks();
                DeploymentOperations deploymentOperations = computeManagementClient.getDeploymentsOperations();
                for (VirtualMachineDiskListResponse.VirtualMachineDisk vmd : vmds.getDisks()) {
                    if (!AzureUtil.compareLocation(this.regionId, vmd.getLocation(), vmd.getAffinityGroup(), affinityGroupListResponse.getAffinityGroups()) || !vmd.getName().equals(this.storageId)) continue;
                    for (HostedServiceListResponse.HostedService hostedService : computeManagementClient.getHostedServicesOperations().list()) {
                        for (DeploymentSlot slot : AzureUtil.getDeploymentSlots()) {
                            DeploymentGetResponse deploymentGetResponse = null;
                            try {
                                deploymentGetResponse = deploymentOperations.getBySlot(hostedService.getServiceName(), slot);
                            }
                            catch (ServiceException e) {
                                if (e.getErrorCode().equals("ResourceNotFound")) continue;
                                this.logger.error((Object)("deleteStorage: " + this.storageId + "(" + e.getErrorCode() + ") " + e.getMessage()));
                                throw new CloudManagerFault(e.getMessage(), (Throwable)e);
                            }
                            for (Role role : deploymentGetResponse.getRoles()) {
                                for (DataVirtualHardDisk dvhd : role.getDataVirtualHardDisks()) {
                                    OperationStatusResponse operationStatusResponse2;
                                    if (!dvhd.getName().equals(this.storageId)) continue;
                                    VirtualMachineDiskOperations virtualMachineDiskOperations = computeManagementClient.getVirtualMachineDisksOperations();
                                    this.logger.info("VirtualMachineDiskOperations.beginDeletingDataDisk(" + vmd.getUsageDetails().getHostedServiceName() + "," + vmd.getUsageDetails().getDeploymentName() + "," + vmd.getUsageDetails().getRoleName() + "," + dvhd.getLogicalUnitNumber() == null ? Integer.valueOf(0) : dvhd.getLogicalUnitNumber() + ")");
                                    operationResponse = virtualMachineDiskOperations.beginDeletingDataDisk(vmd.getUsageDetails().getHostedServiceName(), vmd.getUsageDetails().getDeploymentName(), vmd.getUsageDetails().getRoleName(), dvhd.getLogicalUnitNumber() == null ? 0 : dvhd.getLogicalUnitNumber(), true);
                                    this.logger.info((Object)("RequestId:" + operationResponse.getRequestId()));
                                    while ((operationStatusResponse2 = computeManagementClient.getOperationStatus(operationResponse.getRequestId())).getStatus().equals((Object)OperationStatus.InProgress)) {
                                    }
                                    this.logger.info((Object)("deleting " + this.getClass().getSimpleName() + "..."));
                                    if (operationStatusResponse2.getStatus().equals((Object)OperationStatus.Succeeded)) {
                                        this.logger.info((Object)("successful in deleting " + this.getClass().getSimpleName() + "..."));
                                    } else {
                                        this.logger.error((Object)("failed in deleting " + operationStatusResponse2.getError()));
                                        this.putLog("DeleteStorage", "DeleteStorage was failed", operationStatusResponse2.getError().getMessage());
                                        throw new CloudManagerFault(operationStatusResponse2.getError().getMessage(), (Throwable)new Exception(operationStatusResponse2.getError().getCode()));
                                    }
                                    return;
                                }
                            }
                        }
                    }
                }
                VirtualMachineDiskOperations virtualMachineDiskOperations = computeManagementClient.getVirtualMachineDisksOperations();
                this.logger.info((Object)("VirtualMachineDiskOperations.deleteDisk(" + this.storageId + ")"));
                operationResponse = virtualMachineDiskOperations.deleteDisk(this.storageId, true);
                this.logger.info((Object)("RequestId:" + operationResponse.getRequestId()));
                while ((operationStatusResponse = computeManagementClient.getOperationStatus(operationResponse.getRequestId())).getStatus().equals((Object)OperationStatus.InProgress)) {
                }
                this.logger.info((Object)("deleting " + this.getClass().getSimpleName() + "..."));
                if (operationStatusResponse.getStatus().equals((Object)OperationStatus.Succeeded)) {
                    this.logger.info((Object)("successful in deleting " + this.getClass().getSimpleName() + "..."));
                    break block19;
                }
                this.logger.error((Object)("failed in deleting " + operationStatusResponse.getError()));
                this.putLog("DeleteStorage", "DeleteStorage was failed", operationStatusResponse.getError().getMessage());
                throw new CloudManagerFault(operationStatusResponse.getError().getMessage(), (Throwable)new Exception(operationStatusResponse.getError().getCode()));
            }
            catch (ServiceException e) {
                this.logger.error((Object)("deleteStorage: " + this.storageId + "(" + e.getErrorCode() + ") " + e.getMessage()));
                this.putLog("DeleteStorage", "DeleteStorage was failed", e.getMessage());
                throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
            }
            catch (Exception e) {
                this.logger.error((Object)("deleteStorage: " + this.storageId + " " + e.getMessage()));
                this.putLog("DeleteStorage", "DeleteStorage was failed", e.getMessage());
                throw new CloudManagerFault(e.getMessage(), (Throwable)e);
            }
            finally {
                this.logger.info((Object)("deleteStorage end: " + this.storageId));
            }
        }
    }
}

