/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.azure.factory;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.azure.factory.AzureAsyncOperations;
import com.clustercontrol.cloud.azure.util.AzureUtil;
import com.microsoft.windowsazure.Configuration;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.OperationStatus;
import com.microsoft.windowsazure.core.OperationStatusResponse;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.compute.ComputeManagementClient;
import com.microsoft.windowsazure.management.compute.ComputeManagementService;
import com.microsoft.windowsazure.management.compute.DeploymentOperations;
import com.microsoft.windowsazure.management.compute.HostedServiceOperations;
import com.microsoft.windowsazure.management.compute.VirtualMachineDiskOperations;
import com.microsoft.windowsazure.management.compute.models.DataVirtualHardDisk;
import com.microsoft.windowsazure.management.compute.models.DeploymentGetResponse;
import com.microsoft.windowsazure.management.compute.models.DeploymentSlot;
import com.microsoft.windowsazure.management.compute.models.HostedServiceListResponse;
import com.microsoft.windowsazure.management.compute.models.Role;
import org.apache.log4j.Logger;

public class AzureDetachStorage
extends AzureAsyncOperations {
    private Logger logger = Logger.getLogger(this.getClass());
    private String instanceId = null;
    private String storageId = null;
    private Configuration config = null;

    public AzureDetachStorage(Configuration config, String instanceId, String storageId) {
        this.config = config;
        this.instanceId = instanceId;
        this.storageId = storageId;
    }

    @Override
    public void execute() throws CloudManagerFault {
        String deploymentName = "";
        String cloudServiceName = "";
        String roleName = "";
        int logicalUnitNumber = 0;
        try {
            this.logger.info((Object)("AzureDetachStorage start: " + this.instanceId + ", " + this.storageId));
            ComputeManagementClient computeManagementClient = ComputeManagementService.create((Configuration)this.config);
            VirtualMachineDiskOperations virtualMachineDiskOperations = computeManagementClient.getVirtualMachineDisksOperations();
            DeploymentOperations deploymentOperations = computeManagementClient.getDeploymentsOperations();
            HostedServiceOperations hostedServicesOperations = computeManagementClient.getHostedServicesOperations();
            HostedServiceListResponse hostedServiceListResponse = hostedServicesOperations.list();
            for (HostedServiceListResponse.HostedService hostService : hostedServiceListResponse.getHostedServices()) {
                for (DeploymentSlot slot : AzureUtil.getDeploymentSlots()) {
                    DeploymentGetResponse deploymentGetResponse = null;
                    try {
                        deploymentGetResponse = deploymentOperations.getBySlot(hostService.getServiceName(), slot);
                    }
                    catch (ServiceException e) {
                        if (e.getErrorCode().equals("ResourceNotFound")) continue;
                        throw new CloudManagerFault(e.getMessage(), (Throwable)e);
                    }
                    deploymentGetResponse.getRoles();
                    for (Role role : deploymentGetResponse.getRoles()) {
                        if (!role.getRoleName().equals(this.instanceId)) continue;
                        cloudServiceName = hostService.getServiceName();
                        deploymentName = deploymentGetResponse.getName();
                        roleName = role.getRoleName();
                        for (DataVirtualHardDisk dvhd : role.getDataVirtualHardDisks()) {
                            OperationStatusResponse operationStatusResponse;
                            if (!dvhd.getName().equals(this.storageId)) continue;
                            logicalUnitNumber = dvhd.getLogicalUnitNumber() == null ? 0 : dvhd.getLogicalUnitNumber();
                            this.logger.info((Object)("virtualMachineDiskOperations.beginDeletingDataDisk(" + cloudServiceName + "," + deploymentName + "," + roleName + "," + logicalUnitNumber + ")"));
                            OperationResponse operationResponse = virtualMachineDiskOperations.beginDeletingDataDisk(cloudServiceName, deploymentName, roleName, logicalUnitNumber, false);
                            this.logger.info((Object)("RequestId:" + operationResponse.getRequestId()));
                            while ((operationStatusResponse = computeManagementClient.getOperationStatus(operationResponse.getRequestId())).getStatus().equals((Object)OperationStatus.InProgress)) {
                            }
                            this.logger.info((Object)("detaching " + this.getClass().getSimpleName() + "..."));
                            if (operationStatusResponse.getStatus().equals((Object)OperationStatus.Succeeded)) {
                                this.logger.info((Object)("successful in detaching " + this.getClass().getSimpleName() + "..."));
                            } else {
                                this.logger.error((Object)("failed in detaching " + operationStatusResponse.getError()));
                                this.putLog("DetacheStorage", "DetacheStorage was failed", operationStatusResponse.getError().getMessage());
                                throw new CloudManagerFault(operationStatusResponse.getError().getMessage(), (Throwable)new Exception(operationStatusResponse.getError().getCode()));
                            }
                            return;
                        }
                    }
                }
            }
        }
        catch (ServiceException e) {
            this.putLog("DetacheStorage", "DetacheStorage was failed", e.getMessage());
            throw new CloudManagerFault(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            this.putLog("DetacheStorage", "DetacheStorage was failed", e.getMessage());
            throw new CloudManagerFault(e.getMessage(), (Throwable)e);
        }
        finally {
            this.logger.info((Object)("AzureDetachStorage end: " + this.instanceId + ", " + this.storageId));
        }
    }
}

