/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.management.network;

import com.microsoft.windowsazure.core.OperationStatus;
import com.microsoft.windowsazure.core.OperationStatusResponse;
import com.microsoft.windowsazure.core.ServiceClient;
import com.microsoft.windowsazure.core.utils.BOMInputStream;
import com.microsoft.windowsazure.core.utils.XmlUtility;
import com.microsoft.windowsazure.credentials.SubscriptionCloudCredentials;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.network.ClientRootCertificateOperations;
import com.microsoft.windowsazure.management.network.ClientRootCertificateOperationsImpl;
import com.microsoft.windowsazure.management.network.GatewayOperations;
import com.microsoft.windowsazure.management.network.GatewayOperationsImpl;
import com.microsoft.windowsazure.management.network.NetworkManagementClient;
import com.microsoft.windowsazure.management.network.NetworkOperations;
import com.microsoft.windowsazure.management.network.NetworkOperationsImpl;
import com.microsoft.windowsazure.management.network.ReservedIPOperations;
import com.microsoft.windowsazure.management.network.ReservedIPOperationsImpl;
import com.microsoft.windowsazure.management.network.StaticIPOperations;
import com.microsoft.windowsazure.management.network.StaticIPOperationsImpl;
import com.microsoft.windowsazure.management.network.models.LocalNetworkConnectionType;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class NetworkManagementClientImpl
extends ServiceClient<NetworkManagementClient>
implements NetworkManagementClient {
    private URI baseUri;
    private SubscriptionCloudCredentials credentials;
    private ClientRootCertificateOperations clientRootCertificates = new ClientRootCertificateOperationsImpl(this);
    private GatewayOperations gateways = new GatewayOperationsImpl(this);
    private NetworkOperations networks = new NetworkOperationsImpl(this);
    private ReservedIPOperations reservedIPs = new ReservedIPOperationsImpl(this);
    private StaticIPOperations staticIPs = new StaticIPOperationsImpl(this);

    @Override
    public URI getBaseUri() {
        return this.baseUri;
    }

    @Override
    public SubscriptionCloudCredentials getCredentials() {
        return this.credentials;
    }

    @Override
    public ClientRootCertificateOperations getClientRootCertificatesOperations() {
        return this.clientRootCertificates;
    }

    @Override
    public GatewayOperations getGatewaysOperations() {
        return this.gateways;
    }

    @Override
    public NetworkOperations getNetworksOperations() {
        return this.networks;
    }

    @Override
    public ReservedIPOperations getReservedIPsOperations() {
        return this.reservedIPs;
    }

    @Override
    public StaticIPOperations getStaticIPsOperations() {
        return this.staticIPs;
    }

    private NetworkManagementClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService) {
        super(httpBuilder, executorService);
    }

    @Inject
    public NetworkManagementClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService, @Named(value="com.microsoft.windowsazure.Configuration.credentials") SubscriptionCloudCredentials credentials, @Named(value="management.uri") URI baseUri) {
        this(httpBuilder, executorService);
        if (credentials == null) {
            throw new NullPointerException("credentials");
        }
        this.credentials = credentials;
        if (baseUri == null) {
            try {
                this.baseUri = new URI("https://management.core.windows.net");
            }
            catch (URISyntaxException ex) {}
        } else {
            this.baseUri = baseUri;
        }
    }

    public NetworkManagementClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService, SubscriptionCloudCredentials credentials) throws URISyntaxException {
        this(httpBuilder, executorService);
        if (credentials == null) {
            throw new NullPointerException("credentials");
        }
        this.credentials = credentials;
        this.baseUri = new URI("https://management.core.windows.net");
    }

    protected NetworkManagementClientImpl newInstance(HttpClientBuilder httpBuilder, ExecutorService executorService) {
        return new NetworkManagementClientImpl(httpBuilder, executorService, this.getCredentials(), this.getBaseUri());
    }

    @Override
    public Future<OperationStatusResponse> getOperationStatusAsync(final String requestId) {
        return this.getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return NetworkManagementClientImpl.this.getOperationStatus(requestId);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse getOperationStatus(String requestId) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        if (requestId == null) {
            throw new NullPointerException("requestId");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("requestId", requestId);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getOperationStatusAsync", tracingParameters);
        }
        String baseUrl = this.getBaseUri().toString();
        String url = "/" + this.getCredentials().getSubscriptionId().trim() + "/operations/" + requestId.trim();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2013-11-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new OperationStatusResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element operationElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"Operation");
            if (operationElement != null) {
                Element errorElement;
                Element httpStatusCodeElement;
                Element statusElement;
                Element idElement = XmlUtility.getElementByTagNameNS((Node)operationElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ID");
                if (idElement != null) {
                    String idInstance = idElement.getTextContent();
                    result.setId(idInstance);
                }
                if ((statusElement = XmlUtility.getElementByTagNameNS((Node)operationElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Status")) != null) {
                    OperationStatus statusInstance = OperationStatus.valueOf((String)statusElement.getTextContent());
                    result.setStatus(statusInstance);
                }
                if ((httpStatusCodeElement = XmlUtility.getElementByTagNameNS((Node)operationElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"HttpStatusCode")) != null) {
                    Integer httpStatusCodeInstance = Integer.valueOf(httpStatusCodeElement.getTextContent());
                    result.setHttpStatusCode(httpStatusCodeInstance);
                }
                if ((errorElement = XmlUtility.getElementByTagNameNS((Node)operationElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Error")) != null) {
                    Element messageElement;
                    OperationStatusResponse.ErrorDetails errorInstance = new OperationStatusResponse.ErrorDetails();
                    result.setError(errorInstance);
                    Element codeElement = XmlUtility.getElementByTagNameNS((Node)errorElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Code");
                    if (codeElement != null) {
                        String codeInstance = codeElement.getTextContent();
                        errorInstance.setCode(codeInstance);
                    }
                    if ((messageElement = XmlUtility.getElementByTagNameNS((Node)errorElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Message")) != null) {
                        String messageInstance = messageElement.getTextContent();
                        errorInstance.setMessage(messageInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    static LocalNetworkConnectionType parseLocalNetworkConnectionType(String value) {
        if ("IPsec".equalsIgnoreCase(value)) {
            return LocalNetworkConnectionType.IPSecurity;
        }
        if ("Dedicated".equalsIgnoreCase(value)) {
            return LocalNetworkConnectionType.Dedicated;
        }
        throw new IllegalArgumentException("value");
    }

    static String localNetworkConnectionTypeToString(LocalNetworkConnectionType value) {
        if (value == LocalNetworkConnectionType.IPSecurity) {
            return "IPsec";
        }
        if (value == LocalNetworkConnectionType.Dedicated) {
            return "Dedicated";
        }
        throw new IllegalArgumentException("value");
    }
}

