/*
 * Decompiled with CFR 0.152.
 */
package cucumber.deps.com.thoughtworks.xstream.core;

import cucumber.deps.com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import cucumber.deps.com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import cucumber.deps.com.thoughtworks.xstream.core.Caching;
import cucumber.deps.com.thoughtworks.xstream.core.util.PresortedMap;
import cucumber.deps.com.thoughtworks.xstream.core.util.PresortedSet;
import cucumber.deps.com.thoughtworks.xstream.core.util.WeakCache;
import java.lang.reflect.Field;
import java.security.AccessControlException;
import java.text.AttributedString;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class JVM
implements Caching {
    private ReflectionProvider reflectionProvider;
    private transient Map loaderCache = new WeakCache(new HashMap());
    private final boolean supportsAWT = this.loadClass("java.awt.Color") != null;
    private final boolean supportsSwing = this.loadClass("javax.swing.LookAndFeel") != null;
    private final boolean supportsSQL = this.loadClass("java.sql.Date") != null;
    private static final boolean optimizedTreeSetAddAll;
    private static final boolean optimizedTreeMapPutAll;
    private static final boolean canParseUTCDateFormat;
    private static final String vendor;
    private static final float majorJavaVersion;
    private static final boolean reverseFieldOrder;
    static final float DEFAULT_JAVA_VERSION = 1.3f;

    private static final float getMajorJavaVersion() {
        try {
            return JVM.isAndroid() ? 1.5f : Float.parseFloat(System.getProperty("java.specification.version"));
        }
        catch (NumberFormatException e) {
            return 1.3f;
        }
    }

    public static boolean is14() {
        return majorJavaVersion >= 1.4f;
    }

    public static boolean is15() {
        return majorJavaVersion >= 1.5f;
    }

    public static boolean is16() {
        return majorJavaVersion >= 1.6f;
    }

    public static boolean is17() {
        return majorJavaVersion >= 1.7f;
    }

    public static boolean is18() {
        return majorJavaVersion >= 1.8f;
    }

    private static boolean isSun() {
        return vendor.indexOf("Sun") != -1;
    }

    private static boolean isOracle() {
        return vendor.indexOf("Oracle") != -1;
    }

    private static boolean isApple() {
        return vendor.indexOf("Apple") != -1;
    }

    private static boolean isHPUX() {
        return vendor.indexOf("Hewlett-Packard Company") != -1;
    }

    private static boolean isIBM() {
        return vendor.indexOf("IBM") != -1;
    }

    private static boolean isBlackdown() {
        return vendor.indexOf("Blackdown") != -1;
    }

    private static boolean isDiablo() {
        return vendor.indexOf("FreeBSD Foundation") != -1;
    }

    private static boolean isHarmony() {
        return vendor.indexOf("Apache Software Foundation") != -1;
    }

    private static boolean isAndroid() {
        return vendor.indexOf("Android") != -1;
    }

    private static boolean isBEAWithUnsafeSupport() {
        if (vendor.indexOf("BEA") != -1) {
            String vmVersion = System.getProperty("java.vm.version");
            if (vmVersion.startsWith("R")) {
                return true;
            }
            String vmInfo = System.getProperty("java.vm.info");
            if (vmInfo != null) {
                return vmInfo.startsWith("R25.1") || vmInfo.startsWith("R25.2");
            }
        }
        return false;
    }

    private static boolean isHitachi() {
        return vendor.indexOf("Hitachi") != -1;
    }

    private static boolean isSAP() {
        return vendor.indexOf("SAP AG") != -1;
    }

    public Class loadClass(String name) {
        try {
            Class cached = (Class)this.loaderCache.get(name);
            if (cached != null) {
                return cached;
            }
            Class<?> clazz = Class.forName(name, false, this.getClass().getClassLoader());
            this.loaderCache.put(name, clazz);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public synchronized ReflectionProvider bestReflectionProvider() {
        if (this.reflectionProvider == null) {
            try {
                Class cls;
                String className = null;
                if (this.canUseSun14ReflectionProvider()) {
                    className = "cucumber.deps.com.thoughtworks.xstream.converters.reflection.Sun14ReflectionProvider";
                } else if (this.canUseHarmonyReflectionProvider()) {
                    className = "cucumber.deps.com.thoughtworks.xstream.converters.reflection.HarmonyReflectionProvider";
                }
                if (className != null && (cls = this.loadClass(className)) != null) {
                    this.reflectionProvider = (ReflectionProvider)cls.newInstance();
                }
                if (this.reflectionProvider == null) {
                    this.reflectionProvider = new PureJavaReflectionProvider();
                }
            }
            catch (InstantiationException e) {
                this.reflectionProvider = new PureJavaReflectionProvider();
            }
            catch (IllegalAccessException e) {
                this.reflectionProvider = new PureJavaReflectionProvider();
            }
            catch (AccessControlException e) {
                this.reflectionProvider = new PureJavaReflectionProvider();
            }
        }
        return this.reflectionProvider;
    }

    private boolean canUseSun14ReflectionProvider() {
        return (JVM.isSun() || JVM.isOracle() || JVM.isApple() || JVM.isHPUX() || JVM.isIBM() || JVM.isBlackdown() || JVM.isBEAWithUnsafeSupport() || JVM.isHitachi() || JVM.isSAP() || JVM.isDiablo()) && JVM.is14() && this.loadClass("sun.misc.Unsafe") != null;
    }

    private boolean canUseHarmonyReflectionProvider() {
        return JVM.isHarmony();
    }

    public static boolean reverseFieldDefinition() {
        return reverseFieldOrder;
    }

    public boolean supportsAWT() {
        return this.supportsAWT;
    }

    public boolean supportsSwing() {
        return this.supportsSwing;
    }

    public boolean supportsSQL() {
        return this.supportsSQL;
    }

    public static boolean hasOptimizedTreeSetAddAll() {
        return optimizedTreeSetAddAll;
    }

    public static boolean hasOptimizedTreeMapPutAll() {
        return optimizedTreeMapPutAll;
    }

    public static boolean canParseUTCDateFormat() {
        return canParseUTCDateFormat;
    }

    public void flushCache() {
        this.loaderCache.clear();
    }

    private Object readResolve() {
        this.loaderCache = new WeakCache(new HashMap());
        return this;
    }

    public static void main(String[] args) {
        int i;
        boolean reverse = false;
        Field[] fields = AttributedString.class.getDeclaredFields();
        for (i = 0; i < fields.length; ++i) {
            if (!fields[i].getName().equals("text")) continue;
            reverse = i > 3;
            break;
        }
        if (reverse) {
            fields = JVM.class.getDeclaredFields();
            for (i = 0; i < fields.length; ++i) {
                if (!fields[i].getName().equals("reflectionProvider")) continue;
                reverse = i > 2;
                break;
            }
        }
        JVM jvm = new JVM();
        System.out.println("XStream JVM diagnostics");
        System.out.println("java.specification.version: " + System.getProperty("java.specification.version"));
        System.out.println("java.vm.vendor: " + vendor);
        System.out.println("Version: " + majorJavaVersion);
        System.out.println("XStream support for enhanced Mode: " + (jvm.canUseSun14ReflectionProvider() || jvm.canUseHarmonyReflectionProvider()));
        System.out.println("Supports AWT: " + jvm.supportsAWT());
        System.out.println("Supports Swing: " + jvm.supportsSwing());
        System.out.println("Supports SQL: " + jvm.supportsSQL());
        System.out.println("Optimized TreeSet.addAll: " + JVM.hasOptimizedTreeSetAddAll());
        System.out.println("Optimized TreeMap.putAll: " + JVM.hasOptimizedTreeMapPutAll());
        System.out.println("Can parse UTC date format: " + JVM.canParseUTCDateFormat());
        System.out.println("Reverse field order detected (may have failed): " + reverse);
    }

    static {
        vendor = System.getProperty("java.vm.vendor");
        majorJavaVersion = JVM.getMajorJavaVersion();
        reverseFieldOrder = JVM.isHarmony() || JVM.isIBM() && !JVM.is15();
        Comparator comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                throw new RuntimeException();
            }
        };
        boolean test = true;
        PresortedMap map = new PresortedMap(comparator);
        map.put("one", null);
        map.put("two", null);
        try {
            new TreeMap(comparator).putAll(map);
        }
        catch (RuntimeException e) {
            test = false;
        }
        optimizedTreeMapPutAll = test;
        PresortedSet set = new PresortedSet(comparator);
        set.addAll(map.keySet());
        try {
            new TreeSet(comparator).addAll(set);
            test = true;
        }
        catch (RuntimeException e) {
            test = false;
        }
        optimizedTreeSetAddAll = test;
        try {
            new SimpleDateFormat("z").parse("UTC");
            test = true;
        }
        catch (ParseException e) {
            test = false;
        }
        canParseUTCDateFormat = test;
    }
}

