/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime;

import cucumber.runtime.CucumberException;
import cucumber.runtime.io.Resource;
import cucumber.runtime.model.CucumberFeature;
import gherkin.I18n;
import gherkin.formatter.FilterFormatter;
import gherkin.formatter.Formatter;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import gherkin.lexer.Encoding;
import gherkin.parser.Parser;
import gherkin.util.FixJava;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FeatureBuilder
implements Formatter {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final List<CucumberFeature> cucumberFeatures;
    private final char fileSeparatorChar;
    private final MessageDigest md5;
    private final Map<String, String> pathsByChecksum = new HashMap<String, String>();
    private CucumberFeature currentCucumberFeature;
    private String uri;

    public FeatureBuilder(List<CucumberFeature> cucumberFeatures) {
        this(cucumberFeatures, File.separatorChar);
    }

    FeatureBuilder(List<CucumberFeature> cucumberFeatures, char fileSeparatorChar) {
        this.cucumberFeatures = cucumberFeatures;
        this.fileSeparatorChar = fileSeparatorChar;
        try {
            this.md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new CucumberException(e);
        }
    }

    public void uri(String uri) {
        this.uri = uri;
    }

    public void feature(Feature feature) {
        this.currentCucumberFeature = new CucumberFeature(feature, this.uri);
        this.cucumberFeatures.add(this.currentCucumberFeature);
    }

    public void background(Background background) {
        this.currentCucumberFeature.background(background);
    }

    public void scenario(Scenario scenario) {
        this.currentCucumberFeature.scenario(scenario);
    }

    public void scenarioOutline(ScenarioOutline scenarioOutline) {
        this.currentCucumberFeature.scenarioOutline(scenarioOutline);
    }

    public void examples(Examples examples) {
        this.currentCucumberFeature.examples(examples);
    }

    public void step(Step step) {
        this.currentCucumberFeature.step(step);
    }

    public void eof() {
    }

    public void syntaxError(String state, String event, List<String> legalEvents, String uri, Integer line) {
    }

    public void done() {
    }

    public void close() {
    }

    public void parse(Resource resource, List<Object> filters) {
        String gherkin = this.read(resource);
        String checksum = this.checksum(gherkin);
        String path = this.pathsByChecksum.get(checksum);
        if (path != null) {
            return;
        }
        this.pathsByChecksum.put(checksum, resource.getPath());
        FeatureBuilder formatter = this;
        if (!filters.isEmpty()) {
            formatter = new FilterFormatter((Formatter)this, filters);
        }
        Parser parser = new Parser((Formatter)formatter);
        try {
            parser.parse(gherkin, this.convertPathToUri(resource.getPath()), Integer.valueOf(0));
        }
        catch (Exception e) {
            throw new CucumberException(String.format("Error parsing feature file %s", this.convertPathToUri(resource.getPath())), e);
        }
        I18n i18n = parser.getI18nLanguage();
        if (this.currentCucumberFeature != null) {
            this.currentCucumberFeature.setI18n(i18n);
        }
    }

    private String convertPathToUri(String path) {
        return path.replace(this.fileSeparatorChar, '/');
    }

    private String checksum(String gherkin) {
        return new BigInteger(1, this.md5.digest(gherkin.getBytes(UTF8))).toString(16);
    }

    private String read(Resource resource) {
        try {
            String source = FixJava.readReader((Reader)new InputStreamReader(resource.getInputStream(), "UTF-8"));
            String encoding = new Encoding().encoding(source);
            if (!"UTF-8".equals(encoding)) {
                source = FixJava.readReader((Reader)new InputStreamReader(resource.getInputStream(), encoding));
            }
            return source;
        }
        catch (IOException e) {
            throw new CucumberException("Failed to read resource:" + resource.getPath(), e);
        }
    }
}

