/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.factory;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.commons.CloudPropertyConstants;
import com.clustercontrol.cloud.factory.InstanceOperator;
import com.clustercontrol.cloud.factory.TemplateJobUtil;
import com.clustercontrol.cloud.util.RepositoryControllerBeanWrapper;
import com.clustercontrol.fault.FacilityNotFound;
import com.clustercontrol.hinemosagent.util.AgentConnectUtil;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class RegistAgent
implements Runnable {
    private String facilityId;
    private int count = 0;
    private int maxCount = Integer.parseInt(CloudPropertyConstants.agent_connection_count.value());

    public RegistAgent(String facilityId) {
        this.facilityId = facilityId;
    }

    @Override
    public void run() {
        Logger logger = Logger.getLogger(this.getClass());
        ++this.count;
        logger.debug((Object)("try to regist agent " + this.facilityId + " " + this.count + "/" + this.maxCount + " time."));
        boolean success = false;
        try {
            RepositoryControllerBeanWrapper.bean().getNode(this.facilityId);
            success = AgentConnectUtil.sendManagerDiscoveryInfo((String)this.facilityId);
        }
        catch (FacilityNotFound e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException();
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        if (success) {
            logger.info((Object)("success to regist " + this.facilityId + " as agent."));
            throw new RuntimeException();
        }
        if (this.maxCount <= this.count) {
            logger.warn((Object)"timed out. agent doesn't exist.");
            throw new RuntimeException();
        }
    }

    public void asyncRegistAgent() {
        Logger logger = Logger.getLogger(InstanceOperator.class);
        logger.info((Object)("start to ping " + this.facilityId + " as agent for register."));
        SessionService.scheduleWithFixedDelay((Runnable)this, (long)0L, (long)Long.parseLong(CloudPropertyConstants.agent_connection_interval.value()), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public void registAgent() {
        Logger logger = Logger.getLogger(InstanceOperator.class);
        logger.info((Object)("start to ping " + this.facilityId + " as agent for register."));
        try {
            while (true) {
                this.run();
                Thread.sleep(Long.parseLong(CloudPropertyConstants.agent_connection_interval.value()));
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    public Boolean findAgent() throws CloudManagerFault {
        Logger logger = Logger.getLogger(TemplateJobUtil.class);
        try {
            logger.info((Object)("start to check " + this.facilityId + " as agent for register."));
            boolean result = false;
            int counter = 0;
            int maxCount = Integer.parseInt(CloudPropertyConstants.agent_connection_count.value());
            long interval = Long.parseLong(CloudPropertyConstants.agent_connection_interval.value());
            while (counter < maxCount) {
                logger.debug((Object)("tr\uff59 to find agent " + this.facilityId + " " + ++counter + "/" + maxCount + " time."));
                RepositoryControllerBeanWrapper.bean().getNode(this.facilityId);
                if (AgentConnectUtil.isValidAgent((String)this.facilityId)) {
                    logger.info((Object)("success to find " + this.facilityId + " as agent."));
                    return true;
                }
                if (counter >= maxCount) {
                    throw new CloudManagerFault("timed out. agent doesn't exist.");
                }
                Thread.sleep(interval);
            }
            return result;
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
    }

    public static void asyncRegistAgent(String facilityId) {
        new RegistAgent(facilityId).asyncRegistAgent();
    }

    public static void registAgent(String facilityId) {
        new RegistAgent(facilityId).registAgent();
    }

    public static Boolean findAgent(String facilityId) throws CloudManagerFault {
        return new RegistAgent(facilityId).findAgent();
    }
}

