/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.factory.monitors;

import com.clustercontrol.accesscontrol.session.AccessControllerBean;
import com.clustercontrol.cloud.HinemosCredential;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.commons.CloudPropertyConstants;
import com.clustercontrol.cloud.factory.ActionMode;
import com.clustercontrol.commons.util.HinemosSessionContext;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public abstract class AbstractCloudJob
implements Job {
    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            String userId = CloudPropertyConstants.internal_thread_admin_user.value();
            HinemosSessionContext.instance().setProperty("loginUserId", (Object)userId);
            SessionService.current().setHinemosCredential(new HinemosCredential(userId));
            HinemosSessionContext.instance().setProperty("isAdministrator", (Object)new AccessControllerBean().isAdministrator());
            this.internalExecute(context);
        }
        catch (JobExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JobExecutionException((Throwable)e);
        }
        finally {
            SessionService.current().close();
            ActionMode.leaveAutoDetection();
        }
    }

    protected abstract void internalExecute(JobExecutionContext var1) throws Exception;
}

