/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.util;

import com.clustercontrol.accesscontrol.bean.PrivilegeConstant;
import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.ErrorCode;
import com.clustercontrol.cloud.IMessagesHolder;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.persistence.EntityManagerEx;
import java.util.List;
import javax.persistence.Query;

public class ObjectPrivilegeUtil {
    public static <T> T getObject(Class<T> objectClass, String objectIdName, String objectId, String userId, PrivilegeConstant.ObjectPrivilegeMode mode, IMessagesHolder messages) throws CloudManagerFault {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        Query query = em.createQuery("SELECT DISTINCT t, CASE WHEN t.ownerRoleId = r.roleId THEN r.roleId WHEN r.roleId = :ADMINISTRATORS THEN r.roleId ELSE null END, CASE WHEN (r.roleId <> :ADMINISTRATORS AND r.roleId = o.id.roleId AND o.id.objectPrivilege = :privilege) THEN o.id.roleId ELSE null END FROM " + objectClass.getSimpleName() + " AS t LEFT OUTER JOIN t.objectPrivileges AS o, UserEntity as h JOIN h.roleEntities r " + "WHERE t." + objectIdName + " = :objectId AND h.userId = :userId");
        query.setParameter("objectId", (Object)objectId);
        query.setParameter("ADMINISTRATORS", (Object)"ADMINISTRATORS");
        query.setParameter("userId", (Object)userId);
        query.setParameter("privilege", (Object)mode.name());
        List results = query.getResultList();
        for (Object[] result : results) {
            if (result[1] == null && result[2] == null) continue;
            return (T)result[0];
        }
        if (results.size() == 1) {
            throw ErrorCode.OBJECTPRIVILEGE_UNAUTHORIZED_TO_TARGET_OBJECT.cloudManagerFault(messages.getString(objectClass.getSimpleName()), objectId, mode.name());
        }
        throw ErrorCode.OBJECTPRIVILEGE_NOT_FOUND_TARGET_OBJECT.cloudManagerFault(messages.getString(objectClass.getSimpleName()), objectId);
    }

    public static <T> List<T> getObjects(Class<T> objectClass, String objectIdName, String userId, PrivilegeConstant.ObjectPrivilegeMode mode) throws CloudManagerFault {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        Query query = em.createQuery("SELECT DISTINCT t FROM " + objectClass.getSimpleName() + " AS t LEFT OUTER JOIN t.objectPrivileges AS o, UserEntity as h JOIN h.roleEntities r " + "WHERE h.userId = :userId AND (r.roleId = t.ownerRoleId OR r.roleId = :ADMINISTRATORS OR (r.roleId = o.id.roleId AND o.id.objectPrivilege = :privilege))");
        query.setParameter("ADMINISTRATORS", (Object)"ADMINISTRATORS");
        query.setParameter("userId", (Object)userId);
        query.setParameter("privilege", (Object)mode.name());
        return query.getResultList();
    }
}

