#!/bin/bash

#Copyright (C) 2013 NTT DATA Corporation
#
#This program is free software; you can redistribute it and/or 
#Modify it under the terms of the GNU General Public License 
#as published by the Free Software Foundation, version 2.
#
#This program is distributed in the hope that it will be useful, 
#but WITHOUT ANY WARRANTY; without even the implied warranty of 
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
#GNU General Public License for more details

function set_hinemos_home(){
	HINEMOS_HOME="/opt/hinemos"
	
	while [ 1 ]
	do
		if [ ! -f ${HINEMOS_HOME}/hinemos.cfg ]; then
			echo -e "hinemos.cfg is dosn't exist in ${HINEMOS_HOME} ."
			read -p "Please input hinemos installed directory (q input to quit) : " INPUT
			INPUT=${INPUT:=$HINEMOS_HOME}
			case ${INPUT} in
				q|Q)
					exit 1
					;;
				*)
					HINEMOS_HOME=${INPUT}
					;;
			esac
		else
			break
		fi
	done 
}

function check_version(){
	if [ ! -e ${1} ]; then
		echo "error : You must install ${3} v${2} or later in order to install this option on this box!!"
		exit 1
	fi
	
	INSTALLED_VERSION=`cat ${1}`
	echo "Installed ${3} version is ${INSTALLED_VERSION}."
	
	REQUIRE=( `echo ${2} | sed -e 's/[^0-9]*\([1-9]\+\)\.\([0-9]\+\)\.\([0-9]\+\).*\|.*/\1 \2 \3/'` )
	if [ ${#REQUIRE[*]} != 3 ]; then
		echo "error : Required ${3} version(${2}) is invalid format."
		exit 1
	fi
	
	INSTALED=( `echo ${INSTALLED_VERSION} | sed -e 's/[^0-9]*\([1-9]\+\)\.\([0-9]\+\)\.\([0-9]\+\).*\|.*/\1 \2 \3/'` )
	if [ ${#INSTALED[*]} != 3 ]; then
		echo "error : Installed ${3} version(${INSTALLED_VERSION}) is invalid format."
		exit 1
	fi
	
	if [ ${REQUIRE[0]} -ne ${INSTALED[0]} -o  ${REQUIRE[1]} -ne ${INSTALED[1]} ]; then
		echo "error : Not match major version. required=${2}, installed=${INSTALLED_VERSION}"
		exit 1
	fi
	
	if [ ${REQUIRE[2]} -gt ${INSTALED[2]} ]; then
		echo "error : You must install ${3} v${2} or later in order to install this option on this box!!"
		exit 1
	fi
	
	echo version check succeeded!
	echo
}

function install_libraries(){
	for INSTALL_JAR in ${6}
	do
		if ! ls ${3}/${INSTALL_JAR} >/dev/null 2>&1; then
		    echo install-package is lacking !
		    exit 1
		fi
	done
	
	mkdir -p ${1}
	chown ${4}:${5} ${1}
	for INSTALL_JAR in ${6}
	do
		rm -f ${1}/${INSTALL_JAR}
		cp -p ${3}/${INSTALL_JAR} ${1}
		chown ${4}:${5} ${1}/${INSTALL_JAR}
		
		rm -f ${2}/${INSTALL_JAR}
		ln -s ${1}/${INSTALL_JAR} ${2}
	
		RET=$?
		if [ ${RET} -ne 0 ]; then
		    echo link failed at deploy-dir !
		    #exit 1
		fi
		chown -h ${4}:${5} ${2}/${INSTALL_JAR}
	done
}	

function uninstall_libraries(){
	local INSTALL_FILES=${1}

	for FILE in ${INSTALL_FILES}
	do
	  if ls ${FILE} >/dev/null 2>&1; then
	    if rm -f ${FILE}; then
	      echo "${FILE} is removed"
	    fi
	  else
	    echo "${FILE} is already removed"
	  fi
	done
}

function regist_persistence(){	
	for ENTITY_JAR in ${3}
	do
		if [ -f ${1}/${ENTITY_JAR} ]; then
			sed -ie "/<jar-file>${1//\//\\/}\/${ENTITY_JAR}<\/jar-file>/d" ${2}
			sed -ie "/${4}/i \                <jar-file>${1}/${ENTITY_JAR}</jar-file>" ${2}
		else
			echo "${ENTITY_JAR} dosn't exist in ${1} !"
		fi
	done
	
	for ORM_XML_PATH in ${5}
	do
		sed -ie "/<mapping-file>${ORM_XML_PATH//\//\\/}<\/mapping-file>/d" ${2}
		sed -ie "/${6}/i \                <mapping-file>${ORM_XML_PATH}</mapping-file>" ${2}
	done
}

function deregist_persistence(){
	local ENTITY_JARS=${1}
	local LIBDIR=${2}
	local PERSISTENCE_XML_PATH=${3}
	local ORM_XML_PATHS=${4}

	for ENTITY_JAR in ${ENTITY_JARS}
	do
		sed -ie "/<jar-file>${LIBDIR//\//\\/}\/${ENTITY_JAR}<\/jar-file>/d" ${PERSISTENCE_XML_PATH}
	done
	
	for ORM_XML_PATH in ${ORM_XML_PATHS}
	do
		sed -ie "/<mapping-file>${ORM_XML_PATH//\//\\/}<\/mapping-file>/d" ${PERSISTENCE_XML_PATH}
	done
}

function db_manipulate(){
	if [ ! $(printenv PGPASSWORD) ] ; then
		read -s -p "Postgres Password (default hinemos) : " PASSWD
		if [ "${PASSWD}" != "" ] ; then
		    export PGPASSWORD=${PASSWD}
		fi
		echo
	fi
	
	ext=${3##*.}
	ext=${ext% *}
	if [ "sql" = ${ext} ] ; then
		if [ -x ${RDS_HOST} ] ; then
			${1}/bin/psql -p 24001 -U ${2} -f ${3} 1>/dev/null
		else
			${1}/bin/psql -h ${RDS_HOST} -p 24001 -U ${2} -f ${3} 1>/dev/null
		fi
	else
		. ${3}
	fi
	
	RET=$?
	if [ ${RET} -ne 0 ]; then
	    echo SQL failed !
	    exit 1
	fi
}

function install_settings() {
	local srcDir=${1}/settings
	local toDir=${2}

	if [ ! -d ${srcDir} ]; then
	    echo "Don't exist ${srcDir}."
    	exit 1
	fi

	cp -r ${srcDir}/* ${toDir} >/dev/null 2>&1
}

function uninstall_settings() {
	local srcDir=${1}/settings
	local toDir=${2}

	if [ ! -d ${srcDir} ]; then
	    echo "Don't exist ${srcDir}."
    	exit 1
	fi

	files=`find ${srcDir} -type f`
	for f in ${files}
	do
		rm -f `echo ${f} | sed -e "s|^${srcDir}|${toDir}|"` >/dev/null 2>&1
	done
}