/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.azure;

import java.text.MessageFormat;
import java.util.MissingResourceException;

import com.clustercontrol.cloud.CloudManagerFault;

public enum ErrorCode {
	UNEXPECTED("unexpected"),

	// 
	CLOUDUSER_INVALID_ACCESSKEY("message.validation.clouduser.invalid_accesskey.not_found")
	;
	
	private String messageId;

	private ErrorCode(String messageId) {
		this.messageId = messageId;
	}
	
	public String getMessage(Object... args) {
		MessageFormat messageFormat = new MessageFormat(getMessage());
		return messageFormat.format(args);
	}

	public String getMessage() {
		try {
			return Messages.getString(messageId);
		}
		catch (MissingResourceException e) {
			return messageId;
		}
	}

	public CloudManagerFault cloudManagerFault(Object... args) {
		return new CloudManagerFault(getMessage(args), this.name());
	}
}
