package com.clustercontrol.cloud.azure.bean;

import org.apache.log4j.Logger;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.azure.AzureOptionPropertyConstants;
import com.clustercontrol.cloud.azure.factory.AzureAsyncExecution;
import com.clustercontrol.cloud.azure.factory.AzureAsyncOperations;
import com.clustercontrol.cloud.azure.factory.AzureStopInstance;
import com.clustercontrol.cloud.azure.util.AzureUtil;
import com.microsoft.windowsazure.Configuration;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.compute.ComputeManagementClient;
import com.microsoft.windowsazure.management.compute.ComputeManagementService;
import com.microsoft.windowsazure.management.compute.DeploymentOperations;
import com.microsoft.windowsazure.management.compute.HostedServiceOperations;
import com.microsoft.windowsazure.management.compute.models.DeploymentGetResponse;
import com.microsoft.windowsazure.management.compute.models.DeploymentSlot;
import com.microsoft.windowsazure.management.compute.models.HostedServiceListResponse;
import com.microsoft.windowsazure.management.compute.models.RoleInstance;
import com.microsoft.windowsazure.management.compute.models.HostedServiceListResponse.HostedService;

public class AzurePendingStopInstance extends AzureAsyncOperations{
	private Logger logger = Logger.getLogger(this.getClass());
	private Configuration config = null;
	private String instanceId = null;
	private String subscriptionId = null;
	
	public AzurePendingStopInstance(Configuration config,String instanceId,String subscriptionId){
		this.config = config;
		this.instanceId = instanceId;
		this.subscriptionId = subscriptionId;
	}
	
	public void execute() throws CloudManagerFault {
		
		try {
			logger.info("Start AzurePendingStopInstance:" + instanceId);
			
			ComputeManagementClient computeManagementClient = ComputeManagementService.create(config);

			DeploymentOperations deploymentOperations = computeManagementClient.getDeploymentsOperations();
			
			HostedServiceOperations hostedServicesOperations = computeManagementClient.getHostedServicesOperations();
			HostedServiceListResponse hostedServiceListResponse = hostedServicesOperations.list();
			for (HostedService hostService: hostedServiceListResponse.getHostedServices()) {
				for (DeploymentSlot slot:AzureUtil.getDeploymentSlots()) {
					DeploymentGetResponse deploymentGetResponse = null;
					try {
			 			deploymentGetResponse = deploymentOperations.getBySlot(hostService.getServiceName(),slot);
		 			}
		 			catch (ServiceException e) {
		 				if (e.getErrorCode().equals("ResourceNotFound"))
		 					continue;
		 				throw new CloudManagerFault(e.getMessage(), e);
		 			}
					for (RoleInstance roleInstance:deploymentGetResponse.getRoleInstances()) {
						if(roleInstance.getRoleName().equals(instanceId)){

							AzureStopInstance azureStopInstance = new AzureStopInstance(config,hostService.getServiceName(),deploymentGetResponse.getName());
				        	
				        	azureStopInstance.setKey("stopInstance"
				        	                          + "@" + subscriptionId
				        	                          + "@" + hostService.getServiceName()
				        	                          + "@" + deploymentGetResponse.getName());
				        	
				        	azureStopInstance.addParams(roleInstance.getInstanceName());
				        	
							if (AzureOptionPropertyConstants.azure_api_mode.value().equalsIgnoreCase("async")) {
								AzureAsyncExecution.getSingleton().merge(azureStopInstance);
							}else{
								azureStopInstance.execute();
							}
							
					        return;
						}
					}
				}
			}
			
			logger.error("Resouce Not Found!" + instanceId);
			throw new CloudManagerFault("ResourceNotFound");
		}catch (Exception e) {
			putLog("AzurePendingStopInstance","AzurePendingStopInstance was failed",e.getMessage());
			throw new CloudManagerFault(e.getMessage(), e);
		} finally {
			logger.info("Finish AzurePendingStopInstance:" + instanceId);
		}
	}
	
}
