package com.clustercontrol.cloud.azure.factory;

import java.util.ArrayList;

import org.apache.log4j.Logger;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.azure.bean.AzureCreateStorageRequest;
import com.clustercontrol.cloud.azure.util.AzureUtil;
import com.microsoft.windowsazure.Configuration;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.OperationStatus;
import com.microsoft.windowsazure.core.OperationStatusResponse;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.compute.ComputeManagementClient;
import com.microsoft.windowsazure.management.compute.ComputeManagementService;
import com.microsoft.windowsazure.management.compute.DeploymentOperations;
import com.microsoft.windowsazure.management.compute.HostedServiceOperations;
import com.microsoft.windowsazure.management.compute.VirtualMachineDiskOperations;
import com.microsoft.windowsazure.management.compute.models.DataVirtualHardDisk;
import com.microsoft.windowsazure.management.compute.models.DeploymentGetResponse;
import com.microsoft.windowsazure.management.compute.models.DeploymentSlot;
import com.microsoft.windowsazure.management.compute.models.HostedServiceListResponse;
import com.microsoft.windowsazure.management.compute.models.Role;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineDataDiskCreateParameters;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineDiskListResponse;
import com.microsoft.windowsazure.management.compute.models.HostedServiceListResponse.HostedService;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineDiskListResponse.VirtualMachineDisk;
import com.microsoft.windowsazure.management.storage.StorageAccountOperations;
import com.microsoft.windowsazure.management.storage.StorageManagementClient;
import com.microsoft.windowsazure.management.storage.StorageManagementService;
import com.microsoft.windowsazure.management.storage.models.StorageAccount;
import com.microsoft.windowsazure.management.storage.models.StorageAccountListResponse;

public class AzureAttachStorage extends AzureAsyncOperations {
	private Logger logger = Logger.getLogger(this.getClass());
	private Configuration config = null;
	private String storageId = null;
	private AzureCreateStorageRequest azureCreateStorageRequest = null;
	
	
	public AzureAttachStorage(Configuration config, String storageId, AzureCreateStorageRequest azureCreateStorageRequest) {
		this.config = config;
		this.storageId = storageId;
		this.azureCreateStorageRequest = azureCreateStorageRequest;
	}
	
	public void execute() throws CloudManagerFault {
		
		String deploymentName = "";
		String cloudServiceName = "";
		VirtualMachineDisk addDisk = new VirtualMachineDisk();
		AzureUtil.AzureServiceResponseFilter reponseFilter = new AzureUtil.AzureServiceResponseFilter();

		try{
	    	logger.info("AzureAttachStorage start: " + storageId );

	    	ComputeManagementClient computeManagementClient = ComputeManagementService.create(config);
	 		StorageManagementClient storageManagementClient = StorageManagementService.create(config);

			DeploymentOperations deploymentOperations = computeManagementClient.getDeploymentsOperations();
			HostedServiceOperations hostedServicesOperations = computeManagementClient.getHostedServicesOperations();

			ArrayList<DataVirtualHardDisk> dataVirtualHardDisks = new ArrayList<>();
	    	HostedServiceListResponse hostedServiceListResponse = hostedServicesOperations.list();
	 		for (HostedService hostService: hostedServiceListResponse.getHostedServices()) {
	 			if(azureCreateStorageRequest.getCloudServiceName().equals(hostService.getServiceName())){
	 				for (DeploymentSlot slot:AzureUtil.getDeploymentSlots()) {
		 				DeploymentGetResponse deploymentGetResponse = null;
			 			try {
				 			deploymentGetResponse = deploymentOperations.getBySlot(hostService.getServiceName(),slot);
			 			}
			 			catch (ServiceException e) {
			 				if (e.getErrorCode().equals("ResourceNotFound"))
			 					continue;
			 				logger.error("AzureAttachStorage: "+ storageId + " (" + e.getErrorCode() +") "+ e.getMessage());
			 	    		throw new CloudManagerFault(e.getMessage(), e);
			 			}
			 			deploymentGetResponse.getRoles();
			 			for (Role role:deploymentGetResponse.getRoles()) {
			 				if(role.getRoleName().equals(azureCreateStorageRequest.getInstanceName())){
			 					deploymentName = deploymentGetResponse.getName();
			 					cloudServiceName = hostService.getServiceName();
			 					for(DataVirtualHardDisk dvhd : role.getDataVirtualHardDisks()){
			 						dataVirtualHardDisks.add(dvhd);
				 				}
			 				}
			 			}
		 			}
	 			}
	 		}

	 		StorageAccountOperations storageAccountOperations = storageManagementClient.getStorageAccountsOperations();
	    	StorageAccountListResponse storageServiceListResponse = storageAccountOperations.list();
	    	VirtualMachineDiskListResponse vmds = computeManagementClient.getVirtualMachineDisksOperations().listDisks();
	    	for(VirtualMachineDisk vmd : vmds.getDisks()){
	    		for (StorageAccount sa: storageServiceListResponse.getStorageAccounts()) {
					String match = sa.getUri().toString().substring(sa.getUri().toString().lastIndexOf("/")+1);
	        		if(vmd.getMediaLinkUri().toString().indexOf("http://"+match+".")==0
	        				|| vmd.getMediaLinkUri().toString().indexOf("https://"+match+".")==0 ){
	        			if(vmd.getName().equals(storageId)){
	        				addDisk = vmd;
	        			}
	        		}
	        	}
	    	}

	    	VirtualMachineDataDiskCreateParameters parameters = new VirtualMachineDataDiskCreateParameters();
	 		parameters.setHostCaching(azureCreateStorageRequest.getVirtualHardDiskHostCaching());
	 		parameters.setName(addDisk.getName());
	 		parameters.setMediaLinkUri(addDisk.getMediaLinkUri());
	 		parameters.setLogicalUnitNumber(azureCreateStorageRequest.getLUN());
	 		VirtualMachineDiskOperations virtualMachineDiskOperations = computeManagementClient.withResponseFilterLast(reponseFilter).getVirtualMachineDisksOperations();
	 		OperationResponse operationResponse = virtualMachineDiskOperations.createDataDisk(cloudServiceName, deploymentName, azureCreateStorageRequest.getInstanceName(), parameters);

	        logger.info("RequestId:" + operationResponse.getRequestId());

	 		for(;;){
	    		OperationStatusResponse operationStatusResponse = computeManagementClient.getOperationStatus(operationResponse.getRequestId());
	 			if (!operationStatusResponse.getStatus().equals(OperationStatus.InProgress)) {
	 				logger.info("attaching " + getClass().getSimpleName() + "...");
	 				if(operationStatusResponse.getStatus().equals(OperationStatus.Succeeded)){
	 					logger.info("successful in attaching " + getClass().getSimpleName() + "...");
	 				}else{
	 					logger.error("failed in attaching " + operationStatusResponse.getError());
	 					putLog("AttacheStorage","AttacheStorage was failed",operationStatusResponse.getError().getMessage());
	 					throw new CloudManagerFault(operationStatusResponse.getError().getMessage(),new Exception(operationStatusResponse.getError().getCode()));
	 				}
	 				break;
	 			}
	    	}

		}catch(ServiceException e){
			if (reponseFilter != null && reponseFilter.getCalled() > 0) {
	    		switch (reponseFilter.getStatus())
	    		{
	    		case org.apache.http.HttpStatus.SC_OK:
	    		case org.apache.http.HttpStatus.SC_ACCEPTED:
	    		case org.apache.http.HttpStatus.SC_CREATED:
	    			reponseFilter.close();
	    			return;
	    		}
			}
			putLog("AttacheStorage","AttacheStorage was failed",e.getMessage());
			throw new CloudManagerFault(e.getMessage(), e);
		}catch(Exception e){
			putLog("AttacheStorage","AttacheStorage was failed",e.getMessage());
			throw new CloudManagerFault(e.getMessage(), e);
	    } finally {
			reponseFilter.close();
	    	logger.info("AzureAttachStorage end: " + storageId );
	    }		
	}
}
