package com.clustercontrol.cloud.azure.factory;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;

import org.apache.log4j.Logger;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.azure.factory.ListBlobsResult.Blob;
import com.clustercontrol.cloud.azure.util.AzureUtil;
import com.microsoft.windowsazure.Configuration;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.storage.StorageAccountOperations;
import com.microsoft.windowsazure.management.storage.StorageManagementClient;
import com.microsoft.windowsazure.management.storage.StorageManagementService;
import com.microsoft.windowsazure.services.blob.BlobContract;
import com.microsoft.windowsazure.services.blob.BlobService;

public class AzureDeleteStorageBackup extends AzureAsyncOperations {
	private Logger logger = Logger.getLogger(this.getClass());
	private String storageBackupId = null;
	private Configuration config = null;
	
	public AzureDeleteStorageBackup(Configuration config, String storageBackupId) {
		this.config = config;
		this.storageBackupId = storageBackupId;
	}
	
	public void execute() throws CloudManagerFault {
		
		StorageAccountOperations storageAccountOperations = null;
		AzureUtil.AzureServiceRequestFilter request_find = null;
		AzureUtil.AzureServiceResponseFilter response_find = null;

		try {
	    	logger.info("AzureDeleteStorageBackup start: " + storageBackupId );
			
			String snapshotID = "";
	    	String storageAccountName = storageBackupId.substring(0, storageBackupId.indexOf("_"));
	    	String containerName = storageBackupId.substring(storageBackupId.indexOf("_")+1);
	    	containerName = containerName.substring(0, containerName.indexOf("_"));
		
			StorageManagementClient storageManagementClient = StorageManagementService.create(config);
			storageAccountOperations = storageManagementClient.getStorageAccountsOperations();
			
			snapshotID = AzureUtil.getConvertSnapshotValue(storageBackupId.substring(storageBackupId.lastIndexOf("_")+1));
			
			Configuration blobconfig = null;
    		blobconfig = AzureUtil.getBlobConfiguration(storageAccountName, storageAccountOperations.getKeys(storageAccountName).getPrimaryKey());
			
    		request_find = new AzureUtil.AzureServiceRequestFilter();
    		response_find = new AzureUtil.AzureServiceResponseFilter();
    		request_find.changeURL("?", containerName+"?restype=container&include=snapshots&");
    		response_find.setUseBody();
			
    		BlobContract blobContract_find = BlobService.create(blobconfig).withRequestFilterLast(request_find).withResponseFilterLast(response_find);
    		blobContract_find.listContainers();
			
			JAXBContext jaxbContext = JAXBContext.newInstance(ListBlobsResult.class);     
			Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
			ListBlobsResult listBlobsResult = (ListBlobsResult)jaxbUnmarshaller.unmarshal(response_find.getInputStream());
			response_find.close();
			
			for(Blob blob:listBlobsResult.getBlobs()){
				if(blob.getSnapshot()!=null && blob.getSnapshot().equals(snapshotID)){
					AzureUtil.AzureServiceRequestFilter request_del = new AzureUtil.AzureServiceRequestFilter();
					AzureUtil.AzureServiceResponseFilter response_del = new AzureUtil.AzureServiceResponseFilter();
					request_del.changeURL(blob.getName(),blob.getName()+"?snapshot="+snapshotID);
					BlobContract blobContract_del = BlobService.create(blobconfig).withRequestFilterLast(request_del).withResponseFilterLast(response_del);
                	logger.info("BlobContract.deleteBlob(" + containerName +","+ blob.getName()+ ",snapshot="+snapshotID +")");
					blobContract_del.deleteBlob(containerName, blob.getName());
					response_del.close();
					logger.info("Deleting Storage backup is success...");
					break;
				}
			}
		}catch(ServiceException e){
	    	logger.error("Deleting Storage backup is failed...");
			logger.error("AzureDeleteStorageBackup: (" + e.getErrorCode() +") "+ e.getMessage());
			putLog("DeleteStorageBackup","DeleteStorageBackup was failed",e.getMessage());
			throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), e);
		}catch(Exception e){
	    	logger.error("Deleting Storage backup is failed...");
			logger.error("AzureDeleteStorageBackup: " + e.getMessage());
			putLog("DeleteStorageBackup","DeleteStorageBackup was failed",e.getMessage());
			throw new CloudManagerFault(e.getMessage(), e);
	    } finally {
	    	logger.info("AzureDeleteStorageBackup end: " + storageBackupId );
	    	if (response_find != null) {
	    		response_find.close();
	    		response_find = null;
        	}
	    }		
	}
}
