/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.ws.azure;

import java.io.Serializable;
import java.util.List;

import com.microsoft.windowsazure.management.compute.models.DataVirtualHardDisk;

public class InstanceInfo implements Serializable {
    /**
	 * 
	 */
	private static final long serialVersionUID = 1701183873638473865L;

    private String instanceName;
    private String deploymentName;
    private String size;
    private String osType;
    private Integer diskNumber;
    private List<Integer> attachedLun;
    private Integer dataDiskAttachableNum;
    private List<DataVirtualHardDisk> dvhds;

    public String getInstanceName() {
		return instanceName;
	}
	public void setInstanceName(String instanceName) {
		this.instanceName = instanceName;
	}
	public String getDeploymentName() {
		return deploymentName;
	}
	public void setDeploymentName(String deploymentName) {
		this.deploymentName = deploymentName;
	}
	
	public String getSize() {
		return size;
	}
	public void setSize(String size) {
		this.size = size;
	}
	
	public Integer getDiskNumber(){
		return this.diskNumber;
	}
	
	public void setDiskNumber(Integer diskNumber){
		this.diskNumber = diskNumber;
	}
	
	public void setAttachedLun(List<Integer> attachedLun){
		this.attachedLun = attachedLun;
	}
	
	public void addAttachedLun(Integer lun){
		this.attachedLun.add(lun);
	}
	
	public List<Integer> getAttachedLun(){
		return this.attachedLun;
	}
	
	public void setDataDiskAttachableNum(Integer dataDiskAttachableNum){
		this.dataDiskAttachableNum = dataDiskAttachableNum;
	}
	
	public Integer getDataDiskAttachableNum(){
		return this.dataDiskAttachableNum;
	}
	
	public void setOSType(String osType){
		this.osType = osType;
	}
	
	public String getOSType(){
		return this.osType;
	}
	
	public void setDataVirtualHardDisks(List<DataVirtualHardDisk> dvhds){
		this.dvhds = dvhds;
	}
	
	public List<DataVirtualHardDisk> getDataVirtualHardDisks(){
		return this.dvhds;
	}
	
}