/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud;

import java.util.Arrays;
import java.util.List;

import com.clustercontrol.cloud.validation.annotation.ElementId;
import com.clustercontrol.cloud.validation.annotation.NotNull;
import com.clustercontrol.cloud.validation.annotation.NotNullContainer;

public class Filter {
	private String name;
    private List<String> values;
	
	public Filter() {
	}

	public Filter(String name, String... values) {
		this.name = name;
		this.values = Arrays.asList(values);
	}
	
	public Filter(String name, List<String> values) {
		this.name = name;
		this.values = values;
	}
	@ElementId("Filter_name")
	@NotNull
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	@ElementId("Filter_value")
//	@ListElement
	@NotNullContainer
	@NotNull
	public List<String> getValues() {
		return values;
	}
	public void setValues(List<String> values) {
		this.values = values;
	}
}
