/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.persistence;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Date;

@Retention(RetentionPolicy.RUNTIME)  
@Target(ElementType.METHOD)
@ProcessedBy(ApplyCurrentTime.ApplyCurrentTimeProcessor.class)
public @interface ApplyCurrentTime {
	public class ApplyCurrentTimeProcessor extends AbstractProcessor<ApplyCurrentTime> {
		@Override
		public void prePersist(Object entity) throws Exception {
			setMethod.invoke(entity, new java.sql.Timestamp(new Date().getTime()));
		}
		@Override
		public void preUpdate(Object entity) throws Exception {
			if (!annotation.onlyPersist()) {
				setMethod.invoke(entity, new java.sql.Timestamp(new Date().getTime()));
			}
		}
	}
	
	boolean onlyPersist() default false;
}