/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud;

import java.util.Date;
import java.util.List;

import com.clustercontrol.cloud.IResourceManagement.ICredential;

public interface ICloudOption {
	public static class Billing {
		private String currency;
		private double price;
		private Date updateDate;

		public double getPrice() {
			return price;
		}
		public void setPrice(double price) {
			this.price = price;
		}
		public String getCurrency() {
			return currency;
		}
		public void setCurrency(String currency) {
			this.currency = currency;
		}
		public Date getUpdateDate() {
			return updateDate;
		}
		public void setUpdateDate(Date updateDate) {
			this.updateDate = updateDate;
		}
	}
	
	void setCredential(ICredential credential);
	ICredential getCledential();

	Billing getBillingForCloudService(String target) throws CloudManagerFault;
	List<String> getCloudServicesForBilling() throws CloudManagerFault;
}