/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.bean;

import java.util.ArrayList;
import java.util.List;

import com.clustercontrol.cloud.validation.annotation.ElementId;
import com.clustercontrol.cloud.validation.annotation.Identity;
import com.clustercontrol.cloud.validation.annotation.Into;
import com.clustercontrol.cloud.validation.annotation.NotNull;

/**
 * テンプレート付きクラウドインスタンス作成要求に必要な情報を保持するクラス。 
 * {@link com.clustercontrol.ws.cloud.CloudEndpoint#addInstanceByTemplate(String,String,CreateInstanceByTemplateRequest) addInstanceByTemplate 関数} にて使用される。
 *
 */
public class CreateInstanceByTemplateRequest extends CloudRequest {
	private NodeDetail nodeDetail;

	private String flavor;
	private String templateId;
	private String zone;
	private String instanceDetail;
	private List<Tag> tags = new ArrayList<Tag>();
	
	private List<TemplateJobsArgument> arguments;

	/**
	 * ノード作成に必要な情報を返す。
	 * 
	 * @return ノード作成情報。
	 */
	@ElementId("NodeDetail")
	@NotNull
	@Into
	public NodeDetail getNodeDetail() {
		return nodeDetail;
	}

	/**
	 * ノード作成情報を指定する。
	 * この値は、{@link com.clustercontrol.ws.cloud.CloudEndpoint#addInstanceByTemplate(String,String,CreateInstanceByTemplateRequest) addInstanceByTemplate 関数} を実行する際、必須となります。
	 * 
	 * @param nodeDetail ノード作成情報。
	 */
	public void setNodeDetail(NodeDetail nodeDetail) {
		this.nodeDetail = nodeDetail;
	}

	/**
	 * 使用するテンプレートの Id を取得する。
	 * 
	 * @return テンプレート Id
	 */
	@ElementId("templateId")
	@Identity
	public String getTemplateId() {
		return templateId;
	}

	/**
	 * 使用するテンプレートの Id を指定する。
	 * この値は、64 文字以内で、{@link com.clustercontrol.ws.cloud.CloudEndpoint#addInstanceByTemplate(String,String,CreateInstanceByTemplateRequest) addInstanceByTemplate 関数} を実行する際、必須となります。
	 * 
	 * @param templateId テンプレート Id
	 */
	public void setTemplateId(String templateId) {
		this.templateId = templateId;
	}

	/**
	 * インスタンスを配置するゾーンを取得する。
	 * 
	 * @return インスタンスを配置するゾーン。
	 */
	public String getZone() {
		return zone;
	}
	/**
	 * インスタンスを配置するゾーンを設定する。
	 * 
	 * @param zone インスタンスを配置するゾーン。
	 */
	public void setZone(String zone) {
		this.zone = zone;
	}
	
	/**
	 * インスタンスへ設定するタグの一覧を取得する。
	 * 
	 * @return インスタンスへ設定するタグの一覧。
	 */
	@NotNull
	@ElementId("tags")
	public List<Tag> getTags() {
		return tags;
	}
	/**
	 * インスタンスへ設定するタグの一覧を設定する。
	 * 
	 * @param tags インスタンスへ設定するタグの一覧。
	 */
	public void setTags(List<Tag> tags) {
		this.tags = tags;
	}
	
	/**
	 * テンプレートジョブに渡す引数リストを取得する。
	 * 
	 * @return ジョブの引数リスト
	 */
	@NotNull
	@ElementId("templateArguments")
	public List<TemplateJobsArgument> getArguments() {
		return arguments;
	}

	/**
	 * テンプレートジョブに渡す引数リストを指定する。
	 * 
	 * @param arguments ジョブの引数リスト
	 */
	public void setArguments(List<TemplateJobsArgument> arguments) {
		this.arguments = arguments;
	}

	/**
	 * クラウド側へ指定するインスタンスの種別を取得する。
	 * 
	 * @return クラウド側へ指定するインスタンスの種別。
	 */
	public String getFlavor() {
		return flavor;
	}
	/**
	 * クラウド側へ指定するインスタンスの種別を設定する。
	 * 
	 * @param flavor クラウド側へ指定するインスタンスの種別
	 */
	public void setFlavor(String flavor) {
		this.flavor = flavor;
	}

	/**
	 * インスタンス作成に際し必要なクラウド固有の情報を取得する。
	 * 
	 * @return インスタンス作成に際し必要なクラウド固有の情報。
	 */
	public String getInstanceDetail() {
		return instanceDetail;
	}
	/**
	 * インスタンス作成に際し必要なクラウド固有の情報を設定する。
	 * 
	 * @param instanceDetail インスタンス作成に際し必要なクラウド固有の情報。
	 */
	public void setInstanceDetail(String instanceDetail) {
		this.instanceDetail = instanceDetail;
	}
}
