/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.bean;

import com.clustercontrol.cloud.validation.annotation.ElementId;
import com.clustercontrol.cloud.validation.annotation.Identity;
import com.clustercontrol.cloud.validation.annotation.IdentityNullAllow;
import com.clustercontrol.cloud.validation.annotation.NotNull;
import com.clustercontrol.cloud.validation.annotation.Size;

/**
 */
public class CreateTemplateRequest extends CloudRequest {
	private String templateId;
	private String templateName;

	private String region;
	private String imageId;

	private String launchJobId;
	private String startJobId;
	private String stopJobId;
	
	/**
	 * ストレージ名を取得します。
	 * 
	 * @return ストレージ名。
	 */
	@ElementId("templateId")
	@Identity
	public String getTemplateId() {
		return templateId;
	}
	public void setTemplateId(String templateId) {
		this.templateId = templateId;
	}

	@ElementId("templateName")
	@Size(max = 128)
	public String getTemplateName() {
		return templateName;
	}
	public void setTemplateName(String templateName) {
		this.templateName = templateName;
	}

	@ElementId("region")
	@NotNull
	@Size(max = 64)
	public String getRegion() {
		return region;
	}
	public void setRegion(String region) {
		this.region = region;
	}
	
	@ElementId("imageId")
	@NotNull
	@Size(max = 1024)
	public String getImageId() {
		return imageId;
	}
	public void setImageId(String imageId) {
		this.imageId = imageId;
	}

	/**
	 * 起動ジョブ Id を取得する。
	 * 
	 * @return 起動ジョブ Id。
	 */
	@ElementId("launchJobId")
	@IdentityNullAllow
	public String getLaunchJobId() {
		return launchJobId;
	}

	/**
	 * 起動ジョブ Id を指定する。null 可。
	 * 
	 * @param launchJobId 起動ジョブ Id。
	 */
	public void setLaunchJobId(String launchJobId) {
		this.launchJobId = launchJobId;
	}

	/**
	 * 開始ジョブ Id を取得する。
	 * 
	 * @return 開始ジョブ Id。
	 */
	@ElementId("startJobId")
	@IdentityNullAllow
	public String getStartJobId() {
		return startJobId;
	}

	/**
	 * 開始ジョブ Id を指定する。null 可。
	 * 
	 * @param startJobId 開始ジョブ Id。
	 */
	public void setStartJobId(String startJobId) {
		this.startJobId = startJobId;
	}

	/**
	 * 停止ジョブ Id を取得する。
	 * 
	 * @return 停止ジョブ Id。
	 */
	@ElementId("stopJobId")
	@IdentityNullAllow
	public String getStopJobId() {
		return stopJobId;
	}

	/**
	 * 停止ジョブ Id を指定する。null 可。
	 * 
	 * @param stopJobId 停止ジョブ Id。
	 */
	public void setStopJobId(String stopJobId) {
		this.stopJobId = stopJobId;
	}
}
