/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.bean;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.ErrorCode;
import com.clustercontrol.cloud.IMessagesHolder;
import com.clustercontrol.cloud.IUserManagement;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.factory.CloudAccessorUtil;
import com.clustercontrol.cloud.factory.ICloudUserOperator;
import com.clustercontrol.cloud.registry.ObjectRegistryService;
import com.clustercontrol.cloud.util.AuthorizingUtil;
import com.clustercontrol.cloud.validation.CustomEntityValidator;
import com.clustercontrol.cloud.validation.EntityValidator.EntityValidationContext;
import com.clustercontrol.cloud.validation.ValidationConstants;
import com.clustercontrol.cloud.validation.ValidationFault;
import com.clustercontrol.cloud.validation.annotation.CustomEntityValidation;
import com.clustercontrol.cloud.validation.annotation.ElementId;
import com.clustercontrol.cloud.validation.annotation.Identity;
import com.clustercontrol.cloud.validation.annotation.Size;

@CustomEntityValidation(ModifyCloudUserRequest.CloudUserValidator.class)
public class ModifyCloudUserRequest {
	public static class CloudUserValidator implements CustomEntityValidator<ModifyCloudUserRequest>, ValidationConstants {
		@Override
		public void validate(final ModifyCloudUserRequest entity, String group, IMessagesHolder messages, EntityValidationContext context) throws ValidationFault {
			try {
				if (
					!AuthorizingUtil.checkHinemousUser_administrators_account_self(SessionService.current().getHinemosCredential().getUserId(), entity.getCloudUserId())
					) {
					throw ErrorCode.NEED_ADMINISTRATORS_ROLE_OR_ACCOUT_USER_OR_SELF.cloudManagerFault(SessionService.current().getHinemosCredential().getUserId(), entity.getCloudUserId());
				}
				
				// 編集後のアクセスキー とシークレットキーについて、アカウントの場合にアカウント用のものが設定されているか確認。
				ICloudUserOperator userOperator = ObjectRegistryService.registry().get(ICloudUserOperator.class);
				CloudUser cu = userOperator.findCloudUser(entity.getCloudUserId());
				IUserManagement.User user = CloudAccessorUtil.getUser(
						cu.getAccountResourceId(),
						entity.getAccessKey() == null ? cu.getAccessKey(): entity.getAccessKey(),
						entity.getSecretKey() == null ? cu.getSecretKey(): entity.getSecretKey());

				switch (cu.getCloudUserType()) {
				case account:
					if (user.getKind() != IUserManagement.User.UserKind.account) {
						throw new ValidationFault(ErrorCode.CLOUDUSER_INVALID_USE_ONLY_ACCOUNT.getMessage(), ErrorCode.CLOUDUSER_INVALID_USE_ONLY_ACCOUNT.name());
					}
					break;
				case user:
					break;
				}
			}
			catch (CloudManagerFault e) {
				throw new ValidationFault(e.getMessage(), e.getErrorCode(), e);
			}
		}
	}

	private String cloudUserId;
	private String cloudUserName;
	private String description;
	private String accessKey;
	private String secretKey;
	
	@ElementId("cloudUserId")
	@Identity
	public String getCloudUserId() {
		return cloudUserId;
	}
	public void setCloudUserId(String cloudUserId) {
		this.cloudUserId = cloudUserId;
	}
	@ElementId("cloudUserName")
	@Size(max=128)
	public String getCloudUserName() {
		return cloudUserName;
	}
	public void setCloudUserName(String cloudUserName) {
		this.cloudUserName = cloudUserName;
	}
	@ElementId("description")
	@Size(max = 256)
	public String getDescription() {
		return description;
	}
	public void setDescription(String description) {
		this.description = description;
	}
	public String getAccessKey() {
		return accessKey;
	}
	public void setAccessKey(String accessKey) {
		this.accessKey = accessKey;
	}
	public String getSecretKey() {
		return secretKey;
	}
	public void setSecretKey(String secretKey) {
		this.secretKey = secretKey;
	}
}