/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.util;

import java.util.List;

import javax.persistence.Query;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.dao.CloudUserDao;
import com.clustercontrol.cloud.persistence.EntityManagerEx;
import com.clustercontrol.commons.util.HinemosSessionContext;

public class AuthorizingUtil {
	
	public static boolean checkHinemousUser_administrators_account(String hinemousUserId, String accountResourceId) throws CloudManagerFault {
		if (
			!Boolean.TRUE.equals(HinemosSessionContext.instance().getProperty(HinemosSessionContext.IS_ADMINISTRATOR))
			) {
			
			EntityManagerEx em = SessionService.current().getEntityManagerEx();
			Query query = em.createQuery("SELECT c FROM UserEntity u JOIN u.roleEntities r JOIN CloudUserDao AS c ON c.roleId = r.roleId JOIN c.accountResource a " + 
					"WHERE u.userId = :userId AND a.accountResourceId = :accountResourceId AND c.cloudUserType = :cloudUserType");
			query.setParameter("userId", hinemousUserId);
			query.setParameter("accountResourceId", accountResourceId);
			query.setParameter("cloudUserType", CloudUserDao.CloudUserType.account);
			
			@SuppressWarnings("unchecked")
			List<CloudUserDao> daos = (List<CloudUserDao>)query.getResultList();

			return !daos.isEmpty();
		}
		else return true;
	}
	
	public static boolean checkHinemousUser_administrators_account_self(String hinemousUserId, String cloudUserId) throws CloudManagerFault {
		if (
			!Boolean.TRUE.equals(HinemosSessionContext.instance().getProperty(HinemosSessionContext.IS_ADMINISTRATOR))
			) {
			
			EntityManagerEx em = SessionService.current().getEntityManagerEx();
			Query query = em.createQuery("SELECT c FROM UserEntity u JOIN u.roleEntities r JOIN CloudUserDao AS c ON c.roleId = r.roleId JOIN c.accountResource a " + 
					"WHERE u.userId = :userId AND (c.cloudUserId = :cloudUserId OR (a.accountResourceId = (SELECT a2.accountResourceId FROM CloudUserDao AS c2 JOIN c.accountResource a2 WHERE c2.cloudUserId = :cloudUserId) " +
					"AND c.cloudUserType = :cloudUserType))");
			query.setParameter("userId", SessionService.current().getHinemosCredential().getUserId());
			query.setParameter("cloudUserId", cloudUserId);
			query.setParameter("cloudUserType", CloudUserDao.CloudUserType.account);
			
			@SuppressWarnings("unchecked")
			List<CloudUserDao> daos = (List<CloudUserDao>)query.getResultList();

			return !daos.isEmpty();
		}
		else return true;
	}
	
//	public static void checkCloudUserByCloudUserId_administrators_account(String cloudUserId) throws CloudManagerFault {
//		if (
//			!Boolean.TRUE.equals(HinemosSessionContext.instance().getProperty(HinemosSessionContext.IS_ADMINISTRATOR))
//			) {
//			
//			EntityManagerEx em = SessionService.current().getEntityManagerEx();
//			Query query = em.createQuery("SELECT c FROM UserEntity u JOIN u.roleEntities r JOIN CloudUserDao AS c ON c.roleId = r.roleId JOIN c.accountResource a " + 
//					"WHERE u.userId = :userId AND a.accountResourceId = (SELECT a2.accountResourceId FROM CloudUserDao AS c2 JOIN c.accountResource a2 WHERE c2.cloudUserId = :cloudUserId) " +
//					"AND c.cloudUserType = :cloudUserType");
//			query.setParameter("userId", SessionService.current().getHinemosCredential().getUserId());
//			query.setParameter("cloudUserId", cloudUserId);
//			query.setParameter("cloudUserType", CloudUserDao.CloudUserType.account);
//			
//			@SuppressWarnings("unchecked")
//			List<CloudUserDao> daos = (List<CloudUserDao>)query.getResultList();
//
//			if (daos.isEmpty()) {
//				throw ErrorCode.NEED_ADMINISTRATORS_ROLE_OR_ACCOUT_USER.cloudManagerFaultByIndex(1, SessionService.current().getHinemosCredential().getUserId(), cloudUserId);
//			}
//		}
//	}
}