/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.core.pipeline.apache;

import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestContext;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.protocol.HttpContext;

public class HttpServiceRequestContext
implements ServiceRequestContext {
    private final HttpRequest clientRequest;
    private final HttpContext httpContext;

    public HttpServiceRequestContext(HttpRequest clientRequest, HttpContext httpContext) {
        this.clientRequest = clientRequest;
        this.httpContext = httpContext;
    }

    @Override
    public Object getProperty(String name) {
        return this.httpContext.getAttribute(name);
    }

    @Override
    public void setProperty(String name, Object value) {
        this.httpContext.setAttribute(name, value);
    }

    @Override
    public URI getURI() {
        try {
            return new URI(this.clientRequest.getRequestLine().getUri());
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    @Override
    public void setURI(URI uri) {
    }

    @Override
    public String getMethod() {
        return this.clientRequest.getRequestLine().getMethod();
    }

    @Override
    public void setMethod(String method) {
    }

    @Override
    public Object getEntity() {
        return null;
    }

    @Override
    public void setEntity(Object entity) {
    }

    @Override
    public String getHeader(String name) {
        Header first = this.clientRequest.getFirstHeader(name);
        return first != null ? first.getValue() : null;
    }

    @Override
    public void setHeader(String name, String value) {
        this.clientRequest.setHeader(name, value);
    }

    @Override
    public void removeHeader(String name) {
        this.clientRequest.removeHeaders(name);
    }
}

