/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.commons;

import com.clustercontrol.cloud.commons.PropValidator;
import com.clustercontrol.cloud.commons.PropertyContract;
import com.clustercontrol.cloud.util.HinemosUtil;
import com.clustercontrol.commons.util.HinemosProperties;
import org.apache.log4j.Logger;

public enum CloudPropertyConstants implements PropertyContract
{
    billingalarm_notify_interval("hinemos.cloud.billing.notify.interval", "0 15 * * * ?"),
    autoupdate_node("hinemos.cloud.autoupdate.node", "on", (PropValidator)PropValidator.switchValidator),
    autoupdate_mount("hinemos.cloud.autoupdate.mount", "on", (PropValidator)PropValidator.switchValidator),
    autoupdate_instance("hinemos.cloud.autoupdate.instance", "on", (PropValidator)PropValidator.switchValidator),
    autoupdate_storage("hinemos.cloud.autoupdate.storage", "on", (PropValidator)PropValidator.switchValidator),
    autoupdate_backup("hinemos.cloud.autoupdate.backup", "on", (PropValidator)PropValidator.switchValidator),
    autoupdate_interval("hinemos.cloud.autoupdate.interval", "0 */10 * * * ?"),
    internal_thread_admin_user("hinemos.cloud.internal_thread.admin.user", "hinemos"),
    autoregist_scope_relation("hinemos.cloud.autoregist.scope.relation", "on", (PropValidator)PropValidator.switchValidator),
    autoregist_instance("hinemos.cloud.autoregist.instance", "on", (PropValidator)PropValidator.switchValidator),
    autoregist_storage("hinemos.cloud.autoregist.storage", "on", (PropValidator)PropValidator.switchValidator),
    password_crypt_key("hinemos.cloud.password.crypt.key", "hinemos"),
    registcheck_interval("hinemos.cloud.registcheck.interval", String.valueOf(10000), PropValidator.intValidator),
    registcheck_count("hinemos.cloud.registcheck.count", String.valueOf(30), PropValidator.intValidator),
    agent_connection_interval("agent.connection.interval", String.valueOf(10000), PropValidator.intValidator),
    agent_connection_count("agent.connection.count", String.valueOf(30), PropValidator.intValidator),
    templatejob_endcheck_interval("hinemos.cloud.templatejob.endcheck.interval", String.valueOf(10000), PropValidator.intValidator),
    templatejob_endcheck_count("hinemos.cloud.templatejob.endcheck.count", String.valueOf(30), PropValidator.intValidator),
    templatejob_script_file_dir("hinemos.cloud.templatejob.scriptfile.dir", "var/cloud/"),
    proxy("hinemos.cloud.proxy", "on", (PropValidator)PropValidator.switchValidator),
    node_property_agent_awakeport("hinemos.cloud.node.property.agent.awakeport", null),
    node_property_job_priority("hinemos.cloud.node.property.job.priority", null),
    node_property_job_multiplicity("hinemos.cloud.node.property.job.multiplicity", null),
    node_property_snmp_port("hinemos.cloud.node.property.snmp.port", null),
    node_property_snmp_community("hinemos.cloud.node.property.snmp.community", null),
    node_property_snmp_version("hinemos.cloud.node.property.snmp.version", null),
    node_property_snmp_timeout("hinemos.cloud.node.property.snmp.timeout", null),
    node_property_snmp_rRetries("hinemos.cloud.node.property.snmp.rRetries", null),
    node_property_wbem_user("hinemos.cloud.node.property.wbem.user", null),
    node_property_wbem_userpassword("hinemos.cloud.node.property.wbem.userpassword", null),
    node_property_wbem_port("hinemos.cloud.node.property.wbem.port", null),
    node_property_wbem_protocol("hinemos.cloud.node.property.wbem.protocol", null),
    node_property_wbem_timeout("hinemos.cloud.node.property.wbem.timeout", null),
    node_property_wbem_retries("hinemos.cloud.node.property.wbem.retries", null),
    node_property_ipmi_ipaddress("hinemos.cloud.node.property.ipmi.ipaddress", null),
    node_property_ipmi_port("hinemos.cloud.node.property.ipmi.port", null),
    node_property_ipmi_user("hinemos.cloud.node.property.ipmi.user", null),
    node_property_ipmi_userpassword("hinemos.cloud.node.property.ipmi.userpassword", null),
    node_property_ipmi_timeout("hinemos.cloud.node.property.ipmi.timeout", null),
    node_property_ipmi_retries("hinemos.cloud.node.property.ipmi.retries", null),
    node_property_ipmi_protocol("hinemos.cloud.node.property.ipmi.protocol", null),
    node_property_ipmi_level("hinemos.cloud.node.property.ipmi.level", null),
    node_property_winrm_user("hinemos.cloud.node.property.winrm.user", null),
    node_property_winrm_userpassword("hinemos.cloud.node.property.winrm.userpassword", null),
    node_property_winrm_version("hinemos.cloud.node.property.winrm.version", null),
    node_property_winrm_port("hinemos.cloud.node.property.winrm.port", null),
    node_property_winrm_protocol("hinemos.cloud.node.property.winrm.protocol", null),
    node_property_winrm_timeout("hinemos.cloud.node.property.winrm.timeout", null),
    node_property_winrm_retries("hinemos.cloud.node.property.winrm.retries", null),
    node_property_node_variablename("hinemos.cloud.node.property.node.variablename", null),
    node_property_node_variablevalue("hinemos.cloud.node.property.node.variablevalue", null),
    node_property_administrator("hinemos.cloud.node.property.administrator", null),
    node_property_contact("hinemos.cloud.node.property.contact", null);

    public final String id;
    public final String value;
    public final PropValidator validator;

    private CloudPropertyConstants(String id, String value) {
        this.id = id;
        this.value = value;
        this.validator = null;
    }

    private CloudPropertyConstants(String id, String value, PropValidator validator) {
        this.id = id;
        this.value = value;
        this.validator = validator;
    }

    public String value() {
        String prop = HinemosProperties.getProperty((String)this.id, (String)this.value);
        if (this.validator != null) {
            try {
                this.validator.validate(prop);
            }
            catch (Exception e) {
                Logger logger = Logger.getLogger(CloudPropertyConstants.class);
                logger.error((Object)(this.id + " is invalid(" + prop + "), using default value(" + this.value + ")."));
                prop = this.value;
            }
        }
        return prop;
    }

    public boolean match(String value) {
        return this.value().equals(value);
    }

    public String defaultValue() {
        return this.value;
    }

    static {
        HinemosUtil.putUserDefinedNodePropertyList((String)"agentAwakePort", (String)node_property_agent_awakeport.value());
        HinemosUtil.putUserDefinedNodePropertyList((String)"jobPriority", (String)node_property_job_priority.value());
        HinemosUtil.putUserDefinedNodePropertyList((String)"jobMultiplicity", (String)node_property_job_multiplicity.value());
        HinemosUtil.putUserDefinedNodePropertyList((String)"snmpPort", (String)node_property_snmp_port.value());
        HinemosUtil.putUserDefinedNodePropertyList((String)"snmpCommunity", (String)node_property_snmp_community.value());
        HinemosUtil.putUserDefinedNodePropertyList((String)"snmpVersion", (String)node_property_snmp_version.value());
        HinemosUtil.putUserDefinedNodePropertyList((String)"snmpTimeout", (String)node_property_snmp_timeout.value());
        HinemosUtil.putUserDefinedNodePropertyList((String)"snmpRetries", (String)node_property_snmp_rRetries.value());
        HinemosUtil.putUserDefinedNodePropertyList((String)"wbemUser", (String)node_property_wbem_user.value());
        HinemosUtil.putUserDefinedNodePropertyList((String)"wbemUserPassword", (String)node_property_wbem_userpassword.value());
        HinemosUtil.putUserDefinedNodePropertyList((String)"wbemPort", (String)node_property_wbem_port.value());
        HinemosUtil.putUserDefinedNodePropertyList((String)"wbemProtocol", (String)node_property_wbem_protocol.value());
        HinemosUtil.putUserDefinedNodePropertyList((String)"wbemTimeout", (String)node_property_wbem_timeout.value());
        HinemosUtil.putUserDefinedNodePropertyList((String)"wbemRetries", (String)node_property_wbem_retries.value());
        HinemosUtil.putUserDefinedNodePropertyList((String)"ipmiIpAddress", (String)node_property_ipmi_ipaddress.value());
        HinemosUtil.putUserDefinedNodePropertyList((String)"ipmiPort", (String)node_property_ipmi_port.value());
        HinemosUtil.putUserDefinedNodePropertyList((String)"ipmiUser", (String)node_property_ipmi_user.value());
        HinemosUtil.putUserDefinedNodePropertyList((String)"ipmiUserPassword", (String)node_property_ipmi_userpassword.value());
        HinemosUtil.putUserDefinedNodePropertyList((String)"ipmiTimeout", (String)node_property_ipmi_timeout.value());
        HinemosUtil.putUserDefinedNodePropertyList((String)"ipmiRetries", (String)node_property_ipmi_retries.value());
        HinemosUtil.putUserDefinedNodePropertyList((String)"ipmiProtocol", (String)node_property_ipmi_protocol.value());
        HinemosUtil.putUserDefinedNodePropertyList((String)"ipmiLevel", (String)node_property_ipmi_level.value());
        HinemosUtil.putUserDefinedNodePropertyList((String)"winrmUser", (String)node_property_winrm_user.value());
        HinemosUtil.putUserDefinedNodePropertyList((String)"winrmUserPassword", (String)node_property_winrm_userpassword.value());
        HinemosUtil.putUserDefinedNodePropertyList((String)"winrmVersion", (String)node_property_winrm_version.value());
        HinemosUtil.putUserDefinedNodePropertyList((String)"winrmPort", (String)node_property_winrm_port.value());
        HinemosUtil.putUserDefinedNodePropertyList((String)"winrmProtocol", (String)node_property_winrm_protocol.value());
        HinemosUtil.putUserDefinedNodePropertyList((String)"winrmTimeout", (String)node_property_winrm_timeout.value());
        HinemosUtil.putUserDefinedNodePropertyList((String)"winrmRetries", (String)node_property_winrm_retries.value());
        HinemosUtil.putUserDefinedNodePropertyList((String)"nodeVariableName", (String)node_property_node_variablename.value());
        HinemosUtil.putUserDefinedNodePropertyList((String)"nodeVariableValue", (String)node_property_node_variablevalue.value());
        HinemosUtil.putUserDefinedNodePropertyList((String)"administrator", (String)node_property_administrator.value());
        HinemosUtil.putUserDefinedNodePropertyList((String)"contact", (String)node_property_contact.value());
    }
}

