/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.validation;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.ErrorCode;
import com.clustercontrol.cloud.IMessagesHolder;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.persistence.EntityManagerEx;
import com.clustercontrol.cloud.validation.ValidationFault;
import com.clustercontrol.cloud.validation.ValidationUtil;
import com.clustercontrol.cloud.validation.annotation.ValidatedBy;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.persistence.NoResultException;
import javax.persistence.Query;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD, ElementType.PARAMETER})
@ValidatedBy(value=Validator.class)
public @interface AccessibleAccountResource {
    public String elementId() default "";

    public String validationId() default "com.clustercontrol.cloud.validation.AccountResourceAccessibleValidator";

    public String[] groups() default {};

    public static class Validator
    extends ValidationUtil.AbstractValidator<AccessibleAccountResource, String> {
        public void init(AccessibleAccountResource annotation) {
            this.setElementId(annotation.elementId());
            this.setValidationId(annotation.validationId());
            this.setGroups(annotation.groups());
        }

        protected void internalValidate(String property, String group, IMessagesHolder messages) throws ValidationFault {
            if (property == null || property.isEmpty()) {
                return;
            }
            EntityManagerEx em = SessionService.current().getEntityManagerEx();
            Query query = em.createQuery("SELECT DISTINCT u.accountResource FROM CloudUserDao u, UserEntity h, RoleEntity r WHERE u.accountResource.accountResourceId = :accountResourceId AND h.userId = :userId AND h MEMBER OF r.userEntities AND r.roleId = u.roleId");
            query.setParameter("accountResourceId", (Object)property);
            query.setParameter("userId", (Object)SessionService.current().getHinemosCredential().getUserId());
            try {
                query.getSingleResult();
            }
            catch (NoResultException e) {
                CloudManagerFault f = ErrorCode.ACCOUNTRESOURCE_INVALID_ACCOUNTRESOURCE_NOT_FOUND.cloudManagerFault(property);
                throw new ValidationFault(f.getMessage(), f.getErrorCode(), (Throwable)((Object)f));
            }
        }
    }
}

