/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.ws.cloud;

import com.clustercontrol.accesscontrol.bean.PrivilegeConstant;
import com.clustercontrol.accesscontrol.model.RoleEntity;
import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.ErrorCode;
import com.clustercontrol.cloud.Filter;
import com.clustercontrol.cloud.ICloudContext;
import com.clustercontrol.cloud.IResourceManagement;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.bean.AvailableRole;
import com.clustercontrol.cloud.bean.CloudAccountResource;
import com.clustercontrol.cloud.bean.CloudInstance;
import com.clustercontrol.cloud.bean.CloudInstanceBackup;
import com.clustercontrol.cloud.bean.CloudRegion;
import com.clustercontrol.cloud.bean.CloudService;
import com.clustercontrol.cloud.bean.CloudStorage;
import com.clustercontrol.cloud.bean.CloudStorageBackup;
import com.clustercontrol.cloud.bean.CloudTemplate;
import com.clustercontrol.cloud.bean.CloudType;
import com.clustercontrol.cloud.bean.CloudUser;
import com.clustercontrol.cloud.bean.CreateAccountResourceRequest;
import com.clustercontrol.cloud.bean.CreateCloudUserRequest;
import com.clustercontrol.cloud.bean.CreateInstanceBackupRequest;
import com.clustercontrol.cloud.bean.CreateInstanceByTemplateRequest;
import com.clustercontrol.cloud.bean.CreateInstanceRequest;
import com.clustercontrol.cloud.bean.CreateStorageBackupRequest;
import com.clustercontrol.cloud.bean.CreateStorageRequest;
import com.clustercontrol.cloud.bean.CreateTemplateRequest;
import com.clustercontrol.cloud.bean.Image;
import com.clustercontrol.cloud.bean.InstanceStateChange;
import com.clustercontrol.cloud.bean.ModifyAccountBillingDetailRequest;
import com.clustercontrol.cloud.bean.ModifyAccountResourceRequest;
import com.clustercontrol.cloud.bean.ModifyCloudUserRequest;
import com.clustercontrol.cloud.bean.ModifyTemplateRequest;
import com.clustercontrol.cloud.bean.RegistNodeRequest;
import com.clustercontrol.cloud.bean.RestoreInstanceRequest;
import com.clustercontrol.cloud.bean.RestoreStorageRequest;
import com.clustercontrol.cloud.bean.Snapshot;
import com.clustercontrol.cloud.bean.StartInstanceRequest;
import com.clustercontrol.cloud.bean.StopInstanceRequest;
import com.clustercontrol.cloud.bean.Zone;
import com.clustercontrol.cloud.factory.CloudRoleConstants;
import com.clustercontrol.cloud.factory.IAccountResourceOperator;
import com.clustercontrol.cloud.factory.ICloudServiceOperator;
import com.clustercontrol.cloud.factory.ICloudUserOperator;
import com.clustercontrol.cloud.factory.IInstanceOperator;
import com.clustercontrol.cloud.factory.IStorageOperator;
import com.clustercontrol.cloud.factory.ITemplateOperator;
import com.clustercontrol.cloud.factory.RegistAgent;
import com.clustercontrol.cloud.persistence.EntityManagerEx;
import com.clustercontrol.cloud.registry.ObjectRegistryService;
import com.clustercontrol.cloud.util.ResourceUtil;
import com.clustercontrol.cloud.validation.AuthorizingValidator_accountresource;
import com.clustercontrol.cloud.validation.AuthorizingValidator_facility;
import com.clustercontrol.cloud.validation.AuthorizingValidator_get_clouduser;
import com.clustercontrol.cloud.validation.AuthorizingValidator_is_administrator;
import com.clustercontrol.cloud.validation.AuthorizingValidator_remove_clouduser;
import com.clustercontrol.cloud.validation.AuthorizingValidator_role;
import com.clustercontrol.cloud.validation.AuthorizingValidator_role_region;
import com.clustercontrol.cloud.validation.ModifiableAccountResource;
import com.clustercontrol.cloud.validation.annotation.CustomMethodValidation;
import com.clustercontrol.cloud.validation.annotation.ElementId;
import com.clustercontrol.cloud.validation.annotation.Identity;
import com.clustercontrol.cloud.validation.annotation.Into;
import com.clustercontrol.cloud.validation.annotation.NotNull;
import com.clustercontrol.cloud.validation.annotation.NotNullContainer;
import com.clustercontrol.cloud.validation.annotation.Size;
import com.clustercontrol.cloud.validation.annotation.ValidationGroup;
import com.clustercontrol.commons.util.HinemosSessionContext;
import com.clustercontrol.fault.FacilityNotFound;
import com.clustercontrol.fault.InvalidRole;
import com.clustercontrol.fault.InvalidSetting;
import com.clustercontrol.fault.InvalidUserPass;
import com.clustercontrol.repository.util.FacilityTreeCache;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.IWebServiceBase;
import com.clustercontrol.ws.cloud.security.HinemosAccessRight;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import javax.jws.WebService;
import javax.persistence.Query;
import javax.xml.ws.WebServiceContext;

@WebService(serviceName="CloudEndpointService", portName="CloudEndpointPort", targetNamespace="http://cloud.ws.clustercontrol.com", endpointInterface="com.clustercontrol.ws.cloud.CloudEndpoint")
public class CloudEndpointImpl
implements CloudEndpoint,
IWebServiceBase,
CloudRoleConstants {
    @Resource
    private WebServiceContext wsctx;

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ, PrivilegeConstant.SystemPrivilegeMode.ADD})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    @ValidationGroup(value="addInstance")
    public CloudInstance addInstance(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region, @ElementId(value="CreateInstanceRequest") @NotNull @Into CreateInstanceRequest request) throws InvalidUserPass, InvalidRole, CloudManagerFault {
        return ResourceUtil.getResourceOperator(IInstanceOperator.class).createInstance(request);
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ, PrivilegeConstant.SystemPrivilegeMode.ADD})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    @ValidationGroup(value="addInstanceByTemplate")
    public CloudInstance addInstanceByTemplate(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region, @ElementId(value="CreateInstanceByTemplateRequest") @NotNull @Into CreateInstanceByTemplateRequest request) throws InvalidUserPass, InvalidRole, CloudManagerFault {
        return ResourceUtil.getResourceOperator(IInstanceOperator.class).createInstanceByTemplate(request);
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ, PrivilegeConstant.SystemPrivilegeMode.EXEC})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    @ValidationGroup(value="restoreInstance")
    public CloudInstance restoreInstance(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region, @ElementId(value="RestoreInstanceRequest") @NotNull @Into RestoreInstanceRequest request) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        return ResourceUtil.getResourceOperator(IInstanceOperator.class).restoreInstance(request);
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ, PrivilegeConstant.SystemPrivilegeMode.WRITE})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    public void removeInstance(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region, @ElementId(value="instanceId") @NotNull @Size(max=64) String instanceId) throws InvalidUserPass, InvalidRole, CloudManagerFault {
        ResourceUtil.getResourceOperator(IInstanceOperator.class).removeInstance(instanceId);
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    public CloudInstance getInstance(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region, @ElementId(value="instanceId") @NotNull @Size(max=64) String instanceId) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        return ResourceUtil.getResourceOperator(IInstanceOperator.class).getInstance(instanceId);
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    public List<CloudInstance> getInstancesByRegion(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        return ResourceUtil.getResourceOperator(IInstanceOperator.class).getAllInstances();
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ, PrivilegeConstant.SystemPrivilegeMode.EXEC})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    public InstanceStateChange startInstance(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region, @ElementId(value="StartInstanceRequest") @NotNull StartInstanceRequest request) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        return ResourceUtil.getResourceOperator(IInstanceOperator.class).startInstance(request);
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ, PrivilegeConstant.SystemPrivilegeMode.EXEC})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    public InstanceStateChange stopInstance(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region, @ElementId(value="StopInstanceRequest") @NotNull StopInstanceRequest request) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        return ResourceUtil.getResourceOperator(IInstanceOperator.class).stopInstance(request);
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ, PrivilegeConstant.SystemPrivilegeMode.ADD})
    public CloudUser addCloudUser(@ElementId(value="CreateCloudUserRequest") @NotNull @Into CreateCloudUserRequest request) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        return ((ICloudUserOperator)ObjectRegistryService.registry().get(ICloudUserOperator.class)).createCloudUser(request);
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ})
    public List<CloudUser> getCloudUsersByAccountResource(@ElementId(value="accountResourceId") @Identity String accountResourceId) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        return ((ICloudUserOperator)ObjectRegistryService.registry().get(ICloudUserOperator.class)).findCloudUserByAccountResourceAndUserId(accountResourceId, SessionService.current().getHinemosCredential().getUserId());
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ})
    @CustomMethodValidation(value={AuthorizingValidator_get_clouduser.class})
    public CloudUser getCloudUser(@ElementId(value="cloudUserId") @Identity String cloudUserId) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        return ((ICloudUserOperator)ObjectRegistryService.registry().get(ICloudUserOperator.class)).findCloudUser(cloudUserId);
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ, PrivilegeConstant.SystemPrivilegeMode.WRITE})
    @CustomMethodValidation(value={AuthorizingValidator_remove_clouduser.class})
    public void removeCloudUser(@ElementId(value="cloudUserId") @Identity String cloudUserId) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        ((ICloudUserOperator)ObjectRegistryService.registry().get(ICloudUserOperator.class)).removeCloudUser(cloudUserId);
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ, PrivilegeConstant.SystemPrivilegeMode.WRITE})
    public CloudUser modifyCloudUser(@ElementId(value="ModifyCloudUserRequest") @NotNull @Into ModifyCloudUserRequest request) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        return ((ICloudUserOperator)ObjectRegistryService.registry().get(ICloudUserOperator.class)).modifyCloudUser(request);
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ})
    public List<CloudType> getAllSupportedCloudTypes() throws CloudManagerFault, InvalidUserPass, InvalidRole {
        return ((ICloudServiceOperator)ObjectRegistryService.registry().get(ICloudServiceOperator.class)).findAllCloudTypes();
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ})
    public List<CloudRegion> getRegionsByService(@ElementId(value="cloudServiceId") @Identity String cloudServiceId) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        return ((ICloudServiceOperator)ObjectRegistryService.registry().get(ICloudServiceOperator.class)).findCloudRegionsByService(cloudServiceId);
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ})
    @CustomMethodValidation(value={AuthorizingValidator_role.class})
    public List<Zone> getZones(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        ICloudContext context = (ICloudContext)SessionService.current().get(ICloudContext.class);
        return ((ICloudServiceOperator)ObjectRegistryService.registry().get(ICloudServiceOperator.class)).findZonesByRegion(context.getAccessDestionation().getCloudService().getCloudServiceId(), region);
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    public List<Image> getImagesWithFilter(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region, @ElementId(value="filters") @NotNull @NotNullContainer @Into List<Filter> filters) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        return ResourceUtil.getResourceOperator(IInstanceOperator.class).getImagesWithFilter(filters);
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ})
    public List<String> getInstanceFlavorsByService(@ElementId(value="cloudServiceId") @Identity String cloudServiceId) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        ICloudServiceOperator operator = (ICloudServiceOperator)ObjectRegistryService.registry().get(ICloudServiceOperator.class);
        CloudService service = operator.findCloudService(cloudServiceId);
        IResourceManagement rm = (IResourceManagement)ObjectRegistryService.registry().get(IResourceManagement.class, (Object)service.getCloudTypeId());
        if (rm == null) {
            throw ErrorCode.RESOURCEMANAGEMENT_NOT_FOUND.cloudManagerFault(service.getCloudTypeId());
        }
        return rm.getInstanceFlavors();
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    public List<Snapshot> getSnapshotsWithFilter(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region, @ElementId(value="filters") @NotNull @NotNullContainer @Into List<Filter> filters) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        return ResourceUtil.getResourceOperator(IStorageOperator.class).getSnapshotsWithFilter(filters);
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ, PrivilegeConstant.SystemPrivilegeMode.EXEC})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    public void attachStorage(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region, @ElementId(value="instanceId") @NotNull @Size(max=64) String instanceId, @ElementId(value="storageId") @NotNull @Size(max=64) String storageId, @ElementId(value="deviceName") @NotNull @Size(max=128) String deviceName) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        ResourceUtil.getResourceOperator(IStorageOperator.class).attachStorage(instanceId, storageId, deviceName);
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ, PrivilegeConstant.SystemPrivilegeMode.EXEC})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    public void detachStorage(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region, @ElementId(value="instanceId") @NotNull @Size(max=64) String instanceId, @ElementId(value="storageId") @NotNull @Size(max=64) String storageId) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        ResourceUtil.getResourceOperator(IStorageOperator.class).detachStorage(instanceId, storageId);
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ, PrivilegeConstant.SystemPrivilegeMode.ADD})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    public CloudStorage addStorage(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region, @ElementId(value="CreateStorageRequest") @NotNull @Into CreateStorageRequest request) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        return ResourceUtil.getResourceOperator(IStorageOperator.class).createStorage(request);
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ, PrivilegeConstant.SystemPrivilegeMode.EXEC})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    public CloudStorage restoreStorage(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region, @ElementId(value="RestoreStorageRequest") @NotNull @Into RestoreStorageRequest request) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        return ResourceUtil.getResourceOperator(IStorageOperator.class).restoreStorage(request);
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ, PrivilegeConstant.SystemPrivilegeMode.WRITE})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    public void removeStorage(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region, @ElementId(value="storageId") @NotNull @Size(max=64) String storageId) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        ResourceUtil.getResourceOperator(IStorageOperator.class).removeStorage(storageId);
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    public CloudStorage getStorage(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region, @ElementId(value="storageId") @NotNull @Size(max=64) String storageId) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        return ResourceUtil.getResourceOperator(IStorageOperator.class).getStorage(storageId);
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    public List<CloudStorage> getStoragesByRegion(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        return ResourceUtil.getResourceOperator(IStorageOperator.class).getAllStorage();
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ, PrivilegeConstant.SystemPrivilegeMode.EXEC})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    public CloudStorageBackup addStorageBackup(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region, @ElementId(value="CreateStorageBackupRequest") @NotNull @Into CreateStorageBackupRequest request) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        return ResourceUtil.getResourceOperator(IStorageOperator.class).createStorageBackup(request);
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ, PrivilegeConstant.SystemPrivilegeMode.WRITE})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    public void removeStorageBackup(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region, @ElementId(value="storageBackupId") @NotNull @Size(max=64) String storageBackupId) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        ResourceUtil.getResourceOperator(IStorageOperator.class).removeStorageBackup(storageBackupId);
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    public CloudStorageBackup getStorageBackup(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region, @ElementId(value="storageBackupId") @NotNull @Size(max=64) String storageBackupId) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        return ResourceUtil.getResourceOperator(IStorageOperator.class).getStorageBackup(storageBackupId);
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    public List<CloudStorageBackup> getStorageBackupsByRegion(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        return ResourceUtil.getResourceOperator(IStorageOperator.class).getAllStorageBuckup();
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ, PrivilegeConstant.SystemPrivilegeMode.EXEC})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    public CloudInstanceBackup addInstanceBackup(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region, @ElementId(value="CreateInstanceBackupRequest") @NotNull @Into CreateInstanceBackupRequest request) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        return ResourceUtil.getResourceOperator(IInstanceOperator.class).createInstanceBackup(request);
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ, PrivilegeConstant.SystemPrivilegeMode.WRITE})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    public void removeInstanceBackup(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region, @ElementId(value="instanceBackupId") @NotNull @Size(max=64) String instanceBackupId) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        ResourceUtil.getResourceOperator(IInstanceOperator.class).removeInstanceBackup(instanceBackupId);
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    public CloudInstanceBackup getInstanceBackup(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region, @ElementId(value="instanceBackupId") @NotNull @Size(max=64) String instanceBackupId) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        return ResourceUtil.getResourceOperator(IInstanceOperator.class).getInstanceBackup(instanceBackupId);
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    public List<CloudInstanceBackup> getInstanceBackupsByRegion(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        return ResourceUtil.getResourceOperator(IInstanceOperator.class).getAllInstanceBackup();
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ, PrivilegeConstant.SystemPrivilegeMode.WRITE})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    @ValidationGroup(value="registNode")
    public CloudInstance registNode(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region, @ElementId(value="RegistNodeRequest") @NotNull @Into RegistNodeRequest request) throws InvalidUserPass, InvalidRole, CloudManagerFault {
        return ResourceUtil.getResourceOperator(IInstanceOperator.class).registNode(request);
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ, PrivilegeConstant.SystemPrivilegeMode.WRITE})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    public void unregistNode(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region, @ElementId(value="instanceId") @NotNull @Size(max=64) String instanceId) throws InvalidUserPass, InvalidRole, CloudManagerFault {
        ResourceUtil.getResourceOperator(IInstanceOperator.class).unregistNode(instanceId);
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ, PrivilegeConstant.SystemPrivilegeMode.ADD})
    @CustomMethodValidation(value={AuthorizingValidator_role.class})
    public CloudTemplate addTemplate(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="CreateTemplateRequest") @NotNull @Into CreateTemplateRequest request) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        return ResourceUtil.getResourceOperator(ITemplateOperator.class).createTemplate(request);
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ, PrivilegeConstant.SystemPrivilegeMode.WRITE})
    @CustomMethodValidation(value={AuthorizingValidator_role.class})
    public void removeTemplate(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="templateId") @Identity String templateId) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        ResourceUtil.getResourceOperator(ITemplateOperator.class).removeTemplate(templateId);
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ, PrivilegeConstant.SystemPrivilegeMode.WRITE})
    @CustomMethodValidation(value={AuthorizingValidator_role.class})
    public CloudTemplate modifyTemplate(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="ModifyTemplateRequest") @NotNull @Into ModifyTemplateRequest request) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        return ResourceUtil.getResourceOperator(ITemplateOperator.class).modifyTemplate(request);
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ})
    @CustomMethodValidation(value={AuthorizingValidator_role.class})
    public CloudTemplate getTemplate(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="templateId") @Identity String templateId) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        return ResourceUtil.getResourceOperator(ITemplateOperator.class).findTemplate(templateId);
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ})
    @CustomMethodValidation(value={AuthorizingValidator_role.class})
    public List<CloudTemplate> getTemplates(@ElementId(value="roleId") @Identity String roleId) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        return ResourceUtil.getResourceOperator(ITemplateOperator.class).findAllTemplates();
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ})
    @CustomMethodValidation(value={AuthorizingValidator_role.class})
    public List<String> getTemplateScripts(@ElementId(value="roleId") @Identity String roleId) throws CloudManagerFault {
        return ResourceUtil.getResourceOperator(ITemplateOperator.class).findTemplateScripts();
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.ADD, PrivilegeConstant.SystemPrivilegeMode.READ})
    @CustomMethodValidation(value={AuthorizingValidator_is_administrator.class})
    public CloudAccountResource addAccountResource(@ElementId(value="CreateAccountResourceRequest") @NotNull @Into CreateAccountResourceRequest request) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        IAccountResourceOperator cloudAccountResourceOperator = (IAccountResourceOperator)ObjectRegistryService.registry().get(IAccountResourceOperator.class);
        return cloudAccountResourceOperator.createCloudAccountResource(request);
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.WRITE, PrivilegeConstant.SystemPrivilegeMode.READ})
    public CloudAccountResource modifyAccountResource(@ElementId(value="ModifyAccountResourceRequest") @NotNull @Into ModifyAccountResourceRequest request) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        return ((IAccountResourceOperator)ObjectRegistryService.registry().get(IAccountResourceOperator.class)).modifyCloudAccountResource(request);
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.EXEC, PrivilegeConstant.SystemPrivilegeMode.READ})
    public CloudAccountResource modifyAccountBillingDetail(@ElementId(value="ModifyAccountBillingDetailRequest") @NotNull @Into ModifyAccountBillingDetailRequest request) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        return ((IAccountResourceOperator)ObjectRegistryService.registry().get(IAccountResourceOperator.class)).modifyAccountBillingDetail(request);
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.WRITE, PrivilegeConstant.SystemPrivilegeMode.READ})
    @CustomMethodValidation(value={AuthorizingValidator_is_administrator.class})
    public void removeAccountResource(@ElementId(value="accountResourceId") @NotNull @ModifiableAccountResource String accountResourceId) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        ((IAccountResourceOperator)ObjectRegistryService.registry().get(IAccountResourceOperator.class)).removeCloudAccountResource(accountResourceId);
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ})
    public CloudAccountResource getAccountResource(@ElementId(value="accountResourceId") @Identity String accountResourceId) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        return ((IAccountResourceOperator)ObjectRegistryService.registry().get(IAccountResourceOperator.class)).findCloudAccountResourceByCurrentUser(accountResourceId);
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ})
    public List<CloudAccountResource> getAllAccountResources() throws CloudManagerFault, InvalidUserPass, InvalidRole {
        return ((IAccountResourceOperator)ObjectRegistryService.registry().get(IAccountResourceOperator.class)).findCloudAccountResourcesByCurrentUser();
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ})
    public CloudService getCloudService(@ElementId(value="cloudServiceId") @Identity String cloudServiceId) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        return ((ICloudServiceOperator)ObjectRegistryService.registry().get(ICloudServiceOperator.class)).findCloudService(cloudServiceId);
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ})
    public List<CloudService> getAllCloudServices() throws CloudManagerFault, InvalidUserPass, InvalidRole {
        return ((ICloudServiceOperator)ObjectRegistryService.registry().get(ICloudServiceOperator.class)).findAllCloudService();
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ})
    public List<CloudRegion> getCloudRegionsByService(@ElementId(value="cloudServiceId") @Identity String cloudServiceId) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        return ((ICloudServiceOperator)ObjectRegistryService.registry().get(ICloudServiceOperator.class)).findCloudRegionsByService(cloudServiceId);
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ})
    public List<String> getStorageFlavorsByService(@ElementId(value="cloudServiceId") @Identity String cloudServiceId) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        ICloudServiceOperator operator = (ICloudServiceOperator)ObjectRegistryService.registry().get(ICloudServiceOperator.class);
        CloudService service = operator.findCloudService(cloudServiceId);
        IResourceManagement rm = (IResourceManagement)ObjectRegistryService.registry().get(IResourceManagement.class, (Object)service.getCloudTypeId());
        if (rm == null) {
            throw ErrorCode.RESOURCEMANAGEMENT_NOT_FOUND.cloudManagerFault(cloudServiceId);
        }
        return rm.getStorageFlavors();
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ})
    @CustomMethodValidation(value={AuthorizingValidator_accountresource.class})
    public List<String> getCloudServicesForBilling(@ElementId(value="accountResourceId") @Identity String accountResourceId) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        return ((IAccountResourceOperator)ObjectRegistryService.registry().get(IAccountResourceOperator.class)).getCloudServicesForBilling(accountResourceId);
    }

    @Override
    @CustomMethodValidation(value={AuthorizingValidator_facility.class})
    @HinemosAccessRight(roleName="Repository", right={PrivilegeConstant.SystemPrivilegeMode.READ, PrivilegeConstant.SystemPrivilegeMode.EXEC})
    public void establishAgentConnection(@ElementId(value="facilityId") @Identity String facilityId) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        Query query = em.createQuery("SELECT r FROM UserEntity h, RoleEntity r WHERE h.userId = :userId AND h MEMBER OF r.userEntities");
        query.setParameter("userId", (Object)SessionService.current().getHinemosCredential().getUserId());
        boolean accessable = false;
        List results = query.getResultList();
        for (Object o : results) {
            try {
                FacilityTreeCache.validateFacilityId((String)facilityId, (String)((RoleEntity)o).getRoleId(), (boolean)true);
                accessable = true;
                break;
            }
            catch (FacilityNotFound e) {
                throw ErrorCode.HINEMOS_MANAGER_ERROR.cloudManagerFault((Exception)((Object)e));
            }
            catch (InvalidRole | InvalidSetting e) {
            }
        }
        if (!accessable) {
            throw ErrorCode.NODE_DO_NOT_BE_ACCESSIBLE.cloudManagerFault(facilityId);
        }
        RegistAgent.asyncRegistAgent(facilityId);
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ})
    public List<AvailableRole> getAvailableRoles() throws CloudManagerFault, InvalidUserPass, InvalidRole {
        EntityManagerEx em;
        Query query = null;
        List<String> excludes = Arrays.asList("INTERNAL", "HINEMOS_MODULE");
        Boolean isAdministrator = (Boolean)HinemosSessionContext.instance().getProperty("isAdministrator");
        if (isAdministrator == null || !isAdministrator.booleanValue()) {
            em = SessionService.current().getEntityManagerEx();
            query = em.createQuery("SELECT r FROM RoleEntity AS r, UserEntity AS h WHERE r MEMBER OF h.roleEntities AND h.userId = :userId AND NOT r.roleId IN :excludes AND NOT r.roleId IN (SELECT c.roleId FROM CloudUserDao AS c)");
            query.setParameter("userId", (Object)SessionService.current().getHinemosCredential().getUserId());
            query.setParameter("excludes", excludes);
        } else {
            em = SessionService.current().getEntityManagerEx();
            query = em.createQuery("SELECT r FROM RoleEntity AS r WHERE NOT r.roleId IN :excludes AND NOT r.roleId IN (SELECT c.roleId FROM CloudUserDao AS c)");
            query.setParameter("excludes", excludes);
        }
        ArrayList<AvailableRole> availableRoles = new ArrayList<AvailableRole>();
        List roles = query.getResultList();
        for (RoleEntity r : roles) {
            availableRoles.add(new AvailableRole(r.getRoleId(), r.getRoleName()));
        }
        return availableRoles;
    }
}

